/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2023-2024 Broadcom
 * All rights reserved.
 */
#ifndef _CFA_BLD_P70_FIELD_IDS_H_
#define _CFA_BLD_P70_FIELD_IDS_H_

/* clang-format off */

/**
 * Lookup Field Range Check Range Memory Fields:
 */
enum cfa_p70_lkup_frc_profile_flds {
	CFA_P70_LKUP_FRC_PROFILE_FIELD_SEL_1_FLD = 0,
	CFA_P70_LKUP_FRC_PROFILE_RANGE_CHECK_1_FLD = 1,
	CFA_P70_LKUP_FRC_PROFILE_FIELD_SEL_0_FLD = 2,
	CFA_P70_LKUP_FRC_PROFILE_RANGE_CHECK_0_FLD = 3,
	CFA_P70_LKUP_FRC_PROFILE_MAX_FLD
};

/**
 * Lookup Connection Tracking State Memory Fields:
 */
enum cfa_p70_lkup_ct_state_flds {
	CFA_P70_LKUP_CT_STATE_NOTIFY_FLD = 0,
	CFA_P70_LKUP_CT_STATE_NOTIFY_STATE_FLD = 1,
	CFA_P70_LKUP_CT_STATE_ACTION_FLD = 2,
	CFA_P70_LKUP_CT_STATE_TIMER_SELECT_FLD = 3,
	CFA_P70_LKUP_CT_STATE_TIMER_PRELOAD_FLD = 4,
	CFA_P70_LKUP_CT_STATE_MAX_FLD
};

/**
 * Lookup Connection Tracking State Machine Rule Memory Fields:
 */
enum cfa_p70_lkup_ct_rule_flds {
	CFA_P70_LKUP_CT_RULE_VALID_FLD = 0,
	CFA_P70_LKUP_CT_RULE_MASK_FLD = 1,
	CFA_P70_LKUP_CT_RULE_PKT_NOT_BG_FLD = 2,
	CFA_P70_LKUP_CT_RULE_STATE_FLD = 3,
	CFA_P70_LKUP_CT_RULE_TCP_FLAGS_FLD = 4,
	CFA_P70_LKUP_CT_RULE_PROT_IS_TCP_FLD = 5,
	CFA_P70_LKUP_CT_RULE_MSB_UPDT_FLD = 6,
	CFA_P70_LKUP_CT_RULE_FLAGS_FAILED_FLD = 7,
	CFA_P70_LKUP_CT_RULE_WIN_FAILED_FLD = 8,
	CFA_P70_LKUP_CT_RULE_MAX_FLD
};

/**
 * Lookup Connection Tracking State Machine Rule Record Memory Fields:
 */
enum cfa_p70_lkup_ct_rule_record_flds {
	CFA_P70_LKUP_CT_RULE_RECORD_ACTION_FLD = 0,
	CFA_P70_LKUP_CT_RULE_RECORD_NEXT_STATE_FLD = 1,
	CFA_P70_LKUP_CT_RULE_RECORD_SEND_FLD = 2,
	CFA_P70_LKUP_CT_RULE_RECORD_MAX_FLD
};

/**
 * VEB Destination Bitmap Remap Table. Fields:
 */
enum cfa_p70_act_veb_rmp_flds {
	CFA_P70_ACT_VEB_RMP_MODE_FLD = 0,
	CFA_P70_ACT_VEB_RMP_ENABLE_FLD = 1,
	CFA_P70_ACT_VEB_RMP_BITMAP_FLD = 2,
	CFA_P70_ACT_VEB_RMP_MAX_FLD
};

/**
 * Lookup Field Range Check Range Memory Fields:
 */
enum cfa_p70_lkup_frc_range_flds {
	CFA_P70_LKUP_FRC_RANGE_RANGE_LO_FLD = 0,
	CFA_P70_LKUP_FRC_RANGE_RANGE_HI_FLD = 1,
	CFA_P70_LKUP_FRC_RANGE_MAX_FLD
};

/**
 * L2 Context TCAM. Fields:
 */
enum cfa_p70_prof_l2_ctxt_tcam_flds {
	CFA_P70_PROF_L2_CTXT_TCAM_VALID_FLD = 0,
	CFA_P70_PROF_L2_CTXT_TCAM_SPARE_FLD = 1,
	CFA_P70_PROF_L2_CTXT_TCAM_MPASS_CNT_FLD = 2,
	CFA_P70_PROF_L2_CTXT_TCAM_RCYC_FLD = 3,
	CFA_P70_PROF_L2_CTXT_TCAM_LOOPBACK_FLD = 4,
	CFA_P70_PROF_L2_CTXT_TCAM_SPIF_FLD = 5,
	CFA_P70_PROF_L2_CTXT_TCAM_PARIF_FLD = 6,
	CFA_P70_PROF_L2_CTXT_TCAM_SVIF_FLD = 7,
	CFA_P70_PROF_L2_CTXT_TCAM_METADATA_FLD = 8,
	CFA_P70_PROF_L2_CTXT_TCAM_L2_FUNC_FLD = 9,
	CFA_P70_PROF_L2_CTXT_TCAM_ROCE_FLD = 10,
	CFA_P70_PROF_L2_CTXT_TCAM_PURE_LLC_FLD = 11,
	CFA_P70_PROF_L2_CTXT_TCAM_OT_HDR_TYPE_FLD = 12,
	CFA_P70_PROF_L2_CTXT_TCAM_T_HDR_TYPE_FLD = 13,
	CFA_P70_PROF_L2_CTXT_TCAM_ID_CTXT_FLD = 14,
	CFA_P70_PROF_L2_CTXT_TCAM_MAC0_FLD = 15,
	CFA_P70_PROF_L2_CTXT_TCAM_MAC1_FLD = 16,
	CFA_P70_PROF_L2_CTXT_TCAM_VTAG_PRESENT_FLD = 17,
	CFA_P70_PROF_L2_CTXT_TCAM_TWO_VTAGS_FLD = 18,
	CFA_P70_PROF_L2_CTXT_TCAM_OVLAN_VID_FLD = 19,
	CFA_P70_PROF_L2_CTXT_TCAM_OVLAN_TPID_SEL_FLD = 20,
	CFA_P70_PROF_L2_CTXT_TCAM_IVLAN_VID_FLD = 21,
	CFA_P70_PROF_L2_CTXT_TCAM_IVLAN_TPID_SEL_FLD = 22,
	CFA_P70_PROF_L2_CTXT_TCAM_ETYPE_FLD = 23,
	CFA_P70_PROF_L2_CTXT_TCAM_MAX_FLD
};

/**
 * Profiler Profile Lookup TCAM Fields:
 */
enum cfa_p70_prof_profile_tcam_flds {
	CFA_P70_PROF_PROFILE_TCAM_VALID_FLD = 0,
	CFA_P70_PROF_PROFILE_TCAM_SPARE_FLD = 1,
	CFA_P70_PROF_PROFILE_TCAM_LOOPBACK_FLD = 2,
	CFA_P70_PROF_PROFILE_TCAM_PKT_TYPE_FLD = 3,
	CFA_P70_PROF_PROFILE_TCAM_RCYC_FLD = 4,
	CFA_P70_PROF_PROFILE_TCAM_METADATA_FLD = 5,
	CFA_P70_PROF_PROFILE_TCAM_AGG_ERROR_FLD = 6,
	CFA_P70_PROF_PROFILE_TCAM_L2_FUNC_FLD = 7,
	CFA_P70_PROF_PROFILE_TCAM_PROF_FUNC_FLD = 8,
	CFA_P70_PROF_PROFILE_TCAM_HREC_NEXT_FLD = 9,
	CFA_P70_PROF_PROFILE_TCAM_INT_HDR_TYPE_FLD = 10,
	CFA_P70_PROF_PROFILE_TCAM_INT_HDR_GROUP_FLD = 11,
	CFA_P70_PROF_PROFILE_TCAM_INT_IFA_TAIL_FLD = 12,
	CFA_P70_PROF_PROFILE_TCAM_OTL2_HDR_VALID_FLD = 13,
	CFA_P70_PROF_PROFILE_TCAM_OTL2_HDR_TYPE_FLD = 14,
	CFA_P70_PROF_PROFILE_TCAM_OTL2_UC_MC_BC_FLD = 15,
	CFA_P70_PROF_PROFILE_TCAM_OTL2_VTAG_PRESENT_FLD = 16,
	CFA_P70_PROF_PROFILE_TCAM_OTL2_TWO_VTAGS_FLD = 17,
	CFA_P70_PROF_PROFILE_TCAM_OTL3_HDR_VALID_FLD = 18,
	CFA_P70_PROF_PROFILE_TCAM_OTL3_HDR_ERROR_FLD = 19,
	CFA_P70_PROF_PROFILE_TCAM_OTL3_HDR_TYPE_FLD = 20,
	CFA_P70_PROF_PROFILE_TCAM_OTL3_HDR_ISIP_FLD = 21,
	CFA_P70_PROF_PROFILE_TCAM_OTL4_HDR_VALID_FLD = 22,
	CFA_P70_PROF_PROFILE_TCAM_OTL4_HDR_ERROR_FLD = 23,
	CFA_P70_PROF_PROFILE_TCAM_OTL4_HDR_TYPE_FLD = 24,
	CFA_P70_PROF_PROFILE_TCAM_OTL4_HDR_IS_UDP_TCP_FLD = 25,
	CFA_P70_PROF_PROFILE_TCAM_OT_HDR_VALID_FLD = 26,
	CFA_P70_PROF_PROFILE_TCAM_OT_HDR_ERROR_FLD = 27,
	CFA_P70_PROF_PROFILE_TCAM_OT_HDR_TYPE_FLD = 28,
	CFA_P70_PROF_PROFILE_TCAM_OT_HDR_FLAGS_FLD = 29,
	CFA_P70_PROF_PROFILE_TCAM_TL2_HDR_VALID_FLD = 30,
	CFA_P70_PROF_PROFILE_TCAM_TL2_HDR_TYPE_FLD = 31,
	CFA_P70_PROF_PROFILE_TCAM_TL2_UC_MC_BC_FLD = 32,
	CFA_P70_PROF_PROFILE_TCAM_TL2_VTAG_PRESENT_FLD = 33,
	CFA_P70_PROF_PROFILE_TCAM_TL2_TWO_VTAGS_FLD = 34,
	CFA_P70_PROF_PROFILE_TCAM_TL3_HDR_VALID_FLD = 35,
	CFA_P70_PROF_PROFILE_TCAM_TL3_HDR_ERROR_FLD = 36,
	CFA_P70_PROF_PROFILE_TCAM_TL3_HDR_TYPE_FLD = 37,
	CFA_P70_PROF_PROFILE_TCAM_TL3_HDR_ISIP_FLD = 38,
	CFA_P70_PROF_PROFILE_TCAM_TL4_HDR_VALID_FLD = 39,
	CFA_P70_PROF_PROFILE_TCAM_TL4_HDR_ERROR_FLD = 40,
	CFA_P70_PROF_PROFILE_TCAM_TL4_HDR_TYPE_FLD = 41,
	CFA_P70_PROF_PROFILE_TCAM_TL4_HDR_IS_UDP_TCP_FLD = 42,
	CFA_P70_PROF_PROFILE_TCAM_TUN_HDR_VALID_FLD = 43,
	CFA_P70_PROF_PROFILE_TCAM_TUN_HDR_ERROR_FLD = 44,
	CFA_P70_PROF_PROFILE_TCAM_TUN_HDR_TYPE_FLD = 45,
	CFA_P70_PROF_PROFILE_TCAM_TUN_HDR_FLAGS_FLD = 46,
	CFA_P70_PROF_PROFILE_TCAM_L2_HDR_VALID_FLD = 47,
	CFA_P70_PROF_PROFILE_TCAM_L2_HDR_ERROR_FLD = 48,
	CFA_P70_PROF_PROFILE_TCAM_L2_HDR_TYPE_FLD = 49,
	CFA_P70_PROF_PROFILE_TCAM_L2_UC_MC_BC_FLD = 50,
	CFA_P70_PROF_PROFILE_TCAM_L2_VTAG_PRESENT_FLD = 51,
	CFA_P70_PROF_PROFILE_TCAM_L2_TWO_VTAGS_FLD = 52,
	CFA_P70_PROF_PROFILE_TCAM_L3_HDR_VALID_FLD = 53,
	CFA_P70_PROF_PROFILE_TCAM_L3_HDR_ERROR_FLD = 54,
	CFA_P70_PROF_PROFILE_TCAM_L3_HDR_TYPE_FLD = 55,
	CFA_P70_PROF_PROFILE_TCAM_L3_HDR_ISIP_FLD = 56,
	CFA_P70_PROF_PROFILE_TCAM_L3_PROT_FLD = 57,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_VALID_FLD = 58,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_ERROR_FLD = 59,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_TYPE_FLD = 60,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_IS_UDP_TCP_FLD = 61,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_SUBTYPE_FLD = 62,
	CFA_P70_PROF_PROFILE_TCAM_L4_HDR_FLAGS_FLD = 63,
	CFA_P70_PROF_PROFILE_TCAM_L4_DCN_PRESENT_FLD = 64,
	CFA_P70_PROF_PROFILE_TCAM_MAX_FLD
};

/**
 * Action VEB TCAM. TX Fields (VEB Remap Mode):
 */
enum cfa_p70_act_veb_tcam_tx_flds {
	CFA_P70_ACT_VEB_TCAM_TX_VALID_FLD = 0,
	CFA_P70_ACT_VEB_TCAM_TX_PARIF_IN_FLD = 1,
	CFA_P70_ACT_VEB_TCAM_TX_NUM_VTAGS_FLD = 2,
	CFA_P70_ACT_VEB_TCAM_TX_DMAC_FLD = 3,
	CFA_P70_ACT_VEB_TCAM_TX_OVID_FLD = 4,
	CFA_P70_ACT_VEB_TCAM_TX_IVID_FLD = 5,
	CFA_P70_ACT_VEB_TCAM_TX_MAX_FLD
};

/**
 * RX Fields (Source Knockout Mode):
 */
enum cfa_p70_act_veb_tcam_rx_flds {
	CFA_P70_ACT_VEB_TCAM_RX_VALID_FLD = 0,
	CFA_P70_ACT_VEB_TCAM_RX_SPARE_FLD = 1,
	CFA_P70_ACT_VEB_TCAM_RX_PADDING_FLD = 2,
	CFA_P70_ACT_VEB_TCAM_RX_UNICAST_FLD = 3,
	CFA_P70_ACT_VEB_TCAM_RX_MULTICAST_FLD = 4,
	CFA_P70_ACT_VEB_TCAM_RX_BROADCAST_FLD = 5,
	CFA_P70_ACT_VEB_TCAM_RX_PFID_FLD = 6,
	CFA_P70_ACT_VEB_TCAM_RX_VFID_FLD = 7,
	CFA_P70_ACT_VEB_TCAM_RX_SMAC_FLD = 8,
	CFA_P70_ACT_VEB_TCAM_RX_MAX_FLD
};

/**
 * Action Feature Chaining TCAM.
 */
enum cfa_p70_act_fc_tcam_flds {
	CFA_P70_ACT_FC_TCAM_FC_VALID_FLD = 0,
	CFA_P70_ACT_FC_TCAM_FC_RSVD_FLD = 1,
	CFA_P70_ACT_FC_TCAM_FC_METADATA_FLD = 2,
	CFA_P70_ACT_FC_TCAM_MAX_FLD
};

/**
 * Feature Chaining TCAM Remap Table Fields:
 */
enum cfa_p70_act_fc_rmp_dr_flds {
	CFA_P70_ACT_FC_RMP_DR_METADATA_FLD = 0,
	CFA_P70_ACT_FC_RMP_DR_METAMASK_FLD = 1,
	CFA_P70_ACT_FC_RMP_DR_L2_FUNC_FLD = 2,
	CFA_P70_ACT_FC_RMP_DR_MAX_FLD
};

/**
 * Profile Input Lookup Table Memory Fields:
 */
enum cfa_p70_prof_ilt_dr_flds {
	CFA_P70_PROF_ILT_DR_ILT_META_EN_FLD = 0,
	CFA_P70_PROF_ILT_DR_META_PROF_FLD = 1,
	CFA_P70_PROF_ILT_DR_METADATA_FLD = 2,
	CFA_P70_PROF_ILT_DR_PARIF_FLD = 3,
	CFA_P70_PROF_ILT_DR_L2_FUNC_FLD = 4,
	CFA_P70_PROF_ILT_DR_EN_BD_META_FLD = 5,
	CFA_P70_PROF_ILT_DR_EN_BD_ACTION_FLD = 6,
	CFA_P70_PROF_ILT_DR_EN_ILT_DEST_FLD = 7,
	CFA_P70_PROF_ILT_DR_ILT_FWD_OP_FLD = 8,
	CFA_P70_PROF_ILT_DR_ILT_ACT_HINT_FLD = 9,
	CFA_P70_PROF_ILT_DR_ILT_SCOPE_FLD = 10,
	CFA_P70_PROF_ILT_DR_ILT_ACT_REC_PTR_FLD = 11,
	CFA_P70_PROF_ILT_DR_ILT_DESTINATION_FLD = 12,
	CFA_P70_PROF_ILT_DR_MAX_FLD
};

/**
 * Profile Lookup TCAM Remap Table Fields:
 */
enum cfa_p70_prof_profile_rmp_dr_flds {
	CFA_P70_PROF_PROFILE_RMP_DR_PL_BYP_LKUP_EN_FLD = 0,
	CFA_P70_PROF_PROFILE_RMP_DR_EM_SEARCH_EN_FLD = 1,
	CFA_P70_PROF_PROFILE_RMP_DR_EM_PROFILE_ID_FLD = 2,
	CFA_P70_PROF_PROFILE_RMP_DR_EM_KEY_ID_FLD = 3,
	CFA_P70_PROF_PROFILE_RMP_DR_EM_SCOPE_FLD = 4,
	CFA_P70_PROF_PROFILE_RMP_DR_TCAM_SEARCH_EN_FLD = 5,
	CFA_P70_PROF_PROFILE_RMP_DR_TCAM_PROFILE_ID_FLD = 6,
	CFA_P70_PROF_PROFILE_RMP_DR_TCAM_KEY_ID_FLD = 7,
	CFA_P70_PROF_PROFILE_RMP_DR_TCAM_SCOPE_FLD = 8,
	CFA_P70_PROF_PROFILE_RMP_DR_MAX_FLD
};

/**
 * PROF_PROFILE_RMP_DR_BYP
 */
enum cfa_p70_prof_profile_rmp_dr_byp_flds {
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_PL_BYP_LKUP_EN_FLD = 0,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_RESERVED_FLD = 1,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_BYPASS_OP_FLD = 2,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_PL_ACT_HINT_FLD = 3,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_PL_SCOPE_FLD = 4,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_PL_ACT_REC_PTR_FLD = 5,
	CFA_P70_PROF_PROFILE_RMP_DR_BYP_MAX_FLD
};

/**
 * VNIC-SVIF Properties Table Fields: TX SVIF Properties Table
 */
enum cfa_p70_act_vspt_dr_tx_flds {
	CFA_P70_ACT_VSPT_DR_TX_TPID_AS_CTL_FLD = 0,
	CFA_P70_ACT_VSPT_DR_TX_ALWD_TPID_FLD = 1,
	CFA_P70_ACT_VSPT_DR_TX_DFLT_TPID_FLD = 2,
	CFA_P70_ACT_VSPT_DR_TX_PRI_AS_CTL_FLD = 3,
	CFA_P70_ACT_VSPT_DR_TX_ALWD_PRI_FLD = 4,
	CFA_P70_ACT_VSPT_DR_TX_DFLT_PRI_FLD = 5,
	CFA_P70_ACT_VSPT_DR_TX_MIR_FLD = 6,
	CFA_P70_ACT_VSPT_DR_TX_MAX_FLD
};

/**
 * RX VNIC Properties Table
 */
enum cfa_p70_act_vspt_dr_rx_flds {
	CFA_P70_ACT_VSPT_DR_RX_RSVD_FLD = 0,
	CFA_P70_ACT_VSPT_DR_RX_METAFMT_FLD = 1,
	CFA_P70_ACT_VSPT_DR_RX_FID_FLD = 2,
	CFA_P70_ACT_VSPT_DR_RX_MIR_FLD = 3,
	CFA_P70_ACT_VSPT_DR_RX_MAX_FLD
};

/**
 * LAG ID Balance Table Fields:
 */
enum cfa_p70_act_lbt_dr_flds {
	CFA_P70_ACT_LBT_DR_DST_BMP_FLD = 0,
	CFA_P70_ACT_LBT_DR_MAX_FLD
};

/**
 * L2 Context Lookup Remap Table Fields:
 */
enum cfa_p70_prof_l2_ctxt_rmp_dr_flds {
	CFA_P70_PROF_L2_CTXT_RMP_DR_PRSV_PARIF_FLD = 0,
	CFA_P70_PROF_L2_CTXT_RMP_DR_PARIF_FLD = 1,
	CFA_P70_PROF_L2_CTXT_RMP_DR_PRSV_L2IP_CTXT_FLD = 2,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_CTXT_FLD = 3,
	CFA_P70_PROF_L2_CTXT_RMP_DR_PRSV_PROF_FUNC_FLD = 4,
	CFA_P70_PROF_L2_CTXT_RMP_DR_PROF_FUNC_FLD = 5,
	CFA_P70_PROF_L2_CTXT_RMP_DR_CTXT_OPCODE_FLD = 6,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_META_ENB_FLD = 7,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_META_FLD = 8,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_ACT_ENB_FLD = 9,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_ACT_DATA_FLD = 10,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_RFS_ENB_FLD = 11,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_RFS_DATA_FLD = 12,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_DEST_ENB_FLD = 13,
	CFA_P70_PROF_L2_CTXT_RMP_DR_L2IP_DEST_DATA_FLD = 14,
	CFA_P70_PROF_L2_CTXT_RMP_DR_MAX_FLD
};

/**
 * Multi Field Register.
 */
enum cfa_p70_act_fc_tcam_result_flds {
	CFA_P70_ACT_FC_TCAM_RESULT_SEARCH_RESULT_FLD = 0,
	CFA_P70_ACT_FC_TCAM_RESULT_UNUSED_0_FLD = 1,
	CFA_P70_ACT_FC_TCAM_RESULT_SEARCH_HIT_FLD = 2,
	CFA_P70_ACT_FC_TCAM_RESULT_MAX_FLD
};

/**
 * Multi Field Register.
 */
enum cfa_p70_act_mirror_flds {
	CFA_P70_ACT_MIRROR_UNUSED_0_FLD = 0,
	CFA_P70_ACT_MIRROR_RELATIVE_FLD = 1,
	CFA_P70_ACT_MIRROR_HINT_FLD = 2,
	CFA_P70_ACT_MIRROR_SAMP_FLD = 3,
	CFA_P70_ACT_MIRROR_TRUNC_FLD = 4,
	CFA_P70_ACT_MIRROR_IGN_DROP_FLD = 5,
	CFA_P70_ACT_MIRROR_MODE_FLD = 6,
	CFA_P70_ACT_MIRROR_COND_FLD = 7,
	CFA_P70_ACT_MIRROR_AR_PTR_FLD = 8,
	CFA_P70_ACT_MIRROR_SAMP_CFG_FLD = 9,
	CFA_P70_ACT_MIRROR_MAX_FLD
};

/**
 * WC LREC Lookup Record
 */
enum cfa_p70_wc_lrec_flds {
	CFA_P70_WC_LREC_METADATA_FLD = 0,
	CFA_P70_WC_LREC_META_PROF_FLD = 1,
	CFA_P70_WC_LREC_PROF_FUNC_FLD = 2,
	CFA_P70_WC_LREC_RECYCLE_DEST_FLD = 3,
	CFA_P70_WC_LREC_FC_PTR_FLD = 4,
	CFA_P70_WC_LREC_FC_TYPE_FLD = 5,
	CFA_P70_WC_LREC_FC_OP_FLD = 6,
	CFA_P70_WC_LREC_PATHS_M1_FLD = 7,
	CFA_P70_WC_LREC_ACT_REC_SIZE_FLD = 8,
	CFA_P70_WC_LREC_RING_TABLE_IDX_FLD = 9,
	CFA_P70_WC_LREC_DESTINATION_FLD = 10,
	CFA_P70_WC_LREC_ACT_REC_PTR_FLD = 11,
	CFA_P70_WC_LREC_ACT_HINT_FLD = 12,
	CFA_P70_WC_LREC_STRENGTH_FLD = 13,
	CFA_P70_WC_LREC_OPCODE_FLD = 14,
	CFA_P70_WC_LREC_EPOCH1_FLD = 15,
	CFA_P70_WC_LREC_EPOCH0_FLD = 16,
	CFA_P70_WC_LREC_REC_SIZE_FLD = 17,
	CFA_P70_WC_LREC_VALID_FLD = 18,
	CFA_P70_WC_LREC_MAX_FLD
};

/**
 * EM LREC Lookup Record
 */
enum cfa_p70_em_lrec_flds {
	CFA_P70_EM_LREC_RANGE_IDX_FLD = 0,
	CFA_P70_EM_LREC_RANGE_PROFILE_FLD = 1,
	CFA_P70_EM_LREC_CREC_TIMER_VALUE_FLD = 2,
	CFA_P70_EM_LREC_CREC_STATE_FLD = 3,
	CFA_P70_EM_LREC_CREC_TCP_MSB_OPP_INIT_FLD = 4,
	CFA_P70_EM_LREC_CREC_TCP_MSB_OPP_FLD = 5,
	CFA_P70_EM_LREC_CREC_TCP_MSB_LOC_FLD = 6,
	CFA_P70_EM_LREC_CREC_TCP_WIN_FLD = 7,
	CFA_P70_EM_LREC_CREC_TCP_UPDT_EN_FLD = 8,
	CFA_P70_EM_LREC_CREC_TCP_DIR_FLD = 9,
	CFA_P70_EM_LREC_METADATA_FLD = 10,
	CFA_P70_EM_LREC_PROF_FUNC_FLD = 11,
	CFA_P70_EM_LREC_META_PROF_FLD = 12,
	CFA_P70_EM_LREC_RECYCLE_DEST_FLD = 13,
	CFA_P70_EM_LREC_FC_PTR_FLD = 14,
	CFA_P70_EM_LREC_FC_TYPE_FLD = 15,
	CFA_P70_EM_LREC_FC_OP_FLD = 16,
	CFA_P70_EM_LREC_PATHS_M1_FLD = 17,
	CFA_P70_EM_LREC_ACT_REC_SIZE_FLD = 18,
	CFA_P70_EM_LREC_RING_TABLE_IDX_FLD = 19,
	CFA_P70_EM_LREC_DESTINATION_FLD = 20,
	CFA_P70_EM_LREC_ACT_REC_PTR_FLD = 21,
	CFA_P70_EM_LREC_ACT_HINT_FLD = 22,
	CFA_P70_EM_LREC_STRENGTH_FLD = 23,
	CFA_P70_EM_LREC_OPCODE_FLD = 24,
	CFA_P70_EM_LREC_EPOCH1_FLD = 25,
	CFA_P70_EM_LREC_EPOCH0_FLD = 26,
	CFA_P70_EM_LREC_REC_SIZE_FLD = 27,
	CFA_P70_EM_LREC_VALID_FLD = 28,
	CFA_P70_EM_LREC_MAX_FLD
};

/**
 * EM Lookup Bucket Format
 */
enum cfa_p70_em_bucket_flds {
	CFA_P70_EM_BUCKET_BIN0_ENTRY_FLD = 0,
	CFA_P70_EM_BUCKET_BIN0_HASH_MSBS_FLD = 1,
	CFA_P70_EM_BUCKET_BIN1_ENTRY_FLD = 2,
	CFA_P70_EM_BUCKET_BIN1_HASH_MSBS_FLD = 3,
	CFA_P70_EM_BUCKET_BIN2_ENTRY_FLD = 4,
	CFA_P70_EM_BUCKET_BIN2_HASH_MSBS_FLD = 5,
	CFA_P70_EM_BUCKET_BIN3_ENTRY_FLD = 6,
	CFA_P70_EM_BUCKET_BIN3_HASH_MSBS_FLD = 7,
	CFA_P70_EM_BUCKET_BIN4_ENTRY_FLD = 8,
	CFA_P70_EM_BUCKET_BIN4_HASH_MSBS_FLD = 9,
	CFA_P70_EM_BUCKET_BIN5_ENTRY_FLD = 10,
	CFA_P70_EM_BUCKET_BIN5_HASH_MSBS_FLD = 11,
	CFA_P70_EM_BUCKET_CHAIN_POINTER_FLD = 12,
	CFA_P70_EM_BUCKET_CHAIN_VALID_FLD = 13,
	CFA_P70_EM_BUCKET_MAX_FLD
};

/**
 * Compact Action Record. The compact action record uses relative
 * pointers to access needed data. This keeps the compact action record
 * down to 64b.
 */
enum cfa_p70_compact_action_flds {
	CFA_P70_COMPACT_ACTION_TYPE_FLD = 0,
	CFA_P70_COMPACT_ACTION_DROP_FLD = 1,
	CFA_P70_COMPACT_ACTION_VLAN_DELETE_FLD = 2,
	CFA_P70_COMPACT_ACTION_DEST_FLD = 3,
	CFA_P70_COMPACT_ACTION_DEST_OP_FLD = 4,
	CFA_P70_COMPACT_ACTION_DECAP_FLD = 5,
	CFA_P70_COMPACT_ACTION_MIRRORING_FLD = 6,
	CFA_P70_COMPACT_ACTION_METER_PTR_FLD = 7,
	CFA_P70_COMPACT_ACTION_STAT0_OFF_FLD = 8,
	CFA_P70_COMPACT_ACTION_STAT0_OP_FLD = 9,
	CFA_P70_COMPACT_ACTION_STAT0_CTR_TYPE_FLD = 10,
	CFA_P70_COMPACT_ACTION_MOD_OFF_FLD = 11,
	CFA_P70_COMPACT_ACTION_ENC_OFF_FLD = 12,
	CFA_P70_COMPACT_ACTION_SRC_OFF_FLD = 13,
	CFA_P70_COMPACT_ACTION_UNUSED_0_FLD = 14,
	CFA_P70_COMPACT_ACTION_MAX_FLD
};

/**
 * Full Action Record. The full action record uses full pointers to
 * access needed data. It also allows access to all the action features.
 * The Full Action record is 192b.
 */
enum cfa_p70_full_action_flds {
	CFA_P70_FULL_ACTION_TYPE_FLD = 0,
	CFA_P70_FULL_ACTION_DROP_FLD = 1,
	CFA_P70_FULL_ACTION_VLAN_DELETE_FLD = 2,
	CFA_P70_FULL_ACTION_DEST_FLD = 3,
	CFA_P70_FULL_ACTION_DEST_OP_FLD = 4,
	CFA_P70_FULL_ACTION_DECAP_FLD = 5,
	CFA_P70_FULL_ACTION_MIRRORING_FLD = 6,
	CFA_P70_FULL_ACTION_METER_PTR_FLD = 7,
	CFA_P70_FULL_ACTION_STAT0_PTR_FLD = 8,
	CFA_P70_FULL_ACTION_STAT0_OP_FLD = 9,
	CFA_P70_FULL_ACTION_STAT0_CTR_TYPE_FLD = 10,
	CFA_P70_FULL_ACTION_STAT1_PTR_FLD = 11,
	CFA_P70_FULL_ACTION_STAT1_OP_FLD = 12,
	CFA_P70_FULL_ACTION_STAT1_CTR_TYPE_FLD = 13,
	CFA_P70_FULL_ACTION_MOD_PTR_FLD = 14,
	CFA_P70_FULL_ACTION_ENC_PTR_FLD = 15,
	CFA_P70_FULL_ACTION_SRC_PTR_FLD = 16,
	CFA_P70_FULL_ACTION_UNUSED_0_FLD = 17,
	CFA_P70_FULL_ACTION_MAX_FLD
};

/**
 * Multicast Group Action Record. This action is used to send the packet
 * to multiple destinations. The MGC Action record is 256b.
 */
enum cfa_p70_mcg_action_flds {
	CFA_P70_MCG_ACTION_TYPE_FLD = 0,
	CFA_P70_MCG_ACTION_SRC_KO_EN_FLD = 1,
	CFA_P70_MCG_ACTION_UNUSED_0_FLD = 2,
	CFA_P70_MCG_ACTION_NEXT_PTR_FLD = 3,
	CFA_P70_MCG_ACTION_PTR0_ACT_HINT_FLD = 4,
	CFA_P70_MCG_ACTION_PTR0_ACT_REC_PTR_FLD = 5,
	CFA_P70_MCG_ACTION_PTR1_ACT_HINT_FLD = 6,
	CFA_P70_MCG_ACTION_PTR1_ACT_REC_PTR_FLD = 7,
	CFA_P70_MCG_ACTION_PTR2_ACT_HINT_FLD = 8,
	CFA_P70_MCG_ACTION_PTR2_ACT_REC_PTR_FLD = 9,
	CFA_P70_MCG_ACTION_PTR3_ACT_HINT_FLD = 10,
	CFA_P70_MCG_ACTION_PTR3_ACT_REC_PTR_FLD = 11,
	CFA_P70_MCG_ACTION_PTR4_ACT_HINT_FLD = 12,
	CFA_P70_MCG_ACTION_PTR4_ACT_REC_PTR_FLD = 13,
	CFA_P70_MCG_ACTION_PTR5_ACT_HINT_FLD = 14,
	CFA_P70_MCG_ACTION_PTR5_ACT_REC_PTR_FLD = 15,
	CFA_P70_MCG_ACTION_PTR6_ACT_HINT_FLD = 16,
	CFA_P70_MCG_ACTION_PTR6_ACT_REC_PTR_FLD = 17,
	CFA_P70_MCG_ACTION_PTR7_ACT_HINT_FLD = 18,
	CFA_P70_MCG_ACTION_PTR7_ACT_REC_PTR_FLD = 19,
	CFA_P70_MCG_ACTION_MAX_FLD
};

/**
 * Multicast Group Action Record. This action is used to send the packet
 * to multiple destinations. The MGC Action record is 256b.
 */
enum cfa_p70_mcg_subseq_action_flds {
	CFA_P70_MCG_SUBSEQ_ACTION_TYPE_FLD = 0,
	CFA_P70_MCG_SUBSEQ_ACTION_UNUSED_0_FLD = 1,
	CFA_P70_MCG_SUBSEQ_ACTION_NEXT_PTR_FLD = 2,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR0_ACT_HINT_FLD = 3,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR0_ACT_REC_PTR_FLD = 4,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR1_ACT_HINT_FLD = 5,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR1_ACT_REC_PTR_FLD = 6,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR2_ACT_HINT_FLD = 7,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR2_ACT_REC_PTR_FLD = 8,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR3_ACT_HINT_FLD = 9,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR3_ACT_REC_PTR_FLD = 10,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR4_ACT_HINT_FLD = 11,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR4_ACT_REC_PTR_FLD = 12,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR5_ACT_HINT_FLD = 13,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR5_ACT_REC_PTR_FLD = 14,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR6_ACT_HINT_FLD = 15,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR6_ACT_REC_PTR_FLD = 16,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR7_ACT_HINT_FLD = 17,
	CFA_P70_MCG_SUBSEQ_ACTION_PTR7_ACT_REC_PTR_FLD = 18,
	CFA_P70_MCG_SUBSEQ_ACTION_MAX_FLD
};

/**
 * Action Meter Formats
 */
enum cfa_p70_meters_flds {
	CFA_P70_METERS_BKT_C_FLD = 0,
	CFA_P70_METERS_BKT_E_FLD = 1,
	CFA_P70_METERS_FLAGS_MTR_VAL_FLD = 2,
	CFA_P70_METERS_FLAGS_ECN_RMP_EN_FLD = 3,
	CFA_P70_METERS_FLAGS_CF_FLD = 4,
	CFA_P70_METERS_FLAGS_PM_FLD = 5,
	CFA_P70_METERS_FLAGS_RFC2698_FLD = 6,
	CFA_P70_METERS_FLAGS_CBSM_FLD = 7,
	CFA_P70_METERS_FLAGS_EBSM_FLD = 8,
	CFA_P70_METERS_FLAGS_CBND_FLD = 9,
	CFA_P70_METERS_FLAGS_EBND_FLD = 10,
	CFA_P70_METERS_CBS_FLD = 11,
	CFA_P70_METERS_EBS_FLD = 12,
	CFA_P70_METERS_CIR_FLD = 13,
	CFA_P70_METERS_EIR_FLD = 14,
	CFA_P70_METERS_PROTECTION_SCOPE_FLD = 15,
	CFA_P70_METERS_PROTECTION_RSVD_FLD = 16,
	CFA_P70_METERS_PROTECTION_ENABLE_FLD = 17,
	CFA_P70_METERS_MAX_FLD
};

/**
 * Enumeration for fkb
 */
enum cfa_p70_fkb_flds {
	CFA_P70_FKB_PROF_ID_FLD = 0,
	CFA_P70_FKB_L2CTXT_FLD = 1,
	CFA_P70_FKB_L2FUNC_FLD = 2,
	CFA_P70_FKB_PARIF_FLD = 3,
	CFA_P70_FKB_SPIF_FLD = 4,
	CFA_P70_FKB_SVIF_FLD = 5,
	CFA_P70_FKB_LCOS_FLD = 6,
	CFA_P70_FKB_META_HI_FLD = 7,
	CFA_P70_FKB_META_LO_FLD = 8,
	CFA_P70_FKB_RCYC_CNT_FLD = 9,
	CFA_P70_FKB_LOOPBACK_FLD = 10,
	CFA_P70_FKB_OTL2_TYPE_FLD = 11,
	CFA_P70_FKB_OTL2_DMAC_FLD = 12,
	CFA_P70_FKB_OTL2_SMAC_FLD = 13,
	CFA_P70_FKB_OTL2_DT_FLD = 14,
	CFA_P70_FKB_OTL2_SA_FLD = 15,
	CFA_P70_FKB_OTL2_NVT_FLD = 16,
	CFA_P70_FKB_OTL2_OVP_FLD = 17,
	CFA_P70_FKB_OTL2_OVD_FLD = 18,
	CFA_P70_FKB_OTL2_OVV_FLD = 19,
	CFA_P70_FKB_OTL2_OVT_FLD = 20,
	CFA_P70_FKB_OTL2_IVP_FLD = 21,
	CFA_P70_FKB_OTL2_IVD_FLD = 22,
	CFA_P70_FKB_OTL2_IVV_FLD = 23,
	CFA_P70_FKB_OTL2_IVT_FLD = 24,
	CFA_P70_FKB_OTL2_ETYPE_FLD = 25,
	CFA_P70_FKB_OTL3_TYPE_FLD = 26,
	CFA_P70_FKB_OTL3_SIP3_FLD = 27,
	CFA_P70_FKB_OTL3_SIP2_FLD = 28,
	CFA_P70_FKB_OTL3_SIP1_FLD = 29,
	CFA_P70_FKB_OTL3_SIP0_FLD = 30,
	CFA_P70_FKB_OTL3_DIP3_FLD = 31,
	CFA_P70_FKB_OTL3_DIP2_FLD = 32,
	CFA_P70_FKB_OTL3_DIP1_FLD = 33,
	CFA_P70_FKB_OTL3_DIP0_FLD = 34,
	CFA_P70_FKB_OTL3_TTL_FLD = 35,
	CFA_P70_FKB_OTL3_PROT_FLD = 36,
	CFA_P70_FKB_OTL3_FID_FLD = 37,
	CFA_P70_FKB_OTL3_QOS_FLD = 38,
	CFA_P70_FKB_OTL3_IEH_NONEXT_FLD = 39,
	CFA_P70_FKB_OTL3_IEH_SEP_FLD = 40,
	CFA_P70_FKB_OTL3_IEH_AUTH_FLD = 41,
	CFA_P70_FKB_OTL3_IEH_DEST_FLD = 42,
	CFA_P70_FKB_OTL3_IEH_FRAG_FLD = 43,
	CFA_P70_FKB_OTL3_IEH_RTHDR_FLD = 44,
	CFA_P70_FKB_OTL3_IEH_HOP_FLD = 45,
	CFA_P70_FKB_OTL3_IEH_1FRAG_FLD = 46,
	CFA_P70_FKB_OTL3_DF_FLD = 47,
	CFA_P70_FKB_OTL3_L3ERR_FLD = 48,
	CFA_P70_FKB_OTL4_TYPE_FLD = 49,
	CFA_P70_FKB_OTL4_SRC_FLD = 50,
	CFA_P70_FKB_OTL4_DST_FLD = 51,
	CFA_P70_FKB_OTL4_FLAGS_FLD = 52,
	CFA_P70_FKB_OTL4_SEQ_FLD = 53,
	CFA_P70_FKB_OTL4_PA_FLD = 54,
	CFA_P70_FKB_OTL4_OPT_FLD = 55,
	CFA_P70_FKB_OTL4_TCPTS_FLD = 56,
	CFA_P70_FKB_OTL4_ERR_FLD = 57,
	CFA_P70_FKB_OT_TYPE_FLD = 58,
	CFA_P70_FKB_OT_FLAGS_FLD = 59,
	CFA_P70_FKB_OT_IDS_FLD = 60,
	CFA_P70_FKB_OT_ID_FLD = 61,
	CFA_P70_FKB_OT_CTXTS_FLD = 62,
	CFA_P70_FKB_OT_CTXT_FLD = 63,
	CFA_P70_FKB_OT_QOS_FLD = 64,
	CFA_P70_FKB_OT_ERR_FLD = 65,
	CFA_P70_FKB_TL2_TYPE_FLD = 66,
	CFA_P70_FKB_TL2_DMAC_FLD = 67,
	CFA_P70_FKB_TL2_SMAC_FLD = 68,
	CFA_P70_FKB_TL2_DT_FLD = 69,
	CFA_P70_FKB_TL2_SA_FLD = 70,
	CFA_P70_FKB_TL2_NVT_FLD = 71,
	CFA_P70_FKB_TL2_OVP_FLD = 72,
	CFA_P70_FKB_TL2_OVD_FLD = 73,
	CFA_P70_FKB_TL2_OVV_FLD = 74,
	CFA_P70_FKB_TL2_OVT_FLD = 75,
	CFA_P70_FKB_TL2_IVP_FLD = 76,
	CFA_P70_FKB_TL2_IVD_FLD = 77,
	CFA_P70_FKB_TL2_IVV_FLD = 78,
	CFA_P70_FKB_TL2_IVT_FLD = 79,
	CFA_P70_FKB_TL2_ETYPE_FLD = 80,
	CFA_P70_FKB_TL3_TYPE_FLD = 81,
	CFA_P70_FKB_TL3_SIP3_FLD = 82,
	CFA_P70_FKB_TL3_SIP2_FLD = 83,
	CFA_P70_FKB_TL3_SIP1_FLD = 84,
	CFA_P70_FKB_TL3_SIP0_FLD = 85,
	CFA_P70_FKB_TL3_DIP3_FLD = 86,
	CFA_P70_FKB_TL3_DIP2_FLD = 87,
	CFA_P70_FKB_TL3_DIP1_FLD = 88,
	CFA_P70_FKB_TL3_DIP0_FLD = 89,
	CFA_P70_FKB_TL3_TTL_FLD = 90,
	CFA_P70_FKB_TL3_PROT_FLD = 91,
	CFA_P70_FKB_TL3_FID_FLD = 92,
	CFA_P70_FKB_TL3_QOS_FLD = 93,
	CFA_P70_FKB_TL3_IEH_NONEXT_FLD = 94,
	CFA_P70_FKB_TL3_IEH_SEP_FLD = 95,
	CFA_P70_FKB_TL3_IEH_AUTH_FLD = 96,
	CFA_P70_FKB_TL3_IEH_DEST_FLD = 97,
	CFA_P70_FKB_TL3_IEH_FRAG_FLD = 98,
	CFA_P70_FKB_TL3_IEH_RTHDR_FLD = 99,
	CFA_P70_FKB_TL3_IEH_HOP_FLD = 100,
	CFA_P70_FKB_TL3_IEH_1FRAG_FLD = 101,
	CFA_P70_FKB_TL3_DF_FLD = 102,
	CFA_P70_FKB_TL3_L3ERR_FLD = 103,
	CFA_P70_FKB_TL4_TYPE_FLD = 104,
	CFA_P70_FKB_TL4_SRC_FLD = 105,
	CFA_P70_FKB_TL4_DST_FLD = 106,
	CFA_P70_FKB_TL4_FLAGS_FLD = 107,
	CFA_P70_FKB_TL4_SEQ_FLD = 108,
	CFA_P70_FKB_TL4_PA_FLD = 109,
	CFA_P70_FKB_TL4_OPT_FLD = 110,
	CFA_P70_FKB_TL4_TCPTS_FLD = 111,
	CFA_P70_FKB_TL4_ERR_FLD = 112,
	CFA_P70_FKB_T_TYPE_FLD = 113,
	CFA_P70_FKB_T_FLAGS_FLD = 114,
	CFA_P70_FKB_T_IDS_FLD = 115,
	CFA_P70_FKB_T_ID_FLD = 116,
	CFA_P70_FKB_T_CTXTS_FLD = 117,
	CFA_P70_FKB_T_CTXT_FLD = 118,
	CFA_P70_FKB_T_QOS_FLD = 119,
	CFA_P70_FKB_T_ERR_FLD = 120,
	CFA_P70_FKB_L2_TYPE_FLD = 121,
	CFA_P70_FKB_L2_DMAC_FLD = 122,
	CFA_P70_FKB_L2_SMAC_FLD = 123,
	CFA_P70_FKB_L2_DT_FLD = 124,
	CFA_P70_FKB_L2_SA_FLD = 125,
	CFA_P70_FKB_L2_NVT_FLD = 126,
	CFA_P70_FKB_L2_OVP_FLD = 127,
	CFA_P70_FKB_L2_OVD_FLD = 128,
	CFA_P70_FKB_L2_OVV_FLD = 129,
	CFA_P70_FKB_L2_OVT_FLD = 130,
	CFA_P70_FKB_L2_IVP_FLD = 131,
	CFA_P70_FKB_L2_IVD_FLD = 132,
	CFA_P70_FKB_L2_IVV_FLD = 133,
	CFA_P70_FKB_L2_IVT_FLD = 134,
	CFA_P70_FKB_L2_ETYPE_FLD = 135,
	CFA_P70_FKB_L3_TYPE_FLD = 136,
	CFA_P70_FKB_L3_SIP3_FLD = 137,
	CFA_P70_FKB_L3_SIP2_FLD = 138,
	CFA_P70_FKB_L3_SIP1_FLD = 139,
	CFA_P70_FKB_L3_SIP0_FLD = 140,
	CFA_P70_FKB_L3_DIP3_FLD = 141,
	CFA_P70_FKB_L3_DIP2_FLD = 142,
	CFA_P70_FKB_L3_DIP1_FLD = 143,
	CFA_P70_FKB_L3_DIP0_FLD = 144,
	CFA_P70_FKB_L3_TTL_FLD = 145,
	CFA_P70_FKB_L3_PROT_FLD = 146,
	CFA_P70_FKB_L3_FID_FLD = 147,
	CFA_P70_FKB_L3_QOS_FLD = 148,
	CFA_P70_FKB_L3_IEH_NONEXT_FLD = 149,
	CFA_P70_FKB_L3_IEH_SEP_FLD = 150,
	CFA_P70_FKB_L3_IEH_AUTH_FLD = 151,
	CFA_P70_FKB_L3_IEH_DEST_FLD = 152,
	CFA_P70_FKB_L3_IEH_FRAG_FLD = 153,
	CFA_P70_FKB_L3_IEH_RTHDR_FLD = 154,
	CFA_P70_FKB_L3_IEH_HOP_FLD = 155,
	CFA_P70_FKB_L3_IEH_1FRAG_FLD = 156,
	CFA_P70_FKB_L3_DF_FLD = 157,
	CFA_P70_FKB_L3_L3ERR_FLD = 158,
	CFA_P70_FKB_L4_TYPE_FLD = 159,
	CFA_P70_FKB_L4_SRC_FLD = 160,
	CFA_P70_FKB_L4_DST_FLD = 161,
	CFA_P70_FKB_L4_FLAGS_FLD = 162,
	CFA_P70_FKB_L4_SEQ_FLD = 163,
	CFA_P70_FKB_L4_ACK_FLD = 164,
	CFA_P70_FKB_L4_WIN_FLD = 165,
	CFA_P70_FKB_L4_PA_FLD = 166,
	CFA_P70_FKB_L4_OPT_FLD = 167,
	CFA_P70_FKB_L4_TCPTS_FLD = 168,
	CFA_P70_FKB_L4_TSVAL_FLD = 169,
	CFA_P70_FKB_L4_TXECR_FLD = 170,
	CFA_P70_FKB_L4_ERR_FLD = 171,
	CFA_P70_FKB_MAX_FLD = 172,
};

/**
 * Enumeration for wc tcam fkb
 */
enum cfa_p70_wc_tcam_fkb_flds {
	CFA_P70_WC_TCAM_FKB_PROF_ID_FLD = 0,
	CFA_P70_WC_TCAM_FKB_L2CTXT_FLD = 1,
	CFA_P70_WC_TCAM_FKB_L2FUNC_FLD = 2,
	CFA_P70_WC_TCAM_FKB_PARIF_FLD = 3,
	CFA_P70_WC_TCAM_FKB_SPIF_FLD = 4,
	CFA_P70_WC_TCAM_FKB_SVIF_FLD = 5,
	CFA_P70_WC_TCAM_FKB_LCOS_FLD = 6,
	CFA_P70_WC_TCAM_FKB_META_HI_FLD = 7,
	CFA_P70_WC_TCAM_FKB_META_LO_FLD = 8,
	CFA_P70_WC_TCAM_FKB_RCYC_CNT_FLD = 9,
	CFA_P70_WC_TCAM_FKB_LOOPBACK_FLD = 10,
	CFA_P70_WC_TCAM_FKB_OTL2_TYPE_FLD = 11,
	CFA_P70_WC_TCAM_FKB_OTL2_DMAC_FLD = 12,
	CFA_P70_WC_TCAM_FKB_OTL2_SMAC_FLD = 13,
	CFA_P70_WC_TCAM_FKB_OTL2_DT_FLD = 14,
	CFA_P70_WC_TCAM_FKB_OTL2_SA_FLD = 15,
	CFA_P70_WC_TCAM_FKB_OTL2_NVT_FLD = 16,
	CFA_P70_WC_TCAM_FKB_OTL2_OVP_FLD = 17,
	CFA_P70_WC_TCAM_FKB_OTL2_OVD_FLD = 18,
	CFA_P70_WC_TCAM_FKB_OTL2_OVV_FLD = 19,
	CFA_P70_WC_TCAM_FKB_OTL2_OVT_FLD = 20,
	CFA_P70_WC_TCAM_FKB_OTL2_IVP_FLD = 21,
	CFA_P70_WC_TCAM_FKB_OTL2_IVD_FLD = 22,
	CFA_P70_WC_TCAM_FKB_OTL2_IVV_FLD = 23,
	CFA_P70_WC_TCAM_FKB_OTL2_IVT_FLD = 24,
	CFA_P70_WC_TCAM_FKB_OTL2_ETYPE_FLD = 25,
	CFA_P70_WC_TCAM_FKB_OTL3_TYPE_FLD = 26,
	CFA_P70_WC_TCAM_FKB_OTL3_SIP3_FLD = 27,
	CFA_P70_WC_TCAM_FKB_OTL3_SIP2_FLD = 28,
	CFA_P70_WC_TCAM_FKB_OTL3_SIP1_FLD = 29,
	CFA_P70_WC_TCAM_FKB_OTL3_SIP0_FLD = 30,
	CFA_P70_WC_TCAM_FKB_OTL3_DIP3_FLD = 31,
	CFA_P70_WC_TCAM_FKB_OTL3_DIP2_FLD = 32,
	CFA_P70_WC_TCAM_FKB_OTL3_DIP1_FLD = 33,
	CFA_P70_WC_TCAM_FKB_OTL3_DIP0_FLD = 34,
	CFA_P70_WC_TCAM_FKB_OTL3_TTL_FLD = 35,
	CFA_P70_WC_TCAM_FKB_OTL3_PROT_FLD = 36,
	CFA_P70_WC_TCAM_FKB_OTL3_FID_FLD = 37,
	CFA_P70_WC_TCAM_FKB_OTL3_QOS_FLD = 38,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_NONEXT_FLD = 39,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_SEP_FLD = 40,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_AUTH_FLD = 41,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_DEST_FLD = 42,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_FRAG_FLD = 43,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_RTHDR_FLD = 44,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_HOP_FLD = 45,
	CFA_P70_WC_TCAM_FKB_OTL3_IEH_1FRAG_FLD = 46,
	CFA_P70_WC_TCAM_FKB_OTL3_DF_FLD = 47,
	CFA_P70_WC_TCAM_FKB_OTL3_L3ERR_FLD = 48,
	CFA_P70_WC_TCAM_FKB_OTL4_TYPE_FLD = 49,
	CFA_P70_WC_TCAM_FKB_OTL4_SRC_FLD = 50,
	CFA_P70_WC_TCAM_FKB_OTL4_DST_FLD = 51,
	CFA_P70_WC_TCAM_FKB_OTL4_FLAGS_FLD = 52,
	CFA_P70_WC_TCAM_FKB_OTL4_SEQ_FLD = 53,
	CFA_P70_WC_TCAM_FKB_OTL4_PA_FLD = 54,
	CFA_P70_WC_TCAM_FKB_OTL4_OPT_FLD = 55,
	CFA_P70_WC_TCAM_FKB_OTL4_TCPTS_FLD = 56,
	CFA_P70_WC_TCAM_FKB_OTL4_ERR_FLD = 57,
	CFA_P70_WC_TCAM_FKB_OT_TYPE_FLD = 58,
	CFA_P70_WC_TCAM_FKB_OT_FLAGS_FLD = 59,
	CFA_P70_WC_TCAM_FKB_OT_IDS_FLD = 60,
	CFA_P70_WC_TCAM_FKB_OT_ID_FLD = 61,
	CFA_P70_WC_TCAM_FKB_OT_CTXTS_FLD = 62,
	CFA_P70_WC_TCAM_FKB_OT_CTXT_FLD = 63,
	CFA_P70_WC_TCAM_FKB_OT_QOS_FLD = 64,
	CFA_P70_WC_TCAM_FKB_OT_ERR_FLD = 65,
	CFA_P70_WC_TCAM_FKB_TL2_TYPE_FLD = 66,
	CFA_P70_WC_TCAM_FKB_TL2_DMAC_FLD = 67,
	CFA_P70_WC_TCAM_FKB_TL2_SMAC_FLD = 68,
	CFA_P70_WC_TCAM_FKB_TL2_DT_FLD = 69,
	CFA_P70_WC_TCAM_FKB_TL2_SA_FLD = 70,
	CFA_P70_WC_TCAM_FKB_TL2_NVT_FLD = 71,
	CFA_P70_WC_TCAM_FKB_TL2_OVP_FLD = 72,
	CFA_P70_WC_TCAM_FKB_TL2_OVD_FLD = 73,
	CFA_P70_WC_TCAM_FKB_TL2_OVV_FLD = 74,
	CFA_P70_WC_TCAM_FKB_TL2_OVT_FLD = 75,
	CFA_P70_WC_TCAM_FKB_TL2_IVP_FLD = 76,
	CFA_P70_WC_TCAM_FKB_TL2_IVD_FLD = 77,
	CFA_P70_WC_TCAM_FKB_TL2_IVV_FLD = 78,
	CFA_P70_WC_TCAM_FKB_TL2_IVT_FLD = 79,
	CFA_P70_WC_TCAM_FKB_TL2_ETYPE_FLD = 80,
	CFA_P70_WC_TCAM_FKB_TL3_TYPE_FLD = 81,
	CFA_P70_WC_TCAM_FKB_TL3_SIP3_FLD = 82,
	CFA_P70_WC_TCAM_FKB_TL3_SIP2_FLD = 83,
	CFA_P70_WC_TCAM_FKB_TL3_SIP1_FLD = 84,
	CFA_P70_WC_TCAM_FKB_TL3_SIP0_FLD = 85,
	CFA_P70_WC_TCAM_FKB_TL3_DIP3_FLD = 86,
	CFA_P70_WC_TCAM_FKB_TL3_DIP2_FLD = 87,
	CFA_P70_WC_TCAM_FKB_TL3_DIP1_FLD = 88,
	CFA_P70_WC_TCAM_FKB_TL3_DIP0_FLD = 89,
	CFA_P70_WC_TCAM_FKB_TL3_TTL_FLD = 90,
	CFA_P70_WC_TCAM_FKB_TL3_PROT_FLD = 91,
	CFA_P70_WC_TCAM_FKB_TL3_FID_FLD = 92,
	CFA_P70_WC_TCAM_FKB_TL3_QOS_FLD = 93,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_NONEXT_FLD = 94,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_SEP_FLD = 95,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_AUTH_FLD = 96,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_DEST_FLD = 97,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_FRAG_FLD = 98,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_RTHDR_FLD = 99,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_HOP_FLD = 100,
	CFA_P70_WC_TCAM_FKB_TL3_IEH_1FRAG_FLD = 101,
	CFA_P70_WC_TCAM_FKB_TL3_DF_FLD = 102,
	CFA_P70_WC_TCAM_FKB_TL3_L3ERR_FLD = 103,
	CFA_P70_WC_TCAM_FKB_TL4_TYPE_FLD = 104,
	CFA_P70_WC_TCAM_FKB_TL4_SRC_FLD = 105,
	CFA_P70_WC_TCAM_FKB_TL4_DST_FLD = 106,
	CFA_P70_WC_TCAM_FKB_TL4_FLAGS_FLD = 107,
	CFA_P70_WC_TCAM_FKB_TL4_SEQ_FLD = 108,
	CFA_P70_WC_TCAM_FKB_TL4_PA_FLD = 109,
	CFA_P70_WC_TCAM_FKB_TL4_OPT_FLD = 110,
	CFA_P70_WC_TCAM_FKB_TL4_TCPTS_FLD = 111,
	CFA_P70_WC_TCAM_FKB_TL4_ERR_FLD = 112,
	CFA_P70_WC_TCAM_FKB_T_TYPE_FLD = 113,
	CFA_P70_WC_TCAM_FKB_T_FLAGS_FLD = 114,
	CFA_P70_WC_TCAM_FKB_T_IDS_FLD = 115,
	CFA_P70_WC_TCAM_FKB_T_ID_FLD = 116,
	CFA_P70_WC_TCAM_FKB_T_CTXTS_FLD = 117,
	CFA_P70_WC_TCAM_FKB_T_CTXT_FLD = 118,
	CFA_P70_WC_TCAM_FKB_T_QOS_FLD = 119,
	CFA_P70_WC_TCAM_FKB_T_ERR_FLD = 120,
	CFA_P70_WC_TCAM_FKB_L2_TYPE_FLD = 121,
	CFA_P70_WC_TCAM_FKB_L2_DMAC_FLD = 122,
	CFA_P70_WC_TCAM_FKB_L2_SMAC_FLD = 123,
	CFA_P70_WC_TCAM_FKB_L2_DT_FLD = 124,
	CFA_P70_WC_TCAM_FKB_L2_SA_FLD = 125,
	CFA_P70_WC_TCAM_FKB_L2_NVT_FLD = 126,
	CFA_P70_WC_TCAM_FKB_L2_OVP_FLD = 127,
	CFA_P70_WC_TCAM_FKB_L2_OVD_FLD = 128,
	CFA_P70_WC_TCAM_FKB_L2_OVV_FLD = 129,
	CFA_P70_WC_TCAM_FKB_L2_OVT_FLD = 130,
	CFA_P70_WC_TCAM_FKB_L2_IVP_FLD = 131,
	CFA_P70_WC_TCAM_FKB_L2_IVD_FLD = 132,
	CFA_P70_WC_TCAM_FKB_L2_IVV_FLD = 133,
	CFA_P70_WC_TCAM_FKB_L2_IVT_FLD = 134,
	CFA_P70_WC_TCAM_FKB_L2_ETYPE_FLD = 135,
	CFA_P70_WC_TCAM_FKB_L3_TYPE_FLD = 136,
	CFA_P70_WC_TCAM_FKB_L3_SIP3_FLD = 137,
	CFA_P70_WC_TCAM_FKB_L3_SIP2_FLD = 138,
	CFA_P70_WC_TCAM_FKB_L3_SIP1_FLD = 139,
	CFA_P70_WC_TCAM_FKB_L3_SIP0_FLD = 140,
	CFA_P70_WC_TCAM_FKB_L3_DIP3_FLD = 141,
	CFA_P70_WC_TCAM_FKB_L3_DIP2_FLD = 142,
	CFA_P70_WC_TCAM_FKB_L3_DIP1_FLD = 143,
	CFA_P70_WC_TCAM_FKB_L3_DIP0_FLD = 144,
	CFA_P70_WC_TCAM_FKB_L3_TTL_FLD = 145,
	CFA_P70_WC_TCAM_FKB_L3_PROT_FLD = 146,
	CFA_P70_WC_TCAM_FKB_L3_FID_FLD = 147,
	CFA_P70_WC_TCAM_FKB_L3_QOS_FLD = 148,
	CFA_P70_WC_TCAM_FKB_L3_IEH_NONEXT_FLD = 149,
	CFA_P70_WC_TCAM_FKB_L3_IEH_SEP_FLD = 150,
	CFA_P70_WC_TCAM_FKB_L3_IEH_AUTH_FLD = 151,
	CFA_P70_WC_TCAM_FKB_L3_IEH_DEST_FLD = 152,
	CFA_P70_WC_TCAM_FKB_L3_IEH_FRAG_FLD = 153,
	CFA_P70_WC_TCAM_FKB_L3_IEH_RTHDR_FLD = 154,
	CFA_P70_WC_TCAM_FKB_L3_IEH_HOP_FLD = 155,
	CFA_P70_WC_TCAM_FKB_L3_IEH_1FRAG_FLD = 156,
	CFA_P70_WC_TCAM_FKB_L3_DF_FLD = 157,
	CFA_P70_WC_TCAM_FKB_L3_L3ERR_FLD = 158,
	CFA_P70_WC_TCAM_FKB_L4_TYPE_FLD = 159,
	CFA_P70_WC_TCAM_FKB_L4_SRC_FLD = 160,
	CFA_P70_WC_TCAM_FKB_L4_DST_FLD = 161,
	CFA_P70_WC_TCAM_FKB_L4_FLAGS_FLD = 162,
	CFA_P70_WC_TCAM_FKB_L4_SEQ_FLD = 163,
	CFA_P70_WC_TCAM_FKB_L4_ACK_FLD = 164,
	CFA_P70_WC_TCAM_FKB_L4_WIN_FLD = 165,
	CFA_P70_WC_TCAM_FKB_L4_PA_FLD = 166,
	CFA_P70_WC_TCAM_FKB_L4_OPT_FLD = 167,
	CFA_P70_WC_TCAM_FKB_L4_TCPTS_FLD = 168,
	CFA_P70_WC_TCAM_FKB_L4_TSVAL_FLD = 169,
	CFA_P70_WC_TCAM_FKB_L4_TXECR_FLD = 170,
	CFA_P70_WC_TCAM_FKB_L4_ERR_FLD = 171,
	CFA_P70_WC_TCAM_FKB_MAX_FLD = 172,
};

/**
 * Enumeration for em fkb
 */
enum cfa_p70_em_fkb_flds {
	CFA_P70_EM_FKB_PROF_ID_FLD = 0,
	CFA_P70_EM_FKB_L2CTXT_FLD = 1,
	CFA_P70_EM_FKB_L2FUNC_FLD = 2,
	CFA_P70_EM_FKB_PARIF_FLD = 3,
	CFA_P70_EM_FKB_SPIF_FLD = 4,
	CFA_P70_EM_FKB_SVIF_FLD = 5,
	CFA_P70_EM_FKB_LCOS_FLD = 6,
	CFA_P70_EM_FKB_META_HI_FLD = 7,
	CFA_P70_EM_FKB_META_LO_FLD = 8,
	CFA_P70_EM_FKB_RCYC_CNT_FLD = 9,
	CFA_P70_EM_FKB_LOOPBACK_FLD = 10,
	CFA_P70_EM_FKB_OTL2_TYPE_FLD = 11,
	CFA_P70_EM_FKB_OTL2_DMAC_FLD = 12,
	CFA_P70_EM_FKB_OTL2_SMAC_FLD = 13,
	CFA_P70_EM_FKB_OTL2_DT_FLD = 14,
	CFA_P70_EM_FKB_OTL2_SA_FLD = 15,
	CFA_P70_EM_FKB_OTL2_NVT_FLD = 16,
	CFA_P70_EM_FKB_OTL2_OVP_FLD = 17,
	CFA_P70_EM_FKB_OTL2_OVD_FLD = 18,
	CFA_P70_EM_FKB_OTL2_OVV_FLD = 19,
	CFA_P70_EM_FKB_OTL2_OVT_FLD = 20,
	CFA_P70_EM_FKB_OTL2_IVP_FLD = 21,
	CFA_P70_EM_FKB_OTL2_IVD_FLD = 22,
	CFA_P70_EM_FKB_OTL2_IVV_FLD = 23,
	CFA_P70_EM_FKB_OTL2_IVT_FLD = 24,
	CFA_P70_EM_FKB_OTL2_ETYPE_FLD = 25,
	CFA_P70_EM_FKB_OTL3_TYPE_FLD = 26,
	CFA_P70_EM_FKB_OTL3_SIP3_FLD = 27,
	CFA_P70_EM_FKB_OTL3_SIP2_FLD = 28,
	CFA_P70_EM_FKB_OTL3_SIP1_FLD = 29,
	CFA_P70_EM_FKB_OTL3_SIP0_FLD = 30,
	CFA_P70_EM_FKB_OTL3_DIP3_FLD = 31,
	CFA_P70_EM_FKB_OTL3_DIP2_FLD = 32,
	CFA_P70_EM_FKB_OTL3_DIP1_FLD = 33,
	CFA_P70_EM_FKB_OTL3_DIP0_FLD = 34,
	CFA_P70_EM_FKB_OTL3_TTL_FLD = 35,
	CFA_P70_EM_FKB_OTL3_PROT_FLD = 36,
	CFA_P70_EM_FKB_OTL3_FID_FLD = 37,
	CFA_P70_EM_FKB_OTL3_QOS_FLD = 38,
	CFA_P70_EM_FKB_OTL3_IEH_NONEXT_FLD = 39,
	CFA_P70_EM_FKB_OTL3_IEH_SEP_FLD = 40,
	CFA_P70_EM_FKB_OTL3_IEH_AUTH_FLD = 41,
	CFA_P70_EM_FKB_OTL3_IEH_DEST_FLD = 42,
	CFA_P70_EM_FKB_OTL3_IEH_FRAG_FLD = 43,
	CFA_P70_EM_FKB_OTL3_IEH_RTHDR_FLD = 44,
	CFA_P70_EM_FKB_OTL3_IEH_HOP_FLD = 45,
	CFA_P70_EM_FKB_OTL3_IEH_1FRAG_FLD = 46,
	CFA_P70_EM_FKB_OTL3_DF_FLD = 47,
	CFA_P70_EM_FKB_OTL3_L3ERR_FLD = 48,
	CFA_P70_EM_FKB_OTL4_TYPE_FLD = 49,
	CFA_P70_EM_FKB_OTL4_SRC_FLD = 50,
	CFA_P70_EM_FKB_OTL4_DST_FLD = 51,
	CFA_P70_EM_FKB_OTL4_FLAGS_FLD = 52,
	CFA_P70_EM_FKB_OTL4_SEQ_FLD = 53,
	CFA_P70_EM_FKB_OTL4_PA_FLD = 54,
	CFA_P70_EM_FKB_OTL4_OPT_FLD = 55,
	CFA_P70_EM_FKB_OTL4_TCPTS_FLD = 56,
	CFA_P70_EM_FKB_OTL4_ERR_FLD = 57,
	CFA_P70_EM_FKB_OT_TYPE_FLD = 58,
	CFA_P70_EM_FKB_OT_FLAGS_FLD = 59,
	CFA_P70_EM_FKB_OT_IDS_FLD = 60,
	CFA_P70_EM_FKB_OT_ID_FLD = 61,
	CFA_P70_EM_FKB_OT_CTXTS_FLD = 62,
	CFA_P70_EM_FKB_OT_CTXT_FLD = 63,
	CFA_P70_EM_FKB_OT_QOS_FLD = 64,
	CFA_P70_EM_FKB_OT_ERR_FLD = 65,
	CFA_P70_EM_FKB_TL2_TYPE_FLD = 66,
	CFA_P70_EM_FKB_TL2_DMAC_FLD = 67,
	CFA_P70_EM_FKB_TL2_SMAC_FLD = 68,
	CFA_P70_EM_FKB_TL2_DT_FLD = 69,
	CFA_P70_EM_FKB_TL2_SA_FLD = 70,
	CFA_P70_EM_FKB_TL2_NVT_FLD = 71,
	CFA_P70_EM_FKB_TL2_OVP_FLD = 72,
	CFA_P70_EM_FKB_TL2_OVD_FLD = 73,
	CFA_P70_EM_FKB_TL2_OVV_FLD = 74,
	CFA_P70_EM_FKB_TL2_OVT_FLD = 75,
	CFA_P70_EM_FKB_TL2_IVP_FLD = 76,
	CFA_P70_EM_FKB_TL2_IVD_FLD = 77,
	CFA_P70_EM_FKB_TL2_IVV_FLD = 78,
	CFA_P70_EM_FKB_TL2_IVT_FLD = 79,
	CFA_P70_EM_FKB_TL2_ETYPE_FLD = 80,
	CFA_P70_EM_FKB_TL3_TYPE_FLD = 81,
	CFA_P70_EM_FKB_TL3_SIP3_FLD = 82,
	CFA_P70_EM_FKB_TL3_SIP2_FLD = 83,
	CFA_P70_EM_FKB_TL3_SIP1_FLD = 84,
	CFA_P70_EM_FKB_TL3_SIP0_FLD = 85,
	CFA_P70_EM_FKB_TL3_DIP3_FLD = 86,
	CFA_P70_EM_FKB_TL3_DIP2_FLD = 87,
	CFA_P70_EM_FKB_TL3_DIP1_FLD = 88,
	CFA_P70_EM_FKB_TL3_DIP0_FLD = 89,
	CFA_P70_EM_FKB_TL3_TTL_FLD = 90,
	CFA_P70_EM_FKB_TL3_PROT_FLD = 91,
	CFA_P70_EM_FKB_TL3_FID_FLD = 92,
	CFA_P70_EM_FKB_TL3_QOS_FLD = 93,
	CFA_P70_EM_FKB_TL3_IEH_NONEXT_FLD = 94,
	CFA_P70_EM_FKB_TL3_IEH_SEP_FLD = 95,
	CFA_P70_EM_FKB_TL3_IEH_AUTH_FLD = 96,
	CFA_P70_EM_FKB_TL3_IEH_DEST_FLD = 97,
	CFA_P70_EM_FKB_TL3_IEH_FRAG_FLD = 98,
	CFA_P70_EM_FKB_TL3_IEH_RTHDR_FLD = 99,
	CFA_P70_EM_FKB_TL3_IEH_HOP_FLD = 100,
	CFA_P70_EM_FKB_TL3_IEH_1FRAG_FLD = 101,
	CFA_P70_EM_FKB_TL3_DF_FLD = 102,
	CFA_P70_EM_FKB_TL3_L3ERR_FLD = 103,
	CFA_P70_EM_FKB_TL4_TYPE_FLD = 104,
	CFA_P70_EM_FKB_TL4_SRC_FLD = 105,
	CFA_P70_EM_FKB_TL4_DST_FLD = 106,
	CFA_P70_EM_FKB_TL4_FLAGS_FLD = 107,
	CFA_P70_EM_FKB_TL4_SEQ_FLD = 108,
	CFA_P70_EM_FKB_TL4_PA_FLD = 109,
	CFA_P70_EM_FKB_TL4_OPT_FLD = 110,
	CFA_P70_EM_FKB_TL4_TCPTS_FLD = 111,
	CFA_P70_EM_FKB_TL4_ERR_FLD = 112,
	CFA_P70_EM_FKB_T_TYPE_FLD = 113,
	CFA_P70_EM_FKB_T_FLAGS_FLD = 114,
	CFA_P70_EM_FKB_T_IDS_FLD = 115,
	CFA_P70_EM_FKB_T_ID_FLD = 116,
	CFA_P70_EM_FKB_T_CTXTS_FLD = 117,
	CFA_P70_EM_FKB_T_CTXT_FLD = 118,
	CFA_P70_EM_FKB_T_QOS_FLD = 119,
	CFA_P70_EM_FKB_T_ERR_FLD = 120,
	CFA_P70_EM_FKB_L2_TYPE_FLD = 121,
	CFA_P70_EM_FKB_L2_DMAC_FLD = 122,
	CFA_P70_EM_FKB_L2_SMAC_FLD = 123,
	CFA_P70_EM_FKB_L2_DT_FLD = 124,
	CFA_P70_EM_FKB_L2_SA_FLD = 125,
	CFA_P70_EM_FKB_L2_NVT_FLD = 126,
	CFA_P70_EM_FKB_L2_OVP_FLD = 127,
	CFA_P70_EM_FKB_L2_OVD_FLD = 128,
	CFA_P70_EM_FKB_L2_OVV_FLD = 129,
	CFA_P70_EM_FKB_L2_OVT_FLD = 130,
	CFA_P70_EM_FKB_L2_IVP_FLD = 131,
	CFA_P70_EM_FKB_L2_IVD_FLD = 132,
	CFA_P70_EM_FKB_L2_IVV_FLD = 133,
	CFA_P70_EM_FKB_L2_IVT_FLD = 134,
	CFA_P70_EM_FKB_L2_ETYPE_FLD = 135,
	CFA_P70_EM_FKB_L3_TYPE_FLD = 136,
	CFA_P70_EM_FKB_L3_SIP3_FLD = 137,
	CFA_P70_EM_FKB_L3_SIP2_FLD = 138,
	CFA_P70_EM_FKB_L3_SIP1_FLD = 139,
	CFA_P70_EM_FKB_L3_SIP0_FLD = 140,
	CFA_P70_EM_FKB_L3_DIP3_FLD = 141,
	CFA_P70_EM_FKB_L3_DIP2_FLD = 142,
	CFA_P70_EM_FKB_L3_DIP1_FLD = 143,
	CFA_P70_EM_FKB_L3_DIP0_FLD = 144,
	CFA_P70_EM_FKB_L3_TTL_FLD = 145,
	CFA_P70_EM_FKB_L3_PROT_FLD = 146,
	CFA_P70_EM_FKB_L3_FID_FLD = 147,
	CFA_P70_EM_FKB_L3_QOS_FLD = 148,
	CFA_P70_EM_FKB_L3_IEH_NONEXT_FLD = 149,
	CFA_P70_EM_FKB_L3_IEH_SEP_FLD = 150,
	CFA_P70_EM_FKB_L3_IEH_AUTH_FLD = 151,
	CFA_P70_EM_FKB_L3_IEH_DEST_FLD = 152,
	CFA_P70_EM_FKB_L3_IEH_FRAG_FLD = 153,
	CFA_P70_EM_FKB_L3_IEH_RTHDR_FLD = 154,
	CFA_P70_EM_FKB_L3_IEH_HOP_FLD = 155,
	CFA_P70_EM_FKB_L3_IEH_1FRAG_FLD = 156,
	CFA_P70_EM_FKB_L3_DF_FLD = 157,
	CFA_P70_EM_FKB_L3_L3ERR_FLD = 158,
	CFA_P70_EM_FKB_L4_TYPE_FLD = 159,
	CFA_P70_EM_FKB_L4_SRC_FLD = 160,
	CFA_P70_EM_FKB_L4_DST_FLD = 161,
	CFA_P70_EM_FKB_L4_FLAGS_FLD = 162,
	CFA_P70_EM_FKB_L4_SEQ_FLD = 163,
	CFA_P70_EM_FKB_L4_ACK_FLD = 164,
	CFA_P70_EM_FKB_L4_WIN_FLD = 165,
	CFA_P70_EM_FKB_L4_PA_FLD = 166,
	CFA_P70_EM_FKB_L4_OPT_FLD = 167,
	CFA_P70_EM_FKB_L4_TCPTS_FLD = 168,
	CFA_P70_EM_FKB_L4_TSVAL_FLD = 169,
	CFA_P70_EM_FKB_L4_TXECR_FLD = 170,
	CFA_P70_EM_FKB_L4_ERR_FLD = 171,
	CFA_P70_EM_FKB_MAX_FLD = 172,
};

/**
 * Enumeration for em key layout
 */
enum cfa_p70_em_key_layout_flds {
	CFA_P70_EM_KL_RANGE_IDX_FLD = 0,
	CFA_P70_EM_KL_RANGE_PROFILE_FLD = 1,
	CFA_P70_EM_KL_CREC_TIMER_VALUE_FLD = 2,
	CFA_P70_EM_KL_CREC_STATE_FLD = 3,
	CFA_P70_EM_KL_CREC_TCP_MSB_OPP_INIT_FLD = 4,
	CFA_P70_EM_KL_CREC_TCP_MSB_OPP_FLD = 5,
	CFA_P70_EM_KL_CREC_TCP_MSB_LOC_FLD = 6,
	CFA_P70_EM_KL_CREC_TCP_WIN_FLD = 7,
	CFA_P70_EM_KL_CREC_TCP_UPDT_EN_FLD = 8,
	CFA_P70_EM_KL_CREC_TCP_DIR_FLD = 9,
	CFA_P70_EM_KL_METADATA_FLD = 10,
	CFA_P70_EM_KL_PROF_FUNC_FLD = 11,
	CFA_P70_EM_KL_META_PROF_FLD = 12,
	CFA_P70_EM_KL_RECYCLE_DEST_FLD = 13,
	CFA_P70_EM_KL_FC_PTR_FLD = 14,
	CFA_P70_EM_KL_FC_TYPE_FLD = 15,
	CFA_P70_EM_KL_FC_OP_FLD = 16,
	CFA_P70_EM_KL_PATHS_M1_FLD = 17,
	CFA_P70_EM_KL_ACT_REC_SIZE_FLD = 18,
	CFA_P70_EM_KL_RING_TABLE_IDX_FLD = 19,
	CFA_P70_EM_KL_DESTINATION_FLD = 20,
	CFA_P70_EM_KL_ACT_REC_PTR_FLD = 21,
	CFA_P70_EM_KL_ACT_HINT_FLD = 22,
	CFA_P70_EM_KL_STRENGTH_FLD = 23,
	CFA_P70_EM_KL_OPCODE_FLD = 24,
	CFA_P70_EM_KL_EPOCH1_FLD = 25,
	CFA_P70_EM_KL_EPOCH0_FLD = 26,
	CFA_P70_EM_KL_REC_SIZE_FLD = 27,
	CFA_P70_EM_KL_VALID_FLD = 28,
	CFA_P70_EM_KL_PROF_ID_FLD = 29,
	CFA_P70_EM_KL_L2CTXT_FLD = 30,
	CFA_P70_EM_KL_L2FUNC_FLD = 31,
	CFA_P70_EM_KL_PARIF_FLD = 32,
	CFA_P70_EM_KL_SPIF_FLD = 33,
	CFA_P70_EM_KL_SVIF_FLD = 34,
	CFA_P70_EM_KL_LCOS_FLD = 35,
	CFA_P70_EM_KL_META_HI_FLD = 36,
	CFA_P70_EM_KL_META_LO_FLD = 37,
	CFA_P70_EM_KL_RCYC_CNT_FLD = 38,
	CFA_P70_EM_KL_LOOPBACK_FLD = 39,
	CFA_P70_EM_KL_OTL2_TYPE_FLD = 40,
	CFA_P70_EM_KL_OTL2_DMAC_FLD = 41,
	CFA_P70_EM_KL_OTL2_SMAC_FLD = 42,
	CFA_P70_EM_KL_OTL2_DT_FLD = 43,
	CFA_P70_EM_KL_OTL2_SA_FLD = 44,
	CFA_P70_EM_KL_OTL2_NVT_FLD = 45,
	CFA_P70_EM_KL_OTL2_OVP_FLD = 46,
	CFA_P70_EM_KL_OTL2_OVD_FLD = 47,
	CFA_P70_EM_KL_OTL2_OVV_FLD = 48,
	CFA_P70_EM_KL_OTL2_OVT_FLD = 49,
	CFA_P70_EM_KL_OTL2_IVP_FLD = 50,
	CFA_P70_EM_KL_OTL2_IVD_FLD = 51,
	CFA_P70_EM_KL_OTL2_IVV_FLD = 52,
	CFA_P70_EM_KL_OTL2_IVT_FLD = 53,
	CFA_P70_EM_KL_OTL2_ETYPE_FLD = 54,
	CFA_P70_EM_KL_OTL3_TYPE_FLD = 55,
	CFA_P70_EM_KL_OTL3_SIP3_FLD = 56,
	CFA_P70_EM_KL_OTL3_SIP2_FLD = 57,
	CFA_P70_EM_KL_OTL3_SIP1_FLD = 58,
	CFA_P70_EM_KL_OTL3_SIP0_FLD = 59,
	CFA_P70_EM_KL_OTL3_DIP3_FLD = 60,
	CFA_P70_EM_KL_OTL3_DIP2_FLD = 61,
	CFA_P70_EM_KL_OTL3_DIP1_FLD = 62,
	CFA_P70_EM_KL_OTL3_DIP0_FLD = 63,
	CFA_P70_EM_KL_OTL3_TTL_FLD = 64,
	CFA_P70_EM_KL_OTL3_PROT_FLD = 65,
	CFA_P70_EM_KL_OTL3_FID_FLD = 66,
	CFA_P70_EM_KL_OTL3_QOS_FLD = 67,
	CFA_P70_EM_KL_OTL3_IEH_NONEXT_FLD = 68,
	CFA_P70_EM_KL_OTL3_IEH_SEP_FLD = 69,
	CFA_P70_EM_KL_OTL3_IEH_AUTH_FLD = 70,
	CFA_P70_EM_KL_OTL3_IEH_DEST_FLD = 71,
	CFA_P70_EM_KL_OTL3_IEH_FRAG_FLD = 72,
	CFA_P70_EM_KL_OTL3_IEH_RTHDR_FLD = 73,
	CFA_P70_EM_KL_OTL3_IEH_HOP_FLD = 74,
	CFA_P70_EM_KL_OTL3_IEH_1FRAG_FLD = 75,
	CFA_P70_EM_KL_OTL3_DF_FLD = 76,
	CFA_P70_EM_KL_OTL3_L3ERR_FLD = 77,
	CFA_P70_EM_KL_OTL4_TYPE_FLD = 78,
	CFA_P70_EM_KL_OTL4_SRC_FLD = 79,
	CFA_P70_EM_KL_OTL4_DST_FLD = 80,
	CFA_P70_EM_KL_OTL4_FLAGS_FLD = 81,
	CFA_P70_EM_KL_OTL4_SEQ_FLD = 82,
	CFA_P70_EM_KL_OTL4_PA_FLD = 83,
	CFA_P70_EM_KL_OTL4_OPT_FLD = 84,
	CFA_P70_EM_KL_OTL4_TCPTS_FLD = 85,
	CFA_P70_EM_KL_OTL4_ERR_FLD = 86,
	CFA_P70_EM_KL_OT_TYPE_FLD = 87,
	CFA_P70_EM_KL_OT_FLAGS_FLD = 88,
	CFA_P70_EM_KL_OT_IDS_FLD = 89,
	CFA_P70_EM_KL_OT_ID_FLD = 90,
	CFA_P70_EM_KL_OT_CTXTS_FLD = 91,
	CFA_P70_EM_KL_OT_CTXT_FLD = 92,
	CFA_P70_EM_KL_OT_QOS_FLD = 93,
	CFA_P70_EM_KL_OT_ERR_FLD = 94,
	CFA_P70_EM_KL_TL2_TYPE_FLD = 95,
	CFA_P70_EM_KL_TL2_DMAC_FLD = 96,
	CFA_P70_EM_KL_TL2_SMAC_FLD = 97,
	CFA_P70_EM_KL_TL2_DT_FLD = 98,
	CFA_P70_EM_KL_TL2_SA_FLD = 99,
	CFA_P70_EM_KL_TL2_NVT_FLD = 100,
	CFA_P70_EM_KL_TL2_OVP_FLD = 101,
	CFA_P70_EM_KL_TL2_OVD_FLD = 102,
	CFA_P70_EM_KL_TL2_OVV_FLD = 103,
	CFA_P70_EM_KL_TL2_OVT_FLD = 104,
	CFA_P70_EM_KL_TL2_IVP_FLD = 105,
	CFA_P70_EM_KL_TL2_IVD_FLD = 106,
	CFA_P70_EM_KL_TL2_IVV_FLD = 107,
	CFA_P70_EM_KL_TL2_IVT_FLD = 108,
	CFA_P70_EM_KL_TL2_ETYPE_FLD = 109,
	CFA_P70_EM_KL_TL3_TYPE_FLD = 110,
	CFA_P70_EM_KL_TL3_SIP3_FLD = 111,
	CFA_P70_EM_KL_TL3_SIP2_FLD = 112,
	CFA_P70_EM_KL_TL3_SIP1_FLD = 113,
	CFA_P70_EM_KL_TL3_SIP0_FLD = 114,
	CFA_P70_EM_KL_TL3_DIP3_FLD = 115,
	CFA_P70_EM_KL_TL3_DIP2_FLD = 116,
	CFA_P70_EM_KL_TL3_DIP1_FLD = 117,
	CFA_P70_EM_KL_TL3_DIP0_FLD = 118,
	CFA_P70_EM_KL_TL3_TTL_FLD = 119,
	CFA_P70_EM_KL_TL3_PROT_FLD = 120,
	CFA_P70_EM_KL_TL3_FID_FLD = 121,
	CFA_P70_EM_KL_TL3_QOS_FLD = 122,
	CFA_P70_EM_KL_TL3_IEH_NONEXT_FLD = 123,
	CFA_P70_EM_KL_TL3_IEH_SEP_FLD = 124,
	CFA_P70_EM_KL_TL3_IEH_AUTH_FLD = 125,
	CFA_P70_EM_KL_TL3_IEH_DEST_FLD = 126,
	CFA_P70_EM_KL_TL3_IEH_FRAG_FLD = 127,
	CFA_P70_EM_KL_TL3_IEH_RTHDR_FLD = 128,
	CFA_P70_EM_KL_TL3_IEH_HOP_FLD = 129,
	CFA_P70_EM_KL_TL3_IEH_1FRAG_FLD = 130,
	CFA_P70_EM_KL_TL3_DF_FLD = 131,
	CFA_P70_EM_KL_TL3_L3ERR_FLD = 132,
	CFA_P70_EM_KL_TL4_TYPE_FLD = 133,
	CFA_P70_EM_KL_TL4_SRC_FLD = 134,
	CFA_P70_EM_KL_TL4_DST_FLD = 135,
	CFA_P70_EM_KL_TL4_FLAGS_FLD = 136,
	CFA_P70_EM_KL_TL4_SEQ_FLD = 137,
	CFA_P70_EM_KL_TL4_PA_FLD = 138,
	CFA_P70_EM_KL_TL4_OPT_FLD = 139,
	CFA_P70_EM_KL_TL4_TCPTS_FLD = 140,
	CFA_P70_EM_KL_TL4_ERR_FLD = 141,
	CFA_P70_EM_KL_T_TYPE_FLD = 142,
	CFA_P70_EM_KL_T_FLAGS_FLD = 143,
	CFA_P70_EM_KL_T_IDS_FLD = 144,
	CFA_P70_EM_KL_T_ID_FLD = 145,
	CFA_P70_EM_KL_T_CTXTS_FLD = 146,
	CFA_P70_EM_KL_T_CTXT_FLD = 147,
	CFA_P70_EM_KL_T_QOS_FLD = 148,
	CFA_P70_EM_KL_T_ERR_FLD = 149,
	CFA_P70_EM_KL_L2_TYPE_FLD = 150,
	CFA_P70_EM_KL_L2_DMAC_FLD = 151,
	CFA_P70_EM_KL_L2_SMAC_FLD = 152,
	CFA_P70_EM_KL_L2_DT_FLD = 153,
	CFA_P70_EM_KL_L2_SA_FLD = 154,
	CFA_P70_EM_KL_L2_NVT_FLD = 155,
	CFA_P70_EM_KL_L2_OVP_FLD = 156,
	CFA_P70_EM_KL_L2_OVD_FLD = 157,
	CFA_P70_EM_KL_L2_OVV_FLD = 158,
	CFA_P70_EM_KL_L2_OVT_FLD = 159,
	CFA_P70_EM_KL_L2_IVP_FLD = 160,
	CFA_P70_EM_KL_L2_IVD_FLD = 161,
	CFA_P70_EM_KL_L2_IVV_FLD = 162,
	CFA_P70_EM_KL_L2_IVT_FLD = 163,
	CFA_P70_EM_KL_L2_ETYPE_FLD = 164,
	CFA_P70_EM_KL_L3_TYPE_FLD = 165,
	CFA_P70_EM_KL_L3_SIP3_FLD = 166,
	CFA_P70_EM_KL_L3_SIP2_FLD = 167,
	CFA_P70_EM_KL_L3_SIP1_FLD = 168,
	CFA_P70_EM_KL_L3_SIP0_FLD = 169,
	CFA_P70_EM_KL_L3_DIP3_FLD = 170,
	CFA_P70_EM_KL_L3_DIP2_FLD = 171,
	CFA_P70_EM_KL_L3_DIP1_FLD = 172,
	CFA_P70_EM_KL_L3_DIP0_FLD = 173,
	CFA_P70_EM_KL_L3_TTL_FLD = 174,
	CFA_P70_EM_KL_L3_PROT_FLD = 175,
	CFA_P70_EM_KL_L3_FID_FLD = 176,
	CFA_P70_EM_KL_L3_QOS_FLD = 177,
	CFA_P70_EM_KL_L3_IEH_NONEXT_FLD = 178,
	CFA_P70_EM_KL_L3_IEH_SEP_FLD = 179,
	CFA_P70_EM_KL_L3_IEH_AUTH_FLD = 180,
	CFA_P70_EM_KL_L3_IEH_DEST_FLD = 181,
	CFA_P70_EM_KL_L3_IEH_FRAG_FLD = 182,
	CFA_P70_EM_KL_L3_IEH_RTHDR_FLD = 183,
	CFA_P70_EM_KL_L3_IEH_HOP_FLD = 184,
	CFA_P70_EM_KL_L3_IEH_1FRAG_FLD = 185,
	CFA_P70_EM_KL_L3_DF_FLD = 186,
	CFA_P70_EM_KL_L3_L3ERR_FLD = 187,
	CFA_P70_EM_KL_L4_TYPE_FLD = 188,
	CFA_P70_EM_KL_L4_SRC_FLD = 189,
	CFA_P70_EM_KL_L4_DST_FLD = 190,
	CFA_P70_EM_KL_L4_FLAGS_FLD = 191,
	CFA_P70_EM_KL_L4_SEQ_FLD = 192,
	CFA_P70_EM_KL_L4_ACK_FLD = 193,
	CFA_P70_EM_KL_L4_WIN_FLD = 194,
	CFA_P70_EM_KL_L4_PA_FLD = 195,
	CFA_P70_EM_KL_L4_OPT_FLD = 196,
	CFA_P70_EM_KL_L4_TCPTS_FLD = 197,
	CFA_P70_EM_KL_L4_TSVAL_FLD = 198,
	CFA_P70_EM_KL_L4_TXECR_FLD = 199,
	CFA_P70_EM_KL_L4_ERR_FLD = 200,
	CFA_P70_EM_KEY_LAYOUT_MAX_FLD = 201,
	CFA_P70_EM_KL_MAX_FLD = CFA_P70_EM_KEY_LAYOUT_MAX_FLD,
};

/**
 * Enumeration for action
 */
enum cfa_p70_action_flds {
	CFA_P70_ACT_TYPE_FLD = 0,
	CFA_P70_ACT_DROP_FLD = 1,
	CFA_P70_ACT_VLAN_DELETE_FLD = 2,
	CFA_P70_ACT_DEST_FLD = 3,
	CFA_P70_ACT_DEST_OP_FLD = 4,
	CFA_P70_ACT_DECAP_FLD = 5,
	CFA_P70_ACT_MIRRORING_FLD = 6,
	CFA_P70_ACT_METER_PTR_FLD = 7,
	CFA_P70_ACT_STAT0_OFF_FLD = 8,
	CFA_P70_ACT_STAT0_OP_FLD = 9,
	CFA_P70_ACT_STAT0_CTR_TYPE_FLD = 10,
	CFA_P70_ACT_MOD_OFF_FLD = 11,
	CFA_P70_ACT_ENC_OFF_FLD = 12,
	CFA_P70_ACT_SRC_OFF_FLD = 13,
	CFA_P70_ACT_COMPACT_RSVD_0_FLD = 14,
	CFA_P70_ACT_STAT0_PTR_FLD = 15,
	CFA_P70_ACT_STAT1_PTR_FLD = 16,
	CFA_P70_ACT_STAT1_OP_FLD = 17,
	CFA_P70_ACT_STAT1_CTR_TYPE_FLD = 18,
	CFA_P70_ACT_MOD_PTR_FLD = 19,
	CFA_P70_ACT_ENC_PTR_FLD = 20,
	CFA_P70_ACT_SRC_PTR_FLD = 21,
	CFA_P70_ACT_FULL_RSVD_0_FLD = 22,
	CFA_P70_ACT_SRC_KO_EN_FLD = 23,
	CFA_P70_ACT_MCG_RSVD_0_FLD = 24,
	CFA_P70_ACT_NEXT_PTR_FLD = 25,
	CFA_P70_ACT_PTR0_ACT_HINT_FLD = 26,
	CFA_P70_ACT_PTR0_ACT_REC_PTR_FLD = 27,
	CFA_P70_ACT_PTR1_ACT_HINT_FLD = 28,
	CFA_P70_ACT_PTR1_ACT_REC_PTR_FLD = 29,
	CFA_P70_ACT_PTR2_ACT_HINT_FLD = 30,
	CFA_P70_ACT_PTR2_ACT_REC_PTR_FLD = 31,
	CFA_P70_ACT_PTR3_ACT_HINT_FLD = 32,
	CFA_P70_ACT_PTR3_ACT_REC_PTR_FLD = 33,
	CFA_P70_ACT_PTR4_ACT_HINT_FLD = 34,
	CFA_P70_ACT_PTR4_ACT_REC_PTR_FLD = 35,
	CFA_P70_ACT_PTR5_ACT_HINT_FLD = 36,
	CFA_P70_ACT_PTR5_ACT_REC_PTR_FLD = 37,
	CFA_P70_ACT_PTR6_ACT_HINT_FLD = 38,
	CFA_P70_ACT_PTR6_ACT_REC_PTR_FLD = 39,
	CFA_P70_ACT_PTR7_ACT_HINT_FLD = 40,
	CFA_P70_ACT_PTR7_ACT_REC_PTR_FLD = 41,
	CFA_P70_ACT_MCG_SUBSEQ_RSVD_0_FLD = 42,
	CFA_P70_ACT_MOD_MODIFY_ACT_HDR_FLD = 43,
	CFA_P70_ACT_MOD_MD_UPDT_DATA_FLD = 44,
	CFA_P70_ACT_MOD_MD_UPDT_PROF_FLD = 45,
	CFA_P70_ACT_MOD_MD_UPDT_OP_FLD = 46,
	CFA_P70_ACT_MOD_MD_UPDT_RSVD_0_FLD = 47,
	CFA_P70_ACT_MOD_MD_UPDT_TOP_FLD = 48,
	CFA_P70_ACT_MOD_RM_OVLAN_FLD = 49,
	CFA_P70_ACT_MOD_RM_IVLAN_FLD = 50,
	CFA_P70_ACT_MOD_RPL_IVLAN_FLD = 51,
	CFA_P70_ACT_MOD_RPL_OVLAN_FLD = 52,
	CFA_P70_ACT_MOD_TTL_UPDT_OP_FLD = 53,
	CFA_P70_ACT_MOD_TTL_UPDT_ALT_VID_FLD = 54,
	CFA_P70_ACT_MOD_TTL_UPDT_ALT_PFID_FLD = 55,
	CFA_P70_ACT_MOD_TTL_UPDT_TOP_FLD = 56,
	CFA_P70_ACT_MOD_TNL_MODIFY_DEL_FLD = 57,
	CFA_P70_ACT_MOD_TNL_MODIFY_8B_NEW_PROT_FLD = 58,
	CFA_P70_ACT_MOD_TNL_MODIFY_8B_EXIST_PROT_FLD = 59,
	CFA_P70_ACT_MOD_TNL_MODIFY_8B_VEC_FLD = 60,
	CFA_P70_ACT_MOD_TNL_MODIFY_8B_TOP_FLD = 61,
	CFA_P70_ACT_MOD_TNL_MODIFY_16B_NEW_PROT_FLD = 62,
	CFA_P70_ACT_MOD_TNL_MODIFY_16B_EXIST_PROT_FLD = 63,
	CFA_P70_ACT_MOD_TNL_MODIFY_16B_VEC_FLD = 64,
	CFA_P70_ACT_MOD_TNL_MODIFY_16B_TOP_FLD = 65,
	CFA_P70_ACT_MOD_UPDT_FIELD_DATA0_FLD = 66,
	CFA_P70_ACT_MOD_UPDT_FIELD_VEC_RSVD_FLD = 67,
	CFA_P70_ACT_MOD_UPDT_FIELD_VEC_KID_FLD = 68,
	CFA_P70_ACT_MOD_UPDT_FIELD_TOP_FLD = 69,
	CFA_P70_ACT_MOD_SMAC_FLD = 70,
	CFA_P70_ACT_MOD_DMAC_FLD = 71,
	CFA_P70_ACT_MOD_SIPV6_FLD = 72,
	CFA_P70_ACT_MOD_DIPV6_FLD = 73,
	CFA_P70_ACT_MOD_SIPV4_FLD = 74,
	CFA_P70_ACT_MOD_DIPV4_FLD = 75,
	CFA_P70_ACT_MOD_SPORT_FLD = 76,
	CFA_P70_ACT_MOD_DPORT_FLD = 77,
	CFA_P70_ACT_ENC_ECV_TNL_FLD = 78,
	CFA_P70_ACT_ENC_ECV_L4_FLD = 79,
	CFA_P70_ACT_ENC_ECV_L3_FLD = 80,
	CFA_P70_ACT_ENC_ECV_L2_FLD = 81,
	CFA_P70_ACT_ENC_ECV_VTAG_FLD = 82,
	CFA_P70_ACT_ENC_ECV_EC_FLD = 83,
	CFA_P70_ACT_ENC_ECV_VALID_FLD = 84,
	CFA_P70_ACT_ENC_EC_IP_TTL_IH_FLD = 85,
	CFA_P70_ACT_ENC_EC_IP_TOS_IH_FLD = 86,
	CFA_P70_ACT_ENC_EC_TUN_QOS_FLD = 87,
	CFA_P70_ACT_ENC_EC_GRE_SET_K_FLD = 88,
	CFA_P70_ACT_ENC_EC_DMAC_OVR_FLD = 89,
	CFA_P70_ACT_ENC_EC_VLAN_OVR_FLD = 90,
	CFA_P70_ACT_ENC_EC_SMAC_OVR_FLD = 91,
	CFA_P70_ACT_ENC_EC_IPV4_ID_CTRL_FLD = 92,
	CFA_P70_ACT_ENC_L2_DMAC_FLD = 93,
	CFA_P70_ACT_ENC_VLAN1_TAG_VID_FLD = 94,
	CFA_P70_ACT_ENC_VLAN1_TAG_DE_FLD = 95,
	CFA_P70_ACT_ENC_VLAN1_TAG_PRI_FLD = 96,
	CFA_P70_ACT_ENC_VLAN1_TAG_TPID_FLD = 97,
	CFA_P70_ACT_ENC_VLAN2_IT_VID_FLD = 98,
	CFA_P70_ACT_ENC_VLAN2_IT_DE_FLD = 99,
	CFA_P70_ACT_ENC_VLAN2_IT_PRI_FLD = 100,
	CFA_P70_ACT_ENC_VLAN2_IT_TPID_FLD = 101,
	CFA_P70_ACT_ENC_VLAN2_OT_VID_FLD = 102,
	CFA_P70_ACT_ENC_VLAN2_OT_DE_FLD = 103,
	CFA_P70_ACT_ENC_VLAN2_OT_PRI_FLD = 104,
	CFA_P70_ACT_ENC_VLAN2_OT_TPID_FLD = 105,
	CFA_P70_ACT_ENC_IPV4_ID_FLD = 106,
	CFA_P70_ACT_ENC_IPV4_TOS_FLD = 107,
	CFA_P70_ACT_ENC_IPV4_HLEN_FLD = 108,
	CFA_P70_ACT_ENC_IPV4_VER_FLD = 109,
	CFA_P70_ACT_ENC_IPV4_PROT_FLD = 110,
	CFA_P70_ACT_ENC_IPV4_TTL_FLD = 111,
	CFA_P70_ACT_ENC_IPV4_FRAG_FLD = 112,
	CFA_P70_ACT_ENC_IPV4_FLAGS_FLD = 113,
	CFA_P70_ACT_ENC_IPV4_DEST_FLD = 114,
	CFA_P70_ACT_ENC_IPV6_FLOW_LABEL_FLD = 115,
	CFA_P70_ACT_ENC_IPV6_TRAFFIC_CLASS_FLD = 116,
	CFA_P70_ACT_ENC_IPV6_VER_FLD = 117,
	CFA_P70_ACT_ENC_IPV6_HOP_LIMIT_FLD = 118,
	CFA_P70_ACT_ENC_IPV6_NEXT_HEADER_FLD = 119,
	CFA_P70_ACT_ENC_IPV6_PAYLOAD_LENGTH_FLD = 120,
	CFA_P70_ACT_ENC_IPV6_DEST_FLD = 121,
	CFA_P70_ACT_ENC_MPLS_TAG1_FLD = 122,
	CFA_P70_ACT_ENC_MPLS_TAG2_FLD = 123,
	CFA_P70_ACT_ENC_MPLS_TAG3_FLD = 124,
	CFA_P70_ACT_ENC_MPLS_TAG4_FLD = 125,
	CFA_P70_ACT_ENC_MPLS_TAG5_FLD = 126,
	CFA_P70_ACT_ENC_MPLS_TAG6_FLD = 127,
	CFA_P70_ACT_ENC_MPLS_TAG7_FLD = 128,
	CFA_P70_ACT_ENC_MPLS_TAG8_FLD = 129,
	CFA_P70_ACT_ENC_L4_DEST_PORT_FLD = 130,
	CFA_P70_ACT_ENC_L4_SRC_PORT_FLD = 131,
	CFA_P70_ACT_ENC_TNL_VXLAN_NEXT_PROT_FLD = 132,
	CFA_P70_ACT_ENC_TNL_VXLAN_RSVD_0_FLD = 133,
	CFA_P70_ACT_ENC_TNL_VXLAN_FLAGS_FLD = 134,
	CFA_P70_ACT_ENC_TNL_VXLAN_RSVD_1_FLD = 135,
	CFA_P70_ACT_ENC_TNL_VXLAN_VNI_FLD = 136,
	CFA_P70_ACT_ENC_TNL_NGE_PROT_TYPE_FLD = 137,
	CFA_P70_ACT_ENC_TNL_NGE_RSVD_0_FLD = 138,
	CFA_P70_ACT_ENC_TNL_NGE_FLAGS_C_FLD = 139,
	CFA_P70_ACT_ENC_TNL_NGE_FLAGS_O_FLD = 140,
	CFA_P70_ACT_ENC_TNL_NGE_FLAGS_OPT_LEN_FLD = 141,
	CFA_P70_ACT_ENC_TNL_NGE_FLAGS_VER_FLD = 142,
	CFA_P70_ACT_ENC_TNL_NGE_RSVD_1_FLD = 143,
	CFA_P70_ACT_ENC_TNL_NGE_VNI_FLD = 144,
	CFA_P70_ACT_ENC_TNL_NGE_OPTIONS_FLD = 145,
	CFA_P70_ACT_ENC_TNL_NVGRE_FLOW_ID_FLD = 146,
	CFA_P70_ACT_ENC_TNL_NVGRE_VSID_FLD = 147,
	CFA_P70_ACT_ENC_TNL_GRE_KEY_FLD = 148,
	CFA_P70_ACT_ENC_TNL_GENERIC_TID_FLD = 149,
	CFA_P70_ACT_ENC_TNL_GENERIC_LENGTH_FLD = 150,
	CFA_P70_ACT_ENC_TNL_GENERIC_HEADER_FLD = 151,
	CFA_P70_ACT_SRC_MAC_FLD = 152,
	CFA_P70_ACT_SRC_IPV4_ADDR_FLD = 153,
	CFA_P70_ACT_SRC_IPV6_ADDR_FLD = 154,
	CFA_P70_ACT_STAT0_B16_FPC_FLD = 155,
	CFA_P70_ACT_STAT1_B16_FPC_FLD = 156,
	CFA_P70_ACT_STAT0_B16_FBC_FLD = 157,
	CFA_P70_ACT_STAT1_B16_FBC_FLD = 158,
	CFA_P70_ACT_STAT0_B24_FPC_FLD = 159,
	CFA_P70_ACT_STAT1_B24_FPC_FLD = 160,
	CFA_P70_ACT_STAT0_B24_FBC_FLD = 161,
	CFA_P70_ACT_STAT1_B24_FBC_FLD = 162,
	CFA_P70_ACT_STAT0_B24_TIMESTAMP_FLD = 163,
	CFA_P70_ACT_STAT1_B24_TIMESTAMP_FLD = 164,
	CFA_P70_ACT_STAT0_B24_TCP_FLAGS_FLD = 165,
	CFA_P70_ACT_STAT1_B24_TCP_FLAGS_FLD = 166,
	CFA_P70_ACT_STAT0_B24_UNUSED_0_FLD = 167,
	CFA_P70_ACT_STAT1_B24_UNUSED_0_FLD = 168,
	CFA_P70_ACT_STAT0_B32A_FPC_FLD = 169,
	CFA_P70_ACT_STAT1_B32A_FPC_FLD = 170,
	CFA_P70_ACT_STAT0_B32A_FBC_FLD = 171,
	CFA_P70_ACT_STAT1_B32A_FBC_FLD = 172,
	CFA_P70_ACT_STAT0_B32A_MPC_FLD = 173,
	CFA_P70_ACT_STAT1_B32A_MPC_FLD = 174,
	CFA_P70_ACT_STAT0_B32A_MBC_FLD = 175,
	CFA_P70_ACT_STAT1_B32A_MBC_FLD = 176,
	CFA_P70_ACT_STAT0_B32B_FPC_FLD = 177,
	CFA_P70_ACT_STAT1_B32B_FPC_FLD = 178,
	CFA_P70_ACT_STAT0_B32B_FBC_FLD = 179,
	CFA_P70_ACT_STAT1_B32B_FBC_FLD = 180,
	CFA_P70_ACT_STAT0_B32B_TIMESTAMP_FLD = 181,
	CFA_P70_ACT_STAT1_B32B_TIMESTAMP_FLD = 182,
	CFA_P70_ACT_STAT0_B32B_TCP_FLAGS_FLD = 183,
	CFA_P70_ACT_STAT1_B32B_TCP_FLAGS_FLD = 184,
	CFA_P70_ACT_STAT0_B32B_UNUSED_0_FLD = 185,
	CFA_P70_ACT_STAT1_B32B_UNUSED_0_FLD = 186,
	CFA_P70_ACT_STAT0_B32B_MPC15_0_FLD = 187,
	CFA_P70_ACT_STAT1_B32B_MPC15_0_FLD = 188,
	CFA_P70_ACT_STAT0_B32B_MPC37_16_FLD = 189,
	CFA_P70_ACT_STAT1_B32B_MPC37_16_FLD = 190,
	CFA_P70_ACT_STAT0_B32B_MBC_FLD = 191,
	CFA_P70_ACT_STAT1_B32B_MBC_FLD = 192,
	CFA_P70_ACTION_MAX_FLD = 193,
	CFA_P70_ACT_MAX_FLD = CFA_P70_ACTION_MAX_FLD,
};

#define CFA_P70_EM_KEY_LAYOUT_2_BASE_FLD(FLD) \
	((FLD) - CFA_P70_EM_LREC_MAX_FLD)

/* clang-format on */

#endif /* _CFA_BLD_P70_FIELD_IDS_H_ */
