/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:05:24 EDT 2018 */

#include "dft/codelet-dft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_notw.native -fma -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name n2sv_64 -with-ostride 1 -include dft/simd/n2s.h -store-multiple 4 */

/*
 * This function contains 912 FP additions, 392 FP multiplications,
 * (or, 520 additions, 0 multiplications, 392 fused multiply/add),
 * 260 stack variables, 15 constants, and 288 memory accesses
 */
#include "dft/simd/n2s.h"

static void n2sv_64(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DVK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DVK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     {
	  INT i;
	  for (i = v; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * ivs), ii = ii + ((2 * VL) * ivs), ro = ro + ((2 * VL) * ovs), io = io + ((2 * VL) * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V T37, T7B, T8F, T5Z, Tf, Td9, TbB, TcB, T62, T7C, T2i, TdH, Tah, Tcb, T3e;
	       V T8G, Tu, TdI, Tak, TbC, Tan, TbD, T2x, Tda, T3m, T65, T7G, T8I, T7J, T8J;
	       V T3t, T64, TK, Tdd, Tas, Tce, Tav, Tcf, T2N, Tdc, T3G, T6G, T7O, T9k, T7R;
	       V T9l, T3N, T6H, T1L, TdA, Tbs, Tct, Tdx, Teo, T5j, T6Y, T5Q, T6V, T8y, T9z;
	       V Tbb, Tcw, T8n, T9C, TZ, Tdf, Taz, Tch, TaC, Tci, T32, Tdg, T3Z, T6J, T7V;
	       V T9n, T7Y, T9o, T46, T6K, T1g, Tdp, Tb1, Tcm, Tdm, Tej, T4q, T6R, T4X, T6O;
	       V T8f, T9s, TaK, Tcp, T84, T9v, T1v, Tdn, Tb4, Tcq, Tds, Tek, T4N, T6P, T50;
	       V T6S, T8i, T9w, TaV, Tcn, T8b, T9t, T20, Tdy, Tbv, Tcx, TdD, Tep, T5G, T6W;
	       V T5T, T6Z, T8B, T9D, Tbm, Tcu, T8u, T9A;
	       {
		    V T3, T35, T26, T5Y, T6, T5X, T29, T36, Ta, T39, T2d, T38, Td, T3b, T2g;
		    V T3c;
		    {
			 V T1, T2, T24, T25;
			 T1 = LD(&(ri[0]), ivs, &(ri[0]));
			 T2 = LD(&(ri[WS(is, 32)]), ivs, &(ri[0]));
			 T3 = VADD(T1, T2);
			 T35 = VSUB(T1, T2);
			 T24 = LD(&(ii[0]), ivs, &(ii[0]));
			 T25 = LD(&(ii[WS(is, 32)]), ivs, &(ii[0]));
			 T26 = VADD(T24, T25);
			 T5Y = VSUB(T24, T25);
		    }
		    {
			 V T4, T5, T27, T28;
			 T4 = LD(&(ri[WS(is, 16)]), ivs, &(ri[0]));
			 T5 = LD(&(ri[WS(is, 48)]), ivs, &(ri[0]));
			 T6 = VADD(T4, T5);
			 T5X = VSUB(T4, T5);
			 T27 = LD(&(ii[WS(is, 16)]), ivs, &(ii[0]));
			 T28 = LD(&(ii[WS(is, 48)]), ivs, &(ii[0]));
			 T29 = VADD(T27, T28);
			 T36 = VSUB(T27, T28);
		    }
		    {
			 V T8, T9, T2b, T2c;
			 T8 = LD(&(ri[WS(is, 8)]), ivs, &(ri[0]));
			 T9 = LD(&(ri[WS(is, 40)]), ivs, &(ri[0]));
			 Ta = VADD(T8, T9);
			 T39 = VSUB(T8, T9);
			 T2b = LD(&(ii[WS(is, 8)]), ivs, &(ii[0]));
			 T2c = LD(&(ii[WS(is, 40)]), ivs, &(ii[0]));
			 T2d = VADD(T2b, T2c);
			 T38 = VSUB(T2b, T2c);
		    }
		    {
			 V Tb, Tc, T2e, T2f;
			 Tb = LD(&(ri[WS(is, 56)]), ivs, &(ri[0]));
			 Tc = LD(&(ri[WS(is, 24)]), ivs, &(ri[0]));
			 Td = VADD(Tb, Tc);
			 T3b = VSUB(Tb, Tc);
			 T2e = LD(&(ii[WS(is, 56)]), ivs, &(ii[0]));
			 T2f = LD(&(ii[WS(is, 24)]), ivs, &(ii[0]));
			 T2g = VADD(T2e, T2f);
			 T3c = VSUB(T2e, T2f);
		    }
		    {
			 V T7, Te, T2a, T2h;
			 T37 = VSUB(T35, T36);
			 T7B = VADD(T35, T36);
			 T8F = VSUB(T5Y, T5X);
			 T5Z = VADD(T5X, T5Y);
			 T7 = VADD(T3, T6);
			 Te = VADD(Ta, Td);
			 Tf = VADD(T7, Te);
			 Td9 = VSUB(T7, Te);
			 {
			      V Tbz, TbA, T60, T61;
			      Tbz = VSUB(Td, Ta);
			      TbA = VSUB(T26, T29);
			      TbB = VADD(Tbz, TbA);
			      TcB = VSUB(TbA, Tbz);
			      T60 = VSUB(T3b, T3c);
			      T61 = VADD(T39, T38);
			      T62 = VSUB(T60, T61);
			      T7C = VADD(T61, T60);
			 }
			 T2a = VADD(T26, T29);
			 T2h = VADD(T2d, T2g);
			 T2i = VADD(T2a, T2h);
			 TdH = VSUB(T2a, T2h);
			 {
			      V Taf, Tag, T3a, T3d;
			      Taf = VSUB(T3, T6);
			      Tag = VSUB(T2d, T2g);
			      Tah = VADD(Taf, Tag);
			      Tcb = VSUB(Taf, Tag);
			      T3a = VSUB(T38, T39);
			      T3d = VADD(T3b, T3c);
			      T3e = VSUB(T3a, T3d);
			      T8G = VADD(T3a, T3d);
			 }
		    }
	       }
	       {
		    V Ti, T3j, T2l, T3h, Tl, T3g, T2o, T3k, Tp, T3q, T2s, T3o, Ts, T3n, T2v;
		    V T3r;
		    {
			 V Tg, Th, T2j, T2k;
			 Tg = LD(&(ri[WS(is, 4)]), ivs, &(ri[0]));
			 Th = LD(&(ri[WS(is, 36)]), ivs, &(ri[0]));
			 Ti = VADD(Tg, Th);
			 T3j = VSUB(Tg, Th);
			 T2j = LD(&(ii[WS(is, 4)]), ivs, &(ii[0]));
			 T2k = LD(&(ii[WS(is, 36)]), ivs, &(ii[0]));
			 T2l = VADD(T2j, T2k);
			 T3h = VSUB(T2j, T2k);
		    }
		    {
			 V Tj, Tk, T2m, T2n;
			 Tj = LD(&(ri[WS(is, 20)]), ivs, &(ri[0]));
			 Tk = LD(&(ri[WS(is, 52)]), ivs, &(ri[0]));
			 Tl = VADD(Tj, Tk);
			 T3g = VSUB(Tj, Tk);
			 T2m = LD(&(ii[WS(is, 20)]), ivs, &(ii[0]));
			 T2n = LD(&(ii[WS(is, 52)]), ivs, &(ii[0]));
			 T2o = VADD(T2m, T2n);
			 T3k = VSUB(T2m, T2n);
		    }
		    {
			 V Tn, To, T2q, T2r;
			 Tn = LD(&(ri[WS(is, 60)]), ivs, &(ri[0]));
			 To = LD(&(ri[WS(is, 28)]), ivs, &(ri[0]));
			 Tp = VADD(Tn, To);
			 T3q = VSUB(Tn, To);
			 T2q = LD(&(ii[WS(is, 60)]), ivs, &(ii[0]));
			 T2r = LD(&(ii[WS(is, 28)]), ivs, &(ii[0]));
			 T2s = VADD(T2q, T2r);
			 T3o = VSUB(T2q, T2r);
		    }
		    {
			 V Tq, Tr, T2t, T2u;
			 Tq = LD(&(ri[WS(is, 12)]), ivs, &(ri[0]));
			 Tr = LD(&(ri[WS(is, 44)]), ivs, &(ri[0]));
			 Ts = VADD(Tq, Tr);
			 T3n = VSUB(Tq, Tr);
			 T2t = LD(&(ii[WS(is, 12)]), ivs, &(ii[0]));
			 T2u = LD(&(ii[WS(is, 44)]), ivs, &(ii[0]));
			 T2v = VADD(T2t, T2u);
			 T3r = VSUB(T2t, T2u);
		    }
		    {
			 V Tm, Tt, Tai, Taj;
			 Tm = VADD(Ti, Tl);
			 Tt = VADD(Tp, Ts);
			 Tu = VADD(Tm, Tt);
			 TdI = VSUB(Tt, Tm);
			 Tai = VSUB(Ti, Tl);
			 Taj = VSUB(T2l, T2o);
			 Tak = VADD(Tai, Taj);
			 TbC = VSUB(Taj, Tai);
		    }
		    {
			 V Tal, Tam, T2p, T2w;
			 Tal = VSUB(Tp, Ts);
			 Tam = VSUB(T2s, T2v);
			 Tan = VSUB(Tal, Tam);
			 TbD = VADD(Tal, Tam);
			 T2p = VADD(T2l, T2o);
			 T2w = VADD(T2s, T2v);
			 T2x = VADD(T2p, T2w);
			 Tda = VSUB(T2p, T2w);
		    }
		    {
			 V T3i, T3l, T7E, T7F;
			 T3i = VADD(T3g, T3h);
			 T3l = VSUB(T3j, T3k);
			 T3m = VFMA(LDK(KP414213562), T3l, T3i);
			 T65 = VFNMS(LDK(KP414213562), T3i, T3l);
			 T7E = VADD(T3j, T3k);
			 T7F = VSUB(T3h, T3g);
			 T7G = VFMA(LDK(KP414213562), T7F, T7E);
			 T8I = VFNMS(LDK(KP414213562), T7E, T7F);
		    }
		    {
			 V T7H, T7I, T3p, T3s;
			 T7H = VADD(T3q, T3r);
			 T7I = VSUB(T3o, T3n);
			 T7J = VFNMS(LDK(KP414213562), T7I, T7H);
			 T8J = VFMA(LDK(KP414213562), T7H, T7I);
			 T3p = VADD(T3n, T3o);
			 T3s = VSUB(T3q, T3r);
			 T3t = VFNMS(LDK(KP414213562), T3s, T3p);
			 T64 = VFMA(LDK(KP414213562), T3p, T3s);
		    }
	       }
	       {
		    V Ty, T3H, T2B, T3x, TB, T3w, T2E, T3I, TI, T3K, T2L, T3E, TF, T3L, T2I;
		    V T3B;
		    {
			 V Tw, Tx, T2C, T2D;
			 Tw = LD(&(ri[WS(is, 2)]), ivs, &(ri[0]));
			 Tx = LD(&(ri[WS(is, 34)]), ivs, &(ri[0]));
			 Ty = VADD(Tw, Tx);
			 T3H = VSUB(Tw, Tx);
			 {
			      V T2z, T2A, Tz, TA;
			      T2z = LD(&(ii[WS(is, 2)]), ivs, &(ii[0]));
			      T2A = LD(&(ii[WS(is, 34)]), ivs, &(ii[0]));
			      T2B = VADD(T2z, T2A);
			      T3x = VSUB(T2z, T2A);
			      Tz = LD(&(ri[WS(is, 18)]), ivs, &(ri[0]));
			      TA = LD(&(ri[WS(is, 50)]), ivs, &(ri[0]));
			      TB = VADD(Tz, TA);
			      T3w = VSUB(Tz, TA);
			 }
			 T2C = LD(&(ii[WS(is, 18)]), ivs, &(ii[0]));
			 T2D = LD(&(ii[WS(is, 50)]), ivs, &(ii[0]));
			 T2E = VADD(T2C, T2D);
			 T3I = VSUB(T2C, T2D);
			 {
			      V TG, TH, T3C, T2J, T2K, T3D;
			      TG = LD(&(ri[WS(is, 58)]), ivs, &(ri[0]));
			      TH = LD(&(ri[WS(is, 26)]), ivs, &(ri[0]));
			      T3C = VSUB(TG, TH);
			      T2J = LD(&(ii[WS(is, 58)]), ivs, &(ii[0]));
			      T2K = LD(&(ii[WS(is, 26)]), ivs, &(ii[0]));
			      T3D = VSUB(T2J, T2K);
			      TI = VADD(TG, TH);
			      T3K = VADD(T3C, T3D);
			      T2L = VADD(T2J, T2K);
			      T3E = VSUB(T3C, T3D);
			 }
			 {
			      V TD, TE, T3z, T2G, T2H, T3A;
			      TD = LD(&(ri[WS(is, 10)]), ivs, &(ri[0]));
			      TE = LD(&(ri[WS(is, 42)]), ivs, &(ri[0]));
			      T3z = VSUB(TD, TE);
			      T2G = LD(&(ii[WS(is, 10)]), ivs, &(ii[0]));
			      T2H = LD(&(ii[WS(is, 42)]), ivs, &(ii[0]));
			      T3A = VSUB(T2G, T2H);
			      TF = VADD(TD, TE);
			      T3L = VSUB(T3A, T3z);
			      T2I = VADD(T2G, T2H);
			      T3B = VADD(T3z, T3A);
			 }
		    }
		    {
			 V TC, TJ, Taq, Tar;
			 TC = VADD(Ty, TB);
			 TJ = VADD(TF, TI);
			 TK = VADD(TC, TJ);
			 Tdd = VSUB(TC, TJ);
			 Taq = VSUB(TI, TF);
			 Tar = VSUB(T2B, T2E);
			 Tas = VADD(Taq, Tar);
			 Tce = VSUB(Tar, Taq);
		    }
		    {
			 V Tat, Tau, T2F, T2M;
			 Tat = VSUB(Ty, TB);
			 Tau = VSUB(T2I, T2L);
			 Tav = VADD(Tat, Tau);
			 Tcf = VSUB(Tat, Tau);
			 T2F = VADD(T2B, T2E);
			 T2M = VADD(T2I, T2L);
			 T2N = VADD(T2F, T2M);
			 Tdc = VSUB(T2F, T2M);
		    }
		    {
			 V T3y, T3F, T7M, T7N;
			 T3y = VADD(T3w, T3x);
			 T3F = VSUB(T3B, T3E);
			 T3G = VFNMS(LDK(KP707106781), T3F, T3y);
			 T6G = VFMA(LDK(KP707106781), T3F, T3y);
			 T7M = VSUB(T3x, T3w);
			 T7N = VADD(T3L, T3K);
			 T7O = VFMA(LDK(KP707106781), T7N, T7M);
			 T9k = VFNMS(LDK(KP707106781), T7N, T7M);
		    }
		    {
			 V T7P, T7Q, T3J, T3M;
			 T7P = VADD(T3H, T3I);
			 T7Q = VADD(T3B, T3E);
			 T7R = VFMA(LDK(KP707106781), T7Q, T7P);
			 T9l = VFNMS(LDK(KP707106781), T7Q, T7P);
			 T3J = VSUB(T3H, T3I);
			 T3M = VSUB(T3K, T3L);
			 T3N = VFNMS(LDK(KP707106781), T3M, T3J);
			 T6H = VFMA(LDK(KP707106781), T3M, T3J);
		    }
	       }
	       {
		    V T1z, T5I, T56, Tb8, T1C, T53, T5L, Tb9, T1J, Tbq, T5h, T5N, T1G, Tbp, T5c;
		    V T5O;
		    {
			 V T1x, T1y, T5J, T5K;
			 T1x = LD(&(ri[WS(is, 63)]), ivs, &(ri[WS(is, 1)]));
			 T1y = LD(&(ri[WS(is, 31)]), ivs, &(ri[WS(is, 1)]));
			 T1z = VADD(T1x, T1y);
			 T5I = VSUB(T1x, T1y);
			 {
			      V T54, T55, T1A, T1B;
			      T54 = LD(&(ii[WS(is, 63)]), ivs, &(ii[WS(is, 1)]));
			      T55 = LD(&(ii[WS(is, 31)]), ivs, &(ii[WS(is, 1)]));
			      T56 = VSUB(T54, T55);
			      Tb8 = VADD(T54, T55);
			      T1A = LD(&(ri[WS(is, 15)]), ivs, &(ri[WS(is, 1)]));
			      T1B = LD(&(ri[WS(is, 47)]), ivs, &(ri[WS(is, 1)]));
			      T1C = VADD(T1A, T1B);
			      T53 = VSUB(T1A, T1B);
			 }
			 T5J = LD(&(ii[WS(is, 15)]), ivs, &(ii[WS(is, 1)]));
			 T5K = LD(&(ii[WS(is, 47)]), ivs, &(ii[WS(is, 1)]));
			 T5L = VSUB(T5J, T5K);
			 Tb9 = VADD(T5J, T5K);
			 {
			      V T1H, T1I, T5d, T5e, T5f, T5g;
			      T1H = LD(&(ri[WS(is, 55)]), ivs, &(ri[WS(is, 1)]));
			      T1I = LD(&(ri[WS(is, 23)]), ivs, &(ri[WS(is, 1)]));
			      T5d = VSUB(T1H, T1I);
			      T5e = LD(&(ii[WS(is, 55)]), ivs, &(ii[WS(is, 1)]));
			      T5f = LD(&(ii[WS(is, 23)]), ivs, &(ii[WS(is, 1)]));
			      T5g = VSUB(T5e, T5f);
			      T1J = VADD(T1H, T1I);
			      Tbq = VADD(T5e, T5f);
			      T5h = VSUB(T5d, T5g);
			      T5N = VADD(T5d, T5g);
			 }
			 {
			      V T1E, T1F, T58, T59, T5a, T5b;
			      T1E = LD(&(ri[WS(is, 7)]), ivs, &(ri[WS(is, 1)]));
			      T1F = LD(&(ri[WS(is, 39)]), ivs, &(ri[WS(is, 1)]));
			      T58 = VSUB(T1E, T1F);
			      T59 = LD(&(ii[WS(is, 7)]), ivs, &(ii[WS(is, 1)]));
			      T5a = LD(&(ii[WS(is, 39)]), ivs, &(ii[WS(is, 1)]));
			      T5b = VSUB(T59, T5a);
			      T1G = VADD(T1E, T1F);
			      Tbp = VADD(T59, T5a);
			      T5c = VADD(T58, T5b);
			      T5O = VSUB(T5b, T58);
			 }
		    }
		    {
			 V T1D, T1K, Tbo, Tbr;
			 T1D = VADD(T1z, T1C);
			 T1K = VADD(T1G, T1J);
			 T1L = VADD(T1D, T1K);
			 TdA = VSUB(T1D, T1K);
			 Tbo = VSUB(T1z, T1C);
			 Tbr = VSUB(Tbp, Tbq);
			 Tbs = VADD(Tbo, Tbr);
			 Tct = VSUB(Tbo, Tbr);
		    }
		    {
			 V Tdv, Tdw, T57, T5i;
			 Tdv = VADD(Tb8, Tb9);
			 Tdw = VADD(Tbp, Tbq);
			 Tdx = VSUB(Tdv, Tdw);
			 Teo = VADD(Tdv, Tdw);
			 T57 = VADD(T53, T56);
			 T5i = VSUB(T5c, T5h);
			 T5j = VFNMS(LDK(KP707106781), T5i, T57);
			 T6Y = VFMA(LDK(KP707106781), T5i, T57);
		    }
		    {
			 V T5M, T5P, T8w, T8x;
			 T5M = VSUB(T5I, T5L);
			 T5P = VSUB(T5N, T5O);
			 T5Q = VFNMS(LDK(KP707106781), T5P, T5M);
			 T6V = VFMA(LDK(KP707106781), T5P, T5M);
			 T8w = VADD(T5I, T5L);
			 T8x = VADD(T5c, T5h);
			 T8y = VFMA(LDK(KP707106781), T8x, T8w);
			 T9z = VFNMS(LDK(KP707106781), T8x, T8w);
		    }
		    {
			 V Tb7, Tba, T8l, T8m;
			 Tb7 = VSUB(T1J, T1G);
			 Tba = VSUB(Tb8, Tb9);
			 Tbb = VADD(Tb7, Tba);
			 Tcw = VSUB(Tba, Tb7);
			 T8l = VSUB(T56, T53);
			 T8m = VADD(T5O, T5N);
			 T8n = VFMA(LDK(KP707106781), T8m, T8l);
			 T9C = VFNMS(LDK(KP707106781), T8m, T8l);
		    }
	       }
	       {
		    V TN, T40, T2Q, T3Q, TQ, T3P, T2T, T41, TX, T43, T30, T3X, TU, T44, T2X;
		    V T3U;
		    {
			 V TL, TM, T2R, T2S;
			 TL = LD(&(ri[WS(is, 62)]), ivs, &(ri[0]));
			 TM = LD(&(ri[WS(is, 30)]), ivs, &(ri[0]));
			 TN = VADD(TL, TM);
			 T40 = VSUB(TL, TM);
			 {
			      V T2O, T2P, TO, TP;
			      T2O = LD(&(ii[WS(is, 62)]), ivs, &(ii[0]));
			      T2P = LD(&(ii[WS(is, 30)]), ivs, &(ii[0]));
			      T2Q = VADD(T2O, T2P);
			      T3Q = VSUB(T2O, T2P);
			      TO = LD(&(ri[WS(is, 14)]), ivs, &(ri[0]));
			      TP = LD(&(ri[WS(is, 46)]), ivs, &(ri[0]));
			      TQ = VADD(TO, TP);
			      T3P = VSUB(TO, TP);
			 }
			 T2R = LD(&(ii[WS(is, 14)]), ivs, &(ii[0]));
			 T2S = LD(&(ii[WS(is, 46)]), ivs, &(ii[0]));
			 T2T = VADD(T2R, T2S);
			 T41 = VSUB(T2R, T2S);
			 {
			      V TV, TW, T3V, T2Y, T2Z, T3W;
			      TV = LD(&(ri[WS(is, 54)]), ivs, &(ri[0]));
			      TW = LD(&(ri[WS(is, 22)]), ivs, &(ri[0]));
			      T3V = VSUB(TV, TW);
			      T2Y = LD(&(ii[WS(is, 54)]), ivs, &(ii[0]));
			      T2Z = LD(&(ii[WS(is, 22)]), ivs, &(ii[0]));
			      T3W = VSUB(T2Y, T2Z);
			      TX = VADD(TV, TW);
			      T43 = VADD(T3V, T3W);
			      T30 = VADD(T2Y, T2Z);
			      T3X = VSUB(T3V, T3W);
			 }
			 {
			      V TS, TT, T3S, T2V, T2W, T3T;
			      TS = LD(&(ri[WS(is, 6)]), ivs, &(ri[0]));
			      TT = LD(&(ri[WS(is, 38)]), ivs, &(ri[0]));
			      T3S = VSUB(TS, TT);
			      T2V = LD(&(ii[WS(is, 6)]), ivs, &(ii[0]));
			      T2W = LD(&(ii[WS(is, 38)]), ivs, &(ii[0]));
			      T3T = VSUB(T2V, T2W);
			      TU = VADD(TS, TT);
			      T44 = VSUB(T3T, T3S);
			      T2X = VADD(T2V, T2W);
			      T3U = VADD(T3S, T3T);
			 }
		    }
		    {
			 V TR, TY, Tax, Tay;
			 TR = VADD(TN, TQ);
			 TY = VADD(TU, TX);
			 TZ = VADD(TR, TY);
			 Tdf = VSUB(TR, TY);
			 Tax = VSUB(TX, TU);
			 Tay = VSUB(T2Q, T2T);
			 Taz = VADD(Tax, Tay);
			 Tch = VSUB(Tay, Tax);
		    }
		    {
			 V TaA, TaB, T2U, T31;
			 TaA = VSUB(TN, TQ);
			 TaB = VSUB(T2X, T30);
			 TaC = VADD(TaA, TaB);
			 Tci = VSUB(TaA, TaB);
			 T2U = VADD(T2Q, T2T);
			 T31 = VADD(T2X, T30);
			 T32 = VADD(T2U, T31);
			 Tdg = VSUB(T2U, T31);
		    }
		    {
			 V T3R, T3Y, T7T, T7U;
			 T3R = VADD(T3P, T3Q);
			 T3Y = VSUB(T3U, T3X);
			 T3Z = VFNMS(LDK(KP707106781), T3Y, T3R);
			 T6J = VFMA(LDK(KP707106781), T3Y, T3R);
			 T7T = VSUB(T3Q, T3P);
			 T7U = VADD(T44, T43);
			 T7V = VFMA(LDK(KP707106781), T7U, T7T);
			 T9n = VFNMS(LDK(KP707106781), T7U, T7T);
		    }
		    {
			 V T7W, T7X, T42, T45;
			 T7W = VADD(T40, T41);
			 T7X = VADD(T3U, T3X);
			 T7Y = VFMA(LDK(KP707106781), T7X, T7W);
			 T9o = VFNMS(LDK(KP707106781), T7X, T7W);
			 T42 = VSUB(T40, T41);
			 T45 = VSUB(T43, T44);
			 T46 = VFNMS(LDK(KP707106781), T45, T42);
			 T6K = VFMA(LDK(KP707106781), T45, T42);
		    }
	       }
	       {
		    V T14, T4P, T4d, TaH, T17, T4a, T4S, TaI, T1e, TaZ, T4o, T4U, T1b, TaY, T4j;
		    V T4V;
		    {
			 V T12, T13, T4Q, T4R;
			 T12 = LD(&(ri[WS(is, 1)]), ivs, &(ri[WS(is, 1)]));
			 T13 = LD(&(ri[WS(is, 33)]), ivs, &(ri[WS(is, 1)]));
			 T14 = VADD(T12, T13);
			 T4P = VSUB(T12, T13);
			 {
			      V T4b, T4c, T15, T16;
			      T4b = LD(&(ii[WS(is, 1)]), ivs, &(ii[WS(is, 1)]));
			      T4c = LD(&(ii[WS(is, 33)]), ivs, &(ii[WS(is, 1)]));
			      T4d = VSUB(T4b, T4c);
			      TaH = VADD(T4b, T4c);
			      T15 = LD(&(ri[WS(is, 17)]), ivs, &(ri[WS(is, 1)]));
			      T16 = LD(&(ri[WS(is, 49)]), ivs, &(ri[WS(is, 1)]));
			      T17 = VADD(T15, T16);
			      T4a = VSUB(T15, T16);
			 }
			 T4Q = LD(&(ii[WS(is, 17)]), ivs, &(ii[WS(is, 1)]));
			 T4R = LD(&(ii[WS(is, 49)]), ivs, &(ii[WS(is, 1)]));
			 T4S = VSUB(T4Q, T4R);
			 TaI = VADD(T4Q, T4R);
			 {
			      V T1c, T1d, T4k, T4l, T4m, T4n;
			      T1c = LD(&(ri[WS(is, 57)]), ivs, &(ri[WS(is, 1)]));
			      T1d = LD(&(ri[WS(is, 25)]), ivs, &(ri[WS(is, 1)]));
			      T4k = VSUB(T1c, T1d);
			      T4l = LD(&(ii[WS(is, 57)]), ivs, &(ii[WS(is, 1)]));
			      T4m = LD(&(ii[WS(is, 25)]), ivs, &(ii[WS(is, 1)]));
			      T4n = VSUB(T4l, T4m);
			      T1e = VADD(T1c, T1d);
			      TaZ = VADD(T4l, T4m);
			      T4o = VSUB(T4k, T4n);
			      T4U = VADD(T4k, T4n);
			 }
			 {
			      V T19, T1a, T4f, T4g, T4h, T4i;
			      T19 = LD(&(ri[WS(is, 9)]), ivs, &(ri[WS(is, 1)]));
			      T1a = LD(&(ri[WS(is, 41)]), ivs, &(ri[WS(is, 1)]));
			      T4f = VSUB(T19, T1a);
			      T4g = LD(&(ii[WS(is, 9)]), ivs, &(ii[WS(is, 1)]));
			      T4h = LD(&(ii[WS(is, 41)]), ivs, &(ii[WS(is, 1)]));
			      T4i = VSUB(T4g, T4h);
			      T1b = VADD(T19, T1a);
			      TaY = VADD(T4g, T4h);
			      T4j = VADD(T4f, T4i);
			      T4V = VSUB(T4i, T4f);
			 }
		    }
		    {
			 V T18, T1f, TaX, Tb0;
			 T18 = VADD(T14, T17);
			 T1f = VADD(T1b, T1e);
			 T1g = VADD(T18, T1f);
			 Tdp = VSUB(T18, T1f);
			 TaX = VSUB(T14, T17);
			 Tb0 = VSUB(TaY, TaZ);
			 Tb1 = VADD(TaX, Tb0);
			 Tcm = VSUB(TaX, Tb0);
		    }
		    {
			 V Tdk, Tdl, T4e, T4p;
			 Tdk = VADD(TaH, TaI);
			 Tdl = VADD(TaY, TaZ);
			 Tdm = VSUB(Tdk, Tdl);
			 Tej = VADD(Tdk, Tdl);
			 T4e = VADD(T4a, T4d);
			 T4p = VSUB(T4j, T4o);
			 T4q = VFNMS(LDK(KP707106781), T4p, T4e);
			 T6R = VFMA(LDK(KP707106781), T4p, T4e);
		    }
		    {
			 V T4T, T4W, T8d, T8e;
			 T4T = VSUB(T4P, T4S);
			 T4W = VSUB(T4U, T4V);
			 T4X = VFNMS(LDK(KP707106781), T4W, T4T);
			 T6O = VFMA(LDK(KP707106781), T4W, T4T);
			 T8d = VADD(T4P, T4S);
			 T8e = VADD(T4j, T4o);
			 T8f = VFMA(LDK(KP707106781), T8e, T8d);
			 T9s = VFNMS(LDK(KP707106781), T8e, T8d);
		    }
		    {
			 V TaG, TaJ, T82, T83;
			 TaG = VSUB(T1e, T1b);
			 TaJ = VSUB(TaH, TaI);
			 TaK = VADD(TaG, TaJ);
			 Tcp = VSUB(TaJ, TaG);
			 T82 = VSUB(T4d, T4a);
			 T83 = VADD(T4V, T4U);
			 T84 = VFMA(LDK(KP707106781), T83, T82);
			 T9v = VFNMS(LDK(KP707106781), T83, T82);
		    }
	       }
	       {
		    V T1j, TaL, T1m, TaM, T4G, T4L, TaO, TaN, T86, T85, T1q, TaR, T1t, TaS, T4v;
		    V T4A, TaT, TaQ, T89, T88;
		    {
			 V T4C, T4K, T4H, T4F;
			 {
			      V T1h, T1i, T4I, T4J;
			      T1h = LD(&(ri[WS(is, 5)]), ivs, &(ri[WS(is, 1)]));
			      T1i = LD(&(ri[WS(is, 37)]), ivs, &(ri[WS(is, 1)]));
			      T1j = VADD(T1h, T1i);
			      T4C = VSUB(T1h, T1i);
			      T4I = LD(&(ii[WS(is, 5)]), ivs, &(ii[WS(is, 1)]));
			      T4J = LD(&(ii[WS(is, 37)]), ivs, &(ii[WS(is, 1)]));
			      T4K = VSUB(T4I, T4J);
			      TaL = VADD(T4I, T4J);
			 }
			 {
			      V T1k, T1l, T4D, T4E;
			      T1k = LD(&(ri[WS(is, 21)]), ivs, &(ri[WS(is, 1)]));
			      T1l = LD(&(ri[WS(is, 53)]), ivs, &(ri[WS(is, 1)]));
			      T1m = VADD(T1k, T1l);
			      T4H = VSUB(T1k, T1l);
			      T4D = LD(&(ii[WS(is, 21)]), ivs, &(ii[WS(is, 1)]));
			      T4E = LD(&(ii[WS(is, 53)]), ivs, &(ii[WS(is, 1)]));
			      T4F = VSUB(T4D, T4E);
			      TaM = VADD(T4D, T4E);
			 }
			 T4G = VSUB(T4C, T4F);
			 T4L = VADD(T4H, T4K);
			 TaO = VSUB(T1j, T1m);
			 TaN = VSUB(TaL, TaM);
			 T86 = VADD(T4C, T4F);
			 T85 = VSUB(T4K, T4H);
		    }
		    {
			 V T4r, T4z, T4w, T4u;
			 {
			      V T1o, T1p, T4x, T4y;
			      T1o = LD(&(ri[WS(is, 61)]), ivs, &(ri[WS(is, 1)]));
			      T1p = LD(&(ri[WS(is, 29)]), ivs, &(ri[WS(is, 1)]));
			      T1q = VADD(T1o, T1p);
			      T4r = VSUB(T1o, T1p);
			      T4x = LD(&(ii[WS(is, 61)]), ivs, &(ii[WS(is, 1)]));
			      T4y = LD(&(ii[WS(is, 29)]), ivs, &(ii[WS(is, 1)]));
			      T4z = VSUB(T4x, T4y);
			      TaR = VADD(T4x, T4y);
			 }
			 {
			      V T1r, T1s, T4s, T4t;
			      T1r = LD(&(ri[WS(is, 13)]), ivs, &(ri[WS(is, 1)]));
			      T1s = LD(&(ri[WS(is, 45)]), ivs, &(ri[WS(is, 1)]));
			      T1t = VADD(T1r, T1s);
			      T4w = VSUB(T1r, T1s);
			      T4s = LD(&(ii[WS(is, 13)]), ivs, &(ii[WS(is, 1)]));
			      T4t = LD(&(ii[WS(is, 45)]), ivs, &(ii[WS(is, 1)]));
			      T4u = VSUB(T4s, T4t);
			      TaS = VADD(T4s, T4t);
			 }
			 T4v = VSUB(T4r, T4u);
			 T4A = VADD(T4w, T4z);
			 TaT = VSUB(TaR, TaS);
			 TaQ = VSUB(T1q, T1t);
			 T89 = VADD(T4r, T4u);
			 T88 = VSUB(T4z, T4w);
		    }
		    {
			 V T1n, T1u, Tb2, Tb3;
			 T1n = VADD(T1j, T1m);
			 T1u = VADD(T1q, T1t);
			 T1v = VADD(T1n, T1u);
			 Tdn = VSUB(T1u, T1n);
			 Tb2 = VADD(TaO, TaN);
			 Tb3 = VSUB(TaQ, TaT);
			 Tb4 = VADD(Tb2, Tb3);
			 Tcq = VSUB(Tb2, Tb3);
		    }
		    {
			 V Tdq, Tdr, T4B, T4M;
			 Tdq = VADD(TaL, TaM);
			 Tdr = VADD(TaR, TaS);
			 Tds = VSUB(Tdq, Tdr);
			 Tek = VADD(Tdq, Tdr);
			 T4B = VFMA(LDK(KP414213562), T4A, T4v);
			 T4M = VFNMS(LDK(KP414213562), T4L, T4G);
			 T4N = VSUB(T4B, T4M);
			 T6P = VADD(T4M, T4B);
		    }
		    {
			 V T4Y, T4Z, T8g, T8h;
			 T4Y = VFMA(LDK(KP414213562), T4G, T4L);
			 T4Z = VFNMS(LDK(KP414213562), T4v, T4A);
			 T50 = VSUB(T4Y, T4Z);
			 T6S = VADD(T4Y, T4Z);
			 T8g = VFMA(LDK(KP414213562), T85, T86);
			 T8h = VFNMS(LDK(KP414213562), T88, T89);
			 T8i = VADD(T8g, T8h);
			 T9w = VSUB(T8g, T8h);
		    }
		    {
			 V TaP, TaU, T87, T8a;
			 TaP = VSUB(TaN, TaO);
			 TaU = VADD(TaQ, TaT);
			 TaV = VADD(TaP, TaU);
			 Tcn = VSUB(TaU, TaP);
			 T87 = VFNMS(LDK(KP414213562), T86, T85);
			 T8a = VFMA(LDK(KP414213562), T89, T88);
			 T8b = VADD(T87, T8a);
			 T9t = VSUB(T8a, T87);
		    }
	       }
	       {
		    V T1O, Tbc, T1R, Tbd, T5z, T5E, Tbf, Tbe, T8p, T8o, T1V, Tbi, T1Y, Tbj, T5o;
		    V T5t, Tbk, Tbh, T8s, T8r;
		    {
			 V T5v, T5D, T5A, T5y;
			 {
			      V T1M, T1N, T5B, T5C;
			      T1M = LD(&(ri[WS(is, 3)]), ivs, &(ri[WS(is, 1)]));
			      T1N = LD(&(ri[WS(is, 35)]), ivs, &(ri[WS(is, 1)]));
			      T1O = VADD(T1M, T1N);
			      T5v = VSUB(T1M, T1N);
			      T5B = LD(&(ii[WS(is, 3)]), ivs, &(ii[WS(is, 1)]));
			      T5C = LD(&(ii[WS(is, 35)]), ivs, &(ii[WS(is, 1)]));
			      T5D = VSUB(T5B, T5C);
			      Tbc = VADD(T5B, T5C);
			 }
			 {
			      V T1P, T1Q, T5w, T5x;
			      T1P = LD(&(ri[WS(is, 19)]), ivs, &(ri[WS(is, 1)]));
			      T1Q = LD(&(ri[WS(is, 51)]), ivs, &(ri[WS(is, 1)]));
			      T1R = VADD(T1P, T1Q);
			      T5A = VSUB(T1P, T1Q);
			      T5w = LD(&(ii[WS(is, 19)]), ivs, &(ii[WS(is, 1)]));
			      T5x = LD(&(ii[WS(is, 51)]), ivs, &(ii[WS(is, 1)]));
			      T5y = VSUB(T5w, T5x);
			      Tbd = VADD(T5w, T5x);
			 }
			 T5z = VSUB(T5v, T5y);
			 T5E = VADD(T5A, T5D);
			 Tbf = VSUB(T1O, T1R);
			 Tbe = VSUB(Tbc, Tbd);
			 T8p = VADD(T5v, T5y);
			 T8o = VSUB(T5D, T5A);
		    }
		    {
			 V T5k, T5s, T5p, T5n;
			 {
			      V T1T, T1U, T5q, T5r;
			      T1T = LD(&(ri[WS(is, 59)]), ivs, &(ri[WS(is, 1)]));
			      T1U = LD(&(ri[WS(is, 27)]), ivs, &(ri[WS(is, 1)]));
			      T1V = VADD(T1T, T1U);
			      T5k = VSUB(T1T, T1U);
			      T5q = LD(&(ii[WS(is, 59)]), ivs, &(ii[WS(is, 1)]));
			      T5r = LD(&(ii[WS(is, 27)]), ivs, &(ii[WS(is, 1)]));
			      T5s = VSUB(T5q, T5r);
			      Tbi = VADD(T5q, T5r);
			 }
			 {
			      V T1W, T1X, T5l, T5m;
			      T1W = LD(&(ri[WS(is, 11)]), ivs, &(ri[WS(is, 1)]));
			      T1X = LD(&(ri[WS(is, 43)]), ivs, &(ri[WS(is, 1)]));
			      T1Y = VADD(T1W, T1X);
			      T5p = VSUB(T1W, T1X);
			      T5l = LD(&(ii[WS(is, 11)]), ivs, &(ii[WS(is, 1)]));
			      T5m = LD(&(ii[WS(is, 43)]), ivs, &(ii[WS(is, 1)]));
			      T5n = VSUB(T5l, T5m);
			      Tbj = VADD(T5l, T5m);
			 }
			 T5o = VSUB(T5k, T5n);
			 T5t = VADD(T5p, T5s);
			 Tbk = VSUB(Tbi, Tbj);
			 Tbh = VSUB(T1V, T1Y);
			 T8s = VADD(T5k, T5n);
			 T8r = VSUB(T5s, T5p);
		    }
		    {
			 V T1S, T1Z, Tbt, Tbu;
			 T1S = VADD(T1O, T1R);
			 T1Z = VADD(T1V, T1Y);
			 T20 = VADD(T1S, T1Z);
			 Tdy = VSUB(T1Z, T1S);
			 Tbt = VADD(Tbf, Tbe);
			 Tbu = VSUB(Tbh, Tbk);
			 Tbv = VADD(Tbt, Tbu);
			 Tcx = VSUB(Tbt, Tbu);
		    }
		    {
			 V TdB, TdC, T5u, T5F;
			 TdB = VADD(Tbc, Tbd);
			 TdC = VADD(Tbi, Tbj);
			 TdD = VSUB(TdB, TdC);
			 Tep = VADD(TdB, TdC);
			 T5u = VFMA(LDK(KP414213562), T5t, T5o);
			 T5F = VFNMS(LDK(KP414213562), T5E, T5z);
			 T5G = VSUB(T5u, T5F);
			 T6W = VADD(T5F, T5u);
		    }
		    {
			 V T5R, T5S, T8z, T8A;
			 T5R = VFMA(LDK(KP414213562), T5z, T5E);
			 T5S = VFNMS(LDK(KP414213562), T5o, T5t);
			 T5T = VSUB(T5R, T5S);
			 T6Z = VADD(T5R, T5S);
			 T8z = VFMA(LDK(KP414213562), T8o, T8p);
			 T8A = VFNMS(LDK(KP414213562), T8r, T8s);
			 T8B = VADD(T8z, T8A);
			 T9D = VSUB(T8z, T8A);
		    }
		    {
			 V Tbg, Tbl, T8q, T8t;
			 Tbg = VSUB(Tbe, Tbf);
			 Tbl = VADD(Tbh, Tbk);
			 Tbm = VADD(Tbg, Tbl);
			 Tcu = VSUB(Tbl, Tbg);
			 T8q = VFNMS(LDK(KP414213562), T8p, T8o);
			 T8t = VFMA(LDK(KP414213562), T8s, T8r);
			 T8u = VADD(T8q, T8t);
			 T9A = VSUB(T8t, T8q);
		    }
	       }
	       {
		    V TeJ, TeK, TeL, TeM, TeN, TeO, TeP, TeQ, TeR, TeS, TeT, TeU, TeV, TeW, TeX;
		    V TeY, TeZ, Tf0, Tf1, Tf2, Tf3, Tf4, Tf5, Tf6, Tf7, Tf8, Tf9, Tfa, Tfb, Tfc;
		    V Tfd, Tfe, Tff, Tfg, Tfh, Tfi, Tfj, Tfk, Tfl, Tfm, Tfn, Tfo, Tfp, Tfq, Tfr;
		    V Tfs, Tft, Tfu;
		    {
			 V T11, TeD, TeG, TeI, T22, T23, T34, TeH;
			 {
			      V Tv, T10, TeE, TeF;
			      Tv = VADD(Tf, Tu);
			      T10 = VADD(TK, TZ);
			      T11 = VADD(Tv, T10);
			      TeD = VSUB(Tv, T10);
			      TeE = VADD(Tej, Tek);
			      TeF = VADD(Teo, Tep);
			      TeG = VSUB(TeE, TeF);
			      TeI = VADD(TeE, TeF);
			 }
			 {
			      V T1w, T21, T2y, T33;
			      T1w = VADD(T1g, T1v);
			      T21 = VADD(T1L, T20);
			      T22 = VADD(T1w, T21);
			      T23 = VSUB(T21, T1w);
			      T2y = VADD(T2i, T2x);
			      T33 = VADD(T2N, T32);
			      T34 = VSUB(T2y, T33);
			      TeH = VADD(T2y, T33);
			 }
			 TeJ = VSUB(T11, T22);
			 STM4(&(ro[32]), TeJ, ovs, &(ro[0]));
			 TeK = VSUB(TeH, TeI);
			 STM4(&(io[32]), TeK, ovs, &(io[0]));
			 TeL = VADD(T11, T22);
			 STM4(&(ro[0]), TeL, ovs, &(ro[0]));
			 TeM = VADD(TeH, TeI);
			 STM4(&(io[0]), TeM, ovs, &(io[0]));
			 TeN = VADD(T23, T34);
			 STM4(&(io[16]), TeN, ovs, &(io[0]));
			 TeO = VADD(TeD, TeG);
			 STM4(&(ro[16]), TeO, ovs, &(ro[0]));
			 TeP = VSUB(T34, T23);
			 STM4(&(io[48]), TeP, ovs, &(io[0]));
			 TeQ = VSUB(TeD, TeG);
			 STM4(&(ro[48]), TeQ, ovs, &(ro[0]));
		    }
		    {
			 V Teh, Tex, Tev, TeB, Tem, Tey, Ter, Tez;
			 {
			      V Tef, Teg, Tet, Teu;
			      Tef = VSUB(Tf, Tu);
			      Teg = VSUB(T2N, T32);
			      Teh = VADD(Tef, Teg);
			      Tex = VSUB(Tef, Teg);
			      Tet = VSUB(T2i, T2x);
			      Teu = VSUB(TZ, TK);
			      Tev = VSUB(Tet, Teu);
			      TeB = VADD(Teu, Tet);
			 }
			 {
			      V Tei, Tel, Ten, Teq;
			      Tei = VSUB(T1g, T1v);
			      Tel = VSUB(Tej, Tek);
			      Tem = VADD(Tei, Tel);
			      Tey = VSUB(Tel, Tei);
			      Ten = VSUB(T1L, T20);
			      Teq = VSUB(Teo, Tep);
			      Ter = VSUB(Ten, Teq);
			      Tez = VADD(Ten, Teq);
			 }
			 {
			      V Tes, TeC, Tew, TeA;
			      Tes = VADD(Tem, Ter);
			      TeR = VFNMS(LDK(KP707106781), Tes, Teh);
			      STM4(&(ro[40]), TeR, ovs, &(ro[0]));
			      TeS = VFMA(LDK(KP707106781), Tes, Teh);
			      STM4(&(ro[8]), TeS, ovs, &(ro[0]));
			      TeC = VADD(Tey, Tez);
			      TeT = VFNMS(LDK(KP707106781), TeC, TeB);
			      STM4(&(io[40]), TeT, ovs, &(io[0]));
			      TeU = VFMA(LDK(KP707106781), TeC, TeB);
			      STM4(&(io[8]), TeU, ovs, &(io[0]));
			      Tew = VSUB(Ter, Tem);
			      TeV = VFNMS(LDK(KP707106781), Tew, Tev);
			      STM4(&(io[56]), TeV, ovs, &(io[0]));
			      TeW = VFMA(LDK(KP707106781), Tew, Tev);
			      STM4(&(io[24]), TeW, ovs, &(io[0]));
			      TeA = VSUB(Tey, Tez);
			      TeX = VFNMS(LDK(KP707106781), TeA, Tex);
			      STM4(&(ro[56]), TeX, ovs, &(ro[0]));
			      TeY = VFMA(LDK(KP707106781), TeA, Tex);
			      STM4(&(ro[24]), TeY, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tdb, TdV, Te5, TdJ, Tdi, Te6, Te3, Teb, TdM, TdW, Tdu, TdR, Te0, Tea, TdF;
			 V TdQ;
			 {
			      V Tde, Tdh, Tdo, Tdt;
			      Tdb = VSUB(Td9, Tda);
			      TdV = VADD(Td9, Tda);
			      Te5 = VADD(TdI, TdH);
			      TdJ = VSUB(TdH, TdI);
			      Tde = VSUB(Tdc, Tdd);
			      Tdh = VADD(Tdf, Tdg);
			      Tdi = VSUB(Tde, Tdh);
			      Te6 = VADD(Tde, Tdh);
			      {
				   V Te1, Te2, TdK, TdL;
				   Te1 = VADD(TdA, TdD);
				   Te2 = VADD(Tdy, Tdx);
				   Te3 = VFNMS(LDK(KP414213562), Te2, Te1);
				   Teb = VFMA(LDK(KP414213562), Te1, Te2);
				   TdK = VSUB(Tdf, Tdg);
				   TdL = VADD(Tdd, Tdc);
				   TdM = VSUB(TdK, TdL);
				   TdW = VADD(TdL, TdK);
			      }
			      Tdo = VSUB(Tdm, Tdn);
			      Tdt = VSUB(Tdp, Tds);
			      Tdu = VFMA(LDK(KP414213562), Tdt, Tdo);
			      TdR = VFNMS(LDK(KP414213562), Tdo, Tdt);
			      {
				   V TdY, TdZ, Tdz, TdE;
				   TdY = VADD(Tdp, Tds);
				   TdZ = VADD(Tdn, Tdm);
				   Te0 = VFMA(LDK(KP414213562), TdZ, TdY);
				   Tea = VFNMS(LDK(KP414213562), TdY, TdZ);
				   Tdz = VSUB(Tdx, Tdy);
				   TdE = VSUB(TdA, TdD);
				   TdF = VFNMS(LDK(KP414213562), TdE, Tdz);
				   TdQ = VFMA(LDK(KP414213562), Tdz, TdE);
			      }
			 }
			 {
			      V Tdj, TdG, TdP, TdS;
			      Tdj = VFMA(LDK(KP707106781), Tdi, Tdb);
			      TdG = VSUB(Tdu, TdF);
			      TeZ = VFNMS(LDK(KP923879532), TdG, Tdj);
			      STM4(&(ro[44]), TeZ, ovs, &(ro[0]));
			      Tf0 = VFMA(LDK(KP923879532), TdG, Tdj);
			      STM4(&(ro[12]), Tf0, ovs, &(ro[0]));
			      TdP = VFMA(LDK(KP707106781), TdM, TdJ);
			      TdS = VSUB(TdQ, TdR);
			      Tf1 = VFNMS(LDK(KP923879532), TdS, TdP);
			      STM4(&(io[44]), Tf1, ovs, &(io[0]));
			      Tf2 = VFMA(LDK(KP923879532), TdS, TdP);
			      STM4(&(io[12]), Tf2, ovs, &(io[0]));
			 }
			 {
			      V TdN, TdO, TdT, TdU;
			      TdN = VFNMS(LDK(KP707106781), TdM, TdJ);
			      TdO = VADD(Tdu, TdF);
			      Tf3 = VFNMS(LDK(KP923879532), TdO, TdN);
			      STM4(&(io[28]), Tf3, ovs, &(io[0]));
			      Tf4 = VFMA(LDK(KP923879532), TdO, TdN);
			      STM4(&(io[60]), Tf4, ovs, &(io[0]));
			      TdT = VFNMS(LDK(KP707106781), Tdi, Tdb);
			      TdU = VADD(TdR, TdQ);
			      Tf5 = VFNMS(LDK(KP923879532), TdU, TdT);
			      STM4(&(ro[28]), Tf5, ovs, &(ro[0]));
			      Tf6 = VFMA(LDK(KP923879532), TdU, TdT);
			      STM4(&(ro[60]), Tf6, ovs, &(ro[0]));
			 }
			 {
			      V TdX, Te4, Ted, Tee;
			      TdX = VFMA(LDK(KP707106781), TdW, TdV);
			      Te4 = VADD(Te0, Te3);
			      Tf7 = VFNMS(LDK(KP923879532), Te4, TdX);
			      STM4(&(ro[36]), Tf7, ovs, &(ro[0]));
			      Tf8 = VFMA(LDK(KP923879532), Te4, TdX);
			      STM4(&(ro[4]), Tf8, ovs, &(ro[0]));
			      Ted = VFMA(LDK(KP707106781), Te6, Te5);
			      Tee = VADD(Tea, Teb);
			      Tf9 = VFNMS(LDK(KP923879532), Tee, Ted);
			      STM4(&(io[36]), Tf9, ovs, &(io[0]));
			      Tfa = VFMA(LDK(KP923879532), Tee, Ted);
			      STM4(&(io[4]), Tfa, ovs, &(io[0]));
			 }
			 {
			      V Te7, Te8, Te9, Tec;
			      Te7 = VFNMS(LDK(KP707106781), Te6, Te5);
			      Te8 = VSUB(Te3, Te0);
			      Tfb = VFNMS(LDK(KP923879532), Te8, Te7);
			      STM4(&(io[52]), Tfb, ovs, &(io[0]));
			      Tfc = VFMA(LDK(KP923879532), Te8, Te7);
			      STM4(&(io[20]), Tfc, ovs, &(io[0]));
			      Te9 = VFNMS(LDK(KP707106781), TdW, TdV);
			      Tec = VSUB(Tea, Teb);
			      Tfd = VFNMS(LDK(KP923879532), Tec, Te9);
			      STM4(&(ro[52]), Tfd, ovs, &(ro[0]));
			      Tfe = VFMA(LDK(KP923879532), Tec, Te9);
			      STM4(&(ro[20]), Tfe, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tcd, TcP, TcD, TcZ, Tck, Td0, TcX, Td4, Tcs, TcK, TcG, TcQ, TcU, Td5, Tcz;
			 V TcL, Tcc, TcC;
			 Tcc = VSUB(TbC, TbD);
			 Tcd = VFMA(LDK(KP707106781), Tcc, Tcb);
			 TcP = VFNMS(LDK(KP707106781), Tcc, Tcb);
			 TcC = VSUB(Tan, Tak);
			 TcD = VFMA(LDK(KP707106781), TcC, TcB);
			 TcZ = VFNMS(LDK(KP707106781), TcC, TcB);
			 {
			      V Tcg, Tcj, TcV, TcW;
			      Tcg = VFMA(LDK(KP414213562), Tcf, Tce);
			      Tcj = VFNMS(LDK(KP414213562), Tci, Tch);
			      Tck = VSUB(Tcg, Tcj);
			      Td0 = VADD(Tcg, Tcj);
			      TcV = VFMA(LDK(KP707106781), Tcx, Tcw);
			      TcW = VFMA(LDK(KP707106781), Tcu, Tct);
			      TcX = VFNMS(LDK(KP198912367), TcW, TcV);
			      Td4 = VFMA(LDK(KP198912367), TcV, TcW);
			 }
			 {
			      V Tco, Tcr, TcE, TcF;
			      Tco = VFNMS(LDK(KP707106781), Tcn, Tcm);
			      Tcr = VFNMS(LDK(KP707106781), Tcq, Tcp);
			      Tcs = VFMA(LDK(KP668178637), Tcr, Tco);
			      TcK = VFNMS(LDK(KP668178637), Tco, Tcr);
			      TcE = VFMA(LDK(KP414213562), Tch, Tci);
			      TcF = VFNMS(LDK(KP414213562), Tce, Tcf);
			      TcG = VSUB(TcE, TcF);
			      TcQ = VADD(TcF, TcE);
			 }
			 {
			      V TcS, TcT, Tcv, Tcy;
			      TcS = VFMA(LDK(KP707106781), Tcq, Tcp);
			      TcT = VFMA(LDK(KP707106781), Tcn, Tcm);
			      TcU = VFMA(LDK(KP198912367), TcT, TcS);
			      Td5 = VFNMS(LDK(KP198912367), TcS, TcT);
			      Tcv = VFNMS(LDK(KP707106781), Tcu, Tct);
			      Tcy = VFNMS(LDK(KP707106781), Tcx, Tcw);
			      Tcz = VFNMS(LDK(KP668178637), Tcy, Tcv);
			      TcL = VFMA(LDK(KP668178637), Tcv, Tcy);
			 }
			 {
			      V Tcl, TcA, TcN, TcO;
			      Tcl = VFMA(LDK(KP923879532), Tck, Tcd);
			      TcA = VADD(Tcs, Tcz);
			      Tff = VFNMS(LDK(KP831469612), TcA, Tcl);
			      STM4(&(ro[38]), Tff, ovs, &(ro[0]));
			      Tfg = VFMA(LDK(KP831469612), TcA, Tcl);
			      STM4(&(ro[6]), Tfg, ovs, &(ro[0]));
			      TcN = VFMA(LDK(KP923879532), TcG, TcD);
			      TcO = VADD(TcK, TcL);
			      Tfh = VFNMS(LDK(KP831469612), TcO, TcN);
			      STM4(&(io[38]), Tfh, ovs, &(io[0]));
			      Tfi = VFMA(LDK(KP831469612), TcO, TcN);
			      STM4(&(io[6]), Tfi, ovs, &(io[0]));
			 }
			 {
			      V TcH, TcI, TcJ, TcM;
			      TcH = VFNMS(LDK(KP923879532), TcG, TcD);
			      TcI = VSUB(Tcz, Tcs);
			      Tfj = VFNMS(LDK(KP831469612), TcI, TcH);
			      STM4(&(io[54]), Tfj, ovs, &(io[0]));
			      Tfk = VFMA(LDK(KP831469612), TcI, TcH);
			      STM4(&(io[22]), Tfk, ovs, &(io[0]));
			      TcJ = VFNMS(LDK(KP923879532), Tck, Tcd);
			      TcM = VSUB(TcK, TcL);
			      Tfl = VFNMS(LDK(KP831469612), TcM, TcJ);
			      STM4(&(ro[54]), Tfl, ovs, &(ro[0]));
			      Tfm = VFMA(LDK(KP831469612), TcM, TcJ);
			      STM4(&(ro[22]), Tfm, ovs, &(ro[0]));
			 }
			 {
			      V TcR, TcY, Td3, Td6;
			      TcR = VFNMS(LDK(KP923879532), TcQ, TcP);
			      TcY = VSUB(TcU, TcX);
			      Tfn = VFNMS(LDK(KP980785280), TcY, TcR);
			      STM4(&(ro[46]), Tfn, ovs, &(ro[0]));
			      Tfo = VFMA(LDK(KP980785280), TcY, TcR);
			      STM4(&(ro[14]), Tfo, ovs, &(ro[0]));
			      Td3 = VFNMS(LDK(KP923879532), Td0, TcZ);
			      Td6 = VSUB(Td4, Td5);
			      Tfp = VFNMS(LDK(KP980785280), Td6, Td3);
			      STM4(&(io[46]), Tfp, ovs, &(io[0]));
			      Tfq = VFMA(LDK(KP980785280), Td6, Td3);
			      STM4(&(io[14]), Tfq, ovs, &(io[0]));
			 }
			 {
			      V Td1, Td2, Td7, Td8;
			      Td1 = VFMA(LDK(KP923879532), Td0, TcZ);
			      Td2 = VADD(TcU, TcX);
			      Tfr = VFNMS(LDK(KP980785280), Td2, Td1);
			      STM4(&(io[30]), Tfr, ovs, &(io[0]));
			      Tfs = VFMA(LDK(KP980785280), Td2, Td1);
			      STM4(&(io[62]), Tfs, ovs, &(io[0]));
			      Td7 = VFMA(LDK(KP923879532), TcQ, TcP);
			      Td8 = VADD(Td5, Td4);
			      Tft = VFNMS(LDK(KP980785280), Td8, Td7);
			      STM4(&(ro[30]), Tft, ovs, &(ro[0]));
			      Tfu = VFMA(LDK(KP980785280), Td8, Td7);
			      STM4(&(ro[62]), Tfu, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tfv, Tfw, Tfx, Tfy, Tfz, TfA, TfB, TfC, TfD, TfE, TfF, TfG, TfH, TfI, TfJ;
			 V TfK, TfL, TfM, TfN, TfO, TfP, TfQ, TfR, TfS, TfT, TfU, TfV, TfW, TfX, TfY;
			 V TfZ, Tg0;
			 {
			      V Tap, TbR, TbF, Tc1, TaE, Tc2, TbZ, Tc7, Tb6, TbN, TbI, TbS, TbW, Tc6, Tbx;
			      V TbM, Tao, TbE;
			      Tao = VADD(Tak, Tan);
			      Tap = VFNMS(LDK(KP707106781), Tao, Tah);
			      TbR = VFMA(LDK(KP707106781), Tao, Tah);
			      TbE = VADD(TbC, TbD);
			      TbF = VFNMS(LDK(KP707106781), TbE, TbB);
			      Tc1 = VFMA(LDK(KP707106781), TbE, TbB);
			      {
				   V Taw, TaD, TbX, TbY;
				   Taw = VFNMS(LDK(KP414213562), Tav, Tas);
				   TaD = VFMA(LDK(KP414213562), TaC, Taz);
				   TaE = VSUB(Taw, TaD);
				   Tc2 = VADD(Taw, TaD);
				   TbX = VFMA(LDK(KP707106781), Tbv, Tbs);
				   TbY = VFMA(LDK(KP707106781), Tbm, Tbb);
				   TbZ = VFNMS(LDK(KP198912367), TbY, TbX);
				   Tc7 = VFMA(LDK(KP198912367), TbX, TbY);
			      }
			      {
				   V TaW, Tb5, TbG, TbH;
				   TaW = VFNMS(LDK(KP707106781), TaV, TaK);
				   Tb5 = VFNMS(LDK(KP707106781), Tb4, Tb1);
				   Tb6 = VFMA(LDK(KP668178637), Tb5, TaW);
				   TbN = VFNMS(LDK(KP668178637), TaW, Tb5);
				   TbG = VFNMS(LDK(KP414213562), Taz, TaC);
				   TbH = VFMA(LDK(KP414213562), Tas, Tav);
				   TbI = VSUB(TbG, TbH);
				   TbS = VADD(TbH, TbG);
			      }
			      {
				   V TbU, TbV, Tbn, Tbw;
				   TbU = VFMA(LDK(KP707106781), Tb4, Tb1);
				   TbV = VFMA(LDK(KP707106781), TaV, TaK);
				   TbW = VFMA(LDK(KP198912367), TbV, TbU);
				   Tc6 = VFNMS(LDK(KP198912367), TbU, TbV);
				   Tbn = VFNMS(LDK(KP707106781), Tbm, Tbb);
				   Tbw = VFNMS(LDK(KP707106781), Tbv, Tbs);
				   Tbx = VFNMS(LDK(KP668178637), Tbw, Tbn);
				   TbM = VFMA(LDK(KP668178637), Tbn, Tbw);
			      }
			      {
				   V TaF, Tby, TbL, TbO;
				   TaF = VFMA(LDK(KP923879532), TaE, Tap);
				   Tby = VSUB(Tb6, Tbx);
				   Tfv = VFNMS(LDK(KP831469612), Tby, TaF);
				   STM4(&(ro[42]), Tfv, ovs, &(ro[0]));
				   Tfw = VFMA(LDK(KP831469612), Tby, TaF);
				   STM4(&(ro[10]), Tfw, ovs, &(ro[0]));
				   TbL = VFMA(LDK(KP923879532), TbI, TbF);
				   TbO = VSUB(TbM, TbN);
				   Tfx = VFNMS(LDK(KP831469612), TbO, TbL);
				   STM4(&(io[42]), Tfx, ovs, &(io[0]));
				   Tfy = VFMA(LDK(KP831469612), TbO, TbL);
				   STM4(&(io[10]), Tfy, ovs, &(io[0]));
			      }
			      {
				   V TbJ, TbK, TbP, TbQ;
				   TbJ = VFNMS(LDK(KP923879532), TbI, TbF);
				   TbK = VADD(Tb6, Tbx);
				   Tfz = VFNMS(LDK(KP831469612), TbK, TbJ);
				   STM4(&(io[26]), Tfz, ovs, &(io[0]));
				   TfA = VFMA(LDK(KP831469612), TbK, TbJ);
				   STM4(&(io[58]), TfA, ovs, &(io[0]));
				   TbP = VFNMS(LDK(KP923879532), TaE, Tap);
				   TbQ = VADD(TbN, TbM);
				   TfB = VFNMS(LDK(KP831469612), TbQ, TbP);
				   STM4(&(ro[26]), TfB, ovs, &(ro[0]));
				   TfC = VFMA(LDK(KP831469612), TbQ, TbP);
				   STM4(&(ro[58]), TfC, ovs, &(ro[0]));
			      }
			      {
				   V TbT, Tc0, Tc9, Tca;
				   TbT = VFMA(LDK(KP923879532), TbS, TbR);
				   Tc0 = VADD(TbW, TbZ);
				   TfD = VFNMS(LDK(KP980785280), Tc0, TbT);
				   STM4(&(ro[34]), TfD, ovs, &(ro[0]));
				   TfE = VFMA(LDK(KP980785280), Tc0, TbT);
				   STM4(&(ro[2]), TfE, ovs, &(ro[0]));
				   Tc9 = VFMA(LDK(KP923879532), Tc2, Tc1);
				   Tca = VADD(Tc6, Tc7);
				   TfF = VFNMS(LDK(KP980785280), Tca, Tc9);
				   STM4(&(io[34]), TfF, ovs, &(io[0]));
				   TfG = VFMA(LDK(KP980785280), Tca, Tc9);
				   STM4(&(io[2]), TfG, ovs, &(io[0]));
			      }
			      {
				   V Tc3, Tc4, Tc5, Tc8;
				   Tc3 = VFNMS(LDK(KP923879532), Tc2, Tc1);
				   Tc4 = VSUB(TbZ, TbW);
				   TfH = VFNMS(LDK(KP980785280), Tc4, Tc3);
				   STM4(&(io[50]), TfH, ovs, &(io[0]));
				   TfI = VFMA(LDK(KP980785280), Tc4, Tc3);
				   STM4(&(io[18]), TfI, ovs, &(io[0]));
				   Tc5 = VFNMS(LDK(KP923879532), TbS, TbR);
				   Tc8 = VSUB(Tc6, Tc7);
				   TfJ = VFNMS(LDK(KP980785280), Tc8, Tc5);
				   STM4(&(ro[50]), TfJ, ovs, &(ro[0]));
				   TfK = VFMA(LDK(KP980785280), Tc8, Tc5);
				   STM4(&(ro[18]), TfK, ovs, &(ro[0]));
			      }
			 }
			 {
			      V T6F, T7h, T7m, T7x, T7p, T7w, T6M, T7s, T6U, T7c, T75, T7r, T78, T7i, T71;
			      V T7d;
			      {
				   V T6D, T6E, T7k, T7l;
				   T6D = VFNMS(LDK(KP707106781), T3e, T37);
				   T6E = VADD(T65, T64);
				   T6F = VFNMS(LDK(KP923879532), T6E, T6D);
				   T7h = VFMA(LDK(KP923879532), T6E, T6D);
				   T7k = VFMA(LDK(KP923879532), T6S, T6R);
				   T7l = VFMA(LDK(KP923879532), T6P, T6O);
				   T7m = VFMA(LDK(KP098491403), T7l, T7k);
				   T7x = VFNMS(LDK(KP098491403), T7k, T7l);
			      }
			      {
				   V T7n, T7o, T6I, T6L;
				   T7n = VFMA(LDK(KP923879532), T6Z, T6Y);
				   T7o = VFMA(LDK(KP923879532), T6W, T6V);
				   T7p = VFNMS(LDK(KP098491403), T7o, T7n);
				   T7w = VFMA(LDK(KP098491403), T7n, T7o);
				   T6I = VFMA(LDK(KP198912367), T6H, T6G);
				   T6L = VFNMS(LDK(KP198912367), T6K, T6J);
				   T6M = VSUB(T6I, T6L);
				   T7s = VADD(T6I, T6L);
			      }
			      {
				   V T6Q, T6T, T73, T74;
				   T6Q = VFNMS(LDK(KP923879532), T6P, T6O);
				   T6T = VFNMS(LDK(KP923879532), T6S, T6R);
				   T6U = VFMA(LDK(KP820678790), T6T, T6Q);
				   T7c = VFNMS(LDK(KP820678790), T6Q, T6T);
				   T73 = VFNMS(LDK(KP707106781), T62, T5Z);
				   T74 = VADD(T3m, T3t);
				   T75 = VFNMS(LDK(KP923879532), T74, T73);
				   T7r = VFMA(LDK(KP923879532), T74, T73);
			      }
			      {
				   V T76, T77, T6X, T70;
				   T76 = VFMA(LDK(KP198912367), T6J, T6K);
				   T77 = VFNMS(LDK(KP198912367), T6G, T6H);
				   T78 = VSUB(T76, T77);
				   T7i = VADD(T77, T76);
				   T6X = VFNMS(LDK(KP923879532), T6W, T6V);
				   T70 = VFNMS(LDK(KP923879532), T6Z, T6Y);
				   T71 = VFNMS(LDK(KP820678790), T70, T6X);
				   T7d = VFMA(LDK(KP820678790), T6X, T70);
			      }
			      {
				   V T6N, T72, T7f, T7g;
				   T6N = VFMA(LDK(KP980785280), T6M, T6F);
				   T72 = VADD(T6U, T71);
				   TfL = VFNMS(LDK(KP773010453), T72, T6N);
				   STM4(&(ro[39]), TfL, ovs, &(ro[1]));
				   TfM = VFMA(LDK(KP773010453), T72, T6N);
				   STM4(&(ro[7]), TfM, ovs, &(ro[1]));
				   T7f = VFMA(LDK(KP980785280), T78, T75);
				   T7g = VADD(T7c, T7d);
				   TfN = VFNMS(LDK(KP773010453), T7g, T7f);
				   STM4(&(io[39]), TfN, ovs, &(io[1]));
				   TfO = VFMA(LDK(KP773010453), T7g, T7f);
				   STM4(&(io[7]), TfO, ovs, &(io[1]));
			      }
			      {
				   V T79, T7a, T7b, T7e;
				   T79 = VFNMS(LDK(KP980785280), T78, T75);
				   T7a = VSUB(T71, T6U);
				   TfP = VFNMS(LDK(KP773010453), T7a, T79);
				   STM4(&(io[55]), TfP, ovs, &(io[1]));
				   TfQ = VFMA(LDK(KP773010453), T7a, T79);
				   STM4(&(io[23]), TfQ, ovs, &(io[1]));
				   T7b = VFNMS(LDK(KP980785280), T6M, T6F);
				   T7e = VSUB(T7c, T7d);
				   TfR = VFNMS(LDK(KP773010453), T7e, T7b);
				   STM4(&(ro[55]), TfR, ovs, &(ro[1]));
				   TfS = VFMA(LDK(KP773010453), T7e, T7b);
				   STM4(&(ro[23]), TfS, ovs, &(ro[1]));
			      }
			      {
				   V T7j, T7q, T7v, T7y;
				   T7j = VFNMS(LDK(KP980785280), T7i, T7h);
				   T7q = VSUB(T7m, T7p);
				   TfT = VFNMS(LDK(KP995184726), T7q, T7j);
				   STM4(&(ro[47]), TfT, ovs, &(ro[1]));
				   TfU = VFMA(LDK(KP995184726), T7q, T7j);
				   STM4(&(ro[15]), TfU, ovs, &(ro[1]));
				   T7v = VFNMS(LDK(KP980785280), T7s, T7r);
				   T7y = VSUB(T7w, T7x);
				   TfV = VFNMS(LDK(KP995184726), T7y, T7v);
				   STM4(&(io[47]), TfV, ovs, &(io[1]));
				   TfW = VFMA(LDK(KP995184726), T7y, T7v);
				   STM4(&(io[15]), TfW, ovs, &(io[1]));
			      }
			      {
				   V T7t, T7u, T7z, T7A;
				   T7t = VFMA(LDK(KP980785280), T7s, T7r);
				   T7u = VADD(T7m, T7p);
				   TfX = VFNMS(LDK(KP995184726), T7u, T7t);
				   STM4(&(io[31]), TfX, ovs, &(io[1]));
				   TfY = VFMA(LDK(KP995184726), T7u, T7t);
				   STM4(&(io[63]), TfY, ovs, &(io[1]));
				   T7z = VFMA(LDK(KP980785280), T7i, T7h);
				   T7A = VADD(T7x, T7w);
				   TfZ = VFNMS(LDK(KP995184726), T7A, T7z);
				   STM4(&(ro[31]), TfZ, ovs, &(ro[1]));
				   Tg0 = VFMA(LDK(KP995184726), T7A, T7z);
				   STM4(&(ro[63]), Tg0, ovs, &(ro[1]));
			      }
			 }
			 {
			      V T9j, T9V, Ta0, Tab, Ta3, Taa, T9q, Ta6, T9y, T9Q, T9J, Ta5, T9M, T9W, T9F;
			      V T9R;
			      {
				   V T9h, T9i, T9Y, T9Z;
				   T9h = VFNMS(LDK(KP707106781), T7C, T7B);
				   T9i = VSUB(T8I, T8J);
				   T9j = VFMA(LDK(KP923879532), T9i, T9h);
				   T9V = VFNMS(LDK(KP923879532), T9i, T9h);
				   T9Y = VFMA(LDK(KP923879532), T9w, T9v);
				   T9Z = VFMA(LDK(KP923879532), T9t, T9s);
				   Ta0 = VFMA(LDK(KP303346683), T9Z, T9Y);
				   Tab = VFNMS(LDK(KP303346683), T9Y, T9Z);
			      }
			      {
				   V Ta1, Ta2, T9m, T9p;
				   Ta1 = VFMA(LDK(KP923879532), T9D, T9C);
				   Ta2 = VFMA(LDK(KP923879532), T9A, T9z);
				   Ta3 = VFNMS(LDK(KP303346683), Ta2, Ta1);
				   Taa = VFMA(LDK(KP303346683), Ta1, Ta2);
				   T9m = VFMA(LDK(KP668178637), T9l, T9k);
				   T9p = VFNMS(LDK(KP668178637), T9o, T9n);
				   T9q = VSUB(T9m, T9p);
				   Ta6 = VADD(T9m, T9p);
			      }
			      {
				   V T9u, T9x, T9H, T9I;
				   T9u = VFNMS(LDK(KP923879532), T9t, T9s);
				   T9x = VFNMS(LDK(KP923879532), T9w, T9v);
				   T9y = VFMA(LDK(KP534511135), T9x, T9u);
				   T9Q = VFNMS(LDK(KP534511135), T9u, T9x);
				   T9H = VFNMS(LDK(KP707106781), T8G, T8F);
				   T9I = VSUB(T7J, T7G);
				   T9J = VFMA(LDK(KP923879532), T9I, T9H);
				   Ta5 = VFNMS(LDK(KP923879532), T9I, T9H);
			      }
			      {
				   V T9K, T9L, T9B, T9E;
				   T9K = VFMA(LDK(KP668178637), T9n, T9o);
				   T9L = VFNMS(LDK(KP668178637), T9k, T9l);
				   T9M = VSUB(T9K, T9L);
				   T9W = VADD(T9L, T9K);
				   T9B = VFNMS(LDK(KP923879532), T9A, T9z);
				   T9E = VFNMS(LDK(KP923879532), T9D, T9C);
				   T9F = VFNMS(LDK(KP534511135), T9E, T9B);
				   T9R = VFMA(LDK(KP534511135), T9B, T9E);
			      }
			      {
				   V T9r, T9G, Tg1, Tg2;
				   T9r = VFMA(LDK(KP831469612), T9q, T9j);
				   T9G = VADD(T9y, T9F);
				   Tg1 = VFNMS(LDK(KP881921264), T9G, T9r);
				   STM4(&(ro[37]), Tg1, ovs, &(ro[1]));
				   STN4(&(ro[36]), Tf7, Tg1, Tff, TfL, ovs);
				   Tg2 = VFMA(LDK(KP881921264), T9G, T9r);
				   STM4(&(ro[5]), Tg2, ovs, &(ro[1]));
				   STN4(&(ro[4]), Tf8, Tg2, Tfg, TfM, ovs);
			      }
			      {
				   V T9T, T9U, Tg3, Tg4;
				   T9T = VFMA(LDK(KP831469612), T9M, T9J);
				   T9U = VADD(T9Q, T9R);
				   Tg3 = VFNMS(LDK(KP881921264), T9U, T9T);
				   STM4(&(io[37]), Tg3, ovs, &(io[1]));
				   STN4(&(io[36]), Tf9, Tg3, Tfh, TfN, ovs);
				   Tg4 = VFMA(LDK(KP881921264), T9U, T9T);
				   STM4(&(io[5]), Tg4, ovs, &(io[1]));
				   STN4(&(io[4]), Tfa, Tg4, Tfi, TfO, ovs);
			      }
			      {
				   V T9N, T9O, Tg5, Tg6;
				   T9N = VFNMS(LDK(KP831469612), T9M, T9J);
				   T9O = VSUB(T9F, T9y);
				   Tg5 = VFNMS(LDK(KP881921264), T9O, T9N);
				   STM4(&(io[53]), Tg5, ovs, &(io[1]));
				   STN4(&(io[52]), Tfb, Tg5, Tfj, TfP, ovs);
				   Tg6 = VFMA(LDK(KP881921264), T9O, T9N);
				   STM4(&(io[21]), Tg6, ovs, &(io[1]));
				   STN4(&(io[20]), Tfc, Tg6, Tfk, TfQ, ovs);
			      }
			      {
				   V T9P, T9S, Tg7, Tg8;
				   T9P = VFNMS(LDK(KP831469612), T9q, T9j);
				   T9S = VSUB(T9Q, T9R);
				   Tg7 = VFNMS(LDK(KP881921264), T9S, T9P);
				   STM4(&(ro[53]), Tg7, ovs, &(ro[1]));
				   STN4(&(ro[52]), Tfd, Tg7, Tfl, TfR, ovs);
				   Tg8 = VFMA(LDK(KP881921264), T9S, T9P);
				   STM4(&(ro[21]), Tg8, ovs, &(ro[1]));
				   STN4(&(ro[20]), Tfe, Tg8, Tfm, TfS, ovs);
			      }
			      {
				   V T9X, Ta4, Tg9, Tga;
				   T9X = VFNMS(LDK(KP831469612), T9W, T9V);
				   Ta4 = VSUB(Ta0, Ta3);
				   Tg9 = VFNMS(LDK(KP956940335), Ta4, T9X);
				   STM4(&(ro[45]), Tg9, ovs, &(ro[1]));
				   STN4(&(ro[44]), TeZ, Tg9, Tfn, TfT, ovs);
				   Tga = VFMA(LDK(KP956940335), Ta4, T9X);
				   STM4(&(ro[13]), Tga, ovs, &(ro[1]));
				   STN4(&(ro[12]), Tf0, Tga, Tfo, TfU, ovs);
			      }
			      {
				   V Ta9, Tac, Tgb, Tgc;
				   Ta9 = VFNMS(LDK(KP831469612), Ta6, Ta5);
				   Tac = VSUB(Taa, Tab);
				   Tgb = VFNMS(LDK(KP956940335), Tac, Ta9);
				   STM4(&(io[45]), Tgb, ovs, &(io[1]));
				   STN4(&(io[44]), Tf1, Tgb, Tfp, TfV, ovs);
				   Tgc = VFMA(LDK(KP956940335), Tac, Ta9);
				   STM4(&(io[13]), Tgc, ovs, &(io[1]));
				   STN4(&(io[12]), Tf2, Tgc, Tfq, TfW, ovs);
			      }
			      {
				   V Ta7, Ta8, Tgd, Tge;
				   Ta7 = VFMA(LDK(KP831469612), Ta6, Ta5);
				   Ta8 = VADD(Ta0, Ta3);
				   Tgd = VFNMS(LDK(KP956940335), Ta8, Ta7);
				   STM4(&(io[29]), Tgd, ovs, &(io[1]));
				   STN4(&(io[28]), Tf3, Tgd, Tfr, TfX, ovs);
				   Tge = VFMA(LDK(KP956940335), Ta8, Ta7);
				   STM4(&(io[61]), Tge, ovs, &(io[1]));
				   STN4(&(io[60]), Tf4, Tge, Tfs, TfY, ovs);
			      }
			      {
				   V Tad, Tae, Tgf, Tgg;
				   Tad = VFMA(LDK(KP831469612), T9W, T9V);
				   Tae = VADD(Tab, Taa);
				   Tgf = VFNMS(LDK(KP956940335), Tae, Tad);
				   STM4(&(ro[29]), Tgf, ovs, &(ro[1]));
				   STN4(&(ro[28]), Tf5, Tgf, Tft, TfZ, ovs);
				   Tgg = VFMA(LDK(KP956940335), Tae, Tad);
				   STM4(&(ro[61]), Tgg, ovs, &(ro[1]));
				   STN4(&(ro[60]), Tf6, Tgg, Tfu, Tg0, ovs);
			      }
			 }
			 {
			      V Tgh, Tgi, Tgj, Tgk, Tgl, Tgm, Tgn, Tgo, Tgp, Tgq, Tgr, Tgs, Tgt, Tgu, Tgv;
			      V Tgw;
			      {
				   V T3v, T6j, T6o, T6y, T6r, T6z, T48, T6u, T52, T6f, T67, T6t, T6a, T6k, T5V;
				   V T6e;
				   {
					V T3f, T3u, T6m, T6n;
					T3f = VFMA(LDK(KP707106781), T3e, T37);
					T3u = VSUB(T3m, T3t);
					T3v = VFNMS(LDK(KP923879532), T3u, T3f);
					T6j = VFMA(LDK(KP923879532), T3u, T3f);
					T6m = VFMA(LDK(KP923879532), T50, T4X);
					T6n = VFMA(LDK(KP923879532), T4N, T4q);
					T6o = VFMA(LDK(KP303346683), T6n, T6m);
					T6y = VFNMS(LDK(KP303346683), T6m, T6n);
				   }
				   {
					V T6p, T6q, T3O, T47;
					T6p = VFMA(LDK(KP923879532), T5T, T5Q);
					T6q = VFMA(LDK(KP923879532), T5G, T5j);
					T6r = VFNMS(LDK(KP303346683), T6q, T6p);
					T6z = VFMA(LDK(KP303346683), T6p, T6q);
					T3O = VFNMS(LDK(KP668178637), T3N, T3G);
					T47 = VFMA(LDK(KP668178637), T46, T3Z);
					T48 = VSUB(T3O, T47);
					T6u = VADD(T3O, T47);
				   }
				   {
					V T4O, T51, T63, T66;
					T4O = VFNMS(LDK(KP923879532), T4N, T4q);
					T51 = VFNMS(LDK(KP923879532), T50, T4X);
					T52 = VFMA(LDK(KP534511135), T51, T4O);
					T6f = VFNMS(LDK(KP534511135), T4O, T51);
					T63 = VFMA(LDK(KP707106781), T62, T5Z);
					T66 = VSUB(T64, T65);
					T67 = VFNMS(LDK(KP923879532), T66, T63);
					T6t = VFMA(LDK(KP923879532), T66, T63);
				   }
				   {
					V T68, T69, T5H, T5U;
					T68 = VFNMS(LDK(KP668178637), T3Z, T46);
					T69 = VFMA(LDK(KP668178637), T3G, T3N);
					T6a = VSUB(T68, T69);
					T6k = VADD(T69, T68);
					T5H = VFNMS(LDK(KP923879532), T5G, T5j);
					T5U = VFNMS(LDK(KP923879532), T5T, T5Q);
					T5V = VFNMS(LDK(KP534511135), T5U, T5H);
					T6e = VFMA(LDK(KP534511135), T5H, T5U);
				   }
				   {
					V T49, T5W, T6d, T6g;
					T49 = VFMA(LDK(KP831469612), T48, T3v);
					T5W = VSUB(T52, T5V);
					Tgh = VFNMS(LDK(KP881921264), T5W, T49);
					STM4(&(ro[43]), Tgh, ovs, &(ro[1]));
					Tgi = VFMA(LDK(KP881921264), T5W, T49);
					STM4(&(ro[11]), Tgi, ovs, &(ro[1]));
					T6d = VFMA(LDK(KP831469612), T6a, T67);
					T6g = VSUB(T6e, T6f);
					Tgj = VFNMS(LDK(KP881921264), T6g, T6d);
					STM4(&(io[43]), Tgj, ovs, &(io[1]));
					Tgk = VFMA(LDK(KP881921264), T6g, T6d);
					STM4(&(io[11]), Tgk, ovs, &(io[1]));
				   }
				   {
					V T6b, T6c, T6h, T6i;
					T6b = VFNMS(LDK(KP831469612), T6a, T67);
					T6c = VADD(T52, T5V);
					Tgl = VFNMS(LDK(KP881921264), T6c, T6b);
					STM4(&(io[27]), Tgl, ovs, &(io[1]));
					Tgm = VFMA(LDK(KP881921264), T6c, T6b);
					STM4(&(io[59]), Tgm, ovs, &(io[1]));
					T6h = VFNMS(LDK(KP831469612), T48, T3v);
					T6i = VADD(T6f, T6e);
					Tgn = VFNMS(LDK(KP881921264), T6i, T6h);
					STM4(&(ro[27]), Tgn, ovs, &(ro[1]));
					Tgo = VFMA(LDK(KP881921264), T6i, T6h);
					STM4(&(ro[59]), Tgo, ovs, &(ro[1]));
				   }
				   {
					V T6l, T6s, T6B, T6C;
					T6l = VFMA(LDK(KP831469612), T6k, T6j);
					T6s = VADD(T6o, T6r);
					Tgp = VFNMS(LDK(KP956940335), T6s, T6l);
					STM4(&(ro[35]), Tgp, ovs, &(ro[1]));
					Tgq = VFMA(LDK(KP956940335), T6s, T6l);
					STM4(&(ro[3]), Tgq, ovs, &(ro[1]));
					T6B = VFMA(LDK(KP831469612), T6u, T6t);
					T6C = VADD(T6y, T6z);
					Tgr = VFNMS(LDK(KP956940335), T6C, T6B);
					STM4(&(io[35]), Tgr, ovs, &(io[1]));
					Tgs = VFMA(LDK(KP956940335), T6C, T6B);
					STM4(&(io[3]), Tgs, ovs, &(io[1]));
				   }
				   {
					V T6v, T6w, T6x, T6A;
					T6v = VFNMS(LDK(KP831469612), T6u, T6t);
					T6w = VSUB(T6r, T6o);
					Tgt = VFNMS(LDK(KP956940335), T6w, T6v);
					STM4(&(io[51]), Tgt, ovs, &(io[1]));
					Tgu = VFMA(LDK(KP956940335), T6w, T6v);
					STM4(&(io[19]), Tgu, ovs, &(io[1]));
					T6x = VFNMS(LDK(KP831469612), T6k, T6j);
					T6A = VSUB(T6y, T6z);
					Tgv = VFNMS(LDK(KP956940335), T6A, T6x);
					STM4(&(ro[51]), Tgv, ovs, &(ro[1]));
					Tgw = VFMA(LDK(KP956940335), T6A, T6x);
					STM4(&(ro[19]), Tgw, ovs, &(ro[1]));
				   }
			      }
			      {
				   V T7L, T8X, T92, T9c, T95, T9d, T80, T98, T8k, T8T, T8L, T97, T8O, T8Y, T8D;
				   V T8S;
				   {
					V T7D, T7K, T90, T91;
					T7D = VFMA(LDK(KP707106781), T7C, T7B);
					T7K = VADD(T7G, T7J);
					T7L = VFNMS(LDK(KP923879532), T7K, T7D);
					T8X = VFMA(LDK(KP923879532), T7K, T7D);
					T90 = VFMA(LDK(KP923879532), T8i, T8f);
					T91 = VFMA(LDK(KP923879532), T8b, T84);
					T92 = VFMA(LDK(KP098491403), T91, T90);
					T9c = VFNMS(LDK(KP098491403), T90, T91);
				   }
				   {
					V T93, T94, T7S, T7Z;
					T93 = VFMA(LDK(KP923879532), T8B, T8y);
					T94 = VFMA(LDK(KP923879532), T8u, T8n);
					T95 = VFNMS(LDK(KP098491403), T94, T93);
					T9d = VFMA(LDK(KP098491403), T93, T94);
					T7S = VFNMS(LDK(KP198912367), T7R, T7O);
					T7Z = VFMA(LDK(KP198912367), T7Y, T7V);
					T80 = VSUB(T7S, T7Z);
					T98 = VADD(T7S, T7Z);
				   }
				   {
					V T8c, T8j, T8H, T8K;
					T8c = VFNMS(LDK(KP923879532), T8b, T84);
					T8j = VFNMS(LDK(KP923879532), T8i, T8f);
					T8k = VFMA(LDK(KP820678790), T8j, T8c);
					T8T = VFNMS(LDK(KP820678790), T8c, T8j);
					T8H = VFMA(LDK(KP707106781), T8G, T8F);
					T8K = VADD(T8I, T8J);
					T8L = VFNMS(LDK(KP923879532), T8K, T8H);
					T97 = VFMA(LDK(KP923879532), T8K, T8H);
				   }
				   {
					V T8M, T8N, T8v, T8C;
					T8M = VFNMS(LDK(KP198912367), T7V, T7Y);
					T8N = VFMA(LDK(KP198912367), T7O, T7R);
					T8O = VSUB(T8M, T8N);
					T8Y = VADD(T8N, T8M);
					T8v = VFNMS(LDK(KP923879532), T8u, T8n);
					T8C = VFNMS(LDK(KP923879532), T8B, T8y);
					T8D = VFNMS(LDK(KP820678790), T8C, T8v);
					T8S = VFMA(LDK(KP820678790), T8v, T8C);
				   }
				   {
					V T81, T8E, Tgx, Tgy;
					T81 = VFMA(LDK(KP980785280), T80, T7L);
					T8E = VSUB(T8k, T8D);
					Tgx = VFNMS(LDK(KP773010453), T8E, T81);
					STM4(&(ro[41]), Tgx, ovs, &(ro[1]));
					STN4(&(ro[40]), TeR, Tgx, Tfv, Tgh, ovs);
					Tgy = VFMA(LDK(KP773010453), T8E, T81);
					STM4(&(ro[9]), Tgy, ovs, &(ro[1]));
					STN4(&(ro[8]), TeS, Tgy, Tfw, Tgi, ovs);
				   }
				   {
					V T8R, T8U, Tgz, TgA;
					T8R = VFMA(LDK(KP980785280), T8O, T8L);
					T8U = VSUB(T8S, T8T);
					Tgz = VFNMS(LDK(KP773010453), T8U, T8R);
					STM4(&(io[41]), Tgz, ovs, &(io[1]));
					STN4(&(io[40]), TeT, Tgz, Tfx, Tgj, ovs);
					TgA = VFMA(LDK(KP773010453), T8U, T8R);
					STM4(&(io[9]), TgA, ovs, &(io[1]));
					STN4(&(io[8]), TeU, TgA, Tfy, Tgk, ovs);
				   }
				   {
					V T8P, T8Q, TgB, TgC;
					T8P = VFNMS(LDK(KP980785280), T8O, T8L);
					T8Q = VADD(T8k, T8D);
					TgB = VFNMS(LDK(KP773010453), T8Q, T8P);
					STM4(&(io[25]), TgB, ovs, &(io[1]));
					STN4(&(io[24]), TeW, TgB, Tfz, Tgl, ovs);
					TgC = VFMA(LDK(KP773010453), T8Q, T8P);
					STM4(&(io[57]), TgC, ovs, &(io[1]));
					STN4(&(io[56]), TeV, TgC, TfA, Tgm, ovs);
				   }
				   {
					V T8V, T8W, TgD, TgE;
					T8V = VFNMS(LDK(KP980785280), T80, T7L);
					T8W = VADD(T8T, T8S);
					TgD = VFNMS(LDK(KP773010453), T8W, T8V);
					STM4(&(ro[25]), TgD, ovs, &(ro[1]));
					STN4(&(ro[24]), TeY, TgD, TfB, Tgn, ovs);
					TgE = VFMA(LDK(KP773010453), T8W, T8V);
					STM4(&(ro[57]), TgE, ovs, &(ro[1]));
					STN4(&(ro[56]), TeX, TgE, TfC, Tgo, ovs);
				   }
				   {
					V T8Z, T96, TgF, TgG;
					T8Z = VFMA(LDK(KP980785280), T8Y, T8X);
					T96 = VADD(T92, T95);
					TgF = VFNMS(LDK(KP995184726), T96, T8Z);
					STM4(&(ro[33]), TgF, ovs, &(ro[1]));
					STN4(&(ro[32]), TeJ, TgF, TfD, Tgp, ovs);
					TgG = VFMA(LDK(KP995184726), T96, T8Z);
					STM4(&(ro[1]), TgG, ovs, &(ro[1]));
					STN4(&(ro[0]), TeL, TgG, TfE, Tgq, ovs);
				   }
				   {
					V T9f, T9g, TgH, TgI;
					T9f = VFMA(LDK(KP980785280), T98, T97);
					T9g = VADD(T9c, T9d);
					TgH = VFNMS(LDK(KP995184726), T9g, T9f);
					STM4(&(io[33]), TgH, ovs, &(io[1]));
					STN4(&(io[32]), TeK, TgH, TfF, Tgr, ovs);
					TgI = VFMA(LDK(KP995184726), T9g, T9f);
					STM4(&(io[1]), TgI, ovs, &(io[1]));
					STN4(&(io[0]), TeM, TgI, TfG, Tgs, ovs);
				   }
				   {
					V T99, T9a, TgJ, TgK;
					T99 = VFNMS(LDK(KP980785280), T98, T97);
					T9a = VSUB(T95, T92);
					TgJ = VFNMS(LDK(KP995184726), T9a, T99);
					STM4(&(io[49]), TgJ, ovs, &(io[1]));
					STN4(&(io[48]), TeP, TgJ, TfH, Tgt, ovs);
					TgK = VFMA(LDK(KP995184726), T9a, T99);
					STM4(&(io[17]), TgK, ovs, &(io[1]));
					STN4(&(io[16]), TeN, TgK, TfI, Tgu, ovs);
				   }
				   {
					V T9b, T9e, TgL, TgM;
					T9b = VFNMS(LDK(KP980785280), T8Y, T8X);
					T9e = VSUB(T9c, T9d);
					TgL = VFNMS(LDK(KP995184726), T9e, T9b);
					STM4(&(ro[49]), TgL, ovs, &(ro[1]));
					STN4(&(ro[48]), TeQ, TgL, TfJ, Tgv, ovs);
					TgM = VFMA(LDK(KP995184726), T9e, T9b);
					STM4(&(ro[17]), TgM, ovs, &(ro[1]));
					STN4(&(ro[16]), TeO, TgM, TfK, Tgw, ovs);
				   }
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 64, XSIMD_STRING("n2sv_64"), {520, 0, 392, 0}, &GENUS, 0, 1, 0, 0 };

void XSIMD(codelet_n2sv_64) (planner *p) {
     X(kdft_register) (p, n2sv_64, &desc);
}

#else

/* Generated by: ../../../genfft/gen_notw.native -simd -compact -variables 4 -pipeline-latency 8 -n 64 -name n2sv_64 -with-ostride 1 -include dft/simd/n2s.h -store-multiple 4 */

/*
 * This function contains 912 FP additions, 248 FP multiplications,
 * (or, 808 additions, 144 multiplications, 104 fused multiply/add),
 * 260 stack variables, 15 constants, and 288 memory accesses
 */
#include "dft/simd/n2s.h"

static void n2sv_64(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, INT v, INT ivs, INT ovs)
{
     DVK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DVK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DVK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DVK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DVK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DVK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DVK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DVK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT i;
	  for (i = v; i > 0; i = i - (2 * VL), ri = ri + ((2 * VL) * ivs), ii = ii + ((2 * VL) * ivs), ro = ro + ((2 * VL) * ovs), io = io + ((2 * VL) * ovs), MAKE_VOLATILE_STRIDE(256, is), MAKE_VOLATILE_STRIDE(256, os)) {
	       V T37, T7B, T8F, T5Z, Tf, Td9, TbB, TcB, T62, T7C, T2i, TdH, Tah, Tcb, T3e;
	       V T8G, Tu, TdI, Tak, TbD, Tan, TbC, T2x, Tda, T3m, T65, T7G, T8J, T7J, T8I;
	       V T3t, T64, TK, Tdd, Tas, Tce, Tav, Tcf, T2N, Tdc, T3G, T6G, T7O, T9k, T7R;
	       V T9l, T3N, T6H, T1L, Tdv, Tbs, Tcw, TdC, Teo, T5j, T6V, T5Q, T6Y, T8y, T9C;
	       V Tbb, Tct, T8n, T9z, TZ, Tdf, Taz, Tch, TaC, Tci, T32, Tdg, T3Z, T6J, T7V;
	       V T9n, T7Y, T9o, T46, T6K, T1g, Tdp, Tb1, Tcm, Tdm, Tej, T4q, T6R, T4X, T6O;
	       V T8f, T9s, TaK, Tcp, T84, T9v, T1v, Tdn, Tb4, Tcq, Tds, Tek, T4N, T6P, T50;
	       V T6S, T8i, T9w, TaV, Tcn, T8b, T9t, T20, TdD, Tbv, Tcu, Tdy, Tep, T5G, T6Z;
	       V T5T, T6W, T8B, T9A, Tbm, Tcx, T8u, T9D;
	       {
		    V T3, T35, T26, T5Y, T6, T5X, T29, T36, Ta, T39, T2d, T38, Td, T3b, T2g;
		    V T3c;
		    {
			 V T1, T2, T24, T25;
			 T1 = LD(&(ri[0]), ivs, &(ri[0]));
			 T2 = LD(&(ri[WS(is, 32)]), ivs, &(ri[0]));
			 T3 = VADD(T1, T2);
			 T35 = VSUB(T1, T2);
			 T24 = LD(&(ii[0]), ivs, &(ii[0]));
			 T25 = LD(&(ii[WS(is, 32)]), ivs, &(ii[0]));
			 T26 = VADD(T24, T25);
			 T5Y = VSUB(T24, T25);
		    }
		    {
			 V T4, T5, T27, T28;
			 T4 = LD(&(ri[WS(is, 16)]), ivs, &(ri[0]));
			 T5 = LD(&(ri[WS(is, 48)]), ivs, &(ri[0]));
			 T6 = VADD(T4, T5);
			 T5X = VSUB(T4, T5);
			 T27 = LD(&(ii[WS(is, 16)]), ivs, &(ii[0]));
			 T28 = LD(&(ii[WS(is, 48)]), ivs, &(ii[0]));
			 T29 = VADD(T27, T28);
			 T36 = VSUB(T27, T28);
		    }
		    {
			 V T8, T9, T2b, T2c;
			 T8 = LD(&(ri[WS(is, 8)]), ivs, &(ri[0]));
			 T9 = LD(&(ri[WS(is, 40)]), ivs, &(ri[0]));
			 Ta = VADD(T8, T9);
			 T39 = VSUB(T8, T9);
			 T2b = LD(&(ii[WS(is, 8)]), ivs, &(ii[0]));
			 T2c = LD(&(ii[WS(is, 40)]), ivs, &(ii[0]));
			 T2d = VADD(T2b, T2c);
			 T38 = VSUB(T2b, T2c);
		    }
		    {
			 V Tb, Tc, T2e, T2f;
			 Tb = LD(&(ri[WS(is, 56)]), ivs, &(ri[0]));
			 Tc = LD(&(ri[WS(is, 24)]), ivs, &(ri[0]));
			 Td = VADD(Tb, Tc);
			 T3b = VSUB(Tb, Tc);
			 T2e = LD(&(ii[WS(is, 56)]), ivs, &(ii[0]));
			 T2f = LD(&(ii[WS(is, 24)]), ivs, &(ii[0]));
			 T2g = VADD(T2e, T2f);
			 T3c = VSUB(T2e, T2f);
		    }
		    {
			 V T7, Te, T2a, T2h;
			 T37 = VSUB(T35, T36);
			 T7B = VADD(T35, T36);
			 T8F = VSUB(T5Y, T5X);
			 T5Z = VADD(T5X, T5Y);
			 T7 = VADD(T3, T6);
			 Te = VADD(Ta, Td);
			 Tf = VADD(T7, Te);
			 Td9 = VSUB(T7, Te);
			 {
			      V Tbz, TbA, T60, T61;
			      Tbz = VSUB(T26, T29);
			      TbA = VSUB(Td, Ta);
			      TbB = VSUB(Tbz, TbA);
			      TcB = VADD(TbA, Tbz);
			      T60 = VSUB(T3b, T3c);
			      T61 = VADD(T39, T38);
			      T62 = VMUL(LDK(KP707106781), VSUB(T60, T61));
			      T7C = VMUL(LDK(KP707106781), VADD(T61, T60));
			 }
			 T2a = VADD(T26, T29);
			 T2h = VADD(T2d, T2g);
			 T2i = VADD(T2a, T2h);
			 TdH = VSUB(T2a, T2h);
			 {
			      V Taf, Tag, T3a, T3d;
			      Taf = VSUB(T3, T6);
			      Tag = VSUB(T2d, T2g);
			      Tah = VSUB(Taf, Tag);
			      Tcb = VADD(Taf, Tag);
			      T3a = VSUB(T38, T39);
			      T3d = VADD(T3b, T3c);
			      T3e = VMUL(LDK(KP707106781), VSUB(T3a, T3d));
			      T8G = VMUL(LDK(KP707106781), VADD(T3a, T3d));
			 }
		    }
	       }
	       {
		    V Ti, T3j, T2l, T3h, Tl, T3g, T2o, T3k, Tp, T3q, T2s, T3o, Ts, T3n, T2v;
		    V T3r;
		    {
			 V Tg, Th, T2j, T2k;
			 Tg = LD(&(ri[WS(is, 4)]), ivs, &(ri[0]));
			 Th = LD(&(ri[WS(is, 36)]), ivs, &(ri[0]));
			 Ti = VADD(Tg, Th);
			 T3j = VSUB(Tg, Th);
			 T2j = LD(&(ii[WS(is, 4)]), ivs, &(ii[0]));
			 T2k = LD(&(ii[WS(is, 36)]), ivs, &(ii[0]));
			 T2l = VADD(T2j, T2k);
			 T3h = VSUB(T2j, T2k);
		    }
		    {
			 V Tj, Tk, T2m, T2n;
			 Tj = LD(&(ri[WS(is, 20)]), ivs, &(ri[0]));
			 Tk = LD(&(ri[WS(is, 52)]), ivs, &(ri[0]));
			 Tl = VADD(Tj, Tk);
			 T3g = VSUB(Tj, Tk);
			 T2m = LD(&(ii[WS(is, 20)]), ivs, &(ii[0]));
			 T2n = LD(&(ii[WS(is, 52)]), ivs, &(ii[0]));
			 T2o = VADD(T2m, T2n);
			 T3k = VSUB(T2m, T2n);
		    }
		    {
			 V Tn, To, T2q, T2r;
			 Tn = LD(&(ri[WS(is, 60)]), ivs, &(ri[0]));
			 To = LD(&(ri[WS(is, 28)]), ivs, &(ri[0]));
			 Tp = VADD(Tn, To);
			 T3q = VSUB(Tn, To);
			 T2q = LD(&(ii[WS(is, 60)]), ivs, &(ii[0]));
			 T2r = LD(&(ii[WS(is, 28)]), ivs, &(ii[0]));
			 T2s = VADD(T2q, T2r);
			 T3o = VSUB(T2q, T2r);
		    }
		    {
			 V Tq, Tr, T2t, T2u;
			 Tq = LD(&(ri[WS(is, 12)]), ivs, &(ri[0]));
			 Tr = LD(&(ri[WS(is, 44)]), ivs, &(ri[0]));
			 Ts = VADD(Tq, Tr);
			 T3n = VSUB(Tq, Tr);
			 T2t = LD(&(ii[WS(is, 12)]), ivs, &(ii[0]));
			 T2u = LD(&(ii[WS(is, 44)]), ivs, &(ii[0]));
			 T2v = VADD(T2t, T2u);
			 T3r = VSUB(T2t, T2u);
		    }
		    {
			 V Tm, Tt, Tai, Taj;
			 Tm = VADD(Ti, Tl);
			 Tt = VADD(Tp, Ts);
			 Tu = VADD(Tm, Tt);
			 TdI = VSUB(Tt, Tm);
			 Tai = VSUB(T2l, T2o);
			 Taj = VSUB(Ti, Tl);
			 Tak = VSUB(Tai, Taj);
			 TbD = VADD(Taj, Tai);
		    }
		    {
			 V Tal, Tam, T2p, T2w;
			 Tal = VSUB(Tp, Ts);
			 Tam = VSUB(T2s, T2v);
			 Tan = VADD(Tal, Tam);
			 TbC = VSUB(Tal, Tam);
			 T2p = VADD(T2l, T2o);
			 T2w = VADD(T2s, T2v);
			 T2x = VADD(T2p, T2w);
			 Tda = VSUB(T2p, T2w);
		    }
		    {
			 V T3i, T3l, T7E, T7F;
			 T3i = VADD(T3g, T3h);
			 T3l = VSUB(T3j, T3k);
			 T3m = VFNMS(LDK(KP923879532), T3l, VMUL(LDK(KP382683432), T3i));
			 T65 = VFMA(LDK(KP923879532), T3i, VMUL(LDK(KP382683432), T3l));
			 T7E = VSUB(T3h, T3g);
			 T7F = VADD(T3j, T3k);
			 T7G = VFNMS(LDK(KP382683432), T7F, VMUL(LDK(KP923879532), T7E));
			 T8J = VFMA(LDK(KP382683432), T7E, VMUL(LDK(KP923879532), T7F));
		    }
		    {
			 V T7H, T7I, T3p, T3s;
			 T7H = VSUB(T3o, T3n);
			 T7I = VADD(T3q, T3r);
			 T7J = VFMA(LDK(KP923879532), T7H, VMUL(LDK(KP382683432), T7I));
			 T8I = VFNMS(LDK(KP382683432), T7H, VMUL(LDK(KP923879532), T7I));
			 T3p = VADD(T3n, T3o);
			 T3s = VSUB(T3q, T3r);
			 T3t = VFMA(LDK(KP382683432), T3p, VMUL(LDK(KP923879532), T3s));
			 T64 = VFNMS(LDK(KP923879532), T3p, VMUL(LDK(KP382683432), T3s));
		    }
	       }
	       {
		    V Ty, T3H, T2B, T3x, TB, T3w, T2E, T3I, TI, T3L, T2L, T3B, TF, T3K, T2I;
		    V T3E;
		    {
			 V Tw, Tx, T2C, T2D;
			 Tw = LD(&(ri[WS(is, 2)]), ivs, &(ri[0]));
			 Tx = LD(&(ri[WS(is, 34)]), ivs, &(ri[0]));
			 Ty = VADD(Tw, Tx);
			 T3H = VSUB(Tw, Tx);
			 {
			      V T2z, T2A, Tz, TA;
			      T2z = LD(&(ii[WS(is, 2)]), ivs, &(ii[0]));
			      T2A = LD(&(ii[WS(is, 34)]), ivs, &(ii[0]));
			      T2B = VADD(T2z, T2A);
			      T3x = VSUB(T2z, T2A);
			      Tz = LD(&(ri[WS(is, 18)]), ivs, &(ri[0]));
			      TA = LD(&(ri[WS(is, 50)]), ivs, &(ri[0]));
			      TB = VADD(Tz, TA);
			      T3w = VSUB(Tz, TA);
			 }
			 T2C = LD(&(ii[WS(is, 18)]), ivs, &(ii[0]));
			 T2D = LD(&(ii[WS(is, 50)]), ivs, &(ii[0]));
			 T2E = VADD(T2C, T2D);
			 T3I = VSUB(T2C, T2D);
			 {
			      V TG, TH, T3z, T2J, T2K, T3A;
			      TG = LD(&(ri[WS(is, 58)]), ivs, &(ri[0]));
			      TH = LD(&(ri[WS(is, 26)]), ivs, &(ri[0]));
			      T3z = VSUB(TG, TH);
			      T2J = LD(&(ii[WS(is, 58)]), ivs, &(ii[0]));
			      T2K = LD(&(ii[WS(is, 26)]), ivs, &(ii[0]));
			      T3A = VSUB(T2J, T2K);
			      TI = VADD(TG, TH);
			      T3L = VADD(T3z, T3A);
			      T2L = VADD(T2J, T2K);
			      T3B = VSUB(T3z, T3A);
			 }
			 {
			      V TD, TE, T3C, T2G, T2H, T3D;
			      TD = LD(&(ri[WS(is, 10)]), ivs, &(ri[0]));
			      TE = LD(&(ri[WS(is, 42)]), ivs, &(ri[0]));
			      T3C = VSUB(TD, TE);
			      T2G = LD(&(ii[WS(is, 10)]), ivs, &(ii[0]));
			      T2H = LD(&(ii[WS(is, 42)]), ivs, &(ii[0]));
			      T3D = VSUB(T2G, T2H);
			      TF = VADD(TD, TE);
			      T3K = VSUB(T3D, T3C);
			      T2I = VADD(T2G, T2H);
			      T3E = VADD(T3C, T3D);
			 }
		    }
		    {
			 V TC, TJ, Taq, Tar;
			 TC = VADD(Ty, TB);
			 TJ = VADD(TF, TI);
			 TK = VADD(TC, TJ);
			 Tdd = VSUB(TC, TJ);
			 Taq = VSUB(T2B, T2E);
			 Tar = VSUB(TI, TF);
			 Tas = VSUB(Taq, Tar);
			 Tce = VADD(Tar, Taq);
		    }
		    {
			 V Tat, Tau, T2F, T2M;
			 Tat = VSUB(Ty, TB);
			 Tau = VSUB(T2I, T2L);
			 Tav = VSUB(Tat, Tau);
			 Tcf = VADD(Tat, Tau);
			 T2F = VADD(T2B, T2E);
			 T2M = VADD(T2I, T2L);
			 T2N = VADD(T2F, T2M);
			 Tdc = VSUB(T2F, T2M);
		    }
		    {
			 V T3y, T3F, T7M, T7N;
			 T3y = VADD(T3w, T3x);
			 T3F = VMUL(LDK(KP707106781), VSUB(T3B, T3E));
			 T3G = VSUB(T3y, T3F);
			 T6G = VADD(T3y, T3F);
			 T7M = VSUB(T3x, T3w);
			 T7N = VMUL(LDK(KP707106781), VADD(T3K, T3L));
			 T7O = VSUB(T7M, T7N);
			 T9k = VADD(T7M, T7N);
		    }
		    {
			 V T7P, T7Q, T3J, T3M;
			 T7P = VADD(T3H, T3I);
			 T7Q = VMUL(LDK(KP707106781), VADD(T3E, T3B));
			 T7R = VSUB(T7P, T7Q);
			 T9l = VADD(T7P, T7Q);
			 T3J = VSUB(T3H, T3I);
			 T3M = VMUL(LDK(KP707106781), VSUB(T3K, T3L));
			 T3N = VSUB(T3J, T3M);
			 T6H = VADD(T3J, T3M);
		    }
	       }
	       {
		    V T1z, T53, T5L, Tbo, T1C, T5I, T56, Tbp, T1J, Tb9, T5h, T5N, T1G, Tb8, T5c;
		    V T5O;
		    {
			 V T1x, T1y, T54, T55;
			 T1x = LD(&(ri[WS(is, 63)]), ivs, &(ri[WS(is, 1)]));
			 T1y = LD(&(ri[WS(is, 31)]), ivs, &(ri[WS(is, 1)]));
			 T1z = VADD(T1x, T1y);
			 T53 = VSUB(T1x, T1y);
			 {
			      V T5J, T5K, T1A, T1B;
			      T5J = LD(&(ii[WS(is, 63)]), ivs, &(ii[WS(is, 1)]));
			      T5K = LD(&(ii[WS(is, 31)]), ivs, &(ii[WS(is, 1)]));
			      T5L = VSUB(T5J, T5K);
			      Tbo = VADD(T5J, T5K);
			      T1A = LD(&(ri[WS(is, 15)]), ivs, &(ri[WS(is, 1)]));
			      T1B = LD(&(ri[WS(is, 47)]), ivs, &(ri[WS(is, 1)]));
			      T1C = VADD(T1A, T1B);
			      T5I = VSUB(T1A, T1B);
			 }
			 T54 = LD(&(ii[WS(is, 15)]), ivs, &(ii[WS(is, 1)]));
			 T55 = LD(&(ii[WS(is, 47)]), ivs, &(ii[WS(is, 1)]));
			 T56 = VSUB(T54, T55);
			 Tbp = VADD(T54, T55);
			 {
			      V T1H, T1I, T5d, T5e, T5f, T5g;
			      T1H = LD(&(ri[WS(is, 55)]), ivs, &(ri[WS(is, 1)]));
			      T1I = LD(&(ri[WS(is, 23)]), ivs, &(ri[WS(is, 1)]));
			      T5d = VSUB(T1H, T1I);
			      T5e = LD(&(ii[WS(is, 55)]), ivs, &(ii[WS(is, 1)]));
			      T5f = LD(&(ii[WS(is, 23)]), ivs, &(ii[WS(is, 1)]));
			      T5g = VSUB(T5e, T5f);
			      T1J = VADD(T1H, T1I);
			      Tb9 = VADD(T5e, T5f);
			      T5h = VADD(T5d, T5g);
			      T5N = VSUB(T5d, T5g);
			 }
			 {
			      V T1E, T1F, T5b, T58, T59, T5a;
			      T1E = LD(&(ri[WS(is, 7)]), ivs, &(ri[WS(is, 1)]));
			      T1F = LD(&(ri[WS(is, 39)]), ivs, &(ri[WS(is, 1)]));
			      T5b = VSUB(T1E, T1F);
			      T58 = LD(&(ii[WS(is, 7)]), ivs, &(ii[WS(is, 1)]));
			      T59 = LD(&(ii[WS(is, 39)]), ivs, &(ii[WS(is, 1)]));
			      T5a = VSUB(T58, T59);
			      T1G = VADD(T1E, T1F);
			      Tb8 = VADD(T58, T59);
			      T5c = VSUB(T5a, T5b);
			      T5O = VADD(T5b, T5a);
			 }
		    }
		    {
			 V T1D, T1K, Tbq, Tbr;
			 T1D = VADD(T1z, T1C);
			 T1K = VADD(T1G, T1J);
			 T1L = VADD(T1D, T1K);
			 Tdv = VSUB(T1D, T1K);
			 Tbq = VSUB(Tbo, Tbp);
			 Tbr = VSUB(T1J, T1G);
			 Tbs = VSUB(Tbq, Tbr);
			 Tcw = VADD(Tbr, Tbq);
		    }
		    {
			 V TdA, TdB, T57, T5i;
			 TdA = VADD(Tbo, Tbp);
			 TdB = VADD(Tb8, Tb9);
			 TdC = VSUB(TdA, TdB);
			 Teo = VADD(TdA, TdB);
			 T57 = VSUB(T53, T56);
			 T5i = VMUL(LDK(KP707106781), VSUB(T5c, T5h));
			 T5j = VSUB(T57, T5i);
			 T6V = VADD(T57, T5i);
		    }
		    {
			 V T5M, T5P, T8w, T8x;
			 T5M = VADD(T5I, T5L);
			 T5P = VMUL(LDK(KP707106781), VSUB(T5N, T5O));
			 T5Q = VSUB(T5M, T5P);
			 T6Y = VADD(T5M, T5P);
			 T8w = VSUB(T5L, T5I);
			 T8x = VMUL(LDK(KP707106781), VADD(T5c, T5h));
			 T8y = VSUB(T8w, T8x);
			 T9C = VADD(T8w, T8x);
		    }
		    {
			 V Tb7, Tba, T8l, T8m;
			 Tb7 = VSUB(T1z, T1C);
			 Tba = VSUB(Tb8, Tb9);
			 Tbb = VSUB(Tb7, Tba);
			 Tct = VADD(Tb7, Tba);
			 T8l = VADD(T53, T56);
			 T8m = VMUL(LDK(KP707106781), VADD(T5O, T5N));
			 T8n = VSUB(T8l, T8m);
			 T9z = VADD(T8l, T8m);
		    }
	       }
	       {
		    V TN, T40, T2Q, T3Q, TQ, T3P, T2T, T41, TX, T44, T30, T3U, TU, T43, T2X;
		    V T3X;
		    {
			 V TL, TM, T2R, T2S;
			 TL = LD(&(ri[WS(is, 62)]), ivs, &(ri[0]));
			 TM = LD(&(ri[WS(is, 30)]), ivs, &(ri[0]));
			 TN = VADD(TL, TM);
			 T40 = VSUB(TL, TM);
			 {
			      V T2O, T2P, TO, TP;
			      T2O = LD(&(ii[WS(is, 62)]), ivs, &(ii[0]));
			      T2P = LD(&(ii[WS(is, 30)]), ivs, &(ii[0]));
			      T2Q = VADD(T2O, T2P);
			      T3Q = VSUB(T2O, T2P);
			      TO = LD(&(ri[WS(is, 14)]), ivs, &(ri[0]));
			      TP = LD(&(ri[WS(is, 46)]), ivs, &(ri[0]));
			      TQ = VADD(TO, TP);
			      T3P = VSUB(TO, TP);
			 }
			 T2R = LD(&(ii[WS(is, 14)]), ivs, &(ii[0]));
			 T2S = LD(&(ii[WS(is, 46)]), ivs, &(ii[0]));
			 T2T = VADD(T2R, T2S);
			 T41 = VSUB(T2R, T2S);
			 {
			      V TV, TW, T3S, T2Y, T2Z, T3T;
			      TV = LD(&(ri[WS(is, 54)]), ivs, &(ri[0]));
			      TW = LD(&(ri[WS(is, 22)]), ivs, &(ri[0]));
			      T3S = VSUB(TV, TW);
			      T2Y = LD(&(ii[WS(is, 54)]), ivs, &(ii[0]));
			      T2Z = LD(&(ii[WS(is, 22)]), ivs, &(ii[0]));
			      T3T = VSUB(T2Y, T2Z);
			      TX = VADD(TV, TW);
			      T44 = VADD(T3S, T3T);
			      T30 = VADD(T2Y, T2Z);
			      T3U = VSUB(T3S, T3T);
			 }
			 {
			      V TS, TT, T3V, T2V, T2W, T3W;
			      TS = LD(&(ri[WS(is, 6)]), ivs, &(ri[0]));
			      TT = LD(&(ri[WS(is, 38)]), ivs, &(ri[0]));
			      T3V = VSUB(TS, TT);
			      T2V = LD(&(ii[WS(is, 6)]), ivs, &(ii[0]));
			      T2W = LD(&(ii[WS(is, 38)]), ivs, &(ii[0]));
			      T3W = VSUB(T2V, T2W);
			      TU = VADD(TS, TT);
			      T43 = VSUB(T3W, T3V);
			      T2X = VADD(T2V, T2W);
			      T3X = VADD(T3V, T3W);
			 }
		    }
		    {
			 V TR, TY, Tax, Tay;
			 TR = VADD(TN, TQ);
			 TY = VADD(TU, TX);
			 TZ = VADD(TR, TY);
			 Tdf = VSUB(TR, TY);
			 Tax = VSUB(T2Q, T2T);
			 Tay = VSUB(TX, TU);
			 Taz = VSUB(Tax, Tay);
			 Tch = VADD(Tay, Tax);
		    }
		    {
			 V TaA, TaB, T2U, T31;
			 TaA = VSUB(TN, TQ);
			 TaB = VSUB(T2X, T30);
			 TaC = VSUB(TaA, TaB);
			 Tci = VADD(TaA, TaB);
			 T2U = VADD(T2Q, T2T);
			 T31 = VADD(T2X, T30);
			 T32 = VADD(T2U, T31);
			 Tdg = VSUB(T2U, T31);
		    }
		    {
			 V T3R, T3Y, T7T, T7U;
			 T3R = VADD(T3P, T3Q);
			 T3Y = VMUL(LDK(KP707106781), VSUB(T3U, T3X));
			 T3Z = VSUB(T3R, T3Y);
			 T6J = VADD(T3R, T3Y);
			 T7T = VADD(T40, T41);
			 T7U = VMUL(LDK(KP707106781), VADD(T3X, T3U));
			 T7V = VSUB(T7T, T7U);
			 T9n = VADD(T7T, T7U);
		    }
		    {
			 V T7W, T7X, T42, T45;
			 T7W = VSUB(T3Q, T3P);
			 T7X = VMUL(LDK(KP707106781), VADD(T43, T44));
			 T7Y = VSUB(T7W, T7X);
			 T9o = VADD(T7W, T7X);
			 T42 = VSUB(T40, T41);
			 T45 = VMUL(LDK(KP707106781), VSUB(T43, T44));
			 T46 = VSUB(T42, T45);
			 T6K = VADD(T42, T45);
		    }
	       }
	       {
		    V T14, T4P, T4d, TaG, T17, T4a, T4S, TaH, T1e, TaZ, T4j, T4V, T1b, TaY, T4o;
		    V T4U;
		    {
			 V T12, T13, T4Q, T4R;
			 T12 = LD(&(ri[WS(is, 1)]), ivs, &(ri[WS(is, 1)]));
			 T13 = LD(&(ri[WS(is, 33)]), ivs, &(ri[WS(is, 1)]));
			 T14 = VADD(T12, T13);
			 T4P = VSUB(T12, T13);
			 {
			      V T4b, T4c, T15, T16;
			      T4b = LD(&(ii[WS(is, 1)]), ivs, &(ii[WS(is, 1)]));
			      T4c = LD(&(ii[WS(is, 33)]), ivs, &(ii[WS(is, 1)]));
			      T4d = VSUB(T4b, T4c);
			      TaG = VADD(T4b, T4c);
			      T15 = LD(&(ri[WS(is, 17)]), ivs, &(ri[WS(is, 1)]));
			      T16 = LD(&(ri[WS(is, 49)]), ivs, &(ri[WS(is, 1)]));
			      T17 = VADD(T15, T16);
			      T4a = VSUB(T15, T16);
			 }
			 T4Q = LD(&(ii[WS(is, 17)]), ivs, &(ii[WS(is, 1)]));
			 T4R = LD(&(ii[WS(is, 49)]), ivs, &(ii[WS(is, 1)]));
			 T4S = VSUB(T4Q, T4R);
			 TaH = VADD(T4Q, T4R);
			 {
			      V T1c, T1d, T4f, T4g, T4h, T4i;
			      T1c = LD(&(ri[WS(is, 57)]), ivs, &(ri[WS(is, 1)]));
			      T1d = LD(&(ri[WS(is, 25)]), ivs, &(ri[WS(is, 1)]));
			      T4f = VSUB(T1c, T1d);
			      T4g = LD(&(ii[WS(is, 57)]), ivs, &(ii[WS(is, 1)]));
			      T4h = LD(&(ii[WS(is, 25)]), ivs, &(ii[WS(is, 1)]));
			      T4i = VSUB(T4g, T4h);
			      T1e = VADD(T1c, T1d);
			      TaZ = VADD(T4g, T4h);
			      T4j = VSUB(T4f, T4i);
			      T4V = VADD(T4f, T4i);
			 }
			 {
			      V T19, T1a, T4k, T4l, T4m, T4n;
			      T19 = LD(&(ri[WS(is, 9)]), ivs, &(ri[WS(is, 1)]));
			      T1a = LD(&(ri[WS(is, 41)]), ivs, &(ri[WS(is, 1)]));
			      T4k = VSUB(T19, T1a);
			      T4l = LD(&(ii[WS(is, 9)]), ivs, &(ii[WS(is, 1)]));
			      T4m = LD(&(ii[WS(is, 41)]), ivs, &(ii[WS(is, 1)]));
			      T4n = VSUB(T4l, T4m);
			      T1b = VADD(T19, T1a);
			      TaY = VADD(T4l, T4m);
			      T4o = VADD(T4k, T4n);
			      T4U = VSUB(T4n, T4k);
			 }
		    }
		    {
			 V T18, T1f, TaX, Tb0;
			 T18 = VADD(T14, T17);
			 T1f = VADD(T1b, T1e);
			 T1g = VADD(T18, T1f);
			 Tdp = VSUB(T18, T1f);
			 TaX = VSUB(T14, T17);
			 Tb0 = VSUB(TaY, TaZ);
			 Tb1 = VSUB(TaX, Tb0);
			 Tcm = VADD(TaX, Tb0);
		    }
		    {
			 V Tdk, Tdl, T4e, T4p;
			 Tdk = VADD(TaG, TaH);
			 Tdl = VADD(TaY, TaZ);
			 Tdm = VSUB(Tdk, Tdl);
			 Tej = VADD(Tdk, Tdl);
			 T4e = VADD(T4a, T4d);
			 T4p = VMUL(LDK(KP707106781), VSUB(T4j, T4o));
			 T4q = VSUB(T4e, T4p);
			 T6R = VADD(T4e, T4p);
		    }
		    {
			 V T4T, T4W, T8d, T8e;
			 T4T = VSUB(T4P, T4S);
			 T4W = VMUL(LDK(KP707106781), VSUB(T4U, T4V));
			 T4X = VSUB(T4T, T4W);
			 T6O = VADD(T4T, T4W);
			 T8d = VADD(T4P, T4S);
			 T8e = VMUL(LDK(KP707106781), VADD(T4o, T4j));
			 T8f = VSUB(T8d, T8e);
			 T9s = VADD(T8d, T8e);
		    }
		    {
			 V TaI, TaJ, T82, T83;
			 TaI = VSUB(TaG, TaH);
			 TaJ = VSUB(T1e, T1b);
			 TaK = VSUB(TaI, TaJ);
			 Tcp = VADD(TaJ, TaI);
			 T82 = VSUB(T4d, T4a);
			 T83 = VMUL(LDK(KP707106781), VADD(T4U, T4V));
			 T84 = VSUB(T82, T83);
			 T9v = VADD(T82, T83);
		    }
	       }
	       {
		    V T1j, TaR, T1m, TaS, T4G, T4L, TaT, TaQ, T89, T88, T1q, TaM, T1t, TaN, T4v;
		    V T4A, TaO, TaL, T86, T85;
		    {
			 V T4H, T4F, T4C, T4K;
			 {
			      V T1h, T1i, T4D, T4E;
			      T1h = LD(&(ri[WS(is, 5)]), ivs, &(ri[WS(is, 1)]));
			      T1i = LD(&(ri[WS(is, 37)]), ivs, &(ri[WS(is, 1)]));
			      T1j = VADD(T1h, T1i);
			      T4H = VSUB(T1h, T1i);
			      T4D = LD(&(ii[WS(is, 5)]), ivs, &(ii[WS(is, 1)]));
			      T4E = LD(&(ii[WS(is, 37)]), ivs, &(ii[WS(is, 1)]));
			      T4F = VSUB(T4D, T4E);
			      TaR = VADD(T4D, T4E);
			 }
			 {
			      V T1k, T1l, T4I, T4J;
			      T1k = LD(&(ri[WS(is, 21)]), ivs, &(ri[WS(is, 1)]));
			      T1l = LD(&(ri[WS(is, 53)]), ivs, &(ri[WS(is, 1)]));
			      T1m = VADD(T1k, T1l);
			      T4C = VSUB(T1k, T1l);
			      T4I = LD(&(ii[WS(is, 21)]), ivs, &(ii[WS(is, 1)]));
			      T4J = LD(&(ii[WS(is, 53)]), ivs, &(ii[WS(is, 1)]));
			      T4K = VSUB(T4I, T4J);
			      TaS = VADD(T4I, T4J);
			 }
			 T4G = VADD(T4C, T4F);
			 T4L = VSUB(T4H, T4K);
			 TaT = VSUB(TaR, TaS);
			 TaQ = VSUB(T1j, T1m);
			 T89 = VADD(T4H, T4K);
			 T88 = VSUB(T4F, T4C);
		    }
		    {
			 V T4r, T4z, T4w, T4u;
			 {
			      V T1o, T1p, T4x, T4y;
			      T1o = LD(&(ri[WS(is, 61)]), ivs, &(ri[WS(is, 1)]));
			      T1p = LD(&(ri[WS(is, 29)]), ivs, &(ri[WS(is, 1)]));
			      T1q = VADD(T1o, T1p);
			      T4r = VSUB(T1o, T1p);
			      T4x = LD(&(ii[WS(is, 61)]), ivs, &(ii[WS(is, 1)]));
			      T4y = LD(&(ii[WS(is, 29)]), ivs, &(ii[WS(is, 1)]));
			      T4z = VSUB(T4x, T4y);
			      TaM = VADD(T4x, T4y);
			 }
			 {
			      V T1r, T1s, T4s, T4t;
			      T1r = LD(&(ri[WS(is, 13)]), ivs, &(ri[WS(is, 1)]));
			      T1s = LD(&(ri[WS(is, 45)]), ivs, &(ri[WS(is, 1)]));
			      T1t = VADD(T1r, T1s);
			      T4w = VSUB(T1r, T1s);
			      T4s = LD(&(ii[WS(is, 13)]), ivs, &(ii[WS(is, 1)]));
			      T4t = LD(&(ii[WS(is, 45)]), ivs, &(ii[WS(is, 1)]));
			      T4u = VSUB(T4s, T4t);
			      TaN = VADD(T4s, T4t);
			 }
			 T4v = VSUB(T4r, T4u);
			 T4A = VADD(T4w, T4z);
			 TaO = VSUB(TaM, TaN);
			 TaL = VSUB(T1q, T1t);
			 T86 = VSUB(T4z, T4w);
			 T85 = VADD(T4r, T4u);
		    }
		    {
			 V T1n, T1u, Tb2, Tb3;
			 T1n = VADD(T1j, T1m);
			 T1u = VADD(T1q, T1t);
			 T1v = VADD(T1n, T1u);
			 Tdn = VSUB(T1u, T1n);
			 Tb2 = VSUB(TaT, TaQ);
			 Tb3 = VADD(TaL, TaO);
			 Tb4 = VMUL(LDK(KP707106781), VSUB(Tb2, Tb3));
			 Tcq = VMUL(LDK(KP707106781), VADD(Tb2, Tb3));
		    }
		    {
			 V Tdq, Tdr, T4B, T4M;
			 Tdq = VADD(TaR, TaS);
			 Tdr = VADD(TaM, TaN);
			 Tds = VSUB(Tdq, Tdr);
			 Tek = VADD(Tdq, Tdr);
			 T4B = VFNMS(LDK(KP923879532), T4A, VMUL(LDK(KP382683432), T4v));
			 T4M = VFMA(LDK(KP923879532), T4G, VMUL(LDK(KP382683432), T4L));
			 T4N = VSUB(T4B, T4M);
			 T6P = VADD(T4M, T4B);
		    }
		    {
			 V T4Y, T4Z, T8g, T8h;
			 T4Y = VFNMS(LDK(KP923879532), T4L, VMUL(LDK(KP382683432), T4G));
			 T4Z = VFMA(LDK(KP382683432), T4A, VMUL(LDK(KP923879532), T4v));
			 T50 = VSUB(T4Y, T4Z);
			 T6S = VADD(T4Y, T4Z);
			 T8g = VFNMS(LDK(KP382683432), T89, VMUL(LDK(KP923879532), T88));
			 T8h = VFMA(LDK(KP923879532), T86, VMUL(LDK(KP382683432), T85));
			 T8i = VSUB(T8g, T8h);
			 T9w = VADD(T8g, T8h);
		    }
		    {
			 V TaP, TaU, T87, T8a;
			 TaP = VSUB(TaL, TaO);
			 TaU = VADD(TaQ, TaT);
			 TaV = VMUL(LDK(KP707106781), VSUB(TaP, TaU));
			 Tcn = VMUL(LDK(KP707106781), VADD(TaU, TaP));
			 T87 = VFNMS(LDK(KP382683432), T86, VMUL(LDK(KP923879532), T85));
			 T8a = VFMA(LDK(KP382683432), T88, VMUL(LDK(KP923879532), T89));
			 T8b = VSUB(T87, T8a);
			 T9t = VADD(T8a, T87);
		    }
	       }
	       {
		    V T1O, Tbc, T1R, Tbd, T5o, T5t, Tbf, Tbe, T8p, T8o, T1V, Tbi, T1Y, Tbj, T5z;
		    V T5E, Tbk, Tbh, T8s, T8r;
		    {
			 V T5p, T5n, T5k, T5s;
			 {
			      V T1M, T1N, T5l, T5m;
			      T1M = LD(&(ri[WS(is, 3)]), ivs, &(ri[WS(is, 1)]));
			      T1N = LD(&(ri[WS(is, 35)]), ivs, &(ri[WS(is, 1)]));
			      T1O = VADD(T1M, T1N);
			      T5p = VSUB(T1M, T1N);
			      T5l = LD(&(ii[WS(is, 3)]), ivs, &(ii[WS(is, 1)]));
			      T5m = LD(&(ii[WS(is, 35)]), ivs, &(ii[WS(is, 1)]));
			      T5n = VSUB(T5l, T5m);
			      Tbc = VADD(T5l, T5m);
			 }
			 {
			      V T1P, T1Q, T5q, T5r;
			      T1P = LD(&(ri[WS(is, 19)]), ivs, &(ri[WS(is, 1)]));
			      T1Q = LD(&(ri[WS(is, 51)]), ivs, &(ri[WS(is, 1)]));
			      T1R = VADD(T1P, T1Q);
			      T5k = VSUB(T1P, T1Q);
			      T5q = LD(&(ii[WS(is, 19)]), ivs, &(ii[WS(is, 1)]));
			      T5r = LD(&(ii[WS(is, 51)]), ivs, &(ii[WS(is, 1)]));
			      T5s = VSUB(T5q, T5r);
			      Tbd = VADD(T5q, T5r);
			 }
			 T5o = VADD(T5k, T5n);
			 T5t = VSUB(T5p, T5s);
			 Tbf = VSUB(T1O, T1R);
			 Tbe = VSUB(Tbc, Tbd);
			 T8p = VADD(T5p, T5s);
			 T8o = VSUB(T5n, T5k);
		    }
		    {
			 V T5A, T5y, T5v, T5D;
			 {
			      V T1T, T1U, T5w, T5x;
			      T1T = LD(&(ri[WS(is, 59)]), ivs, &(ri[WS(is, 1)]));
			      T1U = LD(&(ri[WS(is, 27)]), ivs, &(ri[WS(is, 1)]));
			      T1V = VADD(T1T, T1U);
			      T5A = VSUB(T1T, T1U);
			      T5w = LD(&(ii[WS(is, 59)]), ivs, &(ii[WS(is, 1)]));
			      T5x = LD(&(ii[WS(is, 27)]), ivs, &(ii[WS(is, 1)]));
			      T5y = VSUB(T5w, T5x);
			      Tbi = VADD(T5w, T5x);
			 }
			 {
			      V T1W, T1X, T5B, T5C;
			      T1W = LD(&(ri[WS(is, 11)]), ivs, &(ri[WS(is, 1)]));
			      T1X = LD(&(ri[WS(is, 43)]), ivs, &(ri[WS(is, 1)]));
			      T1Y = VADD(T1W, T1X);
			      T5v = VSUB(T1W, T1X);
			      T5B = LD(&(ii[WS(is, 11)]), ivs, &(ii[WS(is, 1)]));
			      T5C = LD(&(ii[WS(is, 43)]), ivs, &(ii[WS(is, 1)]));
			      T5D = VSUB(T5B, T5C);
			      Tbj = VADD(T5B, T5C);
			 }
			 T5z = VADD(T5v, T5y);
			 T5E = VSUB(T5A, T5D);
			 Tbk = VSUB(Tbi, Tbj);
			 Tbh = VSUB(T1V, T1Y);
			 T8s = VADD(T5A, T5D);
			 T8r = VSUB(T5y, T5v);
		    }
		    {
			 V T1S, T1Z, Tbt, Tbu;
			 T1S = VADD(T1O, T1R);
			 T1Z = VADD(T1V, T1Y);
			 T20 = VADD(T1S, T1Z);
			 TdD = VSUB(T1Z, T1S);
			 Tbt = VSUB(Tbh, Tbk);
			 Tbu = VADD(Tbf, Tbe);
			 Tbv = VMUL(LDK(KP707106781), VSUB(Tbt, Tbu));
			 Tcu = VMUL(LDK(KP707106781), VADD(Tbu, Tbt));
		    }
		    {
			 V Tdw, Tdx, T5u, T5F;
			 Tdw = VADD(Tbc, Tbd);
			 Tdx = VADD(Tbi, Tbj);
			 Tdy = VSUB(Tdw, Tdx);
			 Tep = VADD(Tdw, Tdx);
			 T5u = VFNMS(LDK(KP923879532), T5t, VMUL(LDK(KP382683432), T5o));
			 T5F = VFMA(LDK(KP382683432), T5z, VMUL(LDK(KP923879532), T5E));
			 T5G = VSUB(T5u, T5F);
			 T6Z = VADD(T5u, T5F);
		    }
		    {
			 V T5R, T5S, T8z, T8A;
			 T5R = VFNMS(LDK(KP923879532), T5z, VMUL(LDK(KP382683432), T5E));
			 T5S = VFMA(LDK(KP923879532), T5o, VMUL(LDK(KP382683432), T5t));
			 T5T = VSUB(T5R, T5S);
			 T6W = VADD(T5S, T5R);
			 T8z = VFNMS(LDK(KP382683432), T8r, VMUL(LDK(KP923879532), T8s));
			 T8A = VFMA(LDK(KP382683432), T8o, VMUL(LDK(KP923879532), T8p));
			 T8B = VSUB(T8z, T8A);
			 T9A = VADD(T8A, T8z);
		    }
		    {
			 V Tbg, Tbl, T8q, T8t;
			 Tbg = VSUB(Tbe, Tbf);
			 Tbl = VADD(Tbh, Tbk);
			 Tbm = VMUL(LDK(KP707106781), VSUB(Tbg, Tbl));
			 Tcx = VMUL(LDK(KP707106781), VADD(Tbg, Tbl));
			 T8q = VFNMS(LDK(KP382683432), T8p, VMUL(LDK(KP923879532), T8o));
			 T8t = VFMA(LDK(KP923879532), T8r, VMUL(LDK(KP382683432), T8s));
			 T8u = VSUB(T8q, T8t);
			 T9D = VADD(T8q, T8t);
		    }
	       }
	       {
		    V TeJ, TeK, TeL, TeM, TeN, TeO, TeP, TeQ, TeR, TeS, TeT, TeU, TeV, TeW, TeX;
		    V TeY, TeZ, Tf0, Tf1, Tf2, Tf3, Tf4, Tf5, Tf6, Tf7, Tf8, Tf9, Tfa, Tfb, Tfc;
		    V Tfd, Tfe, Tff, Tfg, Tfh, Tfi, Tfj, Tfk, Tfl, Tfm, Tfn, Tfo, Tfp, Tfq, Tfr;
		    V Tfs, Tft, Tfu;
		    {
			 V T11, TeD, TeG, TeI, T22, T23, T34, TeH;
			 {
			      V Tv, T10, TeE, TeF;
			      Tv = VADD(Tf, Tu);
			      T10 = VADD(TK, TZ);
			      T11 = VADD(Tv, T10);
			      TeD = VSUB(Tv, T10);
			      TeE = VADD(Tej, Tek);
			      TeF = VADD(Teo, Tep);
			      TeG = VSUB(TeE, TeF);
			      TeI = VADD(TeE, TeF);
			 }
			 {
			      V T1w, T21, T2y, T33;
			      T1w = VADD(T1g, T1v);
			      T21 = VADD(T1L, T20);
			      T22 = VADD(T1w, T21);
			      T23 = VSUB(T21, T1w);
			      T2y = VADD(T2i, T2x);
			      T33 = VADD(T2N, T32);
			      T34 = VSUB(T2y, T33);
			      TeH = VADD(T2y, T33);
			 }
			 TeJ = VSUB(T11, T22);
			 STM4(&(ro[32]), TeJ, ovs, &(ro[0]));
			 TeK = VSUB(TeH, TeI);
			 STM4(&(io[32]), TeK, ovs, &(io[0]));
			 TeL = VADD(T11, T22);
			 STM4(&(ro[0]), TeL, ovs, &(ro[0]));
			 TeM = VADD(TeH, TeI);
			 STM4(&(io[0]), TeM, ovs, &(io[0]));
			 TeN = VADD(T23, T34);
			 STM4(&(io[16]), TeN, ovs, &(io[0]));
			 TeO = VADD(TeD, TeG);
			 STM4(&(ro[16]), TeO, ovs, &(ro[0]));
			 TeP = VSUB(T34, T23);
			 STM4(&(io[48]), TeP, ovs, &(io[0]));
			 TeQ = VSUB(TeD, TeG);
			 STM4(&(ro[48]), TeQ, ovs, &(ro[0]));
		    }
		    {
			 V Teh, Tex, Tev, TeB, Tem, Tey, Ter, Tez;
			 {
			      V Tef, Teg, Tet, Teu;
			      Tef = VSUB(Tf, Tu);
			      Teg = VSUB(T2N, T32);
			      Teh = VADD(Tef, Teg);
			      Tex = VSUB(Tef, Teg);
			      Tet = VSUB(T2i, T2x);
			      Teu = VSUB(TZ, TK);
			      Tev = VSUB(Tet, Teu);
			      TeB = VADD(Teu, Tet);
			 }
			 {
			      V Tei, Tel, Ten, Teq;
			      Tei = VSUB(T1g, T1v);
			      Tel = VSUB(Tej, Tek);
			      Tem = VADD(Tei, Tel);
			      Tey = VSUB(Tel, Tei);
			      Ten = VSUB(T1L, T20);
			      Teq = VSUB(Teo, Tep);
			      Ter = VSUB(Ten, Teq);
			      Tez = VADD(Ten, Teq);
			 }
			 {
			      V Tes, TeC, Tew, TeA;
			      Tes = VMUL(LDK(KP707106781), VADD(Tem, Ter));
			      TeR = VSUB(Teh, Tes);
			      STM4(&(ro[40]), TeR, ovs, &(ro[0]));
			      TeS = VADD(Teh, Tes);
			      STM4(&(ro[8]), TeS, ovs, &(ro[0]));
			      TeC = VMUL(LDK(KP707106781), VADD(Tey, Tez));
			      TeT = VSUB(TeB, TeC);
			      STM4(&(io[40]), TeT, ovs, &(io[0]));
			      TeU = VADD(TeB, TeC);
			      STM4(&(io[8]), TeU, ovs, &(io[0]));
			      Tew = VMUL(LDK(KP707106781), VSUB(Ter, Tem));
			      TeV = VSUB(Tev, Tew);
			      STM4(&(io[56]), TeV, ovs, &(io[0]));
			      TeW = VADD(Tev, Tew);
			      STM4(&(io[24]), TeW, ovs, &(io[0]));
			      TeA = VMUL(LDK(KP707106781), VSUB(Tey, Tez));
			      TeX = VSUB(Tex, TeA);
			      STM4(&(ro[56]), TeX, ovs, &(ro[0]));
			      TeY = VADD(Tex, TeA);
			      STM4(&(ro[24]), TeY, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tdb, TdV, Te5, TdJ, Tdi, Te6, Te3, Teb, TdM, TdW, Tdu, TdQ, Te0, Tea, TdF;
			 V TdR;
			 {
			      V Tde, Tdh, Tdo, Tdt;
			      Tdb = VSUB(Td9, Tda);
			      TdV = VADD(Td9, Tda);
			      Te5 = VADD(TdI, TdH);
			      TdJ = VSUB(TdH, TdI);
			      Tde = VSUB(Tdc, Tdd);
			      Tdh = VADD(Tdf, Tdg);
			      Tdi = VMUL(LDK(KP707106781), VSUB(Tde, Tdh));
			      Te6 = VMUL(LDK(KP707106781), VADD(Tde, Tdh));
			      {
				   V Te1, Te2, TdK, TdL;
				   Te1 = VADD(Tdv, Tdy);
				   Te2 = VADD(TdD, TdC);
				   Te3 = VFNMS(LDK(KP382683432), Te2, VMUL(LDK(KP923879532), Te1));
				   Teb = VFMA(LDK(KP923879532), Te2, VMUL(LDK(KP382683432), Te1));
				   TdK = VSUB(Tdf, Tdg);
				   TdL = VADD(Tdd, Tdc);
				   TdM = VMUL(LDK(KP707106781), VSUB(TdK, TdL));
				   TdW = VMUL(LDK(KP707106781), VADD(TdL, TdK));
			      }
			      Tdo = VSUB(Tdm, Tdn);
			      Tdt = VSUB(Tdp, Tds);
			      Tdu = VFMA(LDK(KP923879532), Tdo, VMUL(LDK(KP382683432), Tdt));
			      TdQ = VFNMS(LDK(KP923879532), Tdt, VMUL(LDK(KP382683432), Tdo));
			      {
				   V TdY, TdZ, Tdz, TdE;
				   TdY = VADD(Tdn, Tdm);
				   TdZ = VADD(Tdp, Tds);
				   Te0 = VFMA(LDK(KP382683432), TdY, VMUL(LDK(KP923879532), TdZ));
				   Tea = VFNMS(LDK(KP382683432), TdZ, VMUL(LDK(KP923879532), TdY));
				   Tdz = VSUB(Tdv, Tdy);
				   TdE = VSUB(TdC, TdD);
				   TdF = VFNMS(LDK(KP923879532), TdE, VMUL(LDK(KP382683432), Tdz));
				   TdR = VFMA(LDK(KP382683432), TdE, VMUL(LDK(KP923879532), Tdz));
			      }
			 }
			 {
			      V Tdj, TdG, TdT, TdU;
			      Tdj = VADD(Tdb, Tdi);
			      TdG = VADD(Tdu, TdF);
			      TeZ = VSUB(Tdj, TdG);
			      STM4(&(ro[44]), TeZ, ovs, &(ro[0]));
			      Tf0 = VADD(Tdj, TdG);
			      STM4(&(ro[12]), Tf0, ovs, &(ro[0]));
			      TdT = VADD(TdJ, TdM);
			      TdU = VADD(TdQ, TdR);
			      Tf1 = VSUB(TdT, TdU);
			      STM4(&(io[44]), Tf1, ovs, &(io[0]));
			      Tf2 = VADD(TdT, TdU);
			      STM4(&(io[12]), Tf2, ovs, &(io[0]));
			 }
			 {
			      V TdN, TdO, TdP, TdS;
			      TdN = VSUB(TdJ, TdM);
			      TdO = VSUB(TdF, Tdu);
			      Tf3 = VSUB(TdN, TdO);
			      STM4(&(io[60]), Tf3, ovs, &(io[0]));
			      Tf4 = VADD(TdN, TdO);
			      STM4(&(io[28]), Tf4, ovs, &(io[0]));
			      TdP = VSUB(Tdb, Tdi);
			      TdS = VSUB(TdQ, TdR);
			      Tf5 = VSUB(TdP, TdS);
			      STM4(&(ro[60]), Tf5, ovs, &(ro[0]));
			      Tf6 = VADD(TdP, TdS);
			      STM4(&(ro[28]), Tf6, ovs, &(ro[0]));
			 }
			 {
			      V TdX, Te4, Ted, Tee;
			      TdX = VADD(TdV, TdW);
			      Te4 = VADD(Te0, Te3);
			      Tf7 = VSUB(TdX, Te4);
			      STM4(&(ro[36]), Tf7, ovs, &(ro[0]));
			      Tf8 = VADD(TdX, Te4);
			      STM4(&(ro[4]), Tf8, ovs, &(ro[0]));
			      Ted = VADD(Te5, Te6);
			      Tee = VADD(Tea, Teb);
			      Tf9 = VSUB(Ted, Tee);
			      STM4(&(io[36]), Tf9, ovs, &(io[0]));
			      Tfa = VADD(Ted, Tee);
			      STM4(&(io[4]), Tfa, ovs, &(io[0]));
			 }
			 {
			      V Te7, Te8, Te9, Tec;
			      Te7 = VSUB(Te5, Te6);
			      Te8 = VSUB(Te3, Te0);
			      Tfb = VSUB(Te7, Te8);
			      STM4(&(io[52]), Tfb, ovs, &(io[0]));
			      Tfc = VADD(Te7, Te8);
			      STM4(&(io[20]), Tfc, ovs, &(io[0]));
			      Te9 = VSUB(TdV, TdW);
			      Tec = VSUB(Tea, Teb);
			      Tfd = VSUB(Te9, Tec);
			      STM4(&(ro[52]), Tfd, ovs, &(ro[0]));
			      Tfe = VADD(Te9, Tec);
			      STM4(&(ro[20]), Tfe, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tcd, TcP, TcD, TcZ, Tck, Td0, TcX, Td5, Tcs, TcK, TcG, TcQ, TcU, Td4, Tcz;
			 V TcL, Tcc, TcC;
			 Tcc = VMUL(LDK(KP707106781), VADD(TbD, TbC));
			 Tcd = VSUB(Tcb, Tcc);
			 TcP = VADD(Tcb, Tcc);
			 TcC = VMUL(LDK(KP707106781), VADD(Tak, Tan));
			 TcD = VSUB(TcB, TcC);
			 TcZ = VADD(TcB, TcC);
			 {
			      V Tcg, Tcj, TcV, TcW;
			      Tcg = VFNMS(LDK(KP382683432), Tcf, VMUL(LDK(KP923879532), Tce));
			      Tcj = VFMA(LDK(KP923879532), Tch, VMUL(LDK(KP382683432), Tci));
			      Tck = VSUB(Tcg, Tcj);
			      Td0 = VADD(Tcg, Tcj);
			      TcV = VADD(Tct, Tcu);
			      TcW = VADD(Tcw, Tcx);
			      TcX = VFNMS(LDK(KP195090322), TcW, VMUL(LDK(KP980785280), TcV));
			      Td5 = VFMA(LDK(KP195090322), TcV, VMUL(LDK(KP980785280), TcW));
			 }
			 {
			      V Tco, Tcr, TcE, TcF;
			      Tco = VSUB(Tcm, Tcn);
			      Tcr = VSUB(Tcp, Tcq);
			      Tcs = VFMA(LDK(KP555570233), Tco, VMUL(LDK(KP831469612), Tcr));
			      TcK = VFNMS(LDK(KP831469612), Tco, VMUL(LDK(KP555570233), Tcr));
			      TcE = VFNMS(LDK(KP382683432), Tch, VMUL(LDK(KP923879532), Tci));
			      TcF = VFMA(LDK(KP382683432), Tce, VMUL(LDK(KP923879532), Tcf));
			      TcG = VSUB(TcE, TcF);
			      TcQ = VADD(TcF, TcE);
			 }
			 {
			      V TcS, TcT, Tcv, Tcy;
			      TcS = VADD(Tcm, Tcn);
			      TcT = VADD(Tcp, Tcq);
			      TcU = VFMA(LDK(KP980785280), TcS, VMUL(LDK(KP195090322), TcT));
			      Td4 = VFNMS(LDK(KP195090322), TcS, VMUL(LDK(KP980785280), TcT));
			      Tcv = VSUB(Tct, Tcu);
			      Tcy = VSUB(Tcw, Tcx);
			      Tcz = VFNMS(LDK(KP831469612), Tcy, VMUL(LDK(KP555570233), Tcv));
			      TcL = VFMA(LDK(KP831469612), Tcv, VMUL(LDK(KP555570233), Tcy));
			 }
			 {
			      V Tcl, TcA, TcN, TcO;
			      Tcl = VADD(Tcd, Tck);
			      TcA = VADD(Tcs, Tcz);
			      Tff = VSUB(Tcl, TcA);
			      STM4(&(ro[42]), Tff, ovs, &(ro[0]));
			      Tfg = VADD(Tcl, TcA);
			      STM4(&(ro[10]), Tfg, ovs, &(ro[0]));
			      TcN = VADD(TcD, TcG);
			      TcO = VADD(TcK, TcL);
			      Tfh = VSUB(TcN, TcO);
			      STM4(&(io[42]), Tfh, ovs, &(io[0]));
			      Tfi = VADD(TcN, TcO);
			      STM4(&(io[10]), Tfi, ovs, &(io[0]));
			 }
			 {
			      V TcH, TcI, TcJ, TcM;
			      TcH = VSUB(TcD, TcG);
			      TcI = VSUB(Tcz, Tcs);
			      Tfj = VSUB(TcH, TcI);
			      STM4(&(io[58]), Tfj, ovs, &(io[0]));
			      Tfk = VADD(TcH, TcI);
			      STM4(&(io[26]), Tfk, ovs, &(io[0]));
			      TcJ = VSUB(Tcd, Tck);
			      TcM = VSUB(TcK, TcL);
			      Tfl = VSUB(TcJ, TcM);
			      STM4(&(ro[58]), Tfl, ovs, &(ro[0]));
			      Tfm = VADD(TcJ, TcM);
			      STM4(&(ro[26]), Tfm, ovs, &(ro[0]));
			 }
			 {
			      V TcR, TcY, Td7, Td8;
			      TcR = VADD(TcP, TcQ);
			      TcY = VADD(TcU, TcX);
			      Tfn = VSUB(TcR, TcY);
			      STM4(&(ro[34]), Tfn, ovs, &(ro[0]));
			      Tfo = VADD(TcR, TcY);
			      STM4(&(ro[2]), Tfo, ovs, &(ro[0]));
			      Td7 = VADD(TcZ, Td0);
			      Td8 = VADD(Td4, Td5);
			      Tfp = VSUB(Td7, Td8);
			      STM4(&(io[34]), Tfp, ovs, &(io[0]));
			      Tfq = VADD(Td7, Td8);
			      STM4(&(io[2]), Tfq, ovs, &(io[0]));
			 }
			 {
			      V Td1, Td2, Td3, Td6;
			      Td1 = VSUB(TcZ, Td0);
			      Td2 = VSUB(TcX, TcU);
			      Tfr = VSUB(Td1, Td2);
			      STM4(&(io[50]), Tfr, ovs, &(io[0]));
			      Tfs = VADD(Td1, Td2);
			      STM4(&(io[18]), Tfs, ovs, &(io[0]));
			      Td3 = VSUB(TcP, TcQ);
			      Td6 = VSUB(Td4, Td5);
			      Tft = VSUB(Td3, Td6);
			      STM4(&(ro[50]), Tft, ovs, &(ro[0]));
			      Tfu = VADD(Td3, Td6);
			      STM4(&(ro[18]), Tfu, ovs, &(ro[0]));
			 }
		    }
		    {
			 V Tfv, Tfw, Tfx, Tfy, Tfz, TfA, TfB, TfC, TfD, TfE, TfF, TfG, TfH, TfI, TfJ;
			 V TfK, TfL, TfM, TfN, TfO, TfP, TfQ, TfR, TfS, TfT, TfU, TfV, TfW, TfX, TfY;
			 V TfZ, Tg0;
			 {
			      V Tap, TbR, TbF, Tc1, TaE, Tc2, TbZ, Tc7, Tb6, TbM, TbI, TbS, TbW, Tc6, Tbx;
			      V TbN, Tao, TbE;
			      Tao = VMUL(LDK(KP707106781), VSUB(Tak, Tan));
			      Tap = VSUB(Tah, Tao);
			      TbR = VADD(Tah, Tao);
			      TbE = VMUL(LDK(KP707106781), VSUB(TbC, TbD));
			      TbF = VSUB(TbB, TbE);
			      Tc1 = VADD(TbB, TbE);
			      {
				   V Taw, TaD, TbX, TbY;
				   Taw = VFNMS(LDK(KP923879532), Tav, VMUL(LDK(KP382683432), Tas));
				   TaD = VFMA(LDK(KP382683432), Taz, VMUL(LDK(KP923879532), TaC));
				   TaE = VSUB(Taw, TaD);
				   Tc2 = VADD(Taw, TaD);
				   TbX = VADD(Tbb, Tbm);
				   TbY = VADD(Tbs, Tbv);
				   TbZ = VFNMS(LDK(KP555570233), TbY, VMUL(LDK(KP831469612), TbX));
				   Tc7 = VFMA(LDK(KP831469612), TbY, VMUL(LDK(KP555570233), TbX));
			      }
			      {
				   V TaW, Tb5, TbG, TbH;
				   TaW = VSUB(TaK, TaV);
				   Tb5 = VSUB(Tb1, Tb4);
				   Tb6 = VFMA(LDK(KP980785280), TaW, VMUL(LDK(KP195090322), Tb5));
				   TbM = VFNMS(LDK(KP980785280), Tb5, VMUL(LDK(KP195090322), TaW));
				   TbG = VFNMS(LDK(KP923879532), Taz, VMUL(LDK(KP382683432), TaC));
				   TbH = VFMA(LDK(KP923879532), Tas, VMUL(LDK(KP382683432), Tav));
				   TbI = VSUB(TbG, TbH);
				   TbS = VADD(TbH, TbG);
			      }
			      {
				   V TbU, TbV, Tbn, Tbw;
				   TbU = VADD(TaK, TaV);
				   TbV = VADD(Tb1, Tb4);
				   TbW = VFMA(LDK(KP555570233), TbU, VMUL(LDK(KP831469612), TbV));
				   Tc6 = VFNMS(LDK(KP555570233), TbV, VMUL(LDK(KP831469612), TbU));
				   Tbn = VSUB(Tbb, Tbm);
				   Tbw = VSUB(Tbs, Tbv);
				   Tbx = VFNMS(LDK(KP980785280), Tbw, VMUL(LDK(KP195090322), Tbn));
				   TbN = VFMA(LDK(KP195090322), Tbw, VMUL(LDK(KP980785280), Tbn));
			      }
			      {
				   V TaF, Tby, TbP, TbQ;
				   TaF = VADD(Tap, TaE);
				   Tby = VADD(Tb6, Tbx);
				   Tfv = VSUB(TaF, Tby);
				   STM4(&(ro[46]), Tfv, ovs, &(ro[0]));
				   Tfw = VADD(TaF, Tby);
				   STM4(&(ro[14]), Tfw, ovs, &(ro[0]));
				   TbP = VADD(TbF, TbI);
				   TbQ = VADD(TbM, TbN);
				   Tfx = VSUB(TbP, TbQ);
				   STM4(&(io[46]), Tfx, ovs, &(io[0]));
				   Tfy = VADD(TbP, TbQ);
				   STM4(&(io[14]), Tfy, ovs, &(io[0]));
			      }
			      {
				   V TbJ, TbK, TbL, TbO;
				   TbJ = VSUB(TbF, TbI);
				   TbK = VSUB(Tbx, Tb6);
				   Tfz = VSUB(TbJ, TbK);
				   STM4(&(io[62]), Tfz, ovs, &(io[0]));
				   TfA = VADD(TbJ, TbK);
				   STM4(&(io[30]), TfA, ovs, &(io[0]));
				   TbL = VSUB(Tap, TaE);
				   TbO = VSUB(TbM, TbN);
				   TfB = VSUB(TbL, TbO);
				   STM4(&(ro[62]), TfB, ovs, &(ro[0]));
				   TfC = VADD(TbL, TbO);
				   STM4(&(ro[30]), TfC, ovs, &(ro[0]));
			      }
			      {
				   V TbT, Tc0, Tc9, Tca;
				   TbT = VADD(TbR, TbS);
				   Tc0 = VADD(TbW, TbZ);
				   TfD = VSUB(TbT, Tc0);
				   STM4(&(ro[38]), TfD, ovs, &(ro[0]));
				   TfE = VADD(TbT, Tc0);
				   STM4(&(ro[6]), TfE, ovs, &(ro[0]));
				   Tc9 = VADD(Tc1, Tc2);
				   Tca = VADD(Tc6, Tc7);
				   TfF = VSUB(Tc9, Tca);
				   STM4(&(io[38]), TfF, ovs, &(io[0]));
				   TfG = VADD(Tc9, Tca);
				   STM4(&(io[6]), TfG, ovs, &(io[0]));
			      }
			      {
				   V Tc3, Tc4, Tc5, Tc8;
				   Tc3 = VSUB(Tc1, Tc2);
				   Tc4 = VSUB(TbZ, TbW);
				   TfH = VSUB(Tc3, Tc4);
				   STM4(&(io[54]), TfH, ovs, &(io[0]));
				   TfI = VADD(Tc3, Tc4);
				   STM4(&(io[22]), TfI, ovs, &(io[0]));
				   Tc5 = VSUB(TbR, TbS);
				   Tc8 = VSUB(Tc6, Tc7);
				   TfJ = VSUB(Tc5, Tc8);
				   STM4(&(ro[54]), TfJ, ovs, &(ro[0]));
				   TfK = VADD(Tc5, Tc8);
				   STM4(&(ro[22]), TfK, ovs, &(ro[0]));
			      }
			 }
			 {
			      V T6F, T7h, T7m, T7w, T7p, T7x, T6M, T7s, T6U, T7c, T75, T7r, T78, T7i, T71;
			      V T7d;
			      {
				   V T6D, T6E, T7k, T7l;
				   T6D = VADD(T37, T3e);
				   T6E = VADD(T65, T64);
				   T6F = VSUB(T6D, T6E);
				   T7h = VADD(T6D, T6E);
				   T7k = VADD(T6O, T6P);
				   T7l = VADD(T6R, T6S);
				   T7m = VFMA(LDK(KP956940335), T7k, VMUL(LDK(KP290284677), T7l));
				   T7w = VFNMS(LDK(KP290284677), T7k, VMUL(LDK(KP956940335), T7l));
			      }
			      {
				   V T7n, T7o, T6I, T6L;
				   T7n = VADD(T6V, T6W);
				   T7o = VADD(T6Y, T6Z);
				   T7p = VFNMS(LDK(KP290284677), T7o, VMUL(LDK(KP956940335), T7n));
				   T7x = VFMA(LDK(KP290284677), T7n, VMUL(LDK(KP956940335), T7o));
				   T6I = VFNMS(LDK(KP555570233), T6H, VMUL(LDK(KP831469612), T6G));
				   T6L = VFMA(LDK(KP831469612), T6J, VMUL(LDK(KP555570233), T6K));
				   T6M = VSUB(T6I, T6L);
				   T7s = VADD(T6I, T6L);
			      }
			      {
				   V T6Q, T6T, T73, T74;
				   T6Q = VSUB(T6O, T6P);
				   T6T = VSUB(T6R, T6S);
				   T6U = VFMA(LDK(KP471396736), T6Q, VMUL(LDK(KP881921264), T6T));
				   T7c = VFNMS(LDK(KP881921264), T6Q, VMUL(LDK(KP471396736), T6T));
				   T73 = VADD(T5Z, T62);
				   T74 = VADD(T3m, T3t);
				   T75 = VSUB(T73, T74);
				   T7r = VADD(T73, T74);
			      }
			      {
				   V T76, T77, T6X, T70;
				   T76 = VFNMS(LDK(KP555570233), T6J, VMUL(LDK(KP831469612), T6K));
				   T77 = VFMA(LDK(KP555570233), T6G, VMUL(LDK(KP831469612), T6H));
				   T78 = VSUB(T76, T77);
				   T7i = VADD(T77, T76);
				   T6X = VSUB(T6V, T6W);
				   T70 = VSUB(T6Y, T6Z);
				   T71 = VFNMS(LDK(KP881921264), T70, VMUL(LDK(KP471396736), T6X));
				   T7d = VFMA(LDK(KP881921264), T6X, VMUL(LDK(KP471396736), T70));
			      }
			      {
				   V T6N, T72, T7f, T7g;
				   T6N = VADD(T6F, T6M);
				   T72 = VADD(T6U, T71);
				   TfL = VSUB(T6N, T72);
				   STM4(&(ro[43]), TfL, ovs, &(ro[1]));
				   TfM = VADD(T6N, T72);
				   STM4(&(ro[11]), TfM, ovs, &(ro[1]));
				   T7f = VADD(T75, T78);
				   T7g = VADD(T7c, T7d);
				   TfN = VSUB(T7f, T7g);
				   STM4(&(io[43]), TfN, ovs, &(io[1]));
				   TfO = VADD(T7f, T7g);
				   STM4(&(io[11]), TfO, ovs, &(io[1]));
			      }
			      {
				   V T79, T7a, T7b, T7e;
				   T79 = VSUB(T75, T78);
				   T7a = VSUB(T71, T6U);
				   TfP = VSUB(T79, T7a);
				   STM4(&(io[59]), TfP, ovs, &(io[1]));
				   TfQ = VADD(T79, T7a);
				   STM4(&(io[27]), TfQ, ovs, &(io[1]));
				   T7b = VSUB(T6F, T6M);
				   T7e = VSUB(T7c, T7d);
				   TfR = VSUB(T7b, T7e);
				   STM4(&(ro[59]), TfR, ovs, &(ro[1]));
				   TfS = VADD(T7b, T7e);
				   STM4(&(ro[27]), TfS, ovs, &(ro[1]));
			      }
			      {
				   V T7j, T7q, T7z, T7A;
				   T7j = VADD(T7h, T7i);
				   T7q = VADD(T7m, T7p);
				   TfT = VSUB(T7j, T7q);
				   STM4(&(ro[35]), TfT, ovs, &(ro[1]));
				   TfU = VADD(T7j, T7q);
				   STM4(&(ro[3]), TfU, ovs, &(ro[1]));
				   T7z = VADD(T7r, T7s);
				   T7A = VADD(T7w, T7x);
				   TfV = VSUB(T7z, T7A);
				   STM4(&(io[35]), TfV, ovs, &(io[1]));
				   TfW = VADD(T7z, T7A);
				   STM4(&(io[3]), TfW, ovs, &(io[1]));
			      }
			      {
				   V T7t, T7u, T7v, T7y;
				   T7t = VSUB(T7r, T7s);
				   T7u = VSUB(T7p, T7m);
				   TfX = VSUB(T7t, T7u);
				   STM4(&(io[51]), TfX, ovs, &(io[1]));
				   TfY = VADD(T7t, T7u);
				   STM4(&(io[19]), TfY, ovs, &(io[1]));
				   T7v = VSUB(T7h, T7i);
				   T7y = VSUB(T7w, T7x);
				   TfZ = VSUB(T7v, T7y);
				   STM4(&(ro[51]), TfZ, ovs, &(ro[1]));
				   Tg0 = VADD(T7v, T7y);
				   STM4(&(ro[19]), Tg0, ovs, &(ro[1]));
			      }
			 }
			 {
			      V T9j, T9V, Ta0, Taa, Ta3, Tab, T9q, Ta6, T9y, T9Q, T9J, Ta5, T9M, T9W, T9F;
			      V T9R;
			      {
				   V T9h, T9i, T9Y, T9Z;
				   T9h = VADD(T7B, T7C);
				   T9i = VADD(T8J, T8I);
				   T9j = VSUB(T9h, T9i);
				   T9V = VADD(T9h, T9i);
				   T9Y = VADD(T9s, T9t);
				   T9Z = VADD(T9v, T9w);
				   Ta0 = VFMA(LDK(KP995184726), T9Y, VMUL(LDK(KP098017140), T9Z));
				   Taa = VFNMS(LDK(KP098017140), T9Y, VMUL(LDK(KP995184726), T9Z));
			      }
			      {
				   V Ta1, Ta2, T9m, T9p;
				   Ta1 = VADD(T9z, T9A);
				   Ta2 = VADD(T9C, T9D);
				   Ta3 = VFNMS(LDK(KP098017140), Ta2, VMUL(LDK(KP995184726), Ta1));
				   Tab = VFMA(LDK(KP098017140), Ta1, VMUL(LDK(KP995184726), Ta2));
				   T9m = VFNMS(LDK(KP195090322), T9l, VMUL(LDK(KP980785280), T9k));
				   T9p = VFMA(LDK(KP195090322), T9n, VMUL(LDK(KP980785280), T9o));
				   T9q = VSUB(T9m, T9p);
				   Ta6 = VADD(T9m, T9p);
			      }
			      {
				   V T9u, T9x, T9H, T9I;
				   T9u = VSUB(T9s, T9t);
				   T9x = VSUB(T9v, T9w);
				   T9y = VFMA(LDK(KP634393284), T9u, VMUL(LDK(KP773010453), T9x));
				   T9Q = VFNMS(LDK(KP773010453), T9u, VMUL(LDK(KP634393284), T9x));
				   T9H = VADD(T8F, T8G);
				   T9I = VADD(T7G, T7J);
				   T9J = VSUB(T9H, T9I);
				   Ta5 = VADD(T9H, T9I);
			      }
			      {
				   V T9K, T9L, T9B, T9E;
				   T9K = VFNMS(LDK(KP195090322), T9o, VMUL(LDK(KP980785280), T9n));
				   T9L = VFMA(LDK(KP980785280), T9l, VMUL(LDK(KP195090322), T9k));
				   T9M = VSUB(T9K, T9L);
				   T9W = VADD(T9L, T9K);
				   T9B = VSUB(T9z, T9A);
				   T9E = VSUB(T9C, T9D);
				   T9F = VFNMS(LDK(KP773010453), T9E, VMUL(LDK(KP634393284), T9B));
				   T9R = VFMA(LDK(KP773010453), T9B, VMUL(LDK(KP634393284), T9E));
			      }
			      {
				   V T9r, T9G, Tg1, Tg2;
				   T9r = VADD(T9j, T9q);
				   T9G = VADD(T9y, T9F);
				   Tg1 = VSUB(T9r, T9G);
				   STM4(&(ro[41]), Tg1, ovs, &(ro[1]));
				   STN4(&(ro[40]), TeR, Tg1, Tff, TfL, ovs);
				   Tg2 = VADD(T9r, T9G);
				   STM4(&(ro[9]), Tg2, ovs, &(ro[1]));
				   STN4(&(ro[8]), TeS, Tg2, Tfg, TfM, ovs);
			      }
			      {
				   V T9T, T9U, Tg3, Tg4;
				   T9T = VADD(T9J, T9M);
				   T9U = VADD(T9Q, T9R);
				   Tg3 = VSUB(T9T, T9U);
				   STM4(&(io[41]), Tg3, ovs, &(io[1]));
				   STN4(&(io[40]), TeT, Tg3, Tfh, TfN, ovs);
				   Tg4 = VADD(T9T, T9U);
				   STM4(&(io[9]), Tg4, ovs, &(io[1]));
				   STN4(&(io[8]), TeU, Tg4, Tfi, TfO, ovs);
			      }
			      {
				   V T9N, T9O, Tg5, Tg6;
				   T9N = VSUB(T9J, T9M);
				   T9O = VSUB(T9F, T9y);
				   Tg5 = VSUB(T9N, T9O);
				   STM4(&(io[57]), Tg5, ovs, &(io[1]));
				   STN4(&(io[56]), TeV, Tg5, Tfj, TfP, ovs);
				   Tg6 = VADD(T9N, T9O);
				   STM4(&(io[25]), Tg6, ovs, &(io[1]));
				   STN4(&(io[24]), TeW, Tg6, Tfk, TfQ, ovs);
			      }
			      {
				   V T9P, T9S, Tg7, Tg8;
				   T9P = VSUB(T9j, T9q);
				   T9S = VSUB(T9Q, T9R);
				   Tg7 = VSUB(T9P, T9S);
				   STM4(&(ro[57]), Tg7, ovs, &(ro[1]));
				   STN4(&(ro[56]), TeX, Tg7, Tfl, TfR, ovs);
				   Tg8 = VADD(T9P, T9S);
				   STM4(&(ro[25]), Tg8, ovs, &(ro[1]));
				   STN4(&(ro[24]), TeY, Tg8, Tfm, TfS, ovs);
			      }
			      {
				   V T9X, Ta4, Tg9, Tga;
				   T9X = VADD(T9V, T9W);
				   Ta4 = VADD(Ta0, Ta3);
				   Tg9 = VSUB(T9X, Ta4);
				   STM4(&(ro[33]), Tg9, ovs, &(ro[1]));
				   STN4(&(ro[32]), TeJ, Tg9, Tfn, TfT, ovs);
				   Tga = VADD(T9X, Ta4);
				   STM4(&(ro[1]), Tga, ovs, &(ro[1]));
				   STN4(&(ro[0]), TeL, Tga, Tfo, TfU, ovs);
			      }
			      {
				   V Tad, Tae, Tgb, Tgc;
				   Tad = VADD(Ta5, Ta6);
				   Tae = VADD(Taa, Tab);
				   Tgb = VSUB(Tad, Tae);
				   STM4(&(io[33]), Tgb, ovs, &(io[1]));
				   STN4(&(io[32]), TeK, Tgb, Tfp, TfV, ovs);
				   Tgc = VADD(Tad, Tae);
				   STM4(&(io[1]), Tgc, ovs, &(io[1]));
				   STN4(&(io[0]), TeM, Tgc, Tfq, TfW, ovs);
			      }
			      {
				   V Ta7, Ta8, Tgd, Tge;
				   Ta7 = VSUB(Ta5, Ta6);
				   Ta8 = VSUB(Ta3, Ta0);
				   Tgd = VSUB(Ta7, Ta8);
				   STM4(&(io[49]), Tgd, ovs, &(io[1]));
				   STN4(&(io[48]), TeP, Tgd, Tfr, TfX, ovs);
				   Tge = VADD(Ta7, Ta8);
				   STM4(&(io[17]), Tge, ovs, &(io[1]));
				   STN4(&(io[16]), TeN, Tge, Tfs, TfY, ovs);
			      }
			      {
				   V Ta9, Tac, Tgf, Tgg;
				   Ta9 = VSUB(T9V, T9W);
				   Tac = VSUB(Taa, Tab);
				   Tgf = VSUB(Ta9, Tac);
				   STM4(&(ro[49]), Tgf, ovs, &(ro[1]));
				   STN4(&(ro[48]), TeQ, Tgf, Tft, TfZ, ovs);
				   Tgg = VADD(Ta9, Tac);
				   STM4(&(ro[17]), Tgg, ovs, &(ro[1]));
				   STN4(&(ro[16]), TeO, Tgg, Tfu, Tg0, ovs);
			      }
			 }
			 {
			      V Tgh, Tgi, Tgj, Tgk, Tgl, Tgm, Tgn, Tgo, Tgp, Tgq, Tgr, Tgs, Tgt, Tgu, Tgv;
			      V Tgw;
			      {
				   V T3v, T6j, T6o, T6y, T6r, T6z, T48, T6u, T52, T6e, T67, T6t, T6a, T6k, T5V;
				   V T6f;
				   {
					V T3f, T3u, T6m, T6n;
					T3f = VSUB(T37, T3e);
					T3u = VSUB(T3m, T3t);
					T3v = VSUB(T3f, T3u);
					T6j = VADD(T3f, T3u);
					T6m = VADD(T4q, T4N);
					T6n = VADD(T4X, T50);
					T6o = VFMA(LDK(KP634393284), T6m, VMUL(LDK(KP773010453), T6n));
					T6y = VFNMS(LDK(KP634393284), T6n, VMUL(LDK(KP773010453), T6m));
				   }
				   {
					V T6p, T6q, T3O, T47;
					T6p = VADD(T5j, T5G);
					T6q = VADD(T5Q, T5T);
					T6r = VFNMS(LDK(KP634393284), T6q, VMUL(LDK(KP773010453), T6p));
					T6z = VFMA(LDK(KP773010453), T6q, VMUL(LDK(KP634393284), T6p));
					T3O = VFNMS(LDK(KP980785280), T3N, VMUL(LDK(KP195090322), T3G));
					T47 = VFMA(LDK(KP195090322), T3Z, VMUL(LDK(KP980785280), T46));
					T48 = VSUB(T3O, T47);
					T6u = VADD(T3O, T47);
				   }
				   {
					V T4O, T51, T63, T66;
					T4O = VSUB(T4q, T4N);
					T51 = VSUB(T4X, T50);
					T52 = VFMA(LDK(KP995184726), T4O, VMUL(LDK(KP098017140), T51));
					T6e = VFNMS(LDK(KP995184726), T51, VMUL(LDK(KP098017140), T4O));
					T63 = VSUB(T5Z, T62);
					T66 = VSUB(T64, T65);
					T67 = VSUB(T63, T66);
					T6t = VADD(T63, T66);
				   }
				   {
					V T68, T69, T5H, T5U;
					T68 = VFNMS(LDK(KP980785280), T3Z, VMUL(LDK(KP195090322), T46));
					T69 = VFMA(LDK(KP980785280), T3G, VMUL(LDK(KP195090322), T3N));
					T6a = VSUB(T68, T69);
					T6k = VADD(T69, T68);
					T5H = VSUB(T5j, T5G);
					T5U = VSUB(T5Q, T5T);
					T5V = VFNMS(LDK(KP995184726), T5U, VMUL(LDK(KP098017140), T5H));
					T6f = VFMA(LDK(KP098017140), T5U, VMUL(LDK(KP995184726), T5H));
				   }
				   {
					V T49, T5W, T6h, T6i;
					T49 = VADD(T3v, T48);
					T5W = VADD(T52, T5V);
					Tgh = VSUB(T49, T5W);
					STM4(&(ro[47]), Tgh, ovs, &(ro[1]));
					Tgi = VADD(T49, T5W);
					STM4(&(ro[15]), Tgi, ovs, &(ro[1]));
					T6h = VADD(T67, T6a);
					T6i = VADD(T6e, T6f);
					Tgj = VSUB(T6h, T6i);
					STM4(&(io[47]), Tgj, ovs, &(io[1]));
					Tgk = VADD(T6h, T6i);
					STM4(&(io[15]), Tgk, ovs, &(io[1]));
				   }
				   {
					V T6b, T6c, T6d, T6g;
					T6b = VSUB(T67, T6a);
					T6c = VSUB(T5V, T52);
					Tgl = VSUB(T6b, T6c);
					STM4(&(io[63]), Tgl, ovs, &(io[1]));
					Tgm = VADD(T6b, T6c);
					STM4(&(io[31]), Tgm, ovs, &(io[1]));
					T6d = VSUB(T3v, T48);
					T6g = VSUB(T6e, T6f);
					Tgn = VSUB(T6d, T6g);
					STM4(&(ro[63]), Tgn, ovs, &(ro[1]));
					Tgo = VADD(T6d, T6g);
					STM4(&(ro[31]), Tgo, ovs, &(ro[1]));
				   }
				   {
					V T6l, T6s, T6B, T6C;
					T6l = VADD(T6j, T6k);
					T6s = VADD(T6o, T6r);
					Tgp = VSUB(T6l, T6s);
					STM4(&(ro[39]), Tgp, ovs, &(ro[1]));
					Tgq = VADD(T6l, T6s);
					STM4(&(ro[7]), Tgq, ovs, &(ro[1]));
					T6B = VADD(T6t, T6u);
					T6C = VADD(T6y, T6z);
					Tgr = VSUB(T6B, T6C);
					STM4(&(io[39]), Tgr, ovs, &(io[1]));
					Tgs = VADD(T6B, T6C);
					STM4(&(io[7]), Tgs, ovs, &(io[1]));
				   }
				   {
					V T6v, T6w, T6x, T6A;
					T6v = VSUB(T6t, T6u);
					T6w = VSUB(T6r, T6o);
					Tgt = VSUB(T6v, T6w);
					STM4(&(io[55]), Tgt, ovs, &(io[1]));
					Tgu = VADD(T6v, T6w);
					STM4(&(io[23]), Tgu, ovs, &(io[1]));
					T6x = VSUB(T6j, T6k);
					T6A = VSUB(T6y, T6z);
					Tgv = VSUB(T6x, T6A);
					STM4(&(ro[55]), Tgv, ovs, &(ro[1]));
					Tgw = VADD(T6x, T6A);
					STM4(&(ro[23]), Tgw, ovs, &(ro[1]));
				   }
			      }
			      {
				   V T7L, T8X, T92, T9c, T95, T9d, T80, T98, T8k, T8S, T8L, T97, T8O, T8Y, T8D;
				   V T8T;
				   {
					V T7D, T7K, T90, T91;
					T7D = VSUB(T7B, T7C);
					T7K = VSUB(T7G, T7J);
					T7L = VSUB(T7D, T7K);
					T8X = VADD(T7D, T7K);
					T90 = VADD(T84, T8b);
					T91 = VADD(T8f, T8i);
					T92 = VFMA(LDK(KP471396736), T90, VMUL(LDK(KP881921264), T91));
					T9c = VFNMS(LDK(KP471396736), T91, VMUL(LDK(KP881921264), T90));
				   }
				   {
					V T93, T94, T7S, T7Z;
					T93 = VADD(T8n, T8u);
					T94 = VADD(T8y, T8B);
					T95 = VFNMS(LDK(KP471396736), T94, VMUL(LDK(KP881921264), T93));
					T9d = VFMA(LDK(KP881921264), T94, VMUL(LDK(KP471396736), T93));
					T7S = VFNMS(LDK(KP831469612), T7R, VMUL(LDK(KP555570233), T7O));
					T7Z = VFMA(LDK(KP831469612), T7V, VMUL(LDK(KP555570233), T7Y));
					T80 = VSUB(T7S, T7Z);
					T98 = VADD(T7S, T7Z);
				   }
				   {
					V T8c, T8j, T8H, T8K;
					T8c = VSUB(T84, T8b);
					T8j = VSUB(T8f, T8i);
					T8k = VFMA(LDK(KP956940335), T8c, VMUL(LDK(KP290284677), T8j));
					T8S = VFNMS(LDK(KP956940335), T8j, VMUL(LDK(KP290284677), T8c));
					T8H = VSUB(T8F, T8G);
					T8K = VSUB(T8I, T8J);
					T8L = VSUB(T8H, T8K);
					T97 = VADD(T8H, T8K);
				   }
				   {
					V T8M, T8N, T8v, T8C;
					T8M = VFNMS(LDK(KP831469612), T7Y, VMUL(LDK(KP555570233), T7V));
					T8N = VFMA(LDK(KP555570233), T7R, VMUL(LDK(KP831469612), T7O));
					T8O = VSUB(T8M, T8N);
					T8Y = VADD(T8N, T8M);
					T8v = VSUB(T8n, T8u);
					T8C = VSUB(T8y, T8B);
					T8D = VFNMS(LDK(KP956940335), T8C, VMUL(LDK(KP290284677), T8v));
					T8T = VFMA(LDK(KP290284677), T8C, VMUL(LDK(KP956940335), T8v));
				   }
				   {
					V T81, T8E, Tgx, Tgy;
					T81 = VADD(T7L, T80);
					T8E = VADD(T8k, T8D);
					Tgx = VSUB(T81, T8E);
					STM4(&(ro[45]), Tgx, ovs, &(ro[1]));
					STN4(&(ro[44]), TeZ, Tgx, Tfv, Tgh, ovs);
					Tgy = VADD(T81, T8E);
					STM4(&(ro[13]), Tgy, ovs, &(ro[1]));
					STN4(&(ro[12]), Tf0, Tgy, Tfw, Tgi, ovs);
				   }
				   {
					V T8V, T8W, Tgz, TgA;
					T8V = VADD(T8L, T8O);
					T8W = VADD(T8S, T8T);
					Tgz = VSUB(T8V, T8W);
					STM4(&(io[45]), Tgz, ovs, &(io[1]));
					STN4(&(io[44]), Tf1, Tgz, Tfx, Tgj, ovs);
					TgA = VADD(T8V, T8W);
					STM4(&(io[13]), TgA, ovs, &(io[1]));
					STN4(&(io[12]), Tf2, TgA, Tfy, Tgk, ovs);
				   }
				   {
					V T8P, T8Q, TgB, TgC;
					T8P = VSUB(T8L, T8O);
					T8Q = VSUB(T8D, T8k);
					TgB = VSUB(T8P, T8Q);
					STM4(&(io[61]), TgB, ovs, &(io[1]));
					STN4(&(io[60]), Tf3, TgB, Tfz, Tgl, ovs);
					TgC = VADD(T8P, T8Q);
					STM4(&(io[29]), TgC, ovs, &(io[1]));
					STN4(&(io[28]), Tf4, TgC, TfA, Tgm, ovs);
				   }
				   {
					V T8R, T8U, TgD, TgE;
					T8R = VSUB(T7L, T80);
					T8U = VSUB(T8S, T8T);
					TgD = VSUB(T8R, T8U);
					STM4(&(ro[61]), TgD, ovs, &(ro[1]));
					STN4(&(ro[60]), Tf5, TgD, TfB, Tgn, ovs);
					TgE = VADD(T8R, T8U);
					STM4(&(ro[29]), TgE, ovs, &(ro[1]));
					STN4(&(ro[28]), Tf6, TgE, TfC, Tgo, ovs);
				   }
				   {
					V T8Z, T96, TgF, TgG;
					T8Z = VADD(T8X, T8Y);
					T96 = VADD(T92, T95);
					TgF = VSUB(T8Z, T96);
					STM4(&(ro[37]), TgF, ovs, &(ro[1]));
					STN4(&(ro[36]), Tf7, TgF, TfD, Tgp, ovs);
					TgG = VADD(T8Z, T96);
					STM4(&(ro[5]), TgG, ovs, &(ro[1]));
					STN4(&(ro[4]), Tf8, TgG, TfE, Tgq, ovs);
				   }
				   {
					V T9f, T9g, TgH, TgI;
					T9f = VADD(T97, T98);
					T9g = VADD(T9c, T9d);
					TgH = VSUB(T9f, T9g);
					STM4(&(io[37]), TgH, ovs, &(io[1]));
					STN4(&(io[36]), Tf9, TgH, TfF, Tgr, ovs);
					TgI = VADD(T9f, T9g);
					STM4(&(io[5]), TgI, ovs, &(io[1]));
					STN4(&(io[4]), Tfa, TgI, TfG, Tgs, ovs);
				   }
				   {
					V T99, T9a, TgJ, TgK;
					T99 = VSUB(T97, T98);
					T9a = VSUB(T95, T92);
					TgJ = VSUB(T99, T9a);
					STM4(&(io[53]), TgJ, ovs, &(io[1]));
					STN4(&(io[52]), Tfb, TgJ, TfH, Tgt, ovs);
					TgK = VADD(T99, T9a);
					STM4(&(io[21]), TgK, ovs, &(io[1]));
					STN4(&(io[20]), Tfc, TgK, TfI, Tgu, ovs);
				   }
				   {
					V T9b, T9e, TgL, TgM;
					T9b = VSUB(T8X, T8Y);
					T9e = VSUB(T9c, T9d);
					TgL = VSUB(T9b, T9e);
					STM4(&(ro[53]), TgL, ovs, &(ro[1]));
					STN4(&(ro[52]), Tfd, TgL, TfJ, Tgv, ovs);
					TgM = VADD(T9b, T9e);
					STM4(&(ro[21]), TgM, ovs, &(ro[1]));
					STN4(&(ro[20]), Tfe, TgM, TfK, Tgw, ovs);
				   }
			      }
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const kdft_desc desc = { 64, XSIMD_STRING("n2sv_64"), {808, 144, 104, 0}, &GENUS, 0, 1, 0, 0 };

void XSIMD(codelet_n2sv_64) (planner *p) {
     X(kdft_register) (p, n2sv_64, &desc);
}

#endif
