/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include "libebook_utils.h"
#include "EBOOKStreamSlice.h"

namespace libebook
{

EBOOKStreamSlice::EBOOKStreamSlice(WPXInputStream *const stream, const long begin, const long end)
  : m_stream(stream)
  , m_begin(begin)
  , m_end(end)
{
  // better to let the stream die unborn than to be inconsistent
  if (0 != m_stream->seek(m_begin, WPX_SEEK_SET))
    throw EndOfStreamException();
}

EBOOKStreamSlice::~EBOOKStreamSlice()
{
}

bool EBOOKStreamSlice::isOLEStream()
{
  return false;
}

WPXInputStream *EBOOKStreamSlice::getDocumentOLEStream(const char *)
{
  return 0;
}

const unsigned char *EBOOKStreamSlice::read(unsigned long numBytes, unsigned long &numBytesRead)
{
  const long pos = m_stream->tell();
  assert((m_begin <= pos) && (pos <= m_end));

  if ((pos + static_cast<long>(numBytes)) > m_end)
    numBytes = static_cast<unsigned long>(m_end - pos);

  if (0 == numBytes)
  {
    numBytesRead = 0;
    return 0;
  }

  return m_stream->read(numBytes, numBytesRead);
}

int EBOOKStreamSlice::seek(long offset, const WPX_SEEK_TYPE seekType)
{
  const long pos = m_stream->tell();
  assert((m_begin <= pos) && (pos <= m_end));

  int retval = 0;
  switch (seekType)
  {
  case WPX_SEEK_SET :
    offset += m_begin;
    if ((offset < m_begin) || (offset > m_end))
      retval = 1;
    break;
  case WPX_SEEK_CUR :
    offset += pos;
    if ((offset < m_begin) || (offset > m_end))
      retval = 1;
    break;
  case WPX_SEEK_END :
    offset += m_end;
    if ((offset < m_begin) || offset > m_end)
      retval = 1;
    break;
  default :
    retval = -1;
  }

  if (retval != 0)
    return retval;

  return m_stream->seek(offset, WPX_SEEK_SET);
}

long EBOOKStreamSlice::tell()
{
  return m_stream->tell() - m_begin;
}

bool EBOOKStreamSlice::atEOS()
{
  return m_stream->tell() >= m_end;
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
