#!/usr/bin/env python

import re, sys, itertools

pattern = re.compile(r'^#define\s+XKB_KEY_(?P<name>\w+)\s+(?P<value>0x[0-9a-fA-F]+)\s')
matches = [pattern.match(line) for line in open(sys.argv[1])]
entries = [(m.group("name"), int(m.group("value"), 16)) for m in matches if m]

print('''
/**
 * This file comes from libxkbcommon and was generated by makekeys.py
 * You can always fetch the latest version from:
 * https://raw.github.com/xkbcommon/libxkbcommon/master/src/ks_tables.h
 */
''')

entry_offsets = {}

print('''
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
static const char *keysym_names =
'''.strip())
offs = 0
for (name, _) in sorted(entries, key=lambda e: e[0].lower()):
    entry_offsets[name] = offs
    print('    "{name}\\0"'.format(name=name))
    offs += len(name) + 1
print('''
;
#pragma GCC diagnostic pop
'''.strip())

print('''
struct name_keysym {
    xkb_keysym_t keysym;
    uint32_t offset;
};\n''')

def print_entries(x):
    for (name, value) in x:
        print('    {{ 0x{value:08x}, {offs} }}, /* {name} */'.format(offs=entry_offsets[name], value=value, name=name))

print('static const struct name_keysym name_to_keysym[] = {')
print_entries(sorted(entries, key=lambda e: e[0].lower()))
print('};\n')

# *.sort() is stable so we always get the first keysym for duplicate
print('static const struct name_keysym keysym_to_name[] = {')
print_entries(next(g[1]) for g in itertools.groupby(sorted(entries, key=lambda e: e[1]), key=lambda e: e[1]))
print('};')
