# Copyright 2015 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_config import cfg

api_paste_config_opt = cfg.StrOpt('api_paste_config',
         default="api-paste.ini",
         help='File name for the paste.deploy config for nova-api')

wsgi_log_format_opt = cfg.StrOpt('wsgi_log_format',
         default='%(client_ip)s "%(request_line)s" status: %(status_code)s'
                 ' len: %(body_length)s time: %(wall_seconds).7f',
         help='A python format string that is used as the template to '
              'generate log lines. The following values can be formatted '
              'into it: client_ip, date_time, request_line, status_code, '
              'body_length, wall_seconds.')

secure_proxy_ssl_header_opt = cfg.StrOpt('secure_proxy_ssl_header',
         help='The HTTP header used to determine the scheme for the '
              'original request, even if it was removed by an SSL '
              'terminating proxy. Typical value is '
              '"HTTP_X_FORWARDED_PROTO".')

ssl_ca_file_opt = cfg.StrOpt('ssl_ca_file',
         help="CA certificate file to use to verify "
              "connecting clients")

ssl_cert_file_opt = cfg.StrOpt('ssl_cert_file',
         help="SSL certificate of API server")

ssl_key_file_opt = cfg.StrOpt('ssl_key_file',
         help="SSL private key of API server")

tcp_keepidle_opt = cfg.IntOpt('tcp_keepidle',
         default=600,
         help="Sets the value of TCP_KEEPIDLE in seconds for each "
              "server socket. Not supported on OS X.")

wsgi_default_pool_size_opt = cfg.IntOpt('wsgi_default_pool_size',
         default=1000,
         help="Size of the pool of greenthreads used by wsgi")

max_header_line_opt = cfg.IntOpt('max_header_line',
         default=16384,
         help="Maximum line size of message headers to be accepted. "
              "max_header_line may need to be increased when using "
              "large tokens (typically those generated by the "
              "Keystone v3 API with big service catalogs).")

wsgi_keep_alive_opt = cfg.BoolOpt('wsgi_keep_alive',
         default=True,
         help="If False, closes the client socket connection "
              "explicitly.")

client_socket_timeout_opt = cfg.IntOpt('client_socket_timeout', default=900,
         help="Timeout for client connections' socket operations. "
              "If an incoming connection is idle for this number of "
              "seconds it will be closed. A value of '0' means "
              "wait forever.")

ALL_OPTS = [api_paste_config_opt,
            wsgi_log_format_opt,
            secure_proxy_ssl_header_opt,
            ssl_ca_file_opt,
            ssl_cert_file_opt,
            ssl_key_file_opt,
            tcp_keepidle_opt,
            wsgi_default_pool_size_opt,
            max_header_line_opt,
            wsgi_keep_alive_opt,
            client_socket_timeout_opt
            ]


def register_opts(conf):
    conf.register_opts(ALL_OPTS)


def list_opts():
    return {"DEFAULT": ALL_OPTS}
