// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Generated 2016-10-20T18:50:22Z

#include "components/autofill/core/browser/address_rewriter.h"

namespace autofill {
namespace internal {
namespace {

const Rule kRules_AD[] = {
    {"\\bparroquia\\s+de\\s+andorra\\s+la\\s+vella\\b", "07"},
    {"\\bprincipal\\s+de\\s+andorra\\b", "07"},
    {"\\bprincipat\\s+de\\s+andorra\\b", "07"},
    {"\\bsant\\s+julia\\s+de\\s+loria\\b", "06"},
    {"\\bescaldes\\s+engordany\\b", "08"},
    {"\\bandorra\\s+la\\s+vella\\b", "07"},
    {"\\bcarrer\\s+del\\b", ""},
    {"\\bla\\s+massana\\b", "04"},
    {"\\bsant\\s+julia\\b", "06"},
    {"\\bcarrer\\s+de\\b", ""},
    {"\\bandorra\\b", "07"},
    {"\\bcanillo\\b", "02"},
    {"\\bmassana\\b", "04"},
    {"\\bencamp\\b", "03"},
    {"\\bordino\\b", "05"},
    {"\\bc\\s+del\\b", ""},
    {"\\bc\\s+de\\b", ""},
    {"\\bad\\b", "07"},
    {"\\ban\\b", "07"},
    {"\\bca\\b", "02"},
    {"\\bee\\b", "08"},
    {"\\ben\\b", "03"},
    {"\\bjl\\b", "06"},
    {"\\bma\\b", "04"},
    {"\\bor\\b", "05"},
};

const Rule kRules_AR[] = {
    {"\\btierra\\s+del\\s+fuego\\s+antartida\\s+e\\s+islas\\s+del\\s+"
      "atlantico\\s+sur\\b",
      "tierra del fuego"},
    {"\\bciudad\\s+autonoma\\s+de\\s+buenos\\s+aires\\b", "caba"},
    {"\\bla\\s+ciudad\\s+de\\s+buenos\\s+aires\\b", "caba"},
    {"\\bcapital\\s+federal\\b", "caba"},
    {"\\bdiecinueve\\b", "19"},
    {"\\bdiecisiete\\b", "17"},
    {"\\bargentina\\b", "ar"},
    {"\\bboulevard\\b", "bv"},
    {"\\bdieciocho\\b", "18"},
    {"\\bdieciseis\\b", "16"},
    {"\\bavenida\\b", "av"},
    {"\\bcatorce\\b", "14"},
    {"\\bprimera\\b", "1a"},
    {"\\bsegunda\\b", "2a"},
    {"\\bseptima\\b", "7a"},
    {"\\btercera\\b", "3a"},
    {"\\bcuarta\\b", "4a"},
    {"\\bcuatro\\b", "4"},
    {"\\boctava\\b", "8a"},
    {"\\bpasaje\\b", "pje"},
    {"\\bquince\\b", "15"},
    {"\\bquinta\\b", "5a"},
    {"\\bveinte\\b", "20"},
    {"\\bcinco\\b", "5"},
    {"\\bnueve\\b", "9"},
    {"\\bsexta\\b", "6a"},
    {"\\bsiete\\b", "7"},
    {"\\btrece\\b", "13"},
    {"\\bdiez\\b", "10"},
    {"\\bdoce\\b", "12"},
    {"\\bocho\\b", "8"},
    {"\\bonce\\b", "11"},
    {"\\bseis\\b", "6"},
    {"\\btres\\b", "3"},
    {"\\bdel\\b", ""},
    {"\\bdos\\b", "2"},
    {"\\blas\\b", ""},
    {"\\blos\\b", ""},
    {"\\buno\\b", "1"},
    {"\\bde\\b", ""},
    {"\\bel\\b", ""},
    {"\\ble\\b", ""},
};

const Rule kRules_AU[] = {
    {"\\baustralian\\s+capital\\s+territory\\b", "act"},
    {"\\bjervis\\s+bay\\s+territory\\b", "jbt"},
    {"\\bnorthern\\s+territory\\b", "nt"},
    {"\\bwestern\\s+australia\\b", "wa"},
    {"\\bnew\\s+south\\s+wales\\b", "nsw"},
    {"\\bsouth\\s+australia\\b", "sa"},
    {"\\bqueensland\\b", "qld"},
    {"\\baustralia\\b", "au"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcrescent\\b", "cres"},
    {"\\btasmania\\b", "tas"},
    {"\\bvictoria\\b", "vic"},
    {"\\bhighway\\b", "hwy"},
    {"\\bparkway\\b", "pkwy"},
    {"\\ba\\.c\\.t\\.\\b", "act"},
    {"\\bau\\-act\\b", "act"},
    {"\\bau\\-jbt\\b", "jbt"},
    {"\\bau\\-nsw\\b", "nsw"},
    {"\\bau\\-qld\\b", "qld"},
    {"\\bau\\-tas\\b", "tas"},
    {"\\bau\\-vic\\b", "vic"},
    {"\\bavenue\\b", "ave"},
    {"\\bcommon\\b", "comm"},
    {"\\bj\\.b\\.t\\.\\b", "jbt"},
    {"\\bn\\.s\\.w\\.\\b", "nsw"},
    {"\\bparade\\b", "pde"},
    {"\\bstreet\\b", "st"},
    {"\\ba\\.c\\.t\\b", "act"},
    {"\\bau\\-nt\\b", "nt"},
    {"\\bau\\-sa\\b", "sa"},
    {"\\bau\\-wa\\b", "wa"},
    {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},
    {"\\beight\\b", "8"},
    {"\\bj\\.b\\.t\\b", "jbt"},
    {"\\bmount\\b", "mt"},
    {"\\bn\\.s\\.w\\b", "nsw"},
    {"\\bnorth\\b", "n"},
    {"\\bplace\\b", "pl"},
    {"\\bpoint\\b", "pt"},
    {"\\bsaint\\b", "st"},
    {"\\bseven\\b", "7"},
    {"\\bsouth\\b", "s"},
    {"\\bthree\\b", "3"},
    {"\\beast\\b", "e"},
    {"\\bfive\\b", "5"},
    {"\\bfour\\b", "4"},
    {"\\blane\\b", "ln"},
    {"\\bn\\.t\\.\\b", "nt"},
    {"\\bnine\\b", "9"},
    {"\\broad\\b", "rd"},
    {"\\bs\\.a\\.\\b", "sa"},
    {"\\bw\\.a\\.\\b", "wa"},
    {"\\bwest\\b", "w"},
    {"\\baus\\b", "au"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bn\\.t\\b", "nt"},
    {"\\bnth\\b", "n"},
    {"\\bone\\b", "1"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bs\\.a\\b", "sa"},
    {"\\bsix\\b", "6"},
    {"\\bst\\.\\b", "st"},
    {"\\bsth\\b", "s"},
    {"\\bten\\b", "10"},
    {"\\btwo\\b", "2"},
    {"\\bw\\.a\\b", "wa"},
    {"\\be\\.\\b", "e"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_BE[] = {
    {"\\barrondissement\\s+administratif\\s+de\\b", ""},
    {"\\barrondissement\\s+administratif\\s+d\\b", ""},
    {"\\bbrussels\\s+hoofdstedelijk\\s+gewest\\b", "brussel"},
    {"\\bbrussel\\s+hoofdstedelijk\\s+gewest\\b", "brussel"},
    {"\\bregion\\s+de\\s+bruxelles\\s+capitale\\b", "brussel"},
    {"\\bseptieme\\s+division\\s+francaise\\b", "7eme division frcse"},
    {"\\bonze\\s+lieve\\s+heersebeestjes\\b", "onze lieve heersbeestjes"},
    {"\\bregion\\s+brussel\\s+hauptstadt\\b", "brussel"},
    {"\\balbert\\s+en\\s+marie\\s+louise\\b", "a & m l"},
    {"\\balbert\\s+et\\s+marie\\s+louise\\b", "a & m l"},
    {"\\bandree\\s+payfa\\s+fosseprez\\b", "a payfa fosseprez"},
    {"\\bseptieme\\s+d\\s+i\\s+francaise\\b", "7eme division frcse"},
    {"\\bwereldtentoonstellings\\b", "wereldtentoonstelings"},
    {"\\bberchem\\s+sainte\\s+agathe\\b", "st agatha berchem"},
    {"\\bflandres\\s+occidentales\\b", "westflandern"},
    {"\\bsaint\\s+josse\\s+ten\\s+noode\\b", "saint josse"},
    {"\\bflandre\\s+occidentales\\b", "westflandern"},
    {"\\bflandres\\s+occidentale\\b", "westflandern"},
    {"\\bhenri\\s+victor\\s+wolvens\\b", "h v wolvens"},
    {"\\bjoseph\\s+van\\s+boterdael\\b", "joseph van boterdae"},
    {"\\bmarilyn\\s+monroegaarde\\b", "marilyn monroe"},
    {"\\bflandre\\s+occidentale\\b", "westflandern"},
    {"\\bflandres\\s+orientales\\b", "ostflandern"},
    {"\\bwoluwe\\s+saint\\s+pierre\\b", "st pieters woluwe"},
    {"\\bbruxelles\\s+capitale\\b", "brussel"},
    {"\\bflandre\\s+orientales\\b", "ostflandern"},
    {"\\bflandres\\s+orientale\\b", "ostflandern"},
    {"\\bhendrik\\s+conscience\\b", "henri conscience"},
    {"\\bleonoardo\\s+da\\s+vinci\\b", "leonard de vinci"},
    {"\\bwallonisch\\s+brabant\\b", "waals brabant"},
    {"\\bwallonische\\s+region\\b", "wallonie"},
    {"\\bbischoffsheimlaan\\b", "bischoffsheim"},
    {"\\bbrouck\\s+du\\s+tilleul\\b", "brouck au tilleul"},
    {"\\bflandre\\s+orientale\\b", "ostflandern"},
    {"\\bleonardo\\s+da\\s+vinci\\b", "leonard de vinci"},
    {"\\barmand\\s+scheitler\\b", "armand scheiter"},
    {"\\bflamisch\\s+brabant\\b", "vlaams brabant"},
    {"\\bflamische\\s+region\\b", "vlaams gewest"},
    {"\\bhenri\\s+wafelaerts\\b", "henri wafelaert"},
    {"\\bpieter\\s+hauwaerts\\b", "pierre hauwaerts"},
    {"\\bregion\\s+wallonien\\b", "wallonie"},
    {"\\brennequin\\s+sualem\\b", "renkin sualem"},
    {"\\baugust\\s+de\\s+boeck\\b", "a de boeck"},
    {"\\bbrabant\\s+flamand\\b", "vlaams brabant"},
    {"\\bbruxelles\\s+ville\\b", "brussel"},
    {"\\bflamisch\\s+region\\b", "vlaams gewest"},
    {"\\bgodefroid\\s+kurth\\b", "godfroid kurth"},
    {"\\boost\\s+vlaanderen\\b", "ostflandern"},
    {"\\bregion\\s+flamande\\b", "vlaams gewest"},
    {"\\bregion\\s+wallonne\\b", "wallonie"},
    {"\\bwest\\s+vlaanderen\\b", "westflandern"},
    {"\\barrondissement\\b", ""},
    {"\\bbrabant\\s+wallon\\b", "waals brabant"},
    {"\\blimburg\\s+strium\\b", "limburg stirum"},
    {"\\bde\\s+ribaucourt\\b", "ribaucourt"},
    {"\\bmichel\\s+angelo\\b", "michel ange"},
    {"\\bpater\\s+damiaan\\b", "pater damian"},
    {"\\bprofondeville\\b", "profondville"},
    {"\\bsint\\s+lenaerts\\b", "sint lenaarts"},
    {"\\bsualem\\s+renkin\\b", "renkin sualem"},
    {"\\bdendermondse\\b", "dendermonde"},
    {"\\bminnezangers\\b", "menestrelen"},
    {"\\bvooruitgangs\\b", "vooruitgang"},
    {"\\bwaals\\s+gewest\\b", "wallonie"},
    {"\\bcortenbergh\\b", "cortenberg"},
    {"\\bjette\\s+jetse\\b", "jette"},
    {"\\bl\\s+urbanisme\\b", "i urbanisme"},
    {"\\bprovince\\s+de\\b", ""},
    {"\\bprovince\\s+du\\b", ""},
    {"\\bpuits\\s+no\\s+iv\\b", "puits n4"},
    {"\\bterhulpense\\b", "terhulpse"},
    {"\\bhenegouwen\\b", "hainaut"},
    {"\\blanguesdoc\\b", "languedoc"},
    {"\\bluxembourg\\b", "luxemburg"},
    {"\\bprovince\\s+d\\b", ""},
    {"\\bpuit\\s+no\\s+iv\\b", "puits n4"},
    {"\\bvan\\s+volxem\\b", "volxem"},
    {"\\bantwerpen\\b", "anvers"},
    {"\\bboulevard\\b", "bd"},
    {"\\bbruxelles\\b", "brussel"},
    {"\\bluitenant\\b", "liutenant"},
    {"\\bwallonien\\b", "wallonie"},
    {"\\bwestphael\\b", "wesphal"},
    {"\\bbelgique\\b", "be"},
    {"\\bbrussels\\b", "brussel"},
    {"\\bchaussee\\b", "chee"},
    {"\\bhennegau\\b", "hainaut"},
    {"\\blimbourg\\b", "limburg"},
    {"\\bsteenweg\\b", "stwg"},
    {"\\bterrasse\\b", "tsse"},
    {"\\bwestphal\\b", "wesphal"},
    {"\\bavenues\\b", "av"},
    {"\\bbelgien\\b", "be"},
    {"\\bbelgium\\b", "be"},
    {"\\bde\\s+wand\\b", "wand"},
    {"\\bimpasse\\b", "imp"},
    {"\\bjettese\\b", "jetse"},
    {"\\bluttich\\b", "luik"},
    {"\\bprovinz\\b", ""},
    {"\\bstrasse\\b", "str"},
    {"\\ballees\\b", "all"},
    {"\\bavenue\\b", "av"},
    {"\\bbelgie\\b", "be"},
    {"\\bcentre\\b", "ctre"},
    {"\\bsainte\\b", "st"},
    {"\\bsquare\\b", "sq"},
    {"\\bstraat\\b", "str"},
    {"\\ballee\\b", "all"},
    {"\\bliege\\b", "luik"},
    {"\\bnamur\\b", "namen"},
    {"\\bpiein\\b", "pl"},
    {"\\bplace\\b", "pl"},
    {"\\bplatz\\b", "pl"},
    {"\\bplein\\b", "pl"},
    {"\\broute\\b", "rte"},
    {"\\bsaint\\b", "st"},
    {"\\bsankt\\b", "st"},
    {"\\bthier\\b", "their"},
    {"\\bsint\\b", "st"},
    {"\\bdes\\b", "d"},
    {"\\brue\\b", "r"},
    {"\\bste\\b", "st"},
    {"\\bde\\b", "d"},
    {"\\bdu\\b", "d"},
};

const Rule kRules_BR[] = {
    {"\\brio\\s+grande\\s+do\\s+norte\\b", "rn"},
    {"\\bmato\\s+grosso\\s+do\\s+sul\\b", "ms"},
    {"\\brio\\s+grande\\s+do\\s+sul\\b", "rs"},
    {"\\bdistrito\\s+federal\\b", "df"},
    {"\\bdecimo\\s+primeiro\\b", "11"},
    {"\\bdecimo\\s+terceiro\\b", "13"},
    {"\\bespirito\\s+santo\\b", "es"},
    {"\\brio\\s+de\\s+janeiro\\b", "rj"},
    {"\\bsanta\\s+catarina\\b", "sc"},
    {"\\bvinte\\s+e\\s+quatro\\b", "24"},
    {"\\bdecimo\\s+oitavo\\b", "18"},
    {"\\bdecimo\\s+quarto\\b", "14"},
    {"\\bdecimo\\s+quinto\\b", "15"},
    {"\\bdecimo\\s+setimo\\b", "17"},
    {"\\bvinte\\s+e\\s+cinco\\b", "25"},
    {"\\bdecimo\\s+sexto\\b", "16"},
    {"\\bminas\\s+gerais\\b", "mg"},
    {"\\bvinte\\s+e\\s+dois\\b", "22"},
    {"\\bvinte\\s+e\\s+nove\\b", "29"},
    {"\\bvinte\\s+e\\s+oito\\b", "28"},
    {"\\bvinte\\s+e\\s+seis\\b", "26"},
    {"\\bvinte\\s+e\\s+sete\\b", "27"},
    {"\\bvinte\\s+e\\s+tres\\b", "23"},
    {"\\bdecimo\\s+nono\\b", "19"},
    {"\\bmato\\s+grosso\\b", "mt"},
    {"\\bcomandante\\b", "com"},
    {"\\bgovernador\\b", "gov"},
    {"\\bpernambuco\\b", "pe"},
    {"\\bpresidente\\b", "pres"},
    {"\\bvinte\\s+e\\s+um\\b", "21"},
    {"\\bcinquenta\\b", "50"},
    {"\\bdezesseis\\b", "16"},
    {"\\bdezessete\\b", "17"},
    {"\\bduodecimo\\b", "12"},
    {"\\bprofessor\\b", "prof"},
    {"\\brepublica\\b", "rep"},
    {"\\bsao\\s+paulo\\b", "sp"},
    {"\\btocantins\\b", "to"},
    {"\\bamazonas\\b", "am"},
    {"\\bdezenove\\b", "19"},
    {"\\bmaranhao\\b", "ma"},
    {"\\bprimeiro\\b", "1"},
    {"\\bprincesa\\b", "prsa"},
    {"\\bquarenta\\b", "40"},
    {"\\brondonia\\b", "ro"},
    {"\\bsargento\\b", "sct"},
    {"\\bsessenta\\b", "60"},
    {"\\bterceiro\\b", "3"},
    {"\\bvigesimo\\b", "20"},
    {"\\balagoas\\b", "al"},
    {"\\balameda\\b", "al"},
    {"\\bavenida\\b", "av"},
    {"\\bcatorze\\b", "14"},
    {"\\bcoronel\\b", "cel"},
    {"\\bdezoito\\b", "18"},
    {"\\bestrada\\b", "estr"},
    {"\\bnoventa\\b", "90"},
    {"\\boitenta\\b", "80"},
    {"\\bparaiba\\b", "pb"},
    {"\\broraima\\b", "rr"},
    {"\\bsegundo\\b", "2"},
    {"\\bsenador\\b", "sen"},
    {"\\bsergipe\\b", "se"},
    {"\\bsetenta\\b", "70"},
    {"\\bbrasil\\b", "b"},
    {"\\bbrazil\\b", "b"},
    {"\\bdecimo\\b", "x"},
    {"\\bdoutor\\b", "dr"},
    {"\\boitavo\\b", "8"},
    {"\\bparana\\b", "pr"},
    {"\\bprincs\\b", "prsa"},
    {"\\bquarto\\b", "4"},
    {"\\bquatro\\b", "4"},
    {"\\bquinto\\b", "5"},
    {"\\bquinze\\b", "15"},
    {"\\bsetimo\\b", "7"},
    {"\\btrinta\\b", "30"},
    {"\\bamapa\\b", "ap"},
    {"\\bbahia\\b", "ba"},
    {"\\bbarao\\b", "b"},
    {"\\bceara\\b", "ce"},
    {"\\bcinco\\b", "5"},
    {"\\bconde\\b", "cde"},
    {"\\bduque\\b", "dq"},
    {"\\bgoias\\b", "go"},
    {"\\bnorte\\b", "n"},
    {"\\boeste\\b", "w"},
    {"\\bpadre\\b", "pe"},
    {"\\bpiaui\\b", "pi"},
    {"\\bsanta\\b", "sta"},
    {"\\bsexto\\b", "6"},
    {"\\btreze\\b", "13"},
    {"\\bviela\\b", "ve"},
    {"\\bvinte\\b", "20"},
    {"\\bacre\\b", "ac"},
    {"\\bbaia\\b", "ba"},
    {"\\bdois\\b", "2"},
    {"\\bdoze\\b", "12"},
    {"\\beste\\b", "e"},
    {"\\blote\\b", "lt"},
    {"\\bnono\\b", "9"},
    {"\\bnove\\b", "9"},
    {"\\boito\\b", "8"},
    {"\\bonze\\b", "11"},
    {"\\bpara\\b", "pa"},
    {"\\bsala\\b", "s"},
    {"\\bseis\\b", "6"},
    {"\\bsete\\b", "7"},
    {"\\btres\\b", "3"},
    {"\\bviii\\b", "8"},
    {"\\bcem\\b", "100"},
    {"\\bdas\\b", ""},
    {"\\bdez\\b", "x"},
    {"\\bdos\\b", ""},
    {"\\biii\\b", "3"},
    {"\\brua\\b", "r"},
    {"\\bsan\\b", "s"},
    {"\\bsgt\\b", "sct"},
    {"\\bsul\\b", "s"},
    {"\\bvii\\b", "7"},
    {"\\b10\\b", "x"},
    {"\\bbr\\b", "b"},
    {"\\bda\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdo\\b", ""},
    {"\\bel\\b", ""},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bsl\\b", "s"},
    {"\\bum\\b", "1"},
    {"\\bvi\\b", "6"},
    {"\\bvl\\b", "ve"},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
};

const Rule kRules_CA[] = {
    {"\\bdsl\\s+de\\s+grand\\s+sault\\s+falls\\s+grand\\s+sault\\s+grand\\s+"
      "falls\\b",
      "grand falls"},
    {"\\bsainte\\s+catherine\\s+de\\s+la\\s+jacques\\s+cartier\\b",
      "ste catherine de la j cartier"},
    {"\\bmadawaska\\s+maliseet\\s+frst\\s+nation\\b", "madawaska"},
    {"\\bregional\\s+county\\s+municipality\\b", ""},
    {"\\bshediac\\s+bridge\\s+shediac\\s+river\\b", "shediac bridge"},
    {"\\bnewfoundland\\s+and\\s+labrador\\b", "nl"},
    {"\\bterritoires\\s+du\\s+nord\\s+ouest\\b", "nt"},
    {"\\bdsl\\s+de\\s+grand\\s+sault\\s+falls\\b", "grand falls"},
    {"\\bregional\\s+municipality\\s+of\\b", ""},
    {"\\bgrand\\s+sault\\s+grand\\s+falls\\b", "grand falls"},
    {"\\bterre\\s+neuve\\s+et\\s+labrador\\b", "nl"},
    {"\\bbay\\s+de\\s+verde\\s+peninsula\\b", "bvd"},
    {"\\bile\\s+du\\s+prince\\s+edouard\\b", "pe"},
    {"\\bnorthwest\\s+territories\\b", "nt"},
    {"\\bregional\\s+municipality\\b", ""},
    {"\\bcolombie\\s+britannique\\b", "bc"},
    {"\\bprince\\s+edward\\s+island\\b", "pe"},
    {"\\bregional\\s+district\\s+of\\b", ""},
    {"\\bfrench\\s+village\\s+york\\b", "french village"},
    {"\\bhead\\s+of\\s+bay\\s+despoir\\b", "head bay d\'espoir"},
    {"\\bterritoire\\s+du\\s+yukon\\b", "yt"},
    {"\\bnouveau\\s+brunswick\\b", "nb"},
    {"\\bregional\\s+district\\b", ""},
    {"\\bbritish\\s+columbia\\b", "bc"},
    {"\\bcanton\\s+stanstead\\b", "stanstead"},
    {"\\bmd\\s+of\\s+bonnyville\\b", "bonnyville"},
    {"\\bnouvelle\\s+ecosse\\b", "ns"},
    {"\\bst\\s+george\\s+brant\\b", "saint george"},
    {"\\byukon\\s+territory\\b", "yt"},
    {"\\bchisholm\\s+mills\\b", "chisholm"},
    {"\\bsackville\\s+road\\b", "sackville"},
    {"\\bnational\\s+park\\b", ""},
    {"\\bnew\\s+brunswick\\b", "nb"},
    {"\\bplacentia\\s+bay\\b", "pb"},
    {"\\bbeaver\\s+brook\\b", "beaverbrook"},
    {"\\bmetropolitan\\b", ""},
    {"\\bnewfoundland\\b", "nl"},
    {"\\brichibouctou\\b", "richibucto"},
    {"\\bsaskatchewan\\b", "sk"},
    {"\\bfortune\\s+bay\\b", "fb"},
    {"\\bnova\\s+scotia\\b", "ns"},
    {"\\bsubdivision\\b", "subdiv"},
    {"\\bsutton\\s+west\\b", "sutton"},
    {"\\bterre\\s+neuve\\b", "nl"},
    {"\\btownship\\s+of\\b", ""},
    {"\\btrinity\\s+bay\\b", "tb"},
    {"\\bbelliveaus\\b", "belliveau"},
    {"\\bconcession\\b", "conc"},
    {"\\bcul\\s+de\\s+sac\\b", "cds"},
    {"\\bcul\\-de\\-sac\\b", "cds"},
    {"\\bde\\s+riviere\\b", "riviere"},
    {"\\bexpressway\\b", "expy"},
    {"\\bmackinnons\\b", "mckinnons"},
    {"\\bnorth\\s+side\\b", "northside"},
    {"\\bpine\\s+ridge\\b", "pineridge"},
    {"\\brond\\s+point\\b", "rdpt"},
    {"\\brond\\-point\\b", "rdpt"},
    {"\\balternate\\b", "alt"},
    {"\\bautoroute\\b", "aut"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcarrefour\\b", "carref"},
    {"\\bcounty\\s+of\\b", ""},
    {"\\bcroissant\\b", "crois"},
    {"\\bdiversion\\b", "divers"},
    {"\\bechangeur\\b", "ech"},
    {"\\besplanade\\b", "espl"},
    {"\\bextension\\b", "exten"},
    {"\\bhalf\\s+moon\\b", "halfmoon"},
    {"\\bhighlands\\b", "hghlds"},
    {"\\bkuskonook\\b", "kuskanook"},
    {"\\bpromenade\\b", "prom"},
    {"\\bturnabout\\b", "trnabt"},
    {"\\bbusiness\\b", "bus"},
    {"\\bcrescent\\b", "cres"},
    {"\\bcrossing\\b", "cross"},
    {"\\bjunction\\b", ""},
    {"\\bmanitoba\\b", "mb"},
    {"\\bmountain\\b", "mtn"},
    {"\\boak\\s+hill\\b", "oakhill"},
    {"\\bpleasent\\b", "pleasant"},
    {"\\bterrasse\\b", "tsse"},
    {"\\btownline\\b", "tline"},
    {"\\btownship\\b", ""},
    {"\\balberta\\b", "ab"},
    {"\\bby\\s+pass\\b", "bypass"},
    {"\\bcircuit\\b", "circt"},
    {"\\bcity\\s+of\\b", ""},
    {"\\bcorners\\b", "crnrs"},
    {"\\bestates\\b", "estate"},
    {"\\bfreeway\\b", "fwy"},
    {"\\bgardens\\b", "gdns"},
    {"\\bgrounds\\b", "grnds"},
    {"\\bharbour\\b", "harbr"},
    {"\\bheights\\b", "hts"},
    {"\\bherbert\\b", "hebert"},
    {"\\bhighway\\b", "hwy"},
    {"\\bimpasse\\b", "imp"},
    {"\\bkeenans\\b", "keenan"},
    {"\\bl\'islet\\b", ""},
    {"\\bla\\s+have\\b", "lahave"},
    {"\\blanding\\b", "landng"},
    {"\\blookout\\b", "lkout"},
    {"\\bnarrows\\b", ""},
    {"\\bnunavut\\b", "nu"},
    {"\\bontario\\b", "on"},
    {"\\borchard\\b", "orch"},
    {"\\bparkway\\b", "pky"},
    {"\\bpassage\\b", "pass"},
    {"\\bpathway\\b", "ptway"},
    {"\\bplateau\\b", "plat"},
    {"\\breserve\\b", ""},
    {"\\bsentier\\b", "sent"},
    {"\\bstation\\b", ""},
    {"\\bterrace\\b", "terr"},
    {"\\bthicket\\b", "thick"},
    {"\\btown\\s+of\\b", ""},
    {"\\bvillage\\b", ""},
    {"\\bavenue\\b", "av"},
    {"\\bbakers\\b", "baker"},
    {"\\bcanada\\b", "ca"},
    {"\\bcanton\\b", ""},
    {"\\bcenter\\b", ""},
    {"\\bcentre\\b", ""},
    {"\\bchemin\\b", "ch"},
    {"\\bcircle\\b", "cir"},
    {"\\bcounty\\b", ""},
    {"\\bharbor\\b", "harbr"},
    {"\\bisland\\b", ""},
    {"\\bl\'isle\\b", "isle"},
    {"\\blimits\\b", "lmts"},
    {"\\bmackay\\b", "mckay"},
    {"\\bmcgrey\\b", "mcgray"},
    {"\\bpointe\\b", "pte"},
    {"\\bquebec\\b", "qc"},
    {"\\bruelle\\b", "rle"},
    {"\\bsainte\\b", ""},
    {"\\bsiding\\b", ""},
    {"\\bsmiths\\b", "smith"},
    {"\\bsquare\\b", "sq"},
    {"\\bstreet\\b", ""},
    {"\\bvalley\\b", ""},
    {"\\bcarre\\b", "car"},
    {"\\bclose\\b", "cl"},
    {"\\bcourt\\b", "crt"},
    {"\\bdrive\\b", "dr"},
    {"\\bfirst\\b", "fst"},
    {"\\bforks\\b", ""},
    {"\\bgrove\\b", "grv"},
    {"\\bmanns\\b", "mann"},
    {"\\bmetro\\b", ""},
    {"\\bmount\\b", "mt"},
    {"\\bnorth\\b", "n"},
    {"\\bouest\\b", "o"},
    {"\\bplace\\b", "pl"},
    {"\\bpoint\\b", "pt"},
    {"\\brange\\b", "rg"},
    {"\\broute\\b", "rt"},
    {"\\bsaint\\b", ""},
    {"\\bsouth\\b", "s"},
    {"\\btrail\\b", "trl"},
    {"\\byukon\\b", "yt"},
    {"\\bboul\\b", "blvd"},
    {"\\bcity\\b", ""},
    {"\\bcove\\b", ""},
    {"\\beast\\b", ""},
    {"\\bfrst\\b", "fst"},
    {"\\blake\\b", ""},
    {"\\blane\\b", "ln"},
    {"\\bnord\\b", "n"},
    {"\\bpark\\b", ""},
    {"\\bpkwy\\b", "pky"},
    {"\\broad\\b", ""},
    {"\\bwest\\b", "o"},
    {"\\bave\\b", "av"},
    {"\\bbay\\b", ""},
    {"\\bbdv\\b", ""},
    {"\\bblp\\b", ""},
    {"\\bcan\\b", "ca"},
    {"\\bcbd\\b", ""},
    {"\\bctr\\b", ""},
    {"\\bdes\\b", ""},
    {"\\bere\\b", ""},
    {"\\best\\b", ""},
    {"\\bile\\b", ""},
    {"\\blab\\b", ""},
    {"\\bndb\\b", ""},
    {"\\bnth\\b", "n"},
    {"\\bont\\b", "on"},
    {"\\bpei\\b", "pe"},
    {"\\brte\\b", "rt"},
    {"\\bsal\\b", ""},
    {"\\bsmb\\b", ""},
    {"\\bste\\b", ""},
    {"\\bsth\\b", "s"},
    {"\\bsud\\b", "s"},
    {"\\bbb\\b", ""},
    {"\\bcb\\b", ""},
    {"\\bco\\b", ""},
    {"\\bd\'\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\ber\\b", ""},
    {"\\bfn\\b", ""},
    {"\\bgb\\b", ""},
    {"\\bnd\\b", ""},
    {"\\bpk\\b", ""},
    {"\\brd\\b", ""},
    {"\\bre\\b", ""},
    {"\\bst\\b", ""},
    {"\\bth\\b", ""},
    {"\\bwb\\b", ""},
    {"\\bc\\b", ""},
    {"\\bd\\b", ""},
    {"\\be\\b", ""},
    {"\\bw\\b", "o"},
};

const Rule kRules_CH[] = {
    {"\\bappenzell\\s+rhodes\\s+exterieures\\b", "ar"},
    {"\\bappenzell\\s+ausserrhoden\\b", "ar"},
    {"\\bappenzell\\s+innerrhoden\\b", "ai"},
    {"\\bjura\\s+north\\s+vaudois\\b", "jura nord vaudois"},
    {"\\bprettigovia\\s+davos\\b", "davos"},
    {"\\bbasel\\s+landschaft\\b", "bl"},
    {"\\bprattigau\\s+davos\\b", "davos"},
    {"\\bsankt\\s+silvester\\b", "st silvester"},
    {"\\bbale\\s+campagne\\b", "bl"},
    {"\\bbasilea\\s+citta\\b", "bs"},
    {"\\bsankt\\s+stephan\\b", "st stephan"},
    {"\\bwallis\\s+valais\\b", "vs"},
    {"\\bdix\\s+huitieme\\b", "18"},
    {"\\bdix\\s+neuvieme\\b", "19"},
    {"\\bdix\\s+septieme\\b", "17"},
    {"\\bsaint\\s+gallen\\b", "sg"},
    {"\\bsankt\\s+gallen\\b", "sg"},
    {"\\bschaffhausen\\b", "sh"},
    {"\\bbasel\\s+stadt\\b", "bs"},
    {"\\bbelinzonese\\b", "bellinzona"},
    {"\\bquatorzieme\\b", "14"},
    {"\\bsaint\\s+gallo\\b", "sg"},
    {"\\bsan\\s+nazzaro\\b", "s nazzaro"},
    {"\\bsan\\s+vittore\\b", "s vittore"},
    {"\\bsankt\\s+gallo\\b", "sg"},
    {"\\bschaffhouse\\b", "sh"},
    {"\\bswitzerland\\b", "ch"},
    {"\\bwinterthour\\b", "winterthur"},
    {"\\bbale\\s+ville\\b", "bs"},
    {"\\bbasel\\s+city\\b", "bs"},
    {"\\bbasel\\s+land\\b", "bl"},
    {"\\bbasel\\s+stad\\b", "bs"},
    {"\\bbazel\\s+stad\\b", "bs"},
    {"\\bbellinzone\\b", "bellinzona"},
    {"\\benclave\\s+de\\b", ""},
    {"\\bgraubunden\\b", "gr"},
    {"\\bsaint\\s+gall\\b", "sg"},
    {"\\bsan\\s+gallen\\b", "sg"},
    {"\\bsankt\\s+gall\\b", "sg"},
    {"\\bst\\.\\s+gallen\\b", "sg"},
    {"\\bvaud\\s+waadt\\b", "vd"},
    {"\\bwaadt\\s+vaud\\b", "vd"},
    {"\\bcinquieme\\b", "5"},
    {"\\blaufental\\b", "laufen"},
    {"\\bneuchatel\\b", "ne"},
    {"\\bneuenburg\\b", "ne"},
    {"\\bnidwalden\\b", "nw"},
    {"\\bquatrieme\\b", "4"},
    {"\\bquinzieme\\b", "15"},
    {"\\bsan\\s+gallo\\b", "sg"},
    {"\\bsciaffusa\\b", "sh"},
    {"\\bsolothurn\\b", "so"},
    {"\\bst\\s+gallen\\b", "sg"},
    {"\\bst\\.\\s+gallo\\b", "sg"},
    {"\\bthurgovia\\b", "tg"},
    {"\\bthurgovie\\b", "tg"},
    {"\\btreizieme\\b", "13"},
    {"\\btroisieme\\b", "3"},
    {"\\bvingtieme\\b", "20"},
    {"\\bd\\\\\'uster\\b", "uster"},
    {"\\bdeuxieme\\b", "2"},
    {"\\bdouzieme\\b", "12"},
    {"\\bfreiburg\\b", "fr"},
    {"\\bfribourg\\b", "fr"},
    {"\\bfriburgo\\b", "fr"},
    {"\\bgessenay\\b", "saanen"},
    {"\\bgrigioni\\b", "gr"},
    {"\\bhuitieme\\b", "8"},
    {"\\bmaloggia\\b", "maloja"},
    {"\\bneuvieme\\b", "9"},
    {"\\bnidvaldo\\b", "nw"},
    {"\\bobwalden\\b", "ow"},
    {"\\bpremiere\\b", "1"},
    {"\\bsan\\s+gall\\b", "sg"},
    {"\\bseizieme\\b", "16"},
    {"\\bseptieme\\b", "7"},
    {"\\bst\\s+gallo\\b", "sg"},
    {"\\bst\\.\\s+gall\\b", "sg"},
    {"\\bturgovia\\b", "tg"},
    {"\\bzofingue\\b", "zofingen"},
    {"\\bargovia\\b", "ag"},
    {"\\bargovie\\b", "ag"},
    {"\\bdixieme\\b", "x"},
    {"\\bfriburg\\b", "fr"},
    {"\\bginevra\\b", "ge"},
    {"\\bglarona\\b", "gl"},
    {"\\bgrisons\\b", "gr"},
    {"\\blucerna\\b", "lu"},
    {"\\blucerne\\b", "lu"},
    {"\\bnidwald\\b", "nw"},
    {"\\bobvaldo\\b", "ow"},
    {"\\bonzieme\\b", "11"},
    {"\\bschweiz\\b", "ch"},
    {"\\bschwytz\\b", "sz"},
    {"\\bsixieme\\b", "6"},
    {"\\bsoletta\\b", "so"},
    {"\\bsoleure\\b", "so"},
    {"\\bst\\s+gall\\b", "sg"},
    {"\\bthurgau\\b", "tg"},
    {"\\bturicum\\b", "zh"},
    {"\\bvallais\\b", "vs"},
    {"\\bvallese\\b", "vs"},
    {"\\bzuerich\\b", "zh"},
    {"\\baargau\\b", "ag"},
    {"\\bbienna\\b", "biel"},
    {"\\bbienne\\b", "biel"},
    {"\\bbrigue\\b", "brig"},
    {"\\bgeneva\\b", "ge"},
    {"\\bgeneve\\b", "ge"},
    {"\\bglaris\\b", "gl"},
    {"\\bglarus\\b", "gl"},
    {"\\blaufon\\b", "laufen"},
    {"\\bluzern\\b", "lu"},
    {"\\bobwald\\b", "ow"},
    {"\\bregion\\b", ""},
    {"\\bsainte\\b", ""},
    {"\\bschwyz\\b", "sz"},
    {"\\bsvitto\\b", "sz"},
    {"\\btessin\\b", "ti"},
    {"\\bthoune\\b", "thun"},
    {"\\bticino\\b", "ti"},
    {"\\bvalais\\b", "vs"},
    {"\\bwallis\\b", "vs"},
    {"\\bzurich\\b", "zh"},
    {"\\bzurigo\\b", "zh"},
    {"\\baaray\\b", "aarau"},
    {"\\bberna\\b", "be"},
    {"\\bberne\\b", "be"},
    {"\\bbriga\\b", "brig"},
    {"\\bde\\s+l\'\\b", ""},
    {"\\bde\\s+la\\b", ""},
    {"\\bet\\s+du\\b", ""},
    {"\\bgiura\\b", "ju"},
    {"\\bmount\\b", "mt"},
    {"\\bnorth\\b", "n"},
    {"\\bouest\\b", "o"},
    {"\\bsaint\\b", ""},
    {"\\bsouth\\b", "s"},
    {"\\bstadt\\b", ""},
    {"\\bviege\\b", "visp"},
    {"\\bwaadt\\b", "vd"},
    {"\\bxviii\\b", "18"},
    {"\\bbern\\b", "be"},
    {"\\bgenf\\b", "ge"},
    {"\\bieme\\b", ""},
    {"\\bjura\\b", "ju"},
    {"\\bnord\\b", "n"},
    {"\\bstad\\b", ""},
    {"\\bvaud\\b", "vd"},
    {"\\bviii\\b", "8"},
    {"\\bwest\\b", "o"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bzoug\\b", "zg"},
    {"\\bzugo\\b", "zg"},
    {"\\bdes\\b", ""},
    {"\\beme\\b", ""},
    {"\\bere\\b", ""},
    {"\\best\\b", ""},
    {"\\biii\\b", "3"},
    {"\\bles\\b", ""},
    {"\\bmte\\b", "mt"},
    {"\\bste\\b", ""},
    {"\\bsud\\b", "s"},
    {"\\bsur\\b", ""},
    {"\\buri\\b", "ur"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxix\\b", "19"},
    {"\\bxvi\\b", "16"},
    {"\\bzug\\b", "zg"},
    {"\\b10\\b", "x"},
    {"\\bd\'\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\ben\\b", ""},
    {"\\ber\\b", ""},
    {"\\bii\\b", "2"},
    {"\\bin\\b", ""},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bl\'\\b", ""},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\bnd\\b", ""},
    {"\\bof\\b", ""},
    {"\\brd\\b", ""},
    {"\\bre\\b", ""},
    {"\\bst\\b", ""},
    {"\\bth\\b", ""},
    {"\\bvi\\b", "6"},
    {"\\bxi\\b", "11"},
    {"\\bxv\\b", "15"},
    {"\\bxx\\b", "20"},
    {"\\be\\b", ""},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
    {"\\bw\\b", "o"},
};

const Rule kRules_CL[] = {
    {"\\baisen\\s+del\\s+general\\s+carlos\\s+ibanez\\s+del\\s+campo\\b", "11"},
    {"\\blibertador\\s+general\\s+bernardo\\s+o\'higgins\\b", "6"},
    {"\\bmetropolitana\\s+de\\s+santiago\\s+de\\s+chile\\b", "rm"},
    {"\\bmagallanes\\s+y\\s+la\\s+antartica\\s+chilena\\b", "12"},
    {"\\bmetropolitana\\s+de\\s+santiago\\b", "rm"},
    {"\\barica\\s+y\\s+parinacota\\b", "15"},
    {"\\bmetropolitana\\b", "rm"},
    {"\\bla\\s+araucania\\b", "9"},
    {"\\bantofagasta\\b", "2"},
    {"\\bvalparaiso\\b", "5"},
    {"\\blos\\s+lagos\\b", "x"},
    {"\\bcoquimbo\\b", "4"},
    {"\\blos\\s+rios\\b", "14"},
    {"\\btarapaca\\b", "1"},
    {"\\batacama\\b", "3"},
    {"\\bbio\\s+bio\\b", "8"},
    {"\\bchile\\b", "cl"},
    {"\\bmaule\\b", "7"},
    {"\\bviii\\b", "8"},
    {"\\biii\\b", "3"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\b10\\b", "x"},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bvi\\b", "6"},
    {"\\bxi\\b", "11"},
    {"\\bxv\\b", "15"},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
};

const Rule kRules_CO[] = {
    {"\\bcolombia\\b", "co"},
    {"\\bcolumbia\\b", "co"},
};

const Rule kRules_DE[] = {
    {"\\bfederal\\s+republic\\s+of\\s+germany\\b", "de"},
    {"\\bbundesrepublik\\s+deutschland\\b", "de"},
    {"\\bfreie\\s+hansestadt\\s+bremen\\b", "hb"},
    {"\\bmecklenburg\\s+vorpommern\\b", "mv"},
    {"\\bnorth\\s+rhine\\s+westphalia\\b", "nw"},
    {"\\brhineland\\s+palatinate\\b", "rp"},
    {"\\bnordrhein\\s+westfalen\\b", "nw"},
    {"\\bschleswig\\s+holstein\\b", "sh"},
    {"\\bbaden\\s+wurttemberg\\b", "bw"},
    {"\\bregionalverband\\b", ""},
    {"\\brheinland\\s+pfalz\\b", "rp"},
    {"\\bsachsen\\s+anhalt\\b", "st"},
    {"\\bniedersachsen\\b", "ni"},
    {"\\bsaxony\\s+anhalt\\b", "st"},
    {"\\blower\\s+saxony\\b", "ni"},
    {"\\bstadtverband\\b", ""},
    {"\\bbrandenburg\\b", "bb"},
    {"\\bdeutschland\\b", "de"},
    {"\\blandkreis\\b", ""},
    {"\\bthuringen\\b", "th"},
    {"\\bthuringia\\b", "th"},
    {"\\bsaarland\\b", "sl"},
    {"\\bbavaria\\b", "by"},
    {"\\bcologne\\b", "koln"},
    {"\\bgermany\\b", "de"},
    {"\\bhamburg\\b", "hh"},
    {"\\bsachsen\\b", "sn"},
    {"\\bstrasse\\b", "str"},
    {"\\bbayern\\b", "by"},
    {"\\bberlin\\b", "be"},
    {"\\bbremen\\b", "hb"},
    {"\\bhessen\\b", "he"},
    {"\\bsaxony\\b", "sn"},
    {"\\bsudost\\b", "se"},
    {"\\bhesse\\b", "he"},
    {"\\bsankt\\b", "st"},
    {"\\bstadt\\b", ""},
    {"\\bnord\\b", "n"},
    {"\\bwest\\b", "w"},
    {"\\bost\\b", "o"},
    {"\\bsud\\b", "s"},
};

const Rule kRules_DK[] = {
    {"\\bgrabrodrestraede\\b", "grabrodrestr"},
    {"\\barnold\\s+nielsens\\b", "arn nielsens"},
    {"\\bhaveforeningen\\b", "haveforening"},
    {"\\bmunicipality\\b", ""},
    {"\\bbispebjergs\\b", "bispebjerg"},
    {"\\btengslemark\\b", "tengslemrk"},
    {"\\bboulevard\\b", "boul"},
    {"\\blillerod\\b", "allerod"},
    {"\\bdanmark\\b", "dk"},
    {"\\bdenmark\\b", "dk"},
    {"\\bkommune\\b", ""},
    {"\\bkvarter\\b", "kvater"},
    {"\\bpladsen\\b", "plads"},
    {"\\bboulev\\b", "boul"},
    {"\\bgammel\\b", "gl"},
    {"\\blokken\\b", "lokke"},
    {"\\bnummer\\b", "nr"},
    {"\\bsondre\\b", "s"},
    {"\\bgamle\\b", "gl"},
    {"\\bnorre\\b", "n"},
    {"\\bsankt\\b", "sct"},
    {"\\bnord\\b", "n"},
    {"\\bvest\\b", "v"},
    {"\\bndr\\b", "n"},
    {"\\bost\\b", "o"},
    {"\\bsdr\\b", "s"},
    {"\\bskt\\b", "sct"},
    {"\\bsyd\\b", "s"},
};

const Rule kRules_ES[] = {
    {"\\bsanta\\s+cruz\\s+de\\s+tenerife\\b", "tf"},
    {"\\bbalearic\\s+islands\\b", "pm"},
    {"\\bislas\\s+baleares\\b", "pm"},
    {"\\billes\\s+balears\\b", "pm"},
    {"\\bciudad\\s+real\\b", "cr"},
    {"\\bguadalajara\\b", "gu"},
    {"\\bla\\s+corunna\\b", "c"},
    {"\\bla\\s+corunya\\b", "c"},
    {"\\blas\\s+palmas\\b", "gc"},
    {"\\bpontevedra\\b", "po"},
    {"\\bvalladolid\\b", "va"},
    {"\\bbarcelona\\b", "b"},
    {"\\bcantabria\\b", "s"},
    {"\\bcastellon\\b", "cs"},
    {"\\besplugues\\b", "esplugas"},
    {"\\bguipuscoa\\b", "ss"},
    {"\\bguipuzcoa\\b", "ss"},
    {"\\bla\\s+coruna\\b", "c"},
    {"\\bsalamanca\\b", "sa"},
    {"\\bsaragossa\\b", "z"},
    {"\\btarragona\\b", "t"},
    {"\\ba\\s+coruna\\b", "c"},
    {"\\balbacete\\b", "ab"},
    {"\\balicante\\b", ""},
    {"\\basturias\\b", "o"},
    {"\\bcastello\\b", "cs"},
    {"\\bgipuzkoa\\b", "ss"},
    {"\\bla\\s+rioja\\b", "lo"},
    {"\\bnafarroa\\b", "na"},
    {"\\bpalencia\\b", "p"},
    {"\\bvalencia\\b", "v"},
    {"\\bzaragoza\\b", "z"},
    {"\\balacant\\b", ""},
    {"\\balmeria\\b", ""},
    {"\\bavenida\\b", "av"},
    {"\\bbadajoz\\b", "ba"},
    {"\\bbizkaia\\b", "bi"},
    {"\\bcaceres\\b", "cc"},
    {"\\bcordoba\\b", "co"},
    {"\\bcordova\\b", "co"},
    {"\\bgranada\\b", "gr"},
    {"\\bnavarra\\b", "na"},
    {"\\bnavarre\\b", "na"},
    {"\\bourense\\b", "or"},
    {"\\bsegovia\\b", "sg"},
    {"\\bsevilla\\b", "se"},
    {"\\bseville\\b", "se"},
    {"\\bvizcaya\\b", "bi"},
    {"\\bbiscay\\b", "bi"},
    {"\\bburgos\\b", "bu"},
    {"\\bcoruna\\b", "c"},
    {"\\bcuenca\\b", "cu"},
    {"\\bespana\\b", "es"},
    {"\\bgerona\\b", "gi"},
    {"\\bgirona\\b", "gi"},
    {"\\bhuelva\\b", "h"},
    {"\\bhuesca\\b", "hu"},
    {"\\blerida\\b", ""},
    {"\\blleida\\b", ""},
    {"\\bmadrid\\b", "m"},
    {"\\bmalaga\\b", "ma"},
    {"\\bmurcia\\b", "mu"},
    {"\\borense\\b", "or"},
    {"\\bteruel\\b", "te"},
    {"\\btoledo\\b", "to"},
    {"\\bzamora\\b", "za"},
    {"\\balava\\b", "vi"},
    {"\\baraba\\b", "vi"},
    {"\\bavila\\b", "av"},
    {"\\bcadiz\\b", "ca"},
    {"\\bnorte\\b", "n"},
    {"\\bnorth\\b", "n"},
    {"\\boeste\\b", "o"},
    {"\\bsoria\\b", "so"},
    {"\\bsouth\\b", "s"},
    {"\\bspain\\b", "es"},
    {"\\beast\\b", "e"},
    {"\\beste\\b", "e"},
    {"\\bjaen\\b", "j"},
    {"\\bleon\\b", "le"},
    {"\\blugo\\b", "lu"},
    {"\\bwest\\b", "o"},
    {"\\bc\\.\\/\\b", "c"},
    {"\\bc\\/\\.\\b", "c"},
    {"\\bdal\\b", ""},
    {"\\bdel\\b", ""},
    {"\\blas\\b", ""},
    {"\\bles\\b", ""},
    {"\\blos\\b", ""},
    {"\\bsur\\b", "s"},
    {"\\bal\\b", ""},
    {"\\bc\\/\\b", "c"},
    {"\\bde\\b", ""},
    {"\\bel\\b", ""},
    {"\\ben\\b", ""},
    {"\\bla\\b", ""},
    {"\\bof\\b", ""},
    {"\\ba\\b", ""},
    {"\\bd\\b", ""},
    {"\\bl\\b", ""},
};

const Rule kRules_FR[] = {
    {"\\bprovence\\s+alpes\\s+cote\\s+d\\s+azur\\b", "u"},
    {"\\balpes\\s+de\\s+haute\\s+provence\\b", "04"},
    {"\\barnouville\\s+les\\s+gonesse\\b", "arnouville"},
    {"\\bterritoire\\s+de\\s+belfort\\b", "90"},
    {"\\blanguedoc\\s+roussillon\\b", "k"},
    {"\\bpyrenees\\s+atlantiques\\b", "64"},
    {"\\bpyrenees\\s+orientales\\b", "66"},
    {"\\bmeurthe\\s+et\\s+moselle\\b", "54"},
    {"\\bnord\\s+pas\\s+de\\s+calais\\b", "o"},
    {"\\bchampagne\\s+ardenne\\b", "g"},
    {"\\bcharente\\s+maritime\\b", "17"},
    {"\\bseine\\s+saint\\s+denis\\b", "93"},
    {"\\bbouches\\s+du\\s+rhone\\b", "13"},
    {"\\bloire\\s+atlantique\\b", "44"},
    {"\\bpays\\s+de\\s+la\\s+loire\\b", "r"},
    {"\\bpoitou\\s+charentes\\b", "t"},
    {"\\balpes\\s+maritimes\\b", "06"},
    {"\\bbasse\\s+normandie\\b", "p"},
    {"\\bhaute\\s+normandie\\b", "q"},
    {"\\bille\\s+et\\s+vilaine\\b", "35"},
    {"\\btarn\\s+et\\s+garonne\\b", "82"},
    {"\\bdepartementale\\b", "d"},
    {"\\bhaute\\s+pyrenees\\b", "65"},
    {"\\bhauts\\s+de\\s+seine\\b", "92"},
    {"\\bindre\\s+et\\s+loire\\b", "37"},
    {"\\blot\\s+et\\s+garonne\\b", "47"},
    {"\\blower\\s+normandy\\b", "p"},
    {"\\bmaine\\s+et\\s+loire\\b", "49"},
    {"\\bsaone\\s+et\\s+loire\\b", "71"},
    {"\\bseine\\s+maritime\\b", "76"},
    {"\\bupper\\s+normandy\\b", "q"},
    {"\\bcotes\\s+d\\s+armor\\b", "22"},
    {"\\bdepartemental\\b", "d"},
    {"\\bfranche\\s+comte\\b", "1"},
    {"\\bhaute\\s+garonne\\b", "31"},
    {"\\bile\\s+de\\s+france\\b", "j"},
    {"\\bmidi\\s+pyrenees\\b", "n"},
    {"\\bpas\\s+de\\s+calais\\b", "62"},
    {"\\bseine\\s+et\\s+mame\\b", "77"},
    {"\\bcorse\\s+du\\s+sud\\b", "2a"},
    {"\\bdix\\s+huitieme\\b", "18"},
    {"\\bdix\\s+neuvieme\\b", "19"},
    {"\\bdix\\s+septieme\\b", "17"},
    {"\\beure\\s+et\\s+loir\\b", "28"},
    {"\\bhaute\\s+savoie\\b", "74"},
    {"\\bhaute\\s+vienne\\b", "87"},
    {"\\bloir\\s+et\\s+cher\\b", "41"},
    {"\\bval\\s+de\\s+marne\\b", "94"},
    {"\\bcouffouleux\\b", "coufouleux"},
    {"\\bdeux\\s+sevres\\b", "79"},
    {"\\bhaute\\s+alpes\\b", "05"},
    {"\\bhaute\\s+corse\\b", "2b"},
    {"\\bhaute\\s+loire\\b", "43"},
    {"\\bhaute\\s+marne\\b", "52"},
    {"\\bhaute\\s+saone\\b", "70"},
    {"\\bpuy\\s+de\\s+dome\\b", "63"},
    {"\\bquatorzieme\\b", "14"},
    {"\\brhone\\s+alpes\\b", "5"},
    {"\\bacquitaine\\b", "b"},
    {"\\benclave\\s+de\\b", ""},
    {"\\bval\\s+d\\s+oise\\b", "95"},
    {"\\baquitaine\\b", "b"},
    {"\\bboulevard\\b", "bd"},
    {"\\bbourgogne\\b", "d"},
    {"\\bcinquieme\\b", "5"},
    {"\\bcote\\s+d\\s+or\\b", "21"},
    {"\\bfinistere\\b", "29"},
    {"\\bhaut\\s+rhin\\b", "68"},
    {"\\bmoribihan\\b", "56"},
    {"\\bnationale\\b", "n"},
    {"\\bquatrieme\\b", "4"},
    {"\\bquinzieme\\b", "15"},
    {"\\btreizieme\\b", "13"},
    {"\\btroisieme\\b", "3"},
    {"\\bvingtieme\\b", "20"},
    {"\\ballemont\\b", "allemond"},
    {"\\bardennes\\b", "08"},
    {"\\bauvergne\\b", "c"},
    {"\\baveryron\\b", "12"},
    {"\\bbas\\s+rhin\\b", "67"},
    {"\\bbretagne\\b", ""},
    {"\\bbrittany\\b", ""},
    {"\\bburgundy\\b", "d"},
    {"\\bcalvados\\b", "14"},
    {"\\bcharente\\b", "16"},
    {"\\bdeuxieme\\b", "2"},
    {"\\bdordogne\\b", "24"},
    {"\\bdouzieme\\b", "12"},
    {"\\bhuitieme\\b", "8"},
    {"\\bla\\s+croix\\b", "lacroix"},
    {"\\blimousin\\b", "l"},
    {"\\blorraine\\b", "m"},
    {"\\bneuvieme\\b", "9"},
    {"\\bpicardie\\b", "s"},
    {"\\bpremiere\\b", "1"},
    {"\\bseizieme\\b", "16"},
    {"\\bseptieme\\b", "7"},
    {"\\bvaucluse\\b", "84"},
    {"\\byvelines\\b", "78"},
    {"\\bardeche\\b", "07"},
    {"\\bcorreze\\b", "19"},
    {"\\bcorsica\\b", "h"},
    {"\\bdixieme\\b", "x"},
    {"\\bessonne\\b", "91"},
    {"\\bgironde\\b", "33"},
    {"\\bherault\\b", "34"},
    {"\\bmayenne\\b", "53"},
    {"\\bmoselle\\b", "57"},
    {"\\bonzieme\\b", "11"},
    {"\\bpicardy\\b", "s"},
    {"\\bsixieme\\b", "6"},
    {"\\ballier\\b", "03"},
    {"\\balsace\\b", "a"},
    {"\\bariege\\b", "09"},
    {"\\bavenue\\b", "ave"},
    {"\\bcantal\\b", "15"},
    {"\\bcentre\\b", "f"},
    {"\\bcreuse\\b", "23"},
    {"\\bfrance\\b", "fr"},
    {"\\bgrande\\b", "gd"},
    {"\\blandes\\b", "40"},
    {"\\bloiret\\b", "45"},
    {"\\blozere\\b", "48"},
    {"\\bmanche\\b", "50"},
    {"\\bnievre\\b", "58"},
    {"\\bregion\\b", ""},
    {"\\bsainte\\b", ""},
    {"\\bsarthe\\b", "72"},
    {"\\bsavoie\\b", "73"},
    {"\\bvendee\\b", "85"},
    {"\\bvienne\\b", "86"},
    {"\\bvosges\\b", "88"},
    {"\\baisne\\b", "02"},
    {"\\bcorse\\b", "h"},
    {"\\bde\\s+l\'\\b", ""},
    {"\\bde\\s+la\\b", ""},
    {"\\bdoubs\\b", "25"},
    {"\\bdrome\\b", "26"},
    {"\\bet\\s+du\\b", ""},
    {"\\bgrand\\b", "gd"},
    {"\\bindre\\b", "36"},
    {"\\bisere\\b", "38"},
    {"\\bloire\\b", "42"},
    {"\\bmarne\\b", "51"},
    {"\\bmeuse\\b", "55"},
    {"\\bmount\\b", "mt"},
    {"\\bnorth\\b", "n"},
    {"\\bouest\\b", "o"},
    {"\\bparis\\b", ""},
    {"\\brhone\\b", "69"},
    {"\\bsaint\\b", ""},
    {"\\bsomme\\b", "80"},
    {"\\bsouth\\b", "s"},
    {"\\bvilla\\b", "vil"},
    {"\\bxviii\\b", "18"},
    {"\\byonne\\b", "89"},
    {"\\baude\\b", "11"},
    {"\\bcher\\b", "18"},
    {"\\beure\\b", "27"},
    {"\\bgard\\b", "30"},
    {"\\bgers\\b", "32"},
    {"\\bieme\\b", ""},
    {"\\bjura\\b", "39"},
    {"\\bnord\\b", "n"},
    {"\\boise\\b", "60"},
    {"\\borne\\b", "61"},
    {"\\btarn\\b", "81"},
    {"\\bviii\\b", "8"},
    {"\\bwest\\b", "o"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bain\\b", "01"},
    {"\\bdes\\b", ""},
    {"\\beme\\b", ""},
    {"\\bere\\b", ""},
    {"\\best\\b", ""},
    {"\\bgde\\b", "gd"},
    {"\\biii\\b", "3"},
    {"\\bles\\b", ""},
    {"\\blot\\b", "46"},
    {"\\bmte\\b", "mt"},
    {"\\bste\\b", ""},
    {"\\bsud\\b", "s"},
    {"\\bsur\\b", ""},
    {"\\bvar\\b", "83"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxix\\b", "19"},
    {"\\bxvi\\b", "16"},
    {"\\b10\\b", "x"},
    {"\\b59\\b", "n"},
    {"\\b75\\b", ""},
    {"\\bd\'\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\ben\\b", ""},
    {"\\ber\\b", ""},
    {"\\bgr\\b", "gd"},
    {"\\bii\\b", "2"},
    {"\\bin\\b", ""},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bl\'\\b", ""},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\bnd\\b", ""},
    {"\\bof\\b", ""},
    {"\\brd\\b", ""},
    {"\\bre\\b", ""},
    {"\\bst\\b", ""},
    {"\\bth\\b", ""},
    {"\\bvi\\b", "6"},
    {"\\bxi\\b", "11"},
    {"\\bxv\\b", "15"},
    {"\\bxx\\b", "20"},
    {"\\be\\b", ""},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
    {"\\bw\\b", "o"},
};

const Rule kRules_GB[] = {
    {"\\bbath\\s+and\\s+north\\s+east\\s+somerset\\b", "gb-bas"},
    {"\\bdungannon\\s+and\\s+south\\s+tyrone\\b", "gb-dgn"},
    {"\\bcheshire\\s+west\\s+and\\s+chester\\b", "gb-chw"},
    {"\\bnewry\\s+and\\s+mourne\\s+district\\b", "gb-nym"},
    {"\\beast\\s+riding\\s+of\\s+yorkshire\\b", "gb-ery"},
    {"\\bmetropolitan\\s+borough\\s+of\\b", ""},
    {"\\bnorth\\s+east\\s+lincolnshire\\b", "gb-nel"},
    {"\\bhammersmith\\s+and\\s+fulham\\b", "gb-hmf"},
    {"\\bkensington\\s+and\\s+chelsea\\b", "gb-kec"},
    {"\\bwindsor\\s+and\\s+maidenhead\\b", "gb-wnm"},
    {"\\bblackburn\\s+with\\s+darwen\\b", "gb-bbd"},
    {"\\bdumfries\\s+and\\s+galloway\\b", "gb-dgy"},
    {"\\bsouth\\s+gloucestershire\\b", "gb-sgc"},
    {"\\bthe\\s+vale\\s+of\\s+glamorgan\\b", "gb-vgl"},
    {"\\bbarking\\s+and\\s+dagenham\\b", "gb-bdg"},
    {"\\bcentral\\s+bedfordshire\\b", "gb-cbf"},
    {"\\bkingston\\s+upon\\s+thames\\b", "gb-ktt"},
    {"\\bredcar\\s+and\\s+cleveland\\b", "gb-rcc"},
    {"\\brhondda\\,\\s+cynon\\,\\s+taff\\b", "gb-rct"},
    {"\\brichmond\\s+upon\\s+thames\\b", "gb-ric"},
    {"\\bthe\\s+scottish\\s+borders\\b", "gb-scb"},
    {"\\beast\\s+dunbartonshire\\b", "gb-edu"},
    {"\\bnewcastle\\s+upon\\s+tyne\\b", "gb-net"},
    {"\\bwest\\s+dunbartonshire\\b", "gb-wdu"},
    {"\\bkingston\\s+upon\\s+hull\\b", "gb-khl"},
    {"\\bliverpool\\s+district\\b", "gb-liv"},
    {"\\bnorth\\s+lincolnshire\\b", "gb-nln"},
    {"\\btelford\\s+and\\s+wrekin\\b", "gb-tfw"},
    {"\\bbrighton\\s+and\\s+hove\\b", "gb-bnh"},
    {"\\bcity\\s+of\\s+edinburgh\\b", "gb-edh"},
    {"\\beast\\s+renfrewshire\\b", "gb-erw"},
    {"\\bkirklees\\s+district\\b", "gb-kir"},
    {"\\blondon\\s+borough\\s+of\\b", ""},
    {"\\bneath\\s+port\\s+talbot\\b", "gb-ntl"},
    {"\\bnorth\\s+lanarkshire\\b", "gb-nlk"},
    {"\\bperth\\s+and\\s+kinross\\b", "gb-pkn"},
    {"\\bsouth\\s+lanarkshire\\b", "gb-slk"},
    {"\\bbracknell\\s+forest\\b", "gb-brc"},
    {"\\bclackmannanshire\\b", "gb-clk"},
    {"\\bisle\\s+of\\s+anglesey\\b", "gb-agy"},
    {"\\bnorthamptonshire\\b", "gb-nth"},
    {"\\bnorthern\\s+ireland\\b", "n.i."},
    {"\\bshetland\\s+islands\\b", "gb-zet"},
    {"\\bstockton\\-on\\-tees\\b", "gb-stt"},
    {"\\bargyll\\s+and\\s+bute\\b", "gb-agb"},
    {"\\bbuckinghamshire\\b", "gb-bkm"},
    {"\\bcarmarthenshire\\b", "gb-cmn"},
    {"\\bcity\\s+of\\s+bristol\\b", "gb-bst"},
    {"\\bgloucestershire\\b", "gb-gls"},
    {"\\bnorth\\s+yorkshire\\b", "gb-nyk"},
    {"\\bnottinghamshire\\b", "gb-ntt"},
    {"\\bsefton\\s+district\\b", "gb-sft"},
    {"\\bsouthend\\-on\\-sea\\b", "gb-sos"},
    {"\\bcambridgeshire\\b", "gb-cam"},
    {"\\bcity\\s+of\\s+london\\b", "gb-lnd"},
    {"\\bleeds\\s+district\\b", "gb-lds"},
    {"\\bleicestershire\\b", "gb-lec"},
    {"\\bmerthyr\\s+tydfil\\b", "gb-mty"},
    {"\\bnorth\\s+ayrshire\\b", "gb-nay"},
    {"\\bnorth\\s+somerset\\b", "gb-nsm"},
    {"\\bnorth\\s+tyneside\\b", "gb-nty"},
    {"\\bnorthumberland\\b", "gb-nbl"},
    {"\\borkney\\s+islands\\b", "gb-ork"},
    {"\\bsouth\\s+ayrshire\\b", "gb-say"},
    {"\\bsouth\\s+tyneside\\b", "gb-sty"},
    {"\\bstoke\\-on\\-trent\\b", "gb-ste"},
    {"\\bwaltham\\s+forest\\b", "gb-wft"},
    {"\\bwest\\s+berkshire\\b", "gb-wbk"},
    {"\\bworcestershire\\b", "gb-wor"},
    {"\\baberdeen\\s+city\\b", "gb-abe"},
    {"\\baberdeenshire\\b", "gb-abd"},
    {"\\bblaenau\\s+gwent\\b", "gb-bgw"},
    {"\\bcarrickfergus\\b", "gb-ckf"},
    {"\\bcheshire\\s+east\\b", "gb-che"},
    {"\\bcounty\\s+durham\\b", "gb-dur"},
    {"\\beast\\s+ayrshire\\b", "gb-eay"},
    {"\\bherefordshire\\b", "gb-hef"},
    {"\\bhertfordshire\\b", "gb-hrt"},
    {"\\bisle\\s+of\\s+wight\\b", "gb-iow"},
    {"\\bmiddlesbrough\\b", "gb-mdb"},
    {"\\bmilton\\s+keynes\\b", "gb-mik"},
    {"\\bmonmouthshire\\b", "gb-mon"},
    {"\\bpembrokeshire\\b", "gb-pem"},
    {"\\bstaffordshire\\b", "gb-sts"},
    {"\\btower\\s+hamlets\\b", "gb-twh"},
    {"\\bwolverhampton\\b", "gb-wlv"},
    {"\\bdenbighshire\\b", "gb-den"},
    {"\\beast\\s+lothian\\b", "gb-eln"},
    {"\\bfulmodestone\\b", "fulmodeston"},
    {"\\bglasgow\\s+city\\b", "gb-glg"},
    {"\\blincolnshire\\b", "gb-lin"},
    {"\\bnewtownabbey\\b", "gb-nta"},
    {"\\bpeterborough\\b", "gb-pte"},
    {"\\brenfrewshire\\b", "gb-rfw"},
    {"\\bwarwickshire\\b", "gb-war"},
    {"\\bwest\\s+lothian\\b", "gb-wln"},
    {"\\bbournemouth\\b", "gb-bmh"},
    {"\\bcastlereagh\\b", "gb-csr"},
    {"\\bdundee\\s+city\\b", "gb-dnd"},
    {"\\bdunnamanagh\\b", "dunamanagh"},
    {"\\beast\\s+sussex\\b", "gb-esx"},
    {"\\beilean\\s+siar\\b", "gb-els"},
    {"\\bking\'s\\s+stag\\b", "king stag"},
    {"\\bmagherafelt\\b", "gb-mft"},
    {"\\boxfordshire\\b", "gb-oxf"},
    {"\\bsouthampton\\b", "gb-sth"},
    {"\\bwest\\s+sussex\\b", "gb-wsx"},
    {"\\bwestminster\\b", "gb-wsm"},
    {"\\bballymoney\\b", "gb-bly"},
    {"\\bbirmingham\\b", "gb-bir"},
    {"\\bborough\\s+of\\b", ""},
    {"\\bcaerphilly\\b", "gb-cay"},
    {"\\bcalderdale\\b", "gb-cld"},
    {"\\bceredigion\\b", "gb-cgn"},
    {"\\bculnacnock\\b", "culnacnoc"},
    {"\\bdarlington\\b", "gb-dal"},
    {"\\bderbyshire\\b", "gb-dby"},
    {"\\bflintshire\\b", "gb-fln"},
    {"\\bgroesllwyd\\b", "groes-lwyd"},
    {"\\bhartlepool\\b", "gb-hpl"},
    {"\\bhillingdon\\b", "gb-hil"},
    {"\\binverclyde\\b", "gb-ivc"},
    {"\\blancashire\\b", "gb-lan"},
    {"\\bmanchester\\b", "gb-man"},
    {"\\bmidlothian\\b", "gb-mln"},
    {"\\bn\\.\\s+ireland\\b", "n.i."},
    {"\\bnorth\\s+down\\b", "gb-ndn"},
    {"\\bnottingham\\b", "gb-ngm"},
    {"\\bportsmouth\\b", "gb-por"},
    {"\\bshropshire\\b", "gb-shr"},
    {"\\bst\\.\\s+helens\\b", "gb-shn"},
    {"\\bsunderland\\b", "gb-snd"},
    {"\\bwandsworth\\b", "gb-wnd"},
    {"\\bwarrington\\b", "gb-wrt"},
    {"\\bballymena\\b", "gb-bla"},
    {"\\bbanbridge\\b", "gb-bnb"},
    {"\\bblackpool\\b", "gb-bpl"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcoleraine\\b", "gb-clr"},
    {"\\bcookstown\\b", "gb-ckt"},
    {"\\bcraigavon\\b", "gb-cgv"},
    {"\\bdoncaster\\b", "gb-dnc"},
    {"\\bfermanagh\\b", "gb-fer"},
    {"\\bgateshead\\b", "gb-gat"},
    {"\\bgreenwich\\b", "gb-gre"},
    {"\\bhampshire\\b", "gb-ham"},
    {"\\bislington\\b", "gb-isl"},
    {"\\bleicester\\b", "gb-lce"},
    {"\\bn\\s+ireland\\b", "n.i."},
    {"\\bn\\.ireland\\b", "n.i."},
    {"\\bredbridge\\b", "gb-rdb"},
    {"\\brotherham\\b", "gb-rot"},
    {"\\bsheffield\\b", "gb-shf"},
    {"\\bsouthwark\\b", "gb-swk"},
    {"\\bstockport\\b", "gb-skp"},
    {"\\bwakefield\\b", "gb-wkf"},
    {"\\bwiltshire\\b", "gb-wil"},
    {"\\bwokingham\\b", "gb-wok"},
    {"\\bbarnsley\\b", "gb-bns"},
    {"\\bbradford\\b", "gb-brd"},
    {"\\bbridgend\\b", "gb-bge"},
    {"\\bcheshire\\b", "gb-chs"},
    {"\\bcornwall\\b", "gb-con"},
    {"\\bcoventry\\b", "gb-cov"},
    {"\\bcrescent\\b", "cres"},
    {"\\bdistrict\\b", ""},
    {"\\bhare\\s+law\\b", "harelaw"},
    {"\\bharingey\\b", "gb-hry"},
    {"\\bhavering\\b", "gb-hav"},
    {"\\bhighland\\b", "gb-hld"},
    {"\\bhounslow\\b", "gb-hns"},
    {"\\bknowsley\\b", "gb-kwl"},
    {"\\blewisham\\b", "gb-lew"},
    {"\\blimavady\\b", "gb-lmv"},
    {"\\bplymouth\\b", "gb-ply"},
    {"\\brochdale\\b", "gb-rch"},
    {"\\bsandwell\\b", "gb-saw"},
    {"\\bscotland\\b", "gb-sct"},
    {"\\bsolihull\\b", "gb-sol"},
    {"\\bsomerset\\b", "gb-som"},
    {"\\bstirling\\b", "gb-stg"},
    {"\\bstrabane\\b", "gb-stb"},
    {"\\btameside\\b", "gb-tam"},
    {"\\bthurrock\\b", "gb-thr"},
    {"\\btrafford\\b", "gb-trf"},
    {"\\bbedford\\b", "gb-bdf"},
    {"\\bbelfast\\b", "gb-bfs"},
    {"\\bbromley\\b", "gb-bry"},
    {"\\bcardiff\\b", "gb-crf"},
    {"\\bcity\\s+of\\b", ""},
    {"\\bcroydon\\b", "gb-cry"},
    {"\\bcumbria\\b", "gb-cma"},
    {"\\benfield\\b", "gb-enf"},
    {"\\bengland\\b", "eng"},
    {"\\bfalkirk\\b", "gb-fal"},
    {"\\bgwynedd\\b", "gb-gwn"},
    {"\\bhackney\\b", "gb-hck"},
    {"\\bhighway\\b", "hwy"},
    {"\\blambeth\\b", "gb-lbh"},
    {"\\blisburn\\b", "gb-lsb"},
    {"\\bnewport\\b", "gb-nwp"},
    {"\\bnorfolk\\b", "gb-nfk"},
    {"\\bparkway\\b", "pkwy"},
    {"\\breading\\b", "gb-rdg"},
    {"\\brutland\\b", "gb-rut"},
    {"\\bsalford\\b", "gb-slf"},
    {"\\bsuffolk\\b", "gb-sfk"},
    {"\\bswansea\\b", "gb-swa"},
    {"\\bswindon\\b", "gb-swd"},
    {"\\btorfaen\\b", "gb-tof"},
    {"\\bwalsall\\b", "gb-wll"},
    {"\\bwrexham\\b", "gb-wrx"},
    {"\\bavenue\\b", "ave"},
    {"\\bcommon\\b", "comm"},
    {"\\bgb\\-ans\\b", "angus"},
    {"\\bgb\\-ant\\b", "antrim"},
    {"\\bgb\\-ard\\b", "ards"},
    {"\\bgb\\-arm\\b", "armagh"},
    {"\\bgb\\-ben\\b", "brent"},
    {"\\bgb\\-bex\\b", "bexley"},
    {"\\bgb\\-bne\\b", "barnet"},
    {"\\bgb\\-bol\\b", "bolton"},
    {"\\bgb\\-bur\\b", "bury"},
    {"\\bgb\\-cmd\\b", "camden"},
    {"\\bgb\\-cwy\\b", "conwy"},
    {"\\bgb\\-der\\b", "derby"},
    {"\\bgb\\-dev\\b", "devon"},
    {"\\bgb\\-dor\\b", "dorset"},
    {"\\bgb\\-dow\\b", "down"},
    {"\\bgb\\-dry\\b", "derry"},
    {"\\bgb\\-dud\\b", "dudley"},
    {"\\bgb\\-eal\\b", "ealing"},
    {"\\bgb\\-eng\\b", "eng"},
    {"\\bgb\\-ess\\b", "essex"},
    {"\\bgb\\-fif\\b", "fife"},
    {"\\bgb\\-ken\\b", "kent"},
    {"\\bgb\\-lrn\\b", "larne"},
    {"\\bgb\\-lut\\b", "luton"},
    {"\\bgb\\-mry\\b", "moray"},
    {"\\bgb\\-myl\\b", "moyle"},
    {"\\bgb\\-nir\\b", "n.i."},
    {"\\bgb\\-omh\\b", "omagh"},
    {"\\bgb\\-pol\\b", "poole"},
    {"\\bgb\\-pow\\b", "powys"},
    {"\\bgb\\-wgn\\b", "wigan"},
    {"\\bgb\\-wls\\b", "wales"},
    {"\\bgb\\-yor\\b", "york"},
    {"\\bhalton\\b", "gb-hal"},
    {"\\bharrow\\b", "gb-hrw"},
    {"\\bmedway\\b", "gb-mdw"},
    {"\\bmerton\\b", "gb-mrt"},
    {"\\bnewham\\b", "gb-nwm"},
    {"\\boldham\\b", "gb-old"},
    {"\\bparade\\b", "pde"},
    {"\\bslough\\b", "gb-slg"},
    {"\\bstreet\\b", "st"},
    {"\\bsurrey\\b", "gb-sry"},
    {"\\bsutton\\b", "gb-stn"},
    {"\\btorbay\\b", "gb-tob"},
    {"\\bwirral\\b", "gb-wrl"},
    {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},
    {"\\bmount\\b", "mt"},
    {"\\bnorth\\b", "n"},
    {"\\bplace\\b", "pl"},
    {"\\bpoint\\b", "pt"},
    {"\\bsaint\\b", "st"},
    {"\\bsouth\\b", "s"},
    {"\\beast\\b", "e"},
    {"\\bg\\.b\\.\\b", "gb"},
    {"\\blane\\b", "ln"},
    {"\\broad\\b", "rd"},
    {"\\bu\\.k\\.\\b", "gb"},
    {"\\bwest\\b", "w"},
    {"\\bg\\.b\\b", "gb"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bnth\\b", "n"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bst\\.\\b", "st"},
    {"\\bsth\\b", "s"},
    {"\\bu\\.k\\b", "gb"},
    {"\\be\\.\\b", "e"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\buk\\b", "gb"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_GR[] = {
    {"\\banatoliki\\s+makedonia\\s+kai\\s+thraki\\b", "a"},
    {"\\baitolia\\s+kai\\s+akarnania\\b", "01"},
    {"\\bkentriki\\s+makedonia\\b", "b"},
    {"\\bdytiki\\s+makedonia\\b", "c"},
    {"\\baitoloakarnania\\b", "01"},
    {"\\bdytiki\\s+ellada\\b", "g"},
    {"\\bsterea\\s+ellada\\b", "h"},
    {"\\bvoreio\\s+aigaio\\b", "k"},
    {"\\bmetamorfossi\\b", "metamorfosi"},
    {"\\bnotio\\s+aigaio\\b", "l"},
    {"\\bpeloponnisos\\b", "j"},
    {"\\bthessaloniki\\b", "54"},
    {"\\bdodekanisos\\b", "81"},
    {"\\bionia\\s+nisia\\b", "f"},
    {"\\bkaissariani\\b", "kesariani"},
    {"\\banatolikos\\b", "e"},
    {"\\bchalkidiki\\b", "64"},
    {"\\bkefallonia\\b", "23"},
    {"\\bperifereia\\b", "periphery"},
    {"\\bthesprotia\\b", "32"},
    {"\\bagio\\s+oros\\b", "69"},
    {"\\bcholargos\\b", "holargos"},
    {"\\bevrytania\\b", "05"},
    {"\\bfthiotida\\b", "06"},
    {"\\bkorinthia\\b", "15"},
    {"\\bnomarchia\\b", "nomo"},
    {"\\bthessalia\\b", "e"},
    {"\\bzakynthos\\b", "21"},
    {"\\bargolida\\b", "11"},
    {"\\bchaidari\\b", "haidari"},
    {"\\bchalkida\\b", "halkida"},
    {"\\bioannina\\b", "33"},
    {"\\birakleio\\b", "91"},
    {"\\bkarditsa\\b", "41"},
    {"\\bkastoria\\b", "56"},
    {"\\bkifissia\\b", "kifisia"},
    {"\\bkyklades\\b", "82"},
    {"\\bmagnisia\\b", "43"},
    {"\\bmaroussi\\b", "marousi"},
    {"\\bmessinia\\b", "17"},
    {"\\brethymni\\b", "93"},
    {"\\brethymno\\b", "93"},
    {"\\banatoli\\b", "e"},
    {"\\barkadia\\b", "12"},
    {"\\bdytikos\\b", "w"},
    {"\\bflorina\\b", "63"},
    {"\\bgrevena\\b", "51"},
    {"\\bimathia\\b", "53"},
    {"\\bipeiros\\b", "d"},
    {"\\bkerkyra\\b", "22"},
    {"\\blakonia\\b", "16"},
    {"\\blasithi\\b", "92"},
    {"\\blefkada\\b", "24"},
    {"\\bpapagou\\b", "papagos"},
    {"\\bpiraeus\\b", "pireas"},
    {"\\bpreveza\\b", "34"},
    {"\\btrikala\\b", "44"},
    {"\\bvoiotia\\b", "03"},
    {"\\bvoreioy\\b", "n"},
    {"\\bachaia\\b", "13"},
    {"\\battiki\\b", "i"},
    {"\\bchania\\b", "94"},
    {"\\bevvoia\\b", "04"},
    {"\\bfokida\\b", "07"},
    {"\\bkavala\\b", "55"},
    {"\\bkilkis\\b", "57"},
    {"\\bkozani\\b", "58"},
    {"\\blarisa\\b", "42"},
    {"\\blesvos\\b", "83"},
    {"\\bnotioy\\b", "s"},
    {"\\bpieria\\b", "61"},
    {"\\brodopi\\b", "73"},
    {"\\bserres\\b", "62"},
    {"\\bvoreio\\b", "n"},
    {"\\bxanthi\\b", "72"},
    {"\\bchios\\b", "85"},
    {"\\bdrama\\b", "52"},
    {"\\bevros\\b", "71"},
    {"\\bhania\\b", "94"},
    {"\\bileia\\b", "14"},
    {"\\bkriti\\b", "m"},
    {"\\bnorth\\b", "n"},
    {"\\bnotio\\b", "s"},
    {"\\bpella\\b", "59"},
    {"\\bsamos\\b", "84"},
    {"\\bsouth\\b", "s"},
    {"\\barta\\b", "31"},
    {"\\bdysi\\b", "w"},
    {"\\beast\\b", "e"},
    {"\\bhios\\b", "85"},
    {"\\bkato\\b", "s"},
    {"\\bwest\\b", "w"},
    {"\\ba\\s+1\\b", "i"},
    {"\\bano\\b", "n"},
};

const Rule kRules_HK[] = {
    {"\\bboulevard\\b", "blvd"},
    {"\\bhong\\s+kong\\b", "hk"},
    {"\\bcrescent\\b", "cres"},
    {"\\bdistrict\\b", ""},
    {"\\bhongkong\\b", "hk"},
    {"\\bjunction\\b", "jct"},
    {"\\bcentral\\b", "c"},
    {"\\bhighway\\b", "hwy"},
    {"\\bparkway\\b", "pkwy"},
    {"\\bseventh\\b", "7"},
    {"\\bavenue\\b", "ave"},
    {"\\bcentre\\b", "center"},
    {"\\bcommon\\b", "comm"},
    {"\\beighth\\b", "8"},
    {"\\bfourth\\b", "4"},
    {"\\bparade\\b", "pde"},
    {"\\bsecond\\b", "2"},
    {"\\bstreet\\b", "st"},
    {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},
    {"\\beight\\b", "8"},
    {"\\bfifth\\b", "5"},
    {"\\bfirst\\b", "1"},
    {"\\bmount\\b", "mt"},
    {"\\bninth\\b", "9"},
    {"\\bnorth\\b", "n"},
    {"\\bplace\\b", "pl"},
    {"\\bpoint\\b", "pt"},
    {"\\bsaint\\b", "st"},
    {"\\bseven\\b", "7"},
    {"\\bsixth\\b", "6"},
    {"\\bsouth\\b", "s"},
    {"\\btenth\\b", "10"},
    {"\\bthird\\b", "3"},
    {"\\bthree\\b", "3"},
    {"\\beast\\b", "e"},
    {"\\bfive\\b", "5"},
    {"\\bfour\\b", "4"},
    {"\\blane\\b", "ln"},
    {"\\bnine\\b", "9"},
    {"\\broad\\b", "rd"},
    {"\\bwest\\b", "w"},
    {"\\bh\\s+k\\b", "hk"},
    {"\\bnth\\b", "n"},
    {"\\bone\\b", "1"},
    {"\\bsix\\b", "6"},
    {"\\bsth\\b", "s"},
    {"\\bten\\b", "10"},
    {"\\btwo\\b", "2"},
};

const Rule kRules_ID[] = {
    {"\\bspecial\\s+region\\s+of\\s+yogyakarta\\b", "yo"},
    {"\\bnanggroe\\s+aceh\\s+darussalam\\b", "ac"},
    {"\\bbangka\\s+belitung\\s+islands\\b", "bb"},
    {"\\bnaggroe\\s+aceh\\s+darussalam\\b", "ac"},
    {"\\bspecial\\s+region\\s+of\\s+papua\\b", "pa"},
    {"\\bspecial\\s+region\\s+of\\s+aceh\\b", "ac"},
    {"\\bcentral\\s+kalimantan\\b", "kt"},
    {"\\bsoutheast\\s+sulawesi\\b", "sg"},
    {"\\bcentral\\s+sulawesi\\b", "st"},
    {"\\bbangka\\s+belitung\\b", "bb"},
    {"\\bjakarta\\s+pusat\\b", "jk"},
    {"\\bjakarta\\s+utara\\b", "jk"},
    {"\\bcentral\\s+java\\b", "jt"},
    {"\\briau\\s+islands\\b", "kr"},
    {"\\bdki\\s+jakarta\\b", "jk"},
    {"\\bjawa\\s+tengah\\b", "jt"},
    {"\\byogyakarta\\b", "yo"},
    {"\\bgorontalo\\b", "go"},
    {"\\bindonesia\\b", "id"},
    {"\\bbengkulu\\b", "be"},
    {"\\bnational\\b", "nasional"},
    {"\\bjakarta\\b", "jk"},
    {"\\blampung\\b", "la"},
    {"\\bselatan\\b", "s"},
    {"\\bbanten\\b", "bt"},
    {"\\bmaluku\\b", "ma"},
    {"\\bnumber\\b", "#"},
    {"\\bbarat\\b", "w"},
    {"\\bblock\\b", "blk"},
    {"\\bjalan\\b", "jl"},
    {"\\bjambi\\b", "ja"},
    {"\\bnorth\\b", "n"},
    {"\\bpapua\\b", "pa"},
    {"\\bsouth\\b", "s"},
    {"\\btimur\\b", "e"},
    {"\\butara\\b", "n"},
    {"\\bxviii\\b", "18"},
    {"\\baceh\\b", "ac"},
    {"\\bbali\\b", "ba"},
    {"\\bblk\\.\\b", "blk"},
    {"\\bblok\\b", "blk"},
    {"\\beast\\b", "e"},
    {"\\bjln\\.\\b", "jl"},
    {"\\briau\\b", "ri"},
    {"\\broad\\b", "rd"},
    {"\\bviii\\b", "8"},
    {"\\bwest\\b", "w"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\biii\\b", "3"},
    {"\\bjl\\.\\b", "jl"},
    {"\\bjln\\b", "jl"},
    {"\\bno\\.\\b", "#"},
    {"\\bnum\\b", "#"},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxix\\b", "19"},
    {"\\bxvi\\b", "16"},
    {"\\b10\\b", "x"},
    {"\\bii\\b", "2"},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bno\\b", "#"},
    {"\\bvi\\b", "6"},
    {"\\bxi\\b", "11"},
    {"\\bxv\\b", "15"},
    {"\\bxx\\b", "20"},
    {"\\bi\\b", "1"},
    {"\\bv\\b", "5"},
};

const Rule kRules_IE[] = {
    {"\\broscommon\\b", "rn"},
    {"\\btipperary\\b", "ta"},
    {"\\bwaterford\\b", "wd"},
    {"\\bwestmeath\\b", "wh"},
    {"\\bkilkenny\\b", "kk"},
    {"\\blimerick\\b", "lk"},
    {"\\blongford\\b", "ld"},
    {"\\bmonaghan\\b", "mn"},
    {"\\bdonegal\\b", "dl"},
    {"\\bireland\\b", "ie"},
    {"\\bkildare\\b", "ke"},
    {"\\bleitrim\\b", "lm"},
    {"\\bterrace\\b", "tce"},
    {"\\bwexford\\b", "wx"},
    {"\\bwicklow\\b", "ww"},
    {"\\bavenue\\b", "ave"},
    {"\\bcarlow\\b", "cw"},
    {"\\bcenter\\b", "cntr"},
    {"\\bcounty\\b", "ck"},
    {"\\bdublin\\b", "d"},
    {"\\bgalway\\b", "g"},
    {"\\blaoise\\b", "ls"},
    {"\\boffaly\\b", "oy"},
    {"\\bstreet\\b", "st"},
    {"\\bcavan\\b", "cn"},
    {"\\bclare\\b", "ce"},
    {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},
    {"\\bkerry\\b", "ky"},
    {"\\blaois\\b", "ls"},
    {"\\blouth\\b", "lh"},
    {"\\bmeath\\b", "mh"},
    {"\\bnorth\\b", "n"},
    {"\\bplace\\b", "pl"},
    {"\\bsaint\\b", "st"},
    {"\\bsligo\\b", "so"},
    {"\\bsouth\\b", "s"},
    {"\\bcork\\b", "ck"},
    {"\\beast\\b", "e"},
    {"\\blane\\b", "ln"},
    {"\\bmayo\\b", "mo"},
    {"\\broad\\b", "rd"},
    {"\\bwalk\\b", "wk"},
    {"\\bwest\\b", "w"},
    {"\\byard\\b", "yd"},
    {"\\bway\\b", "wy"},
    {"\\bco\\b", "ck"},
    {"\\bdn\\b", "d"},
    {"\\bgy\\b", "g"},
    {"\\bty\\b", "ta"},
};

const Rule kRules_IN[] = {
    {"\\bthiruvananthapuram\\b", "tvpm"},
    {"\\bazimabad\\s+kusumpur\\b", "patna"},
    {"\\bjammu\\s+and\\s+kashmir\\b", "j&k"},
    {"\\btiruvananthapuram\\b", "tvpm"},
    {"\\bchandigarh\\s+city\\b", "ch"},
    {"\\bjammu\\s+\\&\\s+kashmir\\b", "j&k"},
    {"\\bgovt\\s+of\\s+india\\b", "goi"},
    {"\\binternational\\b", "intl"},
    {"\\bvisakhapatnam\\b", "vskp"},
    {"\\bchickmagalur\\b", "chicmagalur"},
    {"\\bchikmagaluru\\b", "chicmagalur"},
    {"\\bchikmagalur\\b", "chicmagalur"},
    {"\\bcross\\-roads\\b", "xrd"},
    {"\\bpataliputra\\b", "patna"},
    {"\\branga\\s+reddy\\b", "rangareddi"},
    {"\\bchandigarh\\b", "ch"},
    {"\\bcross\\-road\\b", "xrd"},
    {"\\bcrossroads\\b", "xrd"},
    {"\\bgovernment\\b", "goi"},
    {"\\bpatliputra\\b", "patna"},
    {"\\buniversity\\b", "uni"},
    {"\\bvijayawada\\b", "bza"},
    {"\\bahmedabad\\b", "ahd"},
    {"\\bbangalore\\b", "blr"},
    {"\\bbengaluru\\b", "blr"},
    {"\\bchar\\-rast\\b", "chaurah"},
    {"\\bchaurasta\\b", "chaurah"},
    {"\\bchourasta\\b", "chaurah"},
    {"\\bcrossroad\\b", "xrd"},
    {"\\bhyderabad\\b", "hyd"},
    {"\\bi\\.n\\.d\\.i\\.a\\b", "in"},
    {"\\bvijaywada\\b", "bza"},
    {"\\bcalcutta\\b", "kol"},
    {"\\bchourast\\b", "chaurah"},
    {"\\bchowrast\\b", "chaurah"},
    {"\\bcrossing\\b", "xrd"},
    {"\\bcrossrds\\b", "xrd"},
    {"\\bjunction\\b", "jn."},
    {"\\bkolkatta\\b", "kol"},
    {"\\bvaranasi\\b", "banaras"},
    {"\\bamdavad\\b", "ahd"},
    {"\\bbenaras\\b", "banaras"},
    {"\\bchennai\\b", "che"},
    {"\\bcollege\\b", "clg"},
    {"\\bcrossrd\\b", "xrd"},
    {"\\bgateway\\b", "gtwy"},
    {"\\bheights\\b", "hts"},
    {"\\bkeralam\\b", "kl"},
    {"\\bkolkata\\b", "kol"},
    {"\\bkolkota\\b", "kol"},
    {"\\bseventh\\b", "7"},
    {"\\bvruttha\\b", "cir."},
    {"\\bx\\s+roads\\b", "xrd"},
    {"\\bbombay\\b", "bom"},
    {"\\bcenter\\b", "cen"},
    {"\\bcentre\\b", "cen"},
    {"\\bchowdi\\b", "chok"},
    {"\\bcircle\\b", "cir."},
    {"\\beighth\\b", "8"},
    {"\\bforest\\b", "frst"},
    {"\\bfourth\\b", "4"},
    {"\\bgarden\\b", "gdn"},
    {"\\bgatewy\\b", "gtwy"},
    {"\\bgatway\\b", "gtwy"},
    {"\\bheight\\b", "hts"},
    {"\\bkavala\\b", "jn."},
    {"\\bkerala\\b", "kl"},
    {"\\bmadras\\b", "che"},
    {"\\bmumbai\\b", "bom"},
    {"\\bnumber\\b", "#"},
    {"\\braasta\\b", "rasta"},
    {"\\bsecond\\b", "2"},
    {"\\bstreet\\b", "st"},
    {"\\bx\\s+road\\b", "xrd"},
    {"\\bxroads\\b", "xrd"},
    {"\\bcentr\\b", "cen"},
    {"\\bchauk\\b", "chok"},
    {"\\bchouk\\b", "chok"},
    {"\\bchowk\\b", "chok"},
    {"\\bcnter\\b", "cen"},
    {"\\bdelhi\\b", "del"},
    {"\\bfifth\\b", "5"},
    {"\\bfirst\\b", "1"},
    {"\\bgalli\\b", "gali"},
    {"\\bgardn\\b", "gdn"},
    {"\\bgrden\\b", "gdn"},
    {"\\bgtway\\b", "gtwy"},
    {"\\bindia\\b", "in"},
    {"\\bj\\s+\\&\\s+k\\b", "j&k"},
    {"\\bmukku\\b", "jn."},
    {"\\bnaaka\\b", "jn."},
    {"\\bninth\\b", "9"},
    {"\\bnorth\\b", "n"},
    {"\\bpally\\b", "palli"},
    {"\\bround\\b", "cir."},
    {"\\broute\\b", "rt"},
    {"\\bsixth\\b", "6"},
    {"\\bsouth\\b", "s"},
    {"\\btenth\\b", "10"},
    {"\\bthird\\b", "3"},
    {"\\bvizag\\b", "vskp"},
    {"\\bxroad\\b", "xrd"},
    {"\\bcent\\b", "cen"},
    {"\\bcntr\\b", "cen"},
    {"\\beast\\b", "e"},
    {"\\bgarh\\b", "gad"},
    {"\\bgrdn\\b", "gdn"},
    {"\\bhght\\b", "hts"},
    {"\\bhgts\\b", "hts"},
    {"\\bj\\s+\\&k\\b", "j&k"},
    {"\\bjct\\.\\b", "jn."},
    {"\\bjnct\\b", "jn."},
    {"\\bpeth\\b", "pet"},
    {"\\brnd\\.\\b", "cir."},
    {"\\broad\\b", "rd"},
    {"\\bstr\\.\\b", "st"},
    {"\\buniv\\b", "uni"},
    {"\\bwest\\b", "w"},
    {"\\bx\\-rd\\b", "xrd"},
    {"\\bxrds\\b", "xrd"},
    {"\\bcha\\b", "ch"},
    {"\\bctr\\b", "cen"},
    {"\\bmum\\b", "bom"},
    {"\\bno\\.\\b", "#"},
    {"\\bnum\\b", "#"},
    {"\\brte\\b", "rt"},
    {"\\bst\\.\\b", "st"},
    {"\\bstr\\b", "st"},
    {"\\bno\\b", "#"},
};

const Rule kRules_IT[] = {
    {"\\bbarletta\\s+andria\\s+trani\\b", "bt"},
    {"\\bfriuli\\s+venezia\\s+giulia\\b", "36"},
    {"\\bverbano\\s+cusio\\s+ossola\\b", "vb"},
    {"\\btrentino\\s+alto\\s+adige\\b", "32"},
    {"\\bstrada\\s+provinciale\\b", "sp"},
    {"\\bcarbonia\\s+iglesias\\b", "ci"},
    {"\\btrentino\\s+sudtirol\\b", "32"},
    {"\\bstrada\\s+regionale\\b", "sr"},
    {"\\bventiquattresimo\\b", "24"},
    {"\\bdiciassettesimo\\b", "17"},
    {"\\bmedio\\s+campidano\\b", "vs"},
    {"\\bmonza\\s+e\\s+brianza\\b", "mb"},
    {"\\bpesaro\\s+e\\s+urbino\\b", "pu"},
    {"\\bquattordicesimo\\b", "14"},
    {"\\breggio\\s+calabria\\b", "rc"},
    {"\\bstrada\\s+comunale\\b", "sc"},
    {"\\bventicinquesimo\\b", "25"},
    {"\\bdiciannovesimo\\b", "19"},
    {"\\bemilia\\s+romagna\\b", "45"},
    {"\\bstrada\\s+statali\\b", "ss"},
    {"\\bvallee\\s+d\\s+aoste\\b", "23"},
    {"\\bventisettesimo\\b", "27"},
    {"\\bascoli\\s+piceno\\b", "ap"},
    {"\\bcaltanissetta\\b", "cl"},
    {"\\bmassa\\s+carrara\\b", "ms"},
    {"\\breggio\\s+emilia\\b", "re"},
    {"\\bvalle\\s+d\\s+aosta\\b", "23"},
    {"\\bventinovesimo\\b", "29"},
    {"\\bventitreesimo\\b", "23"},
    {"\\bvibo\\s+valentia\\b", "vv"},
    {"\\bdiciottesimo\\b", "18"},
    {"\\bforli\\s+cesena\\b", "fc"},
    {"\\bolbia\\s+tempio\\b", "ot"},
    {"\\bquindicesimo\\b", "15"},
    {"\\bventiduesimo\\b", "22"},
    {"\\bventiquattro\\b", "24"},
    {"\\bventottesimo\\b", "28"},
    {"\\balessandria\\b", ""},
    {"\\bdiciassette\\b", "17"},
    {"\\bquattordici\\b", "14"},
    {"\\btredicesimo\\b", "13"},
    {"\\bvalle\\s+aosta\\b", "23"},
    {"\\bventicinque\\b", "25"},
    {"\\bventisesimo\\b", "26"},
    {"\\bventunesimo\\b", "21"},
    {"\\bbasilicata\\b", "77"},
    {"\\bcampobasso\\b", "cb"},
    {"\\bdiciannove\\b", "19"},
    {"\\bdodicesimo\\b", "12"},
    {"\\breggimento\\b", "rgt"},
    {"\\bsedicesimo\\b", "16"},
    {"\\btrentesimo\\b", "30"},
    {"\\bundicesimo\\b", "11"},
    {"\\bventisette\\b", "27"},
    {"\\bagrigento\\b", "ag"},
    {"\\bbenevento\\b", "bn"},
    {"\\bcatanzaro\\b", "cz"},
    {"\\bfrosinone\\b", "fr"},
    {"\\bla\\s+spezia\\b", "sp"},
    {"\\blombardia\\b", "25"},
    {"\\bogliastra\\b", "og"},
    {"\\bpordenone\\b", "pn"},
    {"\\bventesimo\\b", "20"},
    {"\\bventinove\\b", "29"},
    {"\\bavellino\\b", "av"},
    {"\\bbrindisi\\b", "br"},
    {"\\bcagliari\\b", "ca"},
    {"\\bcalabria\\b", "78"},
    {"\\bcampania\\b", "72"},
    {"\\bdiciotto\\b", "18"},
    {"\\bgrosseto\\b", "gr"},
    {"\\bl\\s+aquila\\b", "aq"},
    {"\\bmacerata\\b", "mc"},
    {"\\boristano\\b", "or"},
    {"\\bpiacenza\\b", "pc"},
    {"\\bpiemonte\\b", "21"},
    {"\\bquindici\\b", "15"},
    {"\\bsardegna\\b", "88"},
    {"\\bsiracusa\\b", "sr"},
    {"\\btraversa\\b", "trav"},
    {"\\bventidue\\b", "22"},
    {"\\bventisei\\b", "26"},
    {"\\bventitre\\b", "23"},
    {"\\bventotto\\b", "28"},
    {"\\bvercelli\\b", "vc"},
    {"\\babruzzo\\b", "65"},
    {"\\bbelluno\\b", "bl"},
    {"\\bbergamo\\b", "bg"},
    {"\\bbologna\\b", "bo"},
    {"\\bbolzano\\b", "bz"},
    {"\\bbrescia\\b", "bs"},
    {"\\bcaserta\\b", "ce"},
    {"\\bcatania\\b", "ct"},
    {"\\bcosenza\\b", "cs"},
    {"\\bcremona\\b", "cr"},
    {"\\bcrotone\\b", "kr"},
    {"\\bferrara\\b", "fe"},
    {"\\bfirenze\\b", "fi"},
    {"\\bgorizia\\b", "go"},
    {"\\bimperia\\b", "im"},
    {"\\bisernia\\b", "is"},
    {"\\bliguria\\b", "42"},
    {"\\blivorno\\b", "li"},
    {"\\bmantova\\b", "mn"},
    {"\\bmessina\\b", "me"},
    {"\\bpalermo\\b", "pa"},
    {"\\bperugia\\b", "pg"},
    {"\\bpescara\\b", "pe"},
    {"\\bpistoia\\b", "pt"},
    {"\\bpotenza\\b", "pz"},
    {"\\bquattro\\b", "4"},
    {"\\bravenna\\b", "ra"},
    {"\\bsalerno\\b", "sa"},
    {"\\bsassari\\b", "ss"},
    {"\\bsecondo\\b", "2"},
    {"\\bsettimo\\b", "7"},
    {"\\bsicilia\\b", "82"},
    {"\\bsondrio\\b", "so"},
    {"\\btaranto\\b", "ta"},
    {"\\btoscana\\b", "52"},
    {"\\btrapani\\b", "tp"},
    {"\\btredici\\b", "13"},
    {"\\btreviso\\b", "tv"},
    {"\\btrieste\\b", "ts"},
    {"\\bvenezia\\b", "ve"},
    {"\\bventuno\\b", "21"},
    {"\\bvicenza\\b", "6"},
    {"\\bviterbo\\b", "vt"},
    {"\\bancona\\b", "an"},
    {"\\barezzo\\b", "ar"},
    {"\\bbiella\\b", "bi"},
    {"\\bchieti\\b", "ch"},
    {"\\bcinque\\b", "5"},
    {"\\bdecimo\\b", "x"},
    {"\\bdodici\\b", "12"},
    {"\\bfoggia\\b", "fg"},
    {"\\bgenova\\b", "ge"},
    {"\\bitalia\\b", "it"},
    {"\\blatina\\b", "lt"},
    {"\\bmarche\\b", "57"},
    {"\\bmatera\\b", "mt"},
    {"\\bmilano\\b", "mi"},
    {"\\bmodena\\b", "mo"},
    {"\\bmolise\\b", "67"},
    {"\\bnapoli\\b", "na"},
    {"\\bnovara\\b", "no"},
    {"\\bottavo\\b", "8"},
    {"\\bpadova\\b", "pd"},
    {"\\bpuglia\\b", "75"},
    {"\\bquarto\\b", "4"},
    {"\\bquinto\\b", "5"},
    {"\\bragusa\\b", "rg"},
    {"\\brimini\\b", "rn"},
    {"\\brovigo\\b", "ro"},
    {"\\bsavona\\b", "sv"},
    {"\\bsedici\\b", "16"},
    {"\\bteramo\\b", "te"},
    {"\\btorino\\b", "to"},
    {"\\btrenta\\b", "30"},
    {"\\btrento\\b", "tn"},
    {"\\bumbria\\b", "55"},
    {"\\bundici\\b", "11"},
    {"\\bvarese\\b", "va"},
    {"\\bveneto\\b", "34"},
    {"\\bverona\\b", "vr"},
    {"\\bxxviii\\b", "28"},
    {"\\baosta\\b", "ao"},
    {"\\baoste\\b", "ao"},
    {"\\bbozen\\b", "bz"},
    {"\\bcuneo\\b", "cn"},
    {"\\bdagli\\b", ""},
    {"\\bdalla\\b", ""},
    {"\\bdalle\\b", ""},
    {"\\bdallo\\b", ""},
    {"\\bdegli\\b", ""},
    {"\\bdella\\b", ""},
    {"\\bdelle\\b", ""},
    {"\\bdello\\b", ""},
    {"\\bdieci\\b", "x"},
    {"\\bfermo\\b", "fm"},
    {"\\bitaly\\b", "it"},
    {"\\blazio\\b", "62"},
    {"\\blecce\\b", ""},
    {"\\blecco\\b", "lc"},
    {"\\blucca\\b", "lu"},
    {"\\bnegli\\b", ""},
    {"\\bnella\\b", ""},
    {"\\bnelle\\b", ""},
    {"\\bnello\\b", ""},
    {"\\bnorth\\b", "n"},
    {"\\bnuoro\\b", "nu"},
    {"\\bovest\\b", "o"},
    {"\\bparma\\b", "pr"},
    {"\\bpavia\\b", "pv"},
    {"\\bprato\\b", "po"},
    {"\\bprimo\\b", ""},
    {"\\brieti\\b", "ri"},
    {"\\bsesto\\b", "6"},
    {"\\bsette\\b", "7"},
    {"\\bsiena\\b", "si"},
    {"\\bsouth\\b", "s"},
    {"\\bsugli\\b", ""},
    {"\\bsulla\\b", ""},
    {"\\bsulle\\b", ""},
    {"\\bsullo\\b", ""},
    {"\\bterni\\b", "tr"},
    {"\\bterzo\\b", "3"},
    {"\\budine\\b", "ud"},
    {"\\bventi\\b", "20"},
    {"\\bxviii\\b", "18"},
    {"\\bxxiii\\b", "23"},
    {"\\bxxvii\\b", "27"},
    {"\\bagli\\b", ""},
    {"\\balla\\b", ""},
    {"\\balle\\b", ""},
    {"\\ballo\\b", ""},
    {"\\basti\\b", "at"},
    {"\\bbari\\b", "ba"},
    {"\\bcomo\\b", "co"},
    {"\\bdall\\b", ""},
    {"\\bdell\\b", ""},
    {"\\beast\\b", "e"},
    {"\\benna\\b", ""},
    {"\\blodi\\b", ""},
    {"\\bnell\\b", ""},
    {"\\bnono\\b", "9"},
    {"\\bnord\\b", "n"},
    {"\\bnove\\b", "9"},
    {"\\botto\\b", "8"},
    {"\\bpisa\\b", "pi"},
    {"\\broma\\b", "rm"},
    {"\\bsull\\b", ""},
    {"\\bviii\\b", "8"},
    {"\\bwest\\b", "o"},
    {"\\bxiii\\b", "13"},
    {"\\bxvii\\b", "17"},
    {"\\bxxii\\b", "22"},
    {"\\bxxiv\\b", "24"},
    {"\\bxxix\\b", "29"},
    {"\\bxxvi\\b", "26"},
    {"\\ball\\b", ""},
    {"\\bdai\\b", ""},
    {"\\bdal\\b", ""},
    {"\\bdei\\b", ""},
    {"\\bdel\\b", ""},
    {"\\bdue\\b", "2"},
    {"\\best\\b", "e"},
    {"\\bgli\\b", ""},
    {"\\biii\\b", "3"},
    {"\\bles\\b", ""},
    {"\\bnei\\b", ""},
    {"\\bnel\\b", ""},
    {"\\bsei\\b", "6"},
    {"\\bsud\\b", "s"},
    {"\\bsui\\b", ""},
    {"\\bsul\\b", ""},
    {"\\btre\\b", "3"},
    {"\\buno\\b", ""},
    {"\\bvii\\b", "7"},
    {"\\bxii\\b", "12"},
    {"\\bxiv\\b", "14"},
    {"\\bxix\\b", "19"},
    {"\\bxvi\\b", "16"},
    {"\\bxxi\\b", "21"},
    {"\\bxxv\\b", "25"},
    {"\\bxxx\\b", "30"},
    {"\\b10\\b", "x"},
    {"\\bai\\b", ""},
    {"\\bal\\b", ""},
    {"\\bda\\b", ""},
    {"\\bdi\\b", ""},
    {"\\ben\\b", ""},
    {"\\bii\\b", "2"},
    {"\\bil\\b", ""},
    {"\\bin\\b", ""},
    {"\\biv\\b", "4"},
    {"\\bix\\b", "9"},
    {"\\bla\\b", ""},
    {"\\ble\\b", ""},
    {"\\blo\\b", ""},
    {"\\bsu\\b", ""},
    {"\\bvi\\b", "6"},
    {"\\bxi\\b", "11"},
    {"\\bxv\\b", "15"},
    {"\\bxx\\b", "20"},
    {"\\ba\\b", ""},
    {"\\bd\\b", ""},
    {"\\bi\\b", ""},
    {"\\bl\\b", ""},
    {"\\bv\\b", "5"},
    {"\\bw\\b", "o"},
};

const Rule kRules_LU[] = {
    {"\\berpeldange\\s+\\-\\s+lez\\s+\\-\\s+bous\\b", "erpeldange"},
    {"\\bhostert\\s+niederanven\\b", "hostert"},
    {"\\bgoebelsmuehle\\b", "goebelsmuhle"},
    {"\\bbuederscheid\\b", "buderscheid"},
    {"\\bschwebsingen\\b", "schwebsange"},
    {"\\brammeldange\\b", "rameldange"},
    {"\\bcul\\s+de\\s+sac\\b", "cds"},
    {"\\bcul\\-de\\-sac\\b", "cds"},
    {"\\bgeyershaff\\b", "geyershof"},
    {"\\blexembourg\\b", "lu"},
    {"\\bluxembourg\\b", "lu"},
    {"\\brond\\-point\\b", "rdpt"},
    {"\\bboulevard\\b", "boul"},
    {"\\bcarrefour\\b", "carref"},
    {"\\bcroissant\\b", "crois"},
    {"\\bdiversion\\b", "divers"},
    {"\\bechangeur\\b", "ech"},
    {"\\besplanade\\b", "esp"},
    {"\\bluxemburg\\b", "lu"},
    {"\\bpromenade\\b", "prom"},
    {"\\bcapellen\\b", "cap"},
    {"\\bterrasse\\b", "tsse"},
    {"\\bcircuit\\b", "circt"},
    {"\\bimpasse\\b", "imp"},
    {"\\bplateau\\b", "plat"},
    {"\\bsentier\\b", "sent"},
    {"\\bstrasse\\b", "str"},
    {"\\bavenue\\b", "av"},
    {"\\bcenter\\b", "c"},
    {"\\bcentre\\b", "c"},
    {"\\bchemin\\b", "ch"},
    {"\\bpointe\\b", "pte"},
    {"\\bruelle\\b", "rle"},
    {"\\bcarre\\b", "car"},
    {"\\bcourt\\b", "crt"},
    {"\\bdrive\\b", "dr"},
    {"\\bpoint\\b", "pt"},
    {"\\broute\\b", "rte"},
    {"\\bespl\\b", "esp"},
    {"\\bave\\b", "av"},
    {"\\bctr\\b", "c"},
    {"\\bdes\\b", ""},
    {"\\blux\\b", "lu"},
    {"\\brue\\b", "r"},
    {"\\bde\\b", ""},
    {"\\bdu\\b", ""},
    {"\\bd\\b", ""},
};

const Rule kRules_MX[] = {
    {"\\bcoahuila\\s+de\\s+zaragoza\\b", "coahuila"},
    {"\\bbaja\\s+california\\s+sur\\b", "b c s"},
    {"\\bestado\\s+de\\s+mexico\\b", "me"},
    {"\\bbaja\\s+california\\b", "b c"},
    {"\\baguascalientes\\b", "ag"},
    {"\\bveracruz\\s+llave\\b", "veracruz"},
    {"\\bprolongacion\\b", "prol"},
    {"\\bquintana\\s+roo\\b", "qr"},
    {"\\bdiecinueve\\b", "19"},
    {"\\bdiecisiete\\b", "17"},
    {"\\bgobernador\\b", "gob"},
    {"\\bguanajuato\\b", "gt"},
    {"\\blicenciado\\b", "lic"},
    {"\\bpresbitero\\b", "pbro"},
    {"\\bsan\\s+isidro\\b", "s isidro"},
    {"\\bseptiembre\\b", "sept"},
    {"\\bdieciocho\\b", "18"},
    {"\\bdieciseis\\b", "16"},
    {"\\bfrancisco\\b", "fco"},
    {"\\bingeniero\\b", "ing"},
    {"\\brepublica\\b", "rep"},
    {"\\barticulo\\b", "art"},
    {"\\bguerrero\\b", "gr"},
    {"\\bhacienda\\b", "hda"},
    {"\\bponiente\\b", "pte"},
    {"\\bprofesor\\b", "prof"},
    {"\\bsan\\s+juan\\b", "s juan"},
    {"\\bavenida\\b", "av"},
    {"\\bcaptain\\b", "cap"},
    {"\\bcatorce\\b", "14"},
    {"\\bfebrero\\b", "feb"},
    {"\\bgeneral\\b", "gral"},
    {"\\bhidalgo\\b", "hg"},
    {"\\bjalisco\\b", "ja"},
    {"\\boriente\\b", "ote"},
    {"\\bprimera\\b", "1a"},
    {"\\bprivada\\b", "priv"},
    {"\\bsegunda\\b", "2a"},
    {"\\bseptima\\b", "7a"},
    {"\\bsinaloa\\b", "si"},
    {"\\btercera\\b", "3a"},
    {"\\bciudad\\b", "cd"},
    {"\\bcuarta\\b", "4a"},
    {"\\bcuatro\\b", "4"},
    {"\\bdoctor\\b", "dr"},
    {"\\bmexico\\b", "me"},
    {"\\bmx\\s+mex\\b", "me"},
    {"\\boaxaca\\b", "oa"},
    {"\\boctava\\b", "8a"},
    {"\\bpuebla\\b", "pu"},
    {"\\bpuerto\\b", "pto"},
    {"\\bquince\\b", "15"},
    {"\\bquinta\\b", "5a"},
    {"\\bveinte\\b", "20"},
    {"\\bcinco\\b", "5"},
    {"\\bmaria\\b", "ma"},
    {"\\bnorte\\b", "nte"},
    {"\\bnueve\\b", "9"},
    {"\\boeste\\b", "pte"},
    {"\\bq\\s+roo\\b", "qr"},
    {"\\bsanta\\b", "sta"},
    {"\\bsexta\\b", "6a"},
    {"\\bsiete\\b", "7"},
    {"\\btrece\\b", "13"},
    {"\\bdiez\\b", "10"},
    {"\\bdoce\\b", "12"},
    {"\\beste\\b", "ote"},
    {"\\bocho\\b", "8"},
    {"\\bonce\\b", "11"},
    {"\\bseis\\b", "6"},
    {"\\btres\\b", "3"},
    {"\\bags\\b", "ag"},
    {"\\bdel\\b", ""},
    {"\\bdos\\b", "2"},
    {"\\blas\\b", ""},
    {"\\blos\\b", ""},
    {"\\bq\\s+r\\b", "qr"},
    {"\\buno\\b", "1"},
    {"\\bde\\b", ""},
    {"\\bel\\b", ""},
    {"\\ble\\b", ""},
    {"\\bmx\\b", "me"},
};

const Rule kRules_MY[] = {
    {"\\bmalaysia\\b", "my"},
};

const Rule kRules_NL[] = {
    {"\\bwesterhaar\\s+vriezenveensewijk\\b", "westerhaar-vriezenv wijk"},
    {"\\bnoord\\s+brabant\\b", "nb"},
    {"\\bnoord\\s+holland\\b", "nh"},
    {"\\bnoord\\-brabant\\b", "nb"},
    {"\\bnoord\\-holland\\b", "nh"},
    {"\\balphen\\s+chaam\\b", "ac"},
    {"\\bburgemeester\\b", "burg"},
    {"\\bnoordbrabant\\b", "nb"},
    {"\\bs\\s+gravenhage\\b", "sgravenhage"},
    {"\\bzuid\\s+holland\\b", "zh"},
    {"\\bzuid\\-holland\\b", "zh"},
    {"\\bmonseigneur\\b", "mgr"},
    {"\\bnetherlands\\b", "nl"},
    {"\\bnordholland\\b", "nh"},
    {"\\bzuidholland\\b", "zh"},
    {"\\bgelderland\\b", "ge"},
    {"\\bnoordzijde\\b", "nz"},
    {"\\boverijssel\\b", "ov"},
    {"\\bflevoland\\b", "fl"},
    {"\\bfriesland\\b", "fr"},
    {"\\bgroningen\\b", "gn"},
    {"\\bnederland\\b", "nl"},
    {"\\boostzijde\\b", "oz"},
    {"\\bprofessor\\b", "prof"},
    {"\\brotterdam\\b", "rt"},
    {"\\bwestzijde\\b", "wz"},
    {"\\bzuidzijde\\b", "zz"},
    {"\\baan\\s+den\\b", "ad"},
    {"\\bachtste\\b", "8"},
    {"\\bdominee\\b", "ds"},
    {"\\bdrenthe\\b", "dr"},
    {"\\blimburg\\b", "l"},
    {"\\bmeester\\b", "mr"},
    {"\\bnegende\\b", "9"},
    {"\\butrecht\\b", "u"},
    {"\\bzeeland\\b", "z"},
    {"\\bzevende\\b", "7"},
    {"\\baan\\s+de\\b", "ad"},
    {"\\bdoctor\\b", "dr"},
    {"\\beerste\\b", "1"},
    {"\\bstraat\\b", "str"},
    {"\\btweede\\b", "2"},
    {"\\bvierde\\b", "4"},
    {"\\bvijfde\\b", "5"},
    {"\\bderde\\b", "3"},
    {"\\bnl\\-dr\\b", "dr"},
    {"\\bnl\\-fl\\b", "fl"},
    {"\\bnl\\-fr\\b", "fr"},
    {"\\bnl\\-ge\\b", "ge"},
    {"\\bnl\\-gr\\b", "gn"},
    {"\\bnl\\-li\\b", "l"},
    {"\\bnl\\-nb\\b", "nb"},
    {"\\bnl\\-nh\\b", "nh"},
    {"\\bnl\\-ov\\b", "ov"},
    {"\\bnl\\-ut\\b", "u"},
    {"\\bnl\\-ze\\b", "z"},
    {"\\bnl\\-zh\\b", "zh"},
    {"\\bzesde\\b", "6"},
    {"\\bsint\\b", "st"},
    {"\\ba\\s+d\\b", "ad"},
    {"\\bgld\\b", "ge"},
    {"\\bn\\s+z\\b", "nz"},
    {"\\bo\\s+z\\b", "oz"},
    {"\\bw\\s+z\\b", "wz"},
    {"\\bz\\s+z\\b", "zz"},
    {"\\bzld\\b", "z"},
    {"\\bgl\\b", "ge"},
    {"\\bgr\\b", "gn"},
    {"\\blb\\b", "l"},
    {"\\bli\\b", "l"},
    {"\\but\\b", "u"},
    {"\\bze\\b", "z"},
    {"\\bzl\\b", "z"},
    {"\\b\\#\\b", ""},
};

const Rule kRules_NZ[] = {
    {"\\brural\\s+delivery\\b", ""},
    {"\\bocean\\s+beach\\b", "oceanbeach"},
    {"\\blong\\s+beach\\b", "longbeach"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bcrescent\\b", "cres"},
    {"\\bheights\\b", "hts"},
    {"\\bhighway\\b", "hwy"},
    {"\\bparkway\\b", "pkwy"},
    {"\\bavenue\\b", "ave"},
    {"\\bcommon\\b", "comm"},
    {"\\bparade\\b", "pde"},
    {"\\bstreet\\b", "st"},
    {"\\bcourt\\b", "ct"},
    {"\\bdrive\\b", "dr"},
    {"\\bmount\\b", "mt"},
    {"\\bnorth\\b", "n"},
    {"\\bplace\\b", "pl"},
    {"\\bpoint\\b", "pt"},
    {"\\bsaint\\b", "st"},
    {"\\bsouth\\b", "s"},
    {"\\beast\\b", "e"},
    {"\\blane\\b", "ln"},
    {"\\bn\\.z\\.\\b", "nz"},
    {"\\broad\\b", "rd"},
    {"\\bwest\\b", "w"},
    {"\\bmt\\.\\b", "mt"},
    {"\\bn\\.z\\b", "nz"},
    {"\\bnth\\b", "n"},
    {"\\bpt\\.\\b", "pt"},
    {"\\bst\\.\\b", "st"},
    {"\\bsth\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_PE[] = {
    {"\\bavenida\\b", "av"},
    {"\\bperu\\b", "pe"},
    {"\\bdel\\b", ""},
    {"\\blas\\b", ""},
    {"\\blos\\b", ""},
    {"\\bde\\b", ""},
    {"\\bel\\b", ""},
    {"\\ble\\b", ""},
};

const Rule kRules_PH[] = {
    {"\\bphilippines\\b", "ph"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bextension\\b", "ext"},
    {"\\bbarangay\\b", ""},
    {"\\bcaptain\\b", "cap"},
    {"\\bgeneral\\b", "gen"},
    {"\\bavenue\\b", "av"},
    {"\\bdoctor\\b", "dr"},
    {"\\bstreet\\b", "st"},
    {"\\bnorth\\b", "n"},
    {"\\bsouth\\b", "s"},
    {"\\bbrgy\\b", ""},
    {"\\beast\\b", "e"},
    {"\\bextn\\b", "ext"},
    {"\\broad\\b", "rd"},
    {"\\bwest\\b", "w"},
    {"\\bave\\b", "av"},
    {"\\bbgy\\b", ""},
};

const Rule kRules_PL[] = {
    {"\\bkuyavian\\s+pomeranian\\b", "kp"},
    {"\\bzachodniopomorskie\\b", "zp"},
    {"\\bwarmian\\s+masurian\\b", "wn"},
    {"\\bwest\\s+pomeranian\\b", "zp"},
    {"\\bgreater\\s+poland\\b", "wp"},
    {"\\blower\\s+silesian\\b", "ds"},
    {"\\bswietokrzyskie\\b", "sk"},
    {"\\blesser\\s+poland\\b", "mp"},
    {"\\bsubcarpathian\\b", "pk"},
    {"\\bwielkopolskie\\b", "wp"},
    {"\\bdolnoslaskie\\b", "ds"},
    {"\\bpodkarpackie\\b", "pk"},
    {"\\bmalopolskie\\b", "mp"},
    {"\\bmazowieckie\\b", "ma"},
    {"\\bpomeranian\\b", "pm"},
    {"\\blubelskie\\b", "lu"},
    {"\\bmarszalek\\b", "marsz"},
    {"\\bpodlaskie\\b", "pd"},
    {"\\bpomorskie\\b", "pm"},
    {"\\bwarminsko\\b", "wn"},
    {"\\bkujawsko\\b", "kp"},
    {"\\blubuskie\\b", "lb"},
    {"\\bmasovian\\b", "ma"},
    {"\\bopolskie\\b", "op"},
    {"\\bpoludnie\\b", "south"},
    {"\\bsilesian\\b", "sl"},
    {"\\bwschodni\\b", "w"},
    {"\\bzachodni\\b", "z"},
    {"\\blodzkie\\b", "ld"},
    {"\\bosiedle\\b", "os"},
    {"\\bsilesia\\b", "sl"},
    {"\\bslaskie\\b", "sl"},
    {"\\blublin\\b", "lu"},
    {"\\blubusz\\b", "lb"},
    {"\\bpoland\\b", "pl"},
    {"\\bpolnoc\\b", "north"},
    {"\\bwschod\\b", "w"},
    {"\\bzachod\\b", "z"},
    {"\\bopole\\b", "op"},
    {"\\beast\\b", "w"},
    {"\\blodz\\b", "ld"},
    {"\\bwest\\b", "z"},
    {"\\bwlkp\\b", "wp"},
};

const Rule kRules_PR[] = {
    {"\\bsan\\s+juan\\s+antiguo\\b", "old san juan"},
    {"\\bpuerto\\s+rico\\b", "pr"},
    {"\\bcarretera\\b", "carr"},
    {"\\bmal\\s+paso\\b", "malpaso"},
    {"\\bavenida\\b", "av"},
    {"\\bbulevar\\b", "blvd"},
    {"\\bcamino\\b", "cm"},
    {"\\bcalle\\b", "cll"},
    {"\\bcourt\\b", "ct"},
    {"\\bnorth\\b", "n"},
    {"\\bpaseo\\b", "pso"},
    {"\\bplaza\\b", "plz"},
    {"\\bsaint\\b", "st"},
    {"\\bsouth\\b", "s"},
    {"\\bave\\.\\b", "av"},
    {"\\beast\\b", "e"},
    {"\\blane\\b", "ln"},
    {"\\bp\\.r\\.\\b", "pr"},
    {"\\broad\\b", "rd"},
    {"\\bwest\\b", "w"},
    {"\\bave\\b", "av"},
    {"\\bcam\\b", "cm"},
    {"\\bnth\\b", "n"},
    {"\\bp\\.r\\b", "pr"},
    {"\\bst\\.\\b", "st"},
    {"\\bsth\\b", "s"},
    {"\\be\\.\\b", "e"},
    {"\\bn\\.\\b", "n"},
    {"\\bs\\.\\b", "s"},
    {"\\bw\\.\\b", "w"},
};

const Rule kRules_PT[] = {
    {"\\bestrada\\s+nacional\\b", "n"},
    {"\\bviana\\s+do\\s+castelo\\b", "18"},
    {"\\bcastelo\\s+branco\\b", "09"},
    {"\\bportalegre\\b", "08"},
    {"\\bvila\\s+real\\b", "15"},
    {"\\bbraganca\\b", "14"},
    {"\\bportugal\\b", "pt"},
    {"\\bsantarem\\b", "03"},
    {"\\bcoimbra\\b", "11"},
    {"\\bsetubal\\b", "04"},
    {"\\baveiro\\b", "12"},
    {"\\bdoctor\\b", "dr"},
    {"\\bdoutor\\b", "dr"},
    {"\\bguarda\\b", "10"},
    {"\\bleiria\\b", "02"},
    {"\\blisbon\\b", "01"},
    {"\\bbraga\\b", "17"},
    {"\\bevora\\b", "07"},
    {"\\bnorth\\b", "n"},
    {"\\bporto\\b", "16"},
    {"\\bsouth\\b", "s"},
    {"\\bviseu\\b", "13"},
    {"\\bbeja\\b", "05"},
    {"\\bfaro\\b", "06"},
    {"\\bwest\\b", "w"},
    {"\\bdas\\b", ""},
    {"\\bdos\\b", ""},
    {"\\bsao\\b", "s"},
    {"\\bda\\b", ""},
    {"\\bde\\b", ""},
    {"\\bdo\\b", ""},
    {"\\bem\\b", "m"},
    {"\\ben\\b", "n"},
    {"\\be\\b", ""},
};

const Rule kRules_RO[] = {
    {"\\bromania\\b", "ro"},
};

const Rule kRules_RU[] = {
    {"\\bавтодорога\\b", "а/д"},
    {"\\bнабережная\\b", "наб"},
    {"\\bтерритория\\b", "тер"},
    {"\\bпереулок\\b", "пер"},
    {"\\bпроспект\\b", "пр"},
    {"\\bбульвар\\b", "б-р"},
    {"\\bквартал\\b", "кв-л"},
    {"\\bплощадь\\b", "пл"},
    {"\\brussia\\b", "ru"},
    {"\\bдорога\\b", "дор"},
    {"\\bпроезд\\b", "пр-д"},
    {"\\bроссия\\b", "ru"},
    {"\\bбульв\\b", "б-р"},
    {"\\bлиния\\b", "лин"},
    {"\\bпр\\-кт\\b", "пр"},
    {"\\bпросп\\b", "пр"},
    {"\\bтупик\\b", "туп"},
    {"\\bулица\\b", "ул"},
    {"\\bшоссе\\b", "ш"},
    {"\\bпрот\\b", "пр"},
    {"\\bбул\\b", "б-р"},
};

const Rule kRules_SE[] = {
    {"\\bvastra\\s+goetalands\\b", "o"},
    {"\\bvastra\\s+goetaland\\b", "o"},
    {"\\boestergoetlands\\b", "e"},
    {"\\bvasternorrlands\\b", "y"},
    {"\\boestergoetland\\b", "e"},
    {"\\bvastergoetland\\b", "e"},
    {"\\bvasternorrland\\b", "y"},
    {"\\bsodermanlands\\b", "d"},
    {"\\bvasterbottens\\b", "ac"},
    {"\\bjoenkoepings\\b", "f"},
    {"\\bsodermanland\\b", "d"},
    {"\\bvasterbotten\\b", "ac"},
    {"\\bvastmanlands\\b", "u"},
    {"\\bjoenkoeping\\b", "f"},
    {"\\bnorrbottens\\b", "bd"},
    {"\\bvastmanland\\b", "u"},
    {"\\bgavleborgs\\b", "x"},
    {"\\bkronobergs\\b", "g"},
    {"\\bnorrbotten\\b", "bd"},
    {"\\bstockholms\\b", "ab"},
    {"\\bgavleborg\\b", "x"},
    {"\\bjamtlands\\b", "z"},
    {"\\bkronoberg\\b", "g"},
    {"\\bstockholm\\b", "ab"},
    {"\\bvarmlands\\b", "s"},
    {"\\bblekinge\\b", "k"},
    {"\\bdalarnas\\b", "w"},
    {"\\bgotlands\\b", "i"},
    {"\\bhallands\\b", "n"},
    {"\\bjamtland\\b", "z"},
    {"\\boerebros\\b", "t"},
    {"\\bvarmland\\b", "s"},
    {"\\bdalarna\\b", "w"},
    {"\\bgotland\\b", "i"},
    {"\\bhalland\\b", "n"},
    {"\\boerebro\\b", "t"},
    {"\\bsverige\\b", "se"},
    {"\\buppsala\\b", "c"},
    {"\\bkalmar\\b", "h"},
    {"\\bsoeder\\b", "s"},
    {"\\bsweden\\b", "se"},
    {"\\bskane\\b", "m"},
    {"\\bnorr\\b", "n"},
    {"\\boest\\b", "o"},
    {"\\bvast\\b", "v"},
};

const Rule kRules_TH[] = {
    {"\\bประเทศไทย\\b", "th"},
    {"\\bthailand\\b", "th"},
};

const Rule kRules_TR[] = {
    {"\\bturkiye\\b", "tr"},
    {"\\bturkey\\b", "tr"},
};

const Rule kRules_US[] = {
    {"\\bjoint\\s+base\\s+elmendorf\\s+richardson\\b", "jber"},
    {"\\bwashington\\s+district\\s+of\\s+columbia\\b", "dc"},
    {"\\bfederated\\s+states\\s+of\\s+micronesia\\b", "fm"},
    {"\\bjoint\\s+base\\s+pearl\\s+harbor\\s+hickam\\b", "jbphh"},
    {"\\bnational\\s+forest\\s+development\\b", "nat for dev"},
    {"\\bmartin\\s+luther\\s+king\\s+junior\\b", "mlk"},
    {"\\barmed\\s+forces\\s+middle\\s+east\\b", "ae"},
    {"\\bmarine\\s+corps\\s+base\\s+hawaii\\b", "mcbh kanehoe bay"},
    {"\\bnational\\s+for\\s+development\\b", "nat for dev"},
    {"\\bnorthern\\s+mariana\\s+islands\\b", "mp"},
    {"\\bunited\\s+states\\s+of\\s+america\\b", "us"},
    {"\\bmartin\\s+luther\\s+king\\s+jnr\\b", "mlk"},
    {"\\bnat\\s+forest\\s+development\\b", "nat for dev"},
    {"\\barmed\\s+forces\\s+americas\\b", "aa"},
    {"\\bmartin\\s+luther\\s+king\\s+jr\\b", "mlk"},
    {"\\barmed\\s+forces\\s+pacific\\b", "ap"},
    {"\\bdistrict\\s+of\\s+columbia\\b", "dc"},
    {"\\barmed\\s+forces\\s+africa\\b", "ae"},
    {"\\barmed\\s+forces\\s+canada\\b", "ae"},
    {"\\barmed\\s+forces\\s+europe\\b", "ae"},
    {"\\bnat\\s+for\\s+development\\b", "nat for dev"},
    {"\\bnational\\s+forest\\s+dev\\b", "nat for dev"},
    {"\\bjoint\\s+reserve\\s+base\\b", "jrb"},
    {"\\blincolns\\s+new\\s+salem\\b", "lincoln nw sl"},
    {"\\bmartin\\s+luther\\s+king\\b", "mlk"},
    {"\\bmetropolitan\\s+area\\b", ""},
    {"\\bnational\\s+monument\\b", "national mo"},
    {"\\bcolorado\\s+springs\\b", "co spgs"},
    {"\\bdist\\s+of\\s+columbia\\b", "dc"},
    {"\\bfrancis\\s+e\\s+warren\\b", "fe warren"},
    {"\\bmarshall\\s+islands\\b", "mh"},
    {"\\bnational\\s+for\\s+dev\\b", "nat for dev"},
    {"\\bwashington\\s+state\\b", "wa"},
    {"\\bcharlottesville\\b", "charlottesvle"},
    {"\\badministration\\b", "admn"},
    {"\\bair\\s+force\\s+base\\b", "afb"},
    {"\\bamerican\\s+samoa\\b", "as"},
    {"\\bbradford\\s+woods\\b", "bradfordwoods"},
    {"\\bchristiansberg\\b", "christiansbrg"},
    {"\\bcrawfordsville\\b", "crawfordsvlle"},
    {"\\bfarm\\s+to\\s+market\\b", "fm"},
    {"\\bforest\\s+service\\b", "frst srvc"},
    {"\\bfredericksburg\\b", "fredericksbrg"},
    {"\\bhendersonville\\b", "hendersonvlle"},
    {"\\bjeffersonville\\b", "jeffersonvlle"},
    {"\\bjohn\\s+f\\s+kennedy\\b", "jfk"},
    {"\\blittle\\s+diomede\\b", "diomede"},
    {"\\bmechanicsville\\b", "mechanicsvlle"},
    {"\\bnat\\s+forest\\s+dev\\b", "nat for dev"},
    {"\\bnew\\s+york\\s+state\\b", "ny"},
    {"\\bnorth\\s+carolina\\b", "nc"},
    {"\\bnorthumberland\\b", "northumberlnd"},
    {"\\bsalt\\s+lake\\s+city\\b", "slc"},
    {"\\bsouth\\s+carolina\\b", "sc"},
    {"\\bvirgin\\s+islands\\b", "vi"},
    {"\\bwashington\\s+d\\s+c\\b", "dc"},
    {"\\barmy\\s+airfield\\b", "army af"},
    {"\\binternational\\b", "intl"},
    {"\\bjf\\s+kennedy\\s+ap\\b", "jfk airport"},
    {"\\bmassachusetts\\b", "ma"},
    {"\\bnational\\s+park\\b", "ntpk"},
    {"\\bnew\\s+hampshire\\b", "nh"},
    {"\\bnew\\s+york\\s+city\\b", "ny"},
    {"\\bunited\\s+states\\b", "us"},
    {"\\bwashington\\s+dc\\b", "dc"},
    {"\\bwest\\s+virginia\\b", "wv"},
    {"\\bbristle\\s+cone\\b", "bristlecone"},
    {"\\bfrst\\s+service\\b", "frst srvc"},
    {"\\bminers\\s+mills\\b", "miners mill"},
    {"\\bnorth\\s+dakota\\b", "nd"},
    {"\\bpennsylvania\\b", "pa"},
    {"\\brhode\\s+island\\b", "ri"},
    {"\\bservice\\s+road\\b", "service rd"},
    {"\\bsouth\\s+dakota\\b", "sd"},
    {"\\bswan\\s+quarter\\b", "swanquarter"},
    {"\\bbloomington\\b", "blmngtn"},
    {"\\bchevy\\s+chase\\b", "chevy chs"},
    {"\\bclutch\\s+city\\b", "houston"},
    {"\\bconnecticut\\b", "ct"},
    {"\\bforest\\s+srvc\\b", "frst srvc"},
    {"\\bfrenchville\\b", "frnchvl"},
    {"\\bgood\\s+fellow\\b", "goodfellow"},
    {"\\bhigh\\s+bridge\\b", "highbridge"},
    {"\\blos\\s+angeles\\b", "la"},
    {"\\bloxahatchee\\b", "lox"},
    {"\\bmississippi\\b", "ms"},
    {"\\bobservatory\\b", "obs"},
    {"\\bpuerto\\s+rico\\b", "pr"},
    {"\\brural\\s+route\\b", "rr"},
    {"\\bspringfield\\b", "spfld"},
    {"\\byellowstone\\b", "yelwstn"},
    {"\\balpen\\s+glow\\b", "alpenglow"},
    {"\\bambassador\\b", "amb"},
    {"\\bbernardino\\b", "bernrdno"},
    {"\\bbloomfield\\b", "bloomfld"},
    {"\\bbrownstown\\b", "brownstwn"},
    {"\\bburlington\\b", "burlngtn"},
    {"\\bcalifornia\\b", "ca"},
    {"\\bcapistrano\\b", "capo"},
    {"\\bchristmass\\b", "chirstmas"},
    {"\\bcincinnati\\b", "cin"},
    {"\\bcottonwood\\b", "ctwd"},
    {"\\bcrossroads\\b", "xrds"},
    {"\\bexpressway\\b", "exp"},
    {"\\bextensions\\b", "exts"},
    {"\\bfarmington\\b", "farmingtn"},
    {"\\bnew\\s+jersey\\b", "nj"},
    {"\\bnew\\s+mexico\\b", "nm"},
    {"\\bpittsburgh\\b", "pgh"},
    {"\\bplantation\\b", "plt"},
    {"\\bprovidence\\b", "providnce"},
    {"\\bsouth\\s+lake\\b", "southlake"},
    {"\\bthroughway\\b", "trwy"},
    {"\\btrafficway\\b", "trfy"},
    {"\\buniversity\\b", "univ"},
    {"\\bwashington\\b", "wa"},
    {"\\bwest\\s+point\\b", "westpoint"},
    {"\\bbellerose\\b", "bellrs"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bburlingtn\\b", "burlngtn"},
    {"\\bchair\\s+bar\\b", "chairbar"},
    {"\\bchicester\\b", "chicstr"},
    {"\\bcity\\s+base\\b", "cb"},
    {"\\bcleveland\\b", "cleve"},
    {"\\bcommunity\\b", "cmnty"},
    {"\\bcrossroad\\b", "xrd"},
    {"\\bextension\\b", "ext"},
    {"\\bfairmount\\b", "fairmt"},
    {"\\bfernandez\\b", "fdez"},
    {"\\bfrancisco\\b", "fran"},
    {"\\bhighlands\\b", "hlds"},
    {"\\bho\'olehua\\b", "hoolehua"},
    {"\\bhomestead\\b", "hmstd"},
    {"\\bjunctions\\b", "jcts"},
    {"\\blexington\\b", "lxngtn"},
    {"\\blouisiana\\b", "la"},
    {"\\bmilwaukee\\b", "milw"},
    {"\\bminnesota\\b", "mn"},
    {"\\bmountains\\b", "mtns"},
    {"\\brichfield\\b", "richfld"},
    {"\\bstravenue\\b", "stra"},
    {"\\btennessee\\b", ""},
    {"\\bterritory\\b", ""},
    {"\\btown\\s+line\\b", "t l"},
    {"\\bunderpass\\b", "upas"},
    {"\\bwashingtn\\b", "wa"},
    {"\\bwisconsin\\b", "wi"},
    {"\\barkansas\\b", "ar"},
    {"\\bbig\\s+bend\\b", "bg bnd"},
    {"\\bblooming\\b", "blmng"},
    {"\\bbullrush\\b", "bulrush"},
    {"\\bcauseway\\b", "cswy"},
    {"\\bcolorado\\b", "co"},
    {"\\bcottonwd\\b", "ctwd"},
    {"\\bcrescent\\b", "cres"},
    {"\\bcrossing\\b", "xing"},
    {"\\bcrossrds\\b", "xrds"},
    {"\\bdelaware\\b", "de"},
    {"\\bdowntown\\b", ""},
    {"\\bhartford\\b", "hartfrd"},
    {"\\billinois\\b", "il"},
    {"\\bjunction\\b", "jt"},
    {"\\bkentucky\\b", "ky"},
    {"\\bla\\s+salle\\b", "lasalle"},
    {"\\bmaryland\\b", "md"},
    {"\\bmichelle\\b", "michele"},
    {"\\bmichigan\\b", "mi"},
    {"\\bmissouri\\b", "mo"},
    {"\\bmotorway\\b", "mtwy"},
    {"\\bmountain\\b", "mnt"},
    {"\\bnational\\b", "nl"},
    {"\\bnebraska\\b", "ne"},
    {"\\bnew\\s+york\\b", "ny"},
    {"\\boklahoma\\b", "ok"},
    {"\\boverpass\\b", "opas"},
    {"\\bparkways\\b", "pkwys"},
    {"\\brichland\\b", "richlnd"},
    {"\\btownline\\b", "t l"},
    {"\\btownship\\b", "tp"},
    {"\\bturnpike\\b", "tpk"},
    {"\\bvillages\\b", "vlgs"},
    {"\\bvilliage\\b", "vil"},
    {"\\bvirginia\\b", "va"},
    {"\\balabama\\b", "al"},
    {"\\bamerica\\b", "us"},
    {"\\barizona\\b", "az"},
    {"\\bavenida\\b", "av"},
    {"\\bcapitol\\b", "capital"},
    {"\\bcausway\\b", "cswy"},
    {"\\bcenters\\b", "ctrs"},
    {"\\bcentral\\b", ""},
    {"\\bchicago\\b", "chgo"},
    {"\\bcircles\\b", "cirs"},
    {"\\bcollege\\b", "clg"},
    {"\\bcolonel\\b", "col"},
    {"\\bcorners\\b", "cors"},
    {"\\bcountry\\b", "cntry"},
    {"\\bcrecent\\b", "cres"},
    {"\\bcresent\\b", "cres"},
    {"\\bcrossrd\\b", "xrd"},
    {"\\bcrssing\\b", "xing"},
    {"\\bestates\\b", "ests"},
    {"\\bexpress\\b", "exp"},
    {"\\bflorida\\b", "fl"},
    {"\\bfreeway\\b", "fwy"},
    {"\\bgardens\\b", "gdns"},
    {"\\bgateway\\b", "gtwy"},
    {"\\bgeorgia\\b", "ga"},
    {"\\bharbors\\b", "hbrs"},
    {"\\bheights\\b", "ht"},
    {"\\bhighway\\b", "hwy"},
    {"\\bhollows\\b", "hllw"},
    {"\\bindiana\\b", "in"},
    {"\\bislands\\b", "is"},
    {"\\bjohnson\\b", "jhnsn"},
    {"\\bjuncton\\b", "jt"},
    {"\\blanding\\b", "lndg"},
    {"\\bmeadows\\b", "mdws"},
    {"\\bmission\\b", "msn"},
    {"\\bmontana\\b", "mt"},
    {"\\bmountin\\b", "mnt"},
    {"\\borchard\\b", "orch"},
    {"\\bparkway\\b", "pky"},
    {"\\bpassage\\b", "psge"},
    {"\\bphoenix\\b", "phx"},
    {"\\bplaines\\b", "plns"},
    {"\\bpotsdam\\b", "potsdm"},
    {"\\bprairie\\b", "pr"},
    {"\\branches\\b", "rnchs"},
    {"\\branchos\\b", "rnchs"},
    {"\\bseventh\\b", "7"},
    {"\\bsprings\\b", "spg"},
    {"\\bsquares\\b", "sqs"},
    {"\\bstation\\b", "sta"},
    {"\\bstraven\\b", "stra"},
    {"\\bstreets\\b", "sts"},
    {"\\bstrvnue\\b", "stra"},
    {"\\bterrace\\b", "ter"},
    {"\\btownshp\\b", "tp"},
    {"\\btunnels\\b", "tunl"},
    {"\\bvalleys\\b", "vlys"},
    {"\\bvermont\\b", "vt"},
    {"\\bviaduct\\b", "via"},
    {"\\bvillage\\b", "vil"},
    {"\\bwilliam\\b", "wm"},
    {"\\bwshngtn\\b", "wa"},
    {"\\bwyoming\\b", "wy"},
    {"\\balaska\\b", "ak"},
    {"\\barcade\\b", "arc"},
    {"\\bavenue\\b", "av"},
    {"\\bbarrio\\b", "bo"},
    {"\\bbluffs\\b", "blfs"},
    {"\\bbottom\\b", "bot"},
    {"\\bbranch\\b", "br"},
    {"\\bbridge\\b", "brg"},
    {"\\bbrooks\\b", "brks"},
    {"\\bbypass\\b", "byp"},
    {"\\bcamino\\b", "cm"},
    {"\\bcanyon\\b", "cyn"},
    {"\\bcarlin\\b", "carlan"},
    {"\\bcenter\\b", "cen"},
    {"\\bcentre\\b", "cen"},
    {"\\bcircle\\b", "cir"},
    {"\\bcliffs\\b", "clfs"},
    {"\\bcommon\\b", "cmn"},
    {"\\bcorner\\b", "cor"},
    {"\\bcorpus\\b", "crp"},
    {"\\bcounty\\b", ""},
    {"\\bcourse\\b", "crse"},
    {"\\bcourts\\b", "cts"},
    {"\\bcrscnt\\b", "cres"},
    {"\\bcrsent\\b", "cres"},
    {"\\bcrssng\\b", "xing"},
    {"\\bdesert\\b", "dsrt"},
    {"\\bdivide\\b", "dv"},
    {"\\bdrives\\b", "drs"},
    {"\\beighth\\b", "8"},
    {"\\bestate\\b", "est"},
    {"\\bextnsn\\b", "ext"},
    {"\\bfields\\b", "flds"},
    {"\\bforest\\b", "frst"},
    {"\\bforges\\b", "frgs"},
    {"\\bfourth\\b", "4"},
    {"\\bfreewy\\b", "fwy"},
    {"\\bgarden\\b", "gdn"},
    {"\\bgatewy\\b", "gtwy"},
    {"\\bgatway\\b", "gtwy"},
    {"\\bgreens\\b", "grns"},
    {"\\bgroves\\b", "grvs"},
    {"\\bharbor\\b", "hbr"},
    {"\\bhawaii\\b", "hi"},
    {"\\bheight\\b", "ht"},
    {"\\bhighwy\\b", "hwy"},
    {"\\bhollow\\b", "hllw"},
    {"\\bisland\\b", "is"},
    {"\\bislnds\\b", "is"},
    {"\\bjction\\b", "jt"},
    {"\\bjunctn\\b", "jt"},
    {"\\bkansas\\b", "ks"},
    {"\\bknolls\\b", "knls"},
    {"\\blagoon\\b", "lagn"},
    {"\\blights\\b", "lgts"},
    {"\\blittle\\b", "ltl"},
    {"\\bmanors\\b", "mnrs"},
    {"\\bmeadow\\b", "mdw"},
    {"\\bmedows\\b", "mdws"},
    {"\\bmiddle\\b", "mid"},
    {"\\bmntain\\b", "mnt"},
    {"\\bnevada\\b", "nv"},
    {"\\bobispo\\b", "obisp"},
    {"\\borchrd\\b", "orch"},
    {"\\boregon\\b", "or"},
    {"\\bparish\\b", ""},
    {"\\bparkwy\\b", "pky"},
    {"\\bplains\\b", "plns"},
    {"\\bpoints\\b", "pts"},
    {"\\bpuerto\\b", "pto"},
    {"\\bquarry\\b", "qry"},
    {"\\bradial\\b", "rad"},
    {"\\bradiel\\b", "rad"},
    {"\\brancho\\b", "rncho"},
    {"\\branchs\\b", "rnchs"},
    {"\\brapids\\b", "rpds"},
    {"\\bridges\\b", "rdgs"},
    {"\\bschool\\b", "sch"},
    {"\\bsecond\\b", "2"},
    {"\\bsenior\\b", "sr"},
    {"\\bshoals\\b", "shls"},
    {"\\bshoars\\b", "shrs"},
    {"\\bshores\\b", "shrs"},
    {"\\bskyway\\b", "skwy"},
    {"\\bspring\\b", "spg"},
    {"\\bsprngs\\b", "spg"},
    {"\\bsquare\\b", "sq"},
    {"\\bstrave\\b", "stra"},
    {"\\bstravn\\b", "stra"},
    {"\\bstream\\b", "strm"},
    {"\\bstreet\\b", "st"},
    {"\\bstreme\\b", "strm"},
    {"\\bsumitt\\b", "smt"},
    {"\\bsummit\\b", "smt"},
    {"\\bsydney\\b", "sidney"},
    {"\\btraces\\b", "trce"},
    {"\\btracks\\b", "trk"},
    {"\\btrails\\b", "tr"},
    {"\\btunnel\\b", "tunl"},
    {"\\bturnpk\\b", "tpk"},
    {"\\btwnshp\\b", "tp"},
    {"\\bunions\\b", "uns"},
    {"\\bvalley\\b", "vl"},
    {"\\bviadct\\b", "via"},
    {"\\bvillag\\b", "vil"},
    {"\\bwaters\\b", "wtr"},
    {"\\bxroads\\b", "xrds"},
    {"\\ba\\s+f\\s+b\\b", "afb"},
    {"\\ballee\\b", "aly"},
    {"\\balley\\b", "aly"},
    {"\\bannex\\b", "anx"},
    {"\\bavenu\\b", "av"},
    {"\\bavnue\\b", "av"},
    {"\\bbayoo\\b", "byu"},
    {"\\bbayou\\b", "byu"},
    {"\\bbeach\\b", "bch"},
    {"\\bblack\\b", "blk"},
    {"\\bbluff\\b", "blf"},
    {"\\bbottm\\b", "bot"},
    {"\\bboulv\\b", "blvd"},
    {"\\bbrdge\\b", "brg"},
    {"\\bbrnch\\b", "br"},
    {"\\bbrook\\b", "brk"},
    {"\\bburgs\\b", "bgs"},
    {"\\bbypas\\b", "byp"},
    {"\\bcalif\\b", "ca"},
    {"\\bcalle\\b", "cll"},
    {"\\bcanyn\\b", "cyn"},
    {"\\bcentr\\b", "cen"},
    {"\\bcircl\\b", "cir"},
    {"\\bcliff\\b", "clf"},
    {"\\bcnter\\b", "cen"},
    {"\\bcourt\\b", "ct"},
    {"\\bcoves\\b", "cvs"},
    {"\\bcrcle\\b", "cir"},
    {"\\bcreek\\b", "ck"},
    {"\\bcrest\\b", "crst"},
    {"\\bcrsnt\\b", "cres"},
    {"\\bcurve\\b", "curv"},
    {"\\bdepot\\b", "dep"},
    {"\\bdrive\\b", "dr"},
    {"\\beight\\b", "8"},
    {"\\bfalls\\b", "fls"},
    {"\\bferry\\b", "fry"},
    {"\\bfield\\b", "fld"},
    {"\\bfifth\\b", "5"},
    {"\\bfirst\\b", "1"},
    {"\\bflats\\b", "flts"},
    {"\\bfords\\b", "frds"},
    {"\\bforge\\b", "frg"},
    {"\\bforks\\b", "fks"},
    {"\\bfrway\\b", "fwy"},
    {"\\bgardn\\b", "gdn"},
    {"\\bglens\\b", "glns"},
    {"\\bgrand\\b", "grnd"},
    {"\\bgrden\\b", "gdn"},
    {"\\bgrdns\\b", "gdns"},
    {"\\bgreen\\b", "grn"},
    {"\\bgrove\\b", "grv"},
    {"\\bgtway\\b", "gtwy"},
    {"\\bharbr\\b", "hbr"},
    {"\\bhaven\\b", "hvn"},
    {"\\bhills\\b", "hl"},
    {"\\bhiway\\b", "hwy"},
    {"\\bholws\\b", "hllw"},
    {"\\bhouse\\b", "hse"},
    {"\\bhrbor\\b", "hbr"},
    {"\\bidaho\\b", "id"},
    {"\\binlet\\b", "inlt"},
    {"\\bisles\\b", "isle"},
    {"\\bislnd\\b", "is"},
    {"\\bjctns\\b", "jcts"},
    {"\\bknoll\\b", "knl"},
    {"\\blakes\\b", "lks"},
    {"\\blanes\\b", "la"},
    {"\\blight\\b", "lgt"},
    {"\\blndng\\b", "lndg"},
    {"\\blocks\\b", "lcks"},
    {"\\blodge\\b", "ldg"},
    {"\\bloops\\b", "loop"},
    {"\\blower\\b", "lo"},
    {"\\bm\\s+l\\s+k\\b", "mlk"},
    {"\\bmaine\\b", "me"},
    {"\\bmanor\\b", "mnr"},
    {"\\bmills\\b", "mls"},
    {"\\bmissn\\b", "msn"},
    {"\\bmntns\\b", "mtns"},
    {"\\bmount\\b", "mt"},
    {"\\bn\\s+y\\s+c\\b", "ny"},
    {"\\bninth\\b", "9"},
    {"\\bnorth\\b", "n"},
    {"\\bpalau\\b", "pw"},
    {"\\bpalms\\b", "plms"},
    {"\\bpaseo\\b", "pso"},
    {"\\bpaths\\b", "path"},
    {"\\bpikes\\b", "pike"},
    {"\\bpines\\b", "pnes"},
    {"\\bpkway\\b", "pky"},
    {"\\bplace\\b", "pl"},
    {"\\bplain\\b", "pln"},
    {"\\bplaza\\b", "plz"},
    {"\\bpoint\\b", "pt"},
    {"\\bponds\\b", "pnds"},
    {"\\bports\\b", "prts"},
    {"\\branch\\b", "rch"},
    {"\\brapid\\b", "rpd"},
    {"\\bridge\\b", "rdg"},
    {"\\briver\\b", "riv"},
    {"\\broads\\b", "rds"},
    {"\\broute\\b", "rt"},
    {"\\bsaint\\b", "st"},
    {"\\bseven\\b", "7"},
    {"\\bshoal\\b", "shl"},
    {"\\bshoar\\b", "shr"},
    {"\\bshore\\b", "shr"},
    {"\\bsixth\\b", "6"},
    {"\\bsouth\\b", "s"},
    {"\\bspace\\b", "sp"},
    {"\\bspngs\\b", "spg"},
    {"\\bsprgs\\b", "spg"},
    {"\\bsprng\\b", "spg"},
    {"\\bstatn\\b", "sta"},
    {"\\bstrav\\b", "stra"},
    {"\\bstrvn\\b", "stra"},
    {"\\bsumit\\b", "smt"},
    {"\\btenth\\b", "10"},
    {"\\btexas\\b", "tx"},
    {"\\bthird\\b", "3"},
    {"\\bthree\\b", "3"},
    {"\\btrace\\b", "trce"},
    {"\\btrack\\b", "trk"},
    {"\\btrail\\b", "tr"},
    {"\\btrnpk\\b", "tpk"},
    {"\\btunel\\b", "tunl"},
    {"\\btunls\\b", "tunl"},
    {"\\btunnl\\b", "tunl"},
    {"\\bu\\s+s\\s+a\\b", "us"},
    {"\\bunion\\b", "un"},
    {"\\bvally\\b", "vl"},
    {"\\bverdi\\b", "verde"},
    {"\\bviews\\b", "vws"},
    {"\\bville\\b", "vl"},
    {"\\bvillg\\b", "vil"},
    {"\\bvista\\b", "vis"},
    {"\\bwells\\b", "wls"},
    {"\\bwoods\\b", "wds"},
    {"\\bworks\\b", "wks"},
    {"\\bxroad\\b", "xrd"},
    {"\\bally\\b", "aly"},
    {"\\banex\\b", "anx"},
    {"\\bariz\\b", "az"},
    {"\\baven\\b", "av"},
    {"\\bbend\\b", "bnd"},
    {"\\bbluf\\b", "blf"},
    {"\\bboul\\b", "blvd"},
    {"\\bburg\\b", "bg"},
    {"\\bbyng\\b", "bing"},
    {"\\bbypa\\b", "byp"},
    {"\\bbyps\\b", "byp"},
    {"\\bcamp\\b", "cp"},
    {"\\bcape\\b", "cpe"},
    {"\\bcent\\b", "cen"},
    {"\\bcirc\\b", "cir"},
    {"\\bcity\\b", "cy"},
    {"\\bclub\\b", "clb"},
    {"\\bcntr\\b", "cen"},
    {"\\bcnyn\\b", "cyn"},
    {"\\bcolo\\b", "co"},
    {"\\bconn\\b", "ct"},
    {"\\bcove\\b", "cv"},
    {"\\bcrcl\\b", "cir"},
    {"\\bdale\\b", "dl"},
    {"\\bdriv\\b", "dr"},
    {"\\beast\\b", "e"},
    {"\\bexpr\\b", "exp"},
    {"\\bexpw\\b", "exp"},
    {"\\bexpy\\b", "exp"},
    {"\\bextn\\b", "ext"},
    {"\\bfarm\\b", "frm"},
    {"\\bfive\\b", "5"},
    {"\\bflat\\b", "flt"},
    {"\\bford\\b", "frd"},
    {"\\bforg\\b", "frg"},
    {"\\bfork\\b", "frk"},
    {"\\bfort\\b", "ft"},
    {"\\bfour\\b", "4"},
    {"\\bfrks\\b", "fks"},
    {"\\bfrry\\b", "fry"},
    {"\\bfrwy\\b", "fwy"},
    {"\\bglen\\b", "gln"},
    {"\\bgrdn\\b", "gdn"},
    {"\\bgrov\\b", "grv"},
    {"\\bguam\\b", "gu"},
    {"\\bharb\\b", "hbr"},
    {"\\bhavn\\b", "hvn"},
    {"\\bhght\\b", "ht"},
    {"\\bhgts\\b", "ht"},
    {"\\bhill\\b", "hl"},
    {"\\bhiwy\\b", "hwy"},
    {"\\bholw\\b", "hllw"},
    {"\\bhway\\b", "hwy"},
    {"\\biowa\\b", "ia"},
    {"\\bjctn\\b", "jt"},
    {"\\bjnct\\b", "jt"},
    {"\\bkans\\b", "ks"},
    {"\\bkeys\\b", "kys"},
    {"\\bknol\\b", "knl"},
    {"\\blake\\b", "lk"},
    {"\\blane\\b", "la"},
    {"\\bldge\\b", "ldg"},
    {"\\blitl\\b", "ltl"},
    {"\\bloaf\\b", "lf"},
    {"\\block\\b", "lck"},
    {"\\blodg\\b", "ldg"},
    {"\\bmass\\b", "ma"},
    {"\\bmich\\b", "mi"},
    {"\\bmile\\b", "mle"},
    {"\\bmill\\b", "ml"},
    {"\\bminn\\b", "mn"},
    {"\\bmiss\\b", "ms"},
    {"\\bmntn\\b", "mnt"},
    {"\\bmssn\\b", "msn"},
    {"\\bmtin\\b", "mnt"},
    {"\\bnebr\\b", "ne"},
    {"\\bneck\\b", "nck"},
    {"\\bnine\\b", "9"},
    {"\\bohio\\b", "oh"},
    {"\\bokla\\b", "ok"},
    {"\\boreg\\b", "or"},
    {"\\boval\\b", "ovl"},
    {"\\bpalm\\b", "plm"},
    {"\\bpark\\b", "pk"},
    {"\\bpass\\b", "ps"},
    {"\\bpine\\b", "pne"},
    {"\\bpkwy\\b", "pky"},
    {"\\bplza\\b", "plz"},
    {"\\bport\\b", "prt"},
    {"\\bradl\\b", "rad"},
    {"\\brdge\\b", "rdg"},
    {"\\brest\\b", "rst"},
    {"\\brivr\\b", "riv"},
    {"\\brnch\\b", "rch"},
    {"\\broad\\b", "rd"},
    {"\\bspgs\\b", "spg"},
    {"\\bspng\\b", "spg"},
    {"\\bsprg\\b", "spg"},
    {"\\bsqre\\b", "sq"},
    {"\\bsqrs\\b", "sqs"},
    {"\\bstrt\\b", "st"},
    {"\\btenn\\b", ""},
    {"\\bterr\\b", "ter"},
    {"\\btown\\b", ""},
    {"\\btpke\\b", "tpk"},
    {"\\btrak\\b", "trk"},
    {"\\btrks\\b", "trk"},
    {"\\btrls\\b", "tr"},
    {"\\btrpk\\b", "tpk"},
    {"\\btwln\\b", "t l"},
    {"\\btwsp\\b", "tp"},
    {"\\butah\\b", "ut"},
    {"\\bvdct\\b", "via"},
    {"\\bview\\b", "vw"},
    {"\\bvill\\b", "vil"},
    {"\\bvist\\b", "vis"},
    {"\\bvlly\\b", "vl"},
    {"\\bvsta\\b", "vis"},
    {"\\bwash\\b", "wa"},
    {"\\bwell\\b", "wl"},
    {"\\bwest\\b", "w"},
    {"\\bx\\s+rd\\b", "xrd"},
    {"\\bala\\b", "al"},
    {"\\bave\\b", "av"},
    {"\\bavn\\b", "av"},
    {"\\bbtm\\b", "bot"},
    {"\\bcam\\b", "cm"},
    {"\\bcmp\\b", "cp"},
    {"\\bcrk\\b", "ck"},
    {"\\bcrt\\b", "ct"},
    {"\\bctr\\b", "cen"},
    {"\\bcty\\b", "cy"},
    {"\\bd\\s+c\\b", "dc"},
    {"\\bdam\\b", "dm"},
    {"\\bdiv\\b", "dv"},
    {"\\bdpt\\b", "dep"},
    {"\\bdrv\\b", "dr"},
    {"\\bdvd\\b", "dv"},
    {"\\bfla\\b", "fl"},
    {"\\bfrt\\b", "ft"},
    {"\\bhei\\b", "ht"},
    {"\\bhls\\b", "hl"},
    {"\\bhts\\b", "ht"},
    {"\\bill\\b", "il"},
    {"\\bind\\b", "in"},
    {"\\bisl\\b", "is"},
    {"\\biss\\b", "is"},
    {"\\bjct\\b", "jt"},
    {"\\bkan\\b", "ks"},
    {"\\bkey\\b", "ky"},
    {"\\bl\\s+a\\b", "la"},
    {"\\blke\\b", "lk"},
    {"\\blwr\\b", "lo"},
    {"\\bmtn\\b", "mnt"},
    {"\\bn\\s+c\\b", "nc"},
    {"\\bn\\s+d\\b", "nd"},
    {"\\bn\\s+h\\b", "nh"},
    {"\\bn\\s+j\\b", "nj"},
    {"\\bn\\s+m\\b", "nm"},
    {"\\bn\\s+y\\b", "ny"},
    {"\\bneb\\b", "ne"},
    {"\\bnev\\b", "nv"},
    {"\\bnth\\b", "n"},
    {"\\bntl\\b", "nl"},
    {"\\bnyc\\b", "ny"},
    {"\\bnys\\b", "ny"},
    {"\\bone\\b", "1"},
    {"\\bore\\b", "or"},
    {"\\bp\\s+r\\b", "pr"},
    {"\\bprk\\b", "pk"},
    {"\\bprr\\b", "pr"},
    {"\\br\\s+i\\b", "ri"},
    {"\\brte\\b", "rt"},
    {"\\brvr\\b", "riv"},
    {"\\bs\\s+c\\b", "sc"},
    {"\\bs\\s+d\\b", "sd"},
    {"\\bsan\\b", "sn"},
    {"\\bsix\\b", "6"},
    {"\\bspr\\b", "spg"},
    {"\\bsqr\\b", "sq"},
    {"\\bsqu\\b", "sq"},
    {"\\bsth\\b", "s"},
    {"\\bstn\\b", "sta"},
    {"\\bstr\\b", "st"},
    {"\\bten\\b", "10"},
    {"\\btrl\\b", "tr"},
    {"\\btwo\\b", "2"},
    {"\\btwp\\b", "tp"},
    {"\\bu\\s+s\\b", "us"},
    {"\\busa\\b", "us"},
    {"\\bv\\s+i\\b", "vi"},
    {"\\bvlg\\b", "vil"},
    {"\\bvly\\b", "vl"},
    {"\\bvst\\b", "vis"},
    {"\\bw\\s+v\\b", "wv"},
    {"\\bway\\b", "wy"},
    {"\\bwis\\b", "wi"},
    {"\\bwva\\b", "wv"},
    {"\\bcr\\b", "ck"},
    {"\\bln\\b", "la"},
    {"\\btn\\b", ""},
    {"\\btw\\b", "tp"},
    {"\\bvy\\b", "vl"},
    {"\\b\\#\\b", ""},
};

const Rule kRules_VN[] = {
    {"\\bthi\\s+tran\\s+van\\s+dien\\b", "ttvan dien"},
    {"\\bho\\s+chi\\s+minh\\s+city\\b", "hcm"},
    {"\\bho\\s+chi\\s+minh\\b", "hcm"},
    {"\\bthanh\\s+pho\\b", "tp"},
    {"\\bthi\\s+tran\\b", "tt"},
    {"\\btpha\\s+noi\\b", "ha noi"},
    {"\\bviet\\s+nam\\b", "vn"},
    {"\\bvietnam\\b", "vn"},
    {"\\bphuong\\b", "p"},
    {"\\bthi\\s+xa\\b", "tx"},
    {"\\bhuyen\\b", "h."},
    {"\\bhcmc\\b", "hcm"},
    {"\\bquan\\b", "q."},
    {"\\bph\\.\\b", "p"},
    {"\\btp\\.\\b", "tp"},
    {"\\btt\\.\\b", "tt"},
    {"\\btx\\.\\b", "tx"},
    {"\\bp\\.\\b", "p"},
    {"\\bxa\\b", "x."},
};

const Rule kRules_ZA[] = {
    {"\\brepublic\\s+of\\s+south\\s+africa\\b", "sa"},
    {"\\bkwazulu\\s+natal\\b", "nl"},
    {"\\bnorthern\\s+cape\\b", "nc"},
    {"\\beastern\\s+cape\\b", "ec"},
    {"\\bkwazulunatal\\b", "nl"},
    {"\\bsouth\\s+africa\\b", "sa"},
    {"\\bwestern\\s+cape\\b", "wc"},
    {"\\bfree\\s+state\\b", "fs"},
    {"\\bmpumalanga\\b", "mp"},
    {"\\bnoord\\s+kaap\\b", "nc"},
    {"\\bnorth\\s+west\\b", "nw"},
    {"\\bboulevard\\b", "blvd"},
    {"\\bfreestate\\b", "fs"},
    {"\\bnoordwes\\b", "nw"},
    {"\\boos\\s+kaap\\b", "ec"},
    {"\\bvrystaat\\b", "fs"},
    {"\\bwes\\s+kaap\\b", "wc"},
    {"\\bgauteng\\b", "gp"},
    {"\\bhighway\\b", "hwy"},
    {"\\blimpopo\\b", "lp"},
    {"\\bavenue\\b", "ave"},
    {"\\bstreet\\b", "st"},
    {"\\bdrive\\b", "dr"},
    {"\\bnatal\\b", "nl"},
    {"\\bsaint\\b", "st"},
    {"\\broad\\b", "rd"},
    {"\\bkzn\\b", "nl"},
    {"\\bgt\\b", "gp"},
    {"\\bza\\b", "sa"},
    {"\\bzn\\b", "nl"},
};

}  // namespace

const RegionInfo kRuleTable[] = {
   {"AD", kRules_AD, sizeof(kRules_AD)/sizeof(kRules_AD[0])},
   {"AR", kRules_AR, sizeof(kRules_AR)/sizeof(kRules_AR[0])},
   {"AU", kRules_AU, sizeof(kRules_AU)/sizeof(kRules_AU[0])},
   {"BE", kRules_BE, sizeof(kRules_BE)/sizeof(kRules_BE[0])},
   {"BR", kRules_BR, sizeof(kRules_BR)/sizeof(kRules_BR[0])},
   {"CA", kRules_CA, sizeof(kRules_CA)/sizeof(kRules_CA[0])},
   {"CH", kRules_CH, sizeof(kRules_CH)/sizeof(kRules_CH[0])},
   {"CL", kRules_CL, sizeof(kRules_CL)/sizeof(kRules_CL[0])},
   {"CO", kRules_CO, sizeof(kRules_CO)/sizeof(kRules_CO[0])},
   {"DE", kRules_DE, sizeof(kRules_DE)/sizeof(kRules_DE[0])},
   {"DK", kRules_DK, sizeof(kRules_DK)/sizeof(kRules_DK[0])},
   {"ES", kRules_ES, sizeof(kRules_ES)/sizeof(kRules_ES[0])},
   {"FR", kRules_FR, sizeof(kRules_FR)/sizeof(kRules_FR[0])},
   {"GB", kRules_GB, sizeof(kRules_GB)/sizeof(kRules_GB[0])},
   {"GR", kRules_GR, sizeof(kRules_GR)/sizeof(kRules_GR[0])},
   {"HK", kRules_HK, sizeof(kRules_HK)/sizeof(kRules_HK[0])},
   {"ID", kRules_ID, sizeof(kRules_ID)/sizeof(kRules_ID[0])},
   {"IE", kRules_IE, sizeof(kRules_IE)/sizeof(kRules_IE[0])},
   {"IN", kRules_IN, sizeof(kRules_IN)/sizeof(kRules_IN[0])},
   {"IT", kRules_IT, sizeof(kRules_IT)/sizeof(kRules_IT[0])},
   {"LU", kRules_LU, sizeof(kRules_LU)/sizeof(kRules_LU[0])},
   {"MX", kRules_MX, sizeof(kRules_MX)/sizeof(kRules_MX[0])},
   {"MY", kRules_MY, sizeof(kRules_MY)/sizeof(kRules_MY[0])},
   {"NL", kRules_NL, sizeof(kRules_NL)/sizeof(kRules_NL[0])},
   {"NZ", kRules_NZ, sizeof(kRules_NZ)/sizeof(kRules_NZ[0])},
   {"PE", kRules_PE, sizeof(kRules_PE)/sizeof(kRules_PE[0])},
   {"PH", kRules_PH, sizeof(kRules_PH)/sizeof(kRules_PH[0])},
   {"PL", kRules_PL, sizeof(kRules_PL)/sizeof(kRules_PL[0])},
   {"PR", kRules_PR, sizeof(kRules_PR)/sizeof(kRules_PR[0])},
   {"PT", kRules_PT, sizeof(kRules_PT)/sizeof(kRules_PT[0])},
   {"RO", kRules_RO, sizeof(kRules_RO)/sizeof(kRules_RO[0])},
   {"RU", kRules_RU, sizeof(kRules_RU)/sizeof(kRules_RU[0])},
   {"SE", kRules_SE, sizeof(kRules_SE)/sizeof(kRules_SE[0])},
   {"TH", kRules_TH, sizeof(kRules_TH)/sizeof(kRules_TH[0])},
   {"TR", kRules_TR, sizeof(kRules_TR)/sizeof(kRules_TR[0])},
   {"US", kRules_US, sizeof(kRules_US)/sizeof(kRules_US[0])},
   {"VN", kRules_VN, sizeof(kRules_VN)/sizeof(kRules_VN[0])},
   {"ZA", kRules_ZA, sizeof(kRules_ZA)/sizeof(kRules_ZA[0])},
};

const size_t kRuleTableSize = sizeof(kRuleTable)/sizeof(kRuleTable[0]);
}  // namespace internal
}  // namespace autofill
