#ifndef INCLUDE_MODULE_PEEP_H
#define INCLUDE_MODULE_PEEP_H
/* ----------------------------------------------------------------------------
 * module_peep.h
 * prototypes and definitions for the module peep.
 *
 * Copyright 2002-2005 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

struct tagtable {
	char *tagname;
	long tag;
};

/* public prototypes */
int peep_init ();
int peep_open (struct tagitem *taglist);
int peep_exit ();

/* private prototypes */
void peep_keyboard (struct tagitem *taglist);
void peep_mouse (struct tagitem *taglist);
void peep_t10 (struct tagitem *taglist);
void peep_t100 (struct tagitem *taglist);
void peep_t1000 (struct tagitem *taglist);
void peep_ipc (struct tagitem *taglist);
void peep_config (struct tagitem *taglist);
void peep_query (struct tagitem *taglist);
void peep_secure (struct tagitem *taglist);
void peep_taglist (char *source, struct tagitem *taglist);
struct tagtable *findttentry (struct tagtable *ttab, long tag);

#endif    /* INCLUDE_MODULE_PEEP_H */
