/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.RootPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCheckBox
extends FocusWidget
implements HasName,
TakesValue<Boolean>,
IsEditor<LeafValueEditor<Boolean>> {
    private LeafValueEditor<Boolean> editor;

    public static SimpleCheckBox wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        SimpleCheckBox checkBox = new SimpleCheckBox(element);
        checkBox.onAttach();
        RootPanel.detachOnWindowClose(checkBox);
        return checkBox;
    }

    public SimpleCheckBox() {
        this(Document.get().createCheckInputElement(), "gwt-SimpleCheckBox");
    }

    protected SimpleCheckBox(Element element) {
        assert (InputElement.as(element).getType().equalsIgnoreCase("checkbox"));
        this.setElement(element);
    }

    SimpleCheckBox(Element element, String styleName) {
        this.setElement(element);
        if (styleName != null) {
            this.setStyleName(styleName);
        }
    }

    @Override
    public LeafValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public String getFormValue() {
        return this.getInputElement().getValue();
    }

    @Override
    public String getName() {
        return this.getInputElement().getName();
    }

    @Override
    public Boolean getValue() {
        String propName = this.isAttached() ? "checked" : "defaultChecked";
        return this.getInputElement().getPropertyBoolean(propName);
    }

    @Deprecated
    public boolean isChecked() {
        return this.getValue() == true;
    }

    @Deprecated
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.removeStyleDependentName("disabled");
        } else {
            this.addStyleDependentName("disabled");
        }
    }

    public void setFormValue(String value) {
        this.getInputElement().setAttribute("value", value);
    }

    @Override
    public void setName(String name) {
        this.getInputElement().setName(name);
    }

    @Override
    public void setValue(Boolean value) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        this.getInputElement().setChecked(value);
        this.getInputElement().setDefaultChecked(value);
    }

    @Override
    protected void onUnload() {
        this.setValue(this.getValue());
    }

    private InputElement getInputElement() {
        return InputElement.as(this.getElement());
    }
}

