# Set the identifier of the current archive
# USAGE: set_current_archive $archive
set_current_archive() {
	local archive
	archive="$1"

	# Check that the identifier uses the expected ARCHIVE_BASE_xxx format.
	local regexp
	regexp='^ARCHIVE_BASE\(_[0-9A-Z]\+\)*_[0-9]\+$'
	if ! printf '%s' "$archive" | grep --quiet --regexp="$regexp"; then
		# Allow the old ARCHIVE_xxx format when targeting a compatibility level < 2.21.
		if ! compatibility_level_is_at_least '2.21'; then
			regexp='^ARCHIVE\(_[0-9A-Z]\+\)\+$'
			if ! printf '%s' "$archive" | grep --quiet --regexp="$regexp"; then
				error_current_archive_format_invalid "$archive"
				return 1
			fi
		else
			error_current_archive_format_invalid "$archive"
			return 1
		fi
	fi

	export PLAYIT_CONTEXT_ARCHIVE="$archive"
}

# Print the identifier of the current archive.
# USAGE: current_archive
# RETURNS: the current archive identifier,
#          or an empty string if no archive is set
current_archive() {
	# To ensure backwards-compatibility, the legacy variable should have a higher priority than the modern one.
	# Otherwise the ability to set the context using $ARCHIVE from game scripts would be lost as soon as the library calls set_current_archive.
	local archive
	archive="${ARCHIVE:-}"
	if \
		[ -n "$archive" ] && \
		compatibility_level_is_at_least '2.27'
	then
		warning_context_legacy_archive
	fi

	if [ -z "$archive" ]; then
		archive="${PLAYIT_CONTEXT_ARCHIVE:-}"
	fi

	printf '%s' "$archive"
}

