# Ren'Py - Print the launcher script content
# USAGE: renpy_launcher $application
renpy_launcher() {
	local application
	application="$1"

	local prefix_type
	prefix_type=$(application_prefix_type "$application")
	case "$prefix_type" in
		('none')
			launcher_headers
			renpy_launcher_run
			launcher_exit
		;;
		(*)
			error_launchers_prefix_type_unsupported "$application"
			return 1
		;;
	esac
}

# Ren'Py - Run Ren'Py
# USAGE: renpy_launcher_run
renpy_launcher_run() {
	cat <<- 'EOF'
	# Run the game

	EOF

	application_prerun "$application"
	game_exec_line "$application"
	application_postrun "$application"
}

# Ren'Py - Print the line starting the game
# USAGE: renpy_exec_line $application
# RETURN: the command to execute
renpy_exec_line() {
	## The application identifier is not actually used for Ren'Py games,
	## it is only passed for consistency with other *_exec_line functions.
	local application
	application="$1"

	local path_game
	path_game=$(path_game_data)

	cat <<- EOF
	renpy "$path_game"
	EOF
}

