!{\src2tex{textfont=tt}}
!!****f* ABINIT/ccgradvnl_ylm
!! NAME
!! ccgradvnl_ylm
!!
!! FUNCTION
!!  Compute Vnl(K) and grad_K Vnl(K) three reciprocal lattice units components
!!  using spherical harmonics instead of Legendre polynomials
!!  Needed for chi0(q=0)
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (FB, MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  a1(3),a2(3),a3(3)=the three primitive vectors
!!  b1(3),b2(3),b3(3)=the three primitive vectors in reciprocal space
!!  gvec(3,npwwfn)=integer coordinates of each plane wave in reciprocal space
!!  kibz(3,nkibz)=coordinates of all k points in the irreducible Brillouin zone
!!  mpsang=1+maximum angular momentum for nonlocal pseudopotentials
!!  natom=number of atoms
!!  nkibz=number of k points in the irreducible Brillouin zone
!!  npwwfn=number of planewaves for wavefunctions
!!  ntypat=number of types of atoms
!!  typat(natom)=type of each atom
!!  vkb(npwwfn,ntypat,mpsang,nkibz)=KB projector function
!!  vkbd(npwwfn,ntypat,mpsang,nkibz)=derivative of the KB projector function in reciprocal space
!!  vkbsign(mpsang,ntypat)=sign of each KB dyadic product
!!  xcart(3,natom)=cartesian coordinates of nuclei
!!
!! OUTPUT
!!  l_fnl(npwwfn,mpsang*mpsang,natom,nkibz),
!!  l_fnld(3,npwwfn,mpsang*mpsang,natom,nkibz)
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  Subroutine taken from the EXC code  
!!  All the calculations are done in double precision, but the output arrays l_fnl and l_fnld 
!!  are in single precision, should use double precision after modification of the
!!  other subroutines 
!!  the subroutine does not work wity pseudo with more that one projector per
!!  angular state FIXME 
!!
!! PARENTS
!!  
!! CHILDREN
!!  
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine ccgradvnl_ylm(npwwfn,nkibz,a1,a2,a3,b1,b2,b3,gvec,kibz,ntypat,natom,&
&                        mpsang,typat,xcart,vkbsign,vkb,vkbd,l_fnl,l_fnld)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: mpsang,natom,nkibz,npwwfn,ntypat
!arrays
 integer,intent(in) :: gvec(3,npwwfn),typat(natom)
 real(dp),intent(in) :: a1(3),a2(3),a3(3),b1(3),b2(3),b3(3),kibz(3,nkibz)
 real(dp),intent(in) :: vkb(npwwfn,ntypat,mpsang,nkibz)
 real(dp),intent(in) :: vkbd(npwwfn,ntypat,mpsang,nkibz),vkbsign(mpsang,ntypat)
 real(dp),intent(in) :: xcart(3,natom)
 complex,intent(out) :: l_fnl(npwwfn,mpsang*mpsang,natom,nkibz)
 complex,intent(out) :: l_fnld(3,npwwfn,mpsang*mpsang,natom,nkibz)

!Local variables-------------------------------
!scalars
 integer,parameter :: nlx=3
 integer :: i,ia,ig,ik,il,im,iml,is,istat,j,lmax
 real(dp),parameter :: pad=tol8
 real(dp) :: cosphi,costh,factor,mkg,mkg2,sinphi,sinth,sq,xdotg
 complex(dpc) :: dphi,dth,sfac
 logical,parameter :: DEBUG=.false.
 character(len=500) :: message
!arrays
 real(dp) :: gcart(3),kcart(3),kg(3)
 complex(dpc) :: dylmcart(3),dylmcrys(3),gradphi(3),gradth(3)

! *************************************************************************

!DEBUG
!write(std_out,*)' ccgradvnl_ylm : enter '
!ENDDEBUG
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 complex(dpc) :: ylmc
#endif
!End of the abilint section

 write(message,'(a)')' limit q->0, including term <n,k|[Vnl,iqr]|n"k> using Y_lm'
 call wrtout(6,message,'COLL')

 lmax = mpsang
 if(mpsang>nlx) then
  write(message,'(5a)')&
&  ' ccgradvnl_ylm:  WARNING- ',ch10,&
&  ' number of angular momentum components bigger than programmed.',ch10,&
   ' taken into account only s p d f ' 
  lmax = nlx
 end if

 if(DEBUG) then
  write(*,*)' mpsang ',mpsang
  write(*,*)' ntypat ', ntypat, 'natom ',natom
  write(*,*)' type ',typat
  write(*,*)' vkbsign ',vkbsign
  write(*,*)' vkb(1:3,1,1,1) ',vkb(1:3,1,1,1)
  write(*,*)' vkbd(1:3,1,1,1) ',vkbd(1:3,1,1,1)
  write(*,*)' nikbz',nkibz
  write(*,*)' xcart ',xcart
  write(*,*)' a1',a1(:)
  write(*,*)' b1',b1(:)
 end if

 !Kleiman-Bylander factor and first derivative      
 l_fnl=(0.,0.)
 l_fnld=(0.,0.)

 do ik = 1,nkibz
  do ig = 1,npwwfn

   !kg = k + G in crystallographic coordinates
   kg(:) = kibz(:,ik) + real(gvec(:,ig))

   kcart(:) = kg(1)*b1(:)+kg(2)*b2(:)+kg(3)*b3(:)

   !the next to solve the problem with sinth=0. or sinphi=0.
   if(abs(kcart(2))<pad) kcart(2) = kcart(2)+pad

   mkg2 = kcart(1)**2+kcart(2)**2+kcart(3)**2
   mkg = sqrt(mkg2)
   sq =  sqrt(kcart(1)**2+kcart(2)**2)

   gcart(:) = real(gvec(1,ig))*b1(:)&
&            +real(gvec(2,ig))*b2(:)&
&            +real(gvec(3,ig))*b3(:)

   !(th,phi) spherical coordinates
   costh = kcart(3)/mkg
   sinth = sq/mkg
   cosphi = kcart(1)/sq
   sinphi = kcart(2)/sq
 
   gradth(1) = kcart(1)*kcart(3)/mkg**3/sinth
   gradth(2) = kcart(2)*kcart(3)/mkg**3/sinth
   gradth(3) = -(1.d0/mkg-kcart(3)**2/mkg**3)/sinth
   gradphi(1) = -(1.d0/sq - kcart(1)**2/sq**3)/sinphi
   gradphi(2) = kcart(2)*kcart(1)/sq**3/sinphi
   gradphi(3) = (0.d0,0.d0)
  
   !shoul be possible loop over ntypat, this will lead to a speed up in the
   !application of the gradient of the non local operator 
   do ia = 1,natom

    is=typat(ia)
    xdotg = gcart(1)*xcart(1,ia)+gcart(2)*xcart(2,ia)+gcart(3)*xcart(3,ia)

    !remember that in the GW code the reciprocal vectors 
    !are defined such as a_i*b_j = 2pi delta_ij
    sfac = cmplx(cos(xdotg),sin(xdotg)) 

    do il = 1,lmax
     factor = sqrt(4.d0*pi/real(2*(il-1)+1))
     do im= 1,2*(il-1)+1

      !index of im and il
      iml = im+(il-1)*(il-1)

      !first k-b factor
      !note that l_fnl is simple precision complex, should be possible however use double precision
      l_fnl(ig,iml,ia,ik) = &
&      factor * sfac * ylmc(il-1,im-il,kcart) * vkb(ig,is,il,ik) * vkbsign(il,is)

      !second k-b factor (involving first derivatives)
      call ylmcd(il-1,im-il,kcart,dth,dphi)

      !dYlm/dK = dYlm/dth * grad_K th + dYlm/dphi + grad_K phi
      dylmcart(:) = dth * gradth(:) + dphi * gradphi(:)

      !cartesian to crystallographic axis
      dylmcrys(:) = ( dylmcart(1)*a1(:)&
&                    +dylmcart(2)*a2(:)&
&                    +dylmcart(3)*a3(:) ) /(2.d0*pi)
      do i = 1,3
      !note that l_fnld is simple precision complex, could be possible however use double precision
       l_fnld(i,ig,iml,ia,ik) = factor * sfac * (             &
        kg(i)/mkg * ylmc(il-1,im-il,kcart) * vkbd(ig,is,il,ik)&
&       + dylmcrys(i) * vkb(ig,is,il,ik)                      &
        )
      end do 

     end do !im
    end do !il
   end do !ia
  end do !ig
 end do !ik

!DEBUG
!write(std_out,*)' ccgradvnl_ylm : exit'
!stop
!ENDDEBUG

end subroutine ccgradvnl_ylm
!!***
