!!****m* ABINIT/interfaces_13paw
!! NAME
!! interfaces_13paw
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/13paw
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_13paw

 interface
  subroutine chkpawovlp(natom,ntypat,pawovlp,pawtab,rmet,typat,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: natom
   integer,intent(in) :: ntypat
   real(dp) :: pawovlp
   real(dp),intent(in) :: rmet(3,3)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
   real(dp),intent(in) :: xred(3,natom)
  end subroutine chkpawovlp
 end interface

 interface
  function clp(x)
   use defs_basis
   real(dp) :: clp
   real(dp),intent(in) :: x
  end function clp
 end interface

 interface
  function dbeta(cosbeta,ll,mp,mm)
   use defs_basis
   integer,intent(in) :: ll
   integer,intent(in) :: mm
   integer,intent(in) :: mp
   real(dp),intent(in) :: cosbeta
   real(dp) :: dbeta
  end function dbeta
 end interface

 interface
  function gaunt(ll,mm,l1,m1,l2,m2)
   use defs_basis
   integer,intent(in) :: l1
   integer,intent(in) :: l2
   integer,intent(in) :: ll
   integer,intent(in) :: m1
   integer,intent(in) :: m2
   integer,intent(in) :: mm
   real(dp) :: gaunt
  end function gaunt
 end interface

 interface
  subroutine getsc(blocksize,ffnl,indlmn,istwf_k,kg_k,kpt,lmnmax,matblk,mgfft,mpi_enreg,natom,&  
&  nattyp,ngfft,nloalg,npw_k,nspinor,ntypat,ph1d,ph3d,&  
&  phkxred,sij,ucvol,vectin,vectout)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: blocksize
   integer,intent(in) :: istwf_k
   integer,intent(in) :: lmnmax
   integer,intent(in) :: matblk
   integer,intent(in) :: mgfft
   integer,intent(in) :: natom
   integer,intent(in) :: npw_k
   integer,intent(in) :: nspinor
   integer,intent(in) :: ntypat
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: kpt(3)
   integer,intent(in) :: ngfft(18)
   integer,intent(in) :: nloalg(5)
   real(dp),intent(in) :: ffnl(npw_k,2,lmnmax,ntypat)
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   integer,intent(in) :: kg_k(3,npw_k)
   integer,intent(in) :: nattyp(ntypat)
   real(dp),intent(in) :: ph1d(2,3*(2*mgfft+1)*natom)
   real(dp),intent(in) :: ph3d(2,npw_k,matblk)
   real(dp),intent(in) :: phkxred(2,natom)
   real(dp),intent(in) :: sij(lmnmax*(lmnmax+1)/2,ntypat)
   real(dp),intent(inout) :: vectin(2,nspinor*npw_k*blocksize)
   real(dp),intent(out) :: vectout(2,nspinor*npw_k*blocksize)
  end subroutine getsc
 end interface

 interface
  subroutine indgrid(coatofin,fintocoa,nfftc,nfftf,ngfftc,ngfftf)
   integer,intent(in) :: nfftc
   integer,intent(in) :: nfftf
   integer,intent(in) :: ngfftc(18)
   integer,intent(in) :: ngfftf(18)
   integer,intent(out) :: coatofin(nfftc)
   integer,intent(out) :: fintocoa(nfftf)
  end subroutine indgrid
 end interface

 interface
  subroutine initang(pawang)
   use defs_datatypes
   type(pawang_type),intent(inout) :: pawang
  end subroutine initang
 end interface

 interface
  subroutine initrhoij(indlmn,lmnmax,lpawu,natom,nspden,nsppol,ntypat,pawrhoij,pawtab,spinat,typat)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: lmnmax
   integer,intent(in) :: natom
   integer,intent(in) :: nspden
   integer,intent(in) :: nsppol
   integer,intent(in) :: ntypat
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   integer,intent(in) :: lpawu(ntypat)
   type(pawrhoij_type),intent(out) :: pawrhoij(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   real(dp),intent(in) :: spinat(3,natom)
   integer,intent(in) :: typat(natom)
  end subroutine initrhoij
 end interface

 interface
  subroutine initylmr(mpsang,normchoice,npts,nrm,option,rr,ylmr,ylmr_gr)
   use defs_basis
   integer,intent(in) :: mpsang
   integer,intent(in) :: normchoice
   integer,intent(in) :: npts
   integer,intent(in) :: option
   real(dp),intent(in) :: nrm(npts)
   real(dp),intent(in) :: rr(3,npts)
   real(dp),intent(out) :: ylmr(mpsang*mpsang,npts)
   real(dp),intent(out) :: ylmr_gr(3*(option/2)+6*(option/3),mpsang*mpsang,npts)
  end subroutine initylmr
 end interface

 interface
  subroutine int_ang(ang_phipphj)
   use defs_basis
   real(dp) :: ang_phipphj(16,16,8)
  end subroutine int_ang
 end interface

 interface
  subroutine mkeuler(rot,cosbeta,cosalp,sinalp,cosgam,singam,isn)
   use defs_basis
   integer,intent(out) :: isn
   real(dp),intent(out) :: cosalp
   real(dp),intent(out) :: cosbeta
   real(dp),intent(out) :: cosgam
   real(dp),intent(out) :: sinalp
   real(dp),intent(out) :: singam
   real(dp),intent(in) :: rot(3,3)
  end subroutine mkeuler
 end interface

 interface
  subroutine nhatgrid(atindx1,gmet,mpi_enreg,natom,nattyp,nfft,ngfft,ntypat,&  
&  optgr0,optgr1,optgr2,optrad,optvloc,pawfgrtab,pawtab,rprimd,typat,ucvol,xred)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: ntypat
   integer,intent(in) :: optgr0
   integer,intent(in) :: optgr1
   integer,intent(in) :: optgr2
   integer,intent(in) :: optrad
   integer,intent(in) :: optvloc
   type(MPI_type),intent(in) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx1(natom)
   integer,intent(in) :: nattyp(ntypat)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
   real(dp),intent(in) :: xred(3,natom)
  end subroutine nhatgrid
 end interface

 interface
  subroutine optics_paw(cg,cprj,dtset,ecut,fildata,gprimd,hdr,indlmn,kg,lmnmax,&  
&  mband,mkmem,mpi_enreg,mpsang,mpw,natom,nattyp,nkpt,npwarr,nspinor,nsppol,&  
&  pawrad,pawtab)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: lmnmax
   integer,intent(in) :: mband
   integer,intent(in) :: mkmem
   integer,intent(in) :: mpsang
   integer,intent(in) :: mpw
   integer,intent(in) :: natom
   integer,intent(in) :: nkpt
   integer,intent(in) :: nspinor
   integer,intent(in) :: nsppol
   type(dataset_type),intent(in) :: dtset
   real(dp),intent(in) :: ecut
   character(len=fnlen),intent(in) :: fildata
   type(hdr_type),intent(inout) :: hdr
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: gprimd(3,3)
   real(dp),intent(inout) :: cg(2,mpw*nspinor*mband*mkmem*nsppol)
   type(cprj_type) :: cprj(natom,nspinor*mband*mkmem*nsppol)
   integer,intent(in) :: indlmn(6,lmnmax,dtset%ntypat)
   integer,intent(in) :: kg(3,mpw*mkmem)
   integer,intent(in) :: nattyp(dtset%ntypat)
   integer,intent(in) :: npwarr(nkpt)
   type(pawrad_type),intent(in) :: pawrad(dtset%ntypat)
   type(pawtab_type),intent(in) :: pawtab(dtset%ntypat)
  end subroutine optics_paw
 end interface

 interface
  subroutine pawcorloc(corstr,dnqdq0,dyfrlo,dyfrx2,eei,gmet,gprimd,grtn,grxc,gsqcut,lpsstr,mgfft,&  
&  mpi_enreg,mqgrid,n3xccc,natom,nattyp,ncspl,nfft,ngfft,ntypat,option,ph1d,&  
&  qgrid,qprtrb,rhog,ucvol,vlspl,vprtrb,vpsp,vxc,xccc3d)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: mgfft
   integer,intent(in) :: mqgrid
   integer,intent(in) :: n3xccc
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: ntypat
   integer,intent(in) :: option
   real(dp),intent(in) :: eei
   real(dp),intent(in) :: gsqcut
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   integer,intent(in) :: ngfft(18)
   integer,intent(in) :: qprtrb(3)
   real(dp),intent(in) :: vprtrb(2)
   real(dp),intent(out) :: corstr(6*(4-option)*(option/3))
   real(dp),intent(in) :: dnqdq0(ntypat*(4-option)*(option/3))
   real(dp),intent(out) :: dyfrlo(3,3,natom*(option/4))
   real(dp),intent(out) :: dyfrx2(3,3,natom*(option/4))
   real(dp),intent(out) :: grtn(3,natom*(3-option)*(4-option)*(option/2)/2)
   real(dp),intent(out) :: grxc(3,natom*(3-option)*(4-option)*(option/2)/2)
   real(dp),intent(out) :: lpsstr(6*(4-option)*(option/3))
   integer,intent(in) :: nattyp(ntypat)
   real(dp),intent(in) :: ncspl(mqgrid,2,ntypat)
   real(dp),intent(in) :: ph1d(2,3*(2*mgfft+1)*natom)
   real(dp),intent(in) :: qgrid(mqgrid)
   real(dp),intent(in) :: rhog(2,nfft)
   real(dp),intent(in) :: vlspl(mqgrid,2,ntypat)
   real(dp),intent(out) :: vpsp(nfft)
   real(dp),intent(in) :: vxc(2,n3xccc*((option+1)/3))
   real(dp),intent(out) :: xccc3d(n3xccc)
  end subroutine pawcorloc
 end interface

 interface
  subroutine pawdenpot(compch_sph,epaw,epawdc,ixc,natom,nspden,ntypat,nzlmopt,option,paw_an,&  
&  paw_ij,pawang,pawprtvol,pawrad,pawrhoij,pawtab,pawxcdev,typat)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: natom
   integer,intent(in) :: nspden
   integer,intent(in) :: ntypat
   integer,intent(in) :: nzlmopt
   integer,intent(in) :: option
   integer,intent(in) :: pawprtvol
   integer,intent(in) :: pawxcdev
   real(dp),intent(out) :: compch_sph
   real(dp),intent(out) :: epaw
   real(dp),intent(out) :: epawdc
   type(pawang_type),intent(in) :: pawang
   type(paw_an_type),intent(inout) :: paw_an(natom)
   type(paw_ij_type),intent(inout) :: paw_ij(natom)
   type(pawrad_type),intent(in) :: pawrad(ntypat)
   type(pawrhoij_type),intent(in) :: pawrhoij(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
  end subroutine pawdenpot
 end interface

 interface
  subroutine pawdij(enunit,mpi_enreg,natom,nfft,ngfft,nspden,ntypat,&  
&  paw_an,paw_ij,pawang,pawfgrtab,pawprtvol,pawrad,pawtab,&  
&  pawxcdev,typat,ucvol,vtrial)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: enunit
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nspden
   integer,intent(in) :: ntypat
   integer,intent(in) :: pawprtvol
   integer,intent(in) :: pawxcdev
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfft(18)
   type(paw_an_type),intent(in) :: paw_an(natom)
   type(paw_ij_type),intent(inout) :: paw_ij(natom)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
   type(pawrad_type),intent(in) :: pawrad(ntypat)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
   real(dp),intent(in) :: vtrial(nfft,nspden)
  end subroutine pawdij
 end interface

 interface
  subroutine pawgrnl(atindx1,dimnhat,dimvtrial,dyfrnl,grnl,mpi_enreg,natom,nattyp,nfft,ngfft,&  
&  nhat,nlstr,nspden,nsym,ntypat,optgr,optgr2,optstr,pawang,pawfgrtab,&  
&  pawrhoij,pawtab,rprimd,symrec,typat,vtrial)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: dimnhat
   integer,intent(in) :: dimvtrial
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nspden
   integer,intent(in) :: nsym
   integer,intent(in) :: ntypat
   integer,intent(in) :: optgr
   integer,intent(in) :: optgr2
   integer,intent(in) :: optstr
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   integer,intent(in) :: ngfft(18)
   real(dp),intent(in) :: rprimd(3,3)
   integer,intent(in) :: atindx1(natom)
   real(dp),intent(inout) :: dyfrnl(3,3,natom*optgr2)
   real(dp),intent(inout) :: grnl(3*natom*optgr)
   integer,intent(in) :: nattyp(natom)
   real(dp),intent(in) :: nhat(nfft,dimnhat)
   real(dp),intent(inout) :: nlstr(6*optstr)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
   type(pawrhoij_type),intent(in) :: pawrhoij(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: symrec(3,3,nsym)
   integer,intent(in) :: typat(natom)
   real(dp),intent(in) :: vtrial(nfft,dimvtrial)
  end subroutine pawgrnl
 end interface

 interface
  subroutine pawgylm(gylm,gylmgr,gylmgr2,iatom,ifftsph,itypat,nfgd,optgr0,optgr1,optgr2,optvloc,&  
&  pawtab,rfgd,rfgd_allocated,vlocgr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iatom
   integer,intent(in) :: itypat
   integer,intent(in) :: nfgd
   integer,intent(in) :: optgr0
   integer,intent(in) :: optgr1
   integer,intent(in) :: optgr2
   integer,intent(in) :: optvloc
   integer,intent(in) :: rfgd_allocated
   type(pawtab_type),intent(in) :: pawtab
   real(dp),intent(out) :: gylm(nfgd,optgr0*pawtab%l_size**2)
   real(dp),intent(out) :: gylmgr(3,nfgd,optgr1*pawtab%l_size**2)
   real(dp),intent(out) :: gylmgr2(6,nfgd,optgr2*pawtab%l_size**2)
   integer,intent(in) :: ifftsph(nfgd)
   real(dp),intent(in) :: rfgd(3,nfgd)
   real(dp),intent(out) :: vlocgr(3,nfgd*optvloc)
  end subroutine pawgylm
 end interface

 interface
  subroutine pawinit(indlmn,lcutdens,lmix,lmnmax,mpsang,n1xccc,nphi,nsym,ntheta,ntypat,&  
&  pawang,pawrad,pawtab,pawxcdev)
   use defs_datatypes
   integer,intent(in) :: lcutdens
   integer,intent(in) :: lmix
   integer,intent(in) :: lmnmax
   integer,intent(in) :: mpsang
   integer,intent(inout) :: n1xccc
   integer,intent(in) :: nphi
   integer,intent(in) :: nsym
   integer,intent(in) :: ntheta
   integer,intent(in) :: ntypat
   integer,intent(in) :: pawxcdev
   type(pawang_type),intent(inout) :: pawang
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   type(pawrad_type),intent(in) :: pawrad(ntypat)
   type(pawtab_type),intent(inout) :: pawtab(ntypat)
  end subroutine pawinit
 end interface

 interface
  subroutine pawmkgrad(grho2_updn,ixc,ngrad,nrad,nspden,rhonow,rho_updn)
   use defs_basis
   integer,intent(in) :: ixc
   integer,intent(in) :: ngrad
   integer,intent(in) :: nrad
   integer,intent(in) :: nspden
   real(dp),intent(out) :: grho2_updn(nrad,2*nspden-1)
   real(dp),intent(out) :: rho_updn(nrad,nspden)
   real(dp),intent(in) :: rhonow(nrad,nspden,ngrad*ngrad)
  end subroutine pawmkgrad
 end interface

 interface
  subroutine pawmknhat(compch_fft,ider,izero,mpi_enreg,natom,nfft,ngfft,nhatgrdim,nspden,&  
&  ntypat,pawang,pawfgrtab,pawgrnhat,pawnhat,pawrhoij,pawtab,typat,ucvol)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ider
   integer,intent(in) :: izero
   integer,intent(in) :: natom
   integer,intent(in) :: nfft
   integer,intent(in) :: nhatgrdim
   integer,intent(in) :: nspden
   integer,intent(in) :: ntypat
   real(dp),intent(out) :: compch_fft
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawang_type),intent(in) :: pawang
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: ngfft(18)
   type(pawfgrtab_type),intent(inout) :: pawfgrtab(natom)
   real(dp),intent(out) :: pawgrnhat(nfft,nspden,3*nhatgrdim)
   real(dp),intent(out) :: pawnhat(nfft,nspden)
   type(pawrhoij_type),intent(in) :: pawrhoij(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
  end subroutine pawmknhat
 end interface

 interface
  subroutine pawmkrhoij(atindx1,cprjnk,dimcprj,eigen,istwfk,mband,mkmem,mpi_enreg,natom,nattyp,&  
&  nband,nkpt,nspden,nsppol,ntypat,occ,pawprtvol,pawrhoij,unpaw,wtk)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: mband
   integer,intent(in) :: mkmem
   integer,intent(in) :: natom
   integer,intent(in) :: nkpt
   integer,intent(in) :: nspden
   integer,intent(in) :: nsppol
   integer,intent(in) :: ntypat
   integer,intent(in) :: pawprtvol
   integer,intent(in) :: unpaw
   type(MPI_type),intent(inout) :: mpi_enreg
   integer,intent(in) :: atindx1(natom)
   type(cprj_type) :: cprjnk(natom,mband*mkmem*nsppol)
   integer,intent(in) :: dimcprj(natom)
   real(dp),intent(in) :: eigen(mband*nkpt*nsppol)
   integer,intent(in) :: istwfk(nkpt)
   integer,intent(in) :: nattyp(ntypat)
   integer,intent(in) :: nband(nkpt*nsppol)
   real(dp),intent(in) :: occ(mband*nkpt*nsppol)
   type(pawrhoij_type),intent(inout) :: pawrhoij(natom)
   real(dp),intent(in) :: wtk(nkpt)
  end subroutine pawmkrhoij
 end interface

 interface
  subroutine pawprt(indlmn,enunit,lmnmax,natom,ntypat,paw_ij,pawrhoij,pawtab,typat)
   use defs_datatypes
   integer,intent(in) :: enunit
   integer,intent(in) :: lmnmax
   integer,intent(in) :: natom
   integer,intent(in) :: ntypat
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   type(paw_ij_type),intent(in) :: paw_ij(natom)
   type(pawrhoij_type),intent(in) :: pawrhoij(natom)
   type(pawtab_type),intent(in) :: pawtab(ntypat)
   integer,intent(in) :: typat(natom)
  end subroutine pawprt
 end interface

 interface
  subroutine pawpuinit(jpawu,llpawu,indlmn,lmnmax,ntypat,pawang,pawrad,pawtab,upawu,usepawu)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: lmnmax
   integer,intent(in) :: ntypat
   integer,intent(in) :: usepawu
   type(pawang_type),intent(in) :: pawang
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   real(dp),intent(in) :: jpawu(ntypat)
   integer,intent(in) :: llpawu(ntypat)
   type(pawrad_type),intent(in) :: pawrad(ntypat)
   type(pawtab_type),intent(inout) :: pawtab(ntypat)
   real(dp),intent(in) :: upawu(ntypat)
  end subroutine pawpuinit
 end interface

 interface
  subroutine pawpupot(ispden,nspden,paw_ij,pawprtvol,pawtab,vpawu,VUKS)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ispden
   integer,intent(in) :: nspden
   integer,intent(in) :: pawprtvol
   real(dp) :: VUKS
   type(paw_ij_type),intent(in) :: paw_ij
   type(pawtab_type),intent(in) :: pawtab
   real(dp),intent(inout) :: vpawu(pawtab%lpawu*2+1,pawtab%lpawu*2+1)
  end subroutine pawpupot
 end interface

 interface
  subroutine pawuenergy(eldaumdc,eldaumdcdc,pawprtvol,pawtab,paw_ij,nspden)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: nspden
   integer,intent(in) :: pawprtvol
   real(dp),intent(inout) :: eldaumdc
   real(dp),intent(inout) :: eldaumdcdc
   type(paw_ij_type),intent(in) :: paw_ij
   type(pawtab_type),intent(in) :: pawtab
  end subroutine pawuenergy
 end interface

 interface
  subroutine pawxc(corexc,enxc,enxcdc,ixc,lm_size,lmselect,nhat,nspden,option,&  
&  pawang,pawrad,rhor,usecore,usexcnhat,vxc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: lm_size
   integer,intent(in) :: nspden
   integer,intent(in) :: option
   integer,intent(in) :: usecore
   integer,intent(in) :: usexcnhat
   real(dp),intent(out) :: enxc
   real(dp),intent(out) :: enxcdc
   type(pawang_type),intent(in) :: pawang
   type(pawrad_type),intent(in) :: pawrad
   real(dp),intent(in) :: corexc(pawrad%mesh_size)
   integer,intent(in) :: lmselect(lm_size,nspden)
   real(dp),intent(in) :: nhat(pawrad%mesh_size,lm_size,nspden)
   real(dp),intent(in) :: rhor(pawrad%mesh_size,lm_size,nspden)
   real(dp),intent(out) :: vxc(pawrad%mesh_size,pawang%angl_size,nspden)
  end subroutine pawxc
 end interface

 interface
  subroutine pawxcdenm(ngrad,nrad,nspden,pawrad,rhonow,rhor)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ngrad
   integer,intent(in) :: nrad
   integer,intent(in) :: nspden
   type(pawrad_type),intent(in) :: pawrad
   real(dp),intent(out) :: rhonow(nrad,nspden,ngrad*ngrad)
   real(dp),intent(in) :: rhor(nrad,nspden)
  end subroutine pawxcdenm
 end interface

 interface
  subroutine pawxcgrad(dnexcdn,dvxcdgr,grho2_updn,ngrad,nrad,nspden,nspgrad,nvxcdgr,&  
&  pawrad,rhonow,vxci)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ngrad
   integer,intent(in) :: nrad
   integer,intent(in) :: nspden
   integer,intent(in) :: nspgrad
   integer,intent(in) :: nvxcdgr
   type(pawrad_type),intent(in) :: pawrad
   real(dp),intent(out) :: dnexcdn(nrad,nspgrad)
   real(dp),intent(in) :: dvxcdgr(nrad,nvxcdgr)
   real(dp),intent(in) :: grho2_updn(nrad,2*nspden-1)
   real(dp),intent(out) :: rhonow(nrad,nspden,ngrad*ngrad)
   real(dp),intent(inout) :: vxci(nrad,nspden)
  end subroutine pawxcgrad
 end interface

 interface
  subroutine pawxcm(corexc,enxc,enxcdc,ixc,lm_size,lmselect,nhat,nspden,option,&  
&  pawrad,rhor,usecore,usexcnhat,vxc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: lm_size
   integer,intent(in) :: nspden
   integer,intent(in) :: option
   integer,intent(in) :: usecore
   integer,intent(in) :: usexcnhat
   real(dp),intent(out) :: enxc
   real(dp),intent(out) :: enxcdc
   type(pawrad_type),intent(in) :: pawrad
   real(dp),intent(in) :: corexc(pawrad%mesh_size)
   integer,intent(in) :: lmselect(lm_size,nspden)
   real(dp),intent(in) :: nhat(pawrad%mesh_size,lm_size,nspden)
   real(dp),intent(in) :: rhor(pawrad%mesh_size,lm_size,nspden)
   real(dp),intent(out) :: vxc(pawrad%mesh_size,lm_size,nspden)
  end subroutine pawxcm
 end interface

 interface
  function permutations(nn,kk)
   use defs_basis
   integer,intent(in) :: kk
   integer,intent(in) :: nn
   real(dp) :: permutations
  end function permutations
 end interface

 interface
  function phim(costheta,sintheta,mm)
   use defs_basis
   integer,intent(in) :: mm
   real(dp),intent(in) :: costheta
   real(dp) :: phim
   real(dp),intent(in) :: sintheta
  end function phim
 end interface

 interface
  subroutine realgaunt(l_max,ngnt,gntselect,realgnt)
   use defs_basis
   integer,intent(in) :: l_max
   integer,intent(out) :: ngnt
   integer,intent(out) :: gntselect((2*l_max-1)**2,l_max**2*(l_max**2+1)/2)
   real(dp),intent(out) :: realgnt((2*l_max-1)**2*(l_max)**4)
  end subroutine realgaunt
 end interface

 interface
  subroutine setsymrhoij(gprimd,lmax,nsym,pawprtvol,rprimd,symafm,symrec,zarot)
   use defs_basis
   integer,intent(in) :: lmax
   integer,intent(in) :: nsym
   integer,intent(in) :: pawprtvol
   real(dp),intent(in) :: gprimd(3,3)
   real(dp),intent(in) :: rprimd(3,3)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrec(3,3,nsym)
   real(dp),intent(out) :: zarot(2*lmax+1,2*lmax+1,lmax+1,nsym)
  end subroutine setsymrhoij
 end interface

 interface
  subroutine symdij(indlmn,indsym,lmnmax,natom,nsym,ntypat,&  
&  paw_ij,pawang,pawprtvol,symafm,symrec,typat)
   use defs_datatypes
   integer,intent(in) :: lmnmax
   integer,intent(in) :: natom
   integer,intent(in) :: nsym
   integer,intent(in) :: ntypat
   integer,intent(in) :: pawprtvol
   type(pawang_type),intent(in) :: pawang
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   integer,intent(in) :: indsym(4,nsym,natom)
   type(paw_ij_type),intent(inout) :: paw_ij(natom)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrec(3,3,nsym)
   integer,intent(in) :: typat(natom)
  end subroutine symdij
 end interface

 interface
  subroutine symrhoij(choice,indlmn,indsym,lmnmax,natom,nsym,ntypat,optrhoij,&  
&  pawang,pawprtvol,pawrhoij,symafm,symrec,typat)
   use defs_datatypes
   integer,intent(in) :: choice
   integer,intent(in) :: lmnmax
   integer,intent(in) :: natom
   integer,intent(in) :: nsym
   integer,intent(in) :: ntypat
   integer,intent(in) :: optrhoij
   integer,intent(in) :: pawprtvol
   type(pawang_type),intent(in) :: pawang
   integer,intent(in) :: indlmn(6,lmnmax,ntypat)
   integer,intent(in) :: indsym(4,nsym,natom)
   type(pawrhoij_type),intent(inout) :: pawrhoij(natom)
   integer,intent(in) :: symafm(nsym)
   integer,intent(in) :: symrec(3,3,nsym)
   integer,intent(in) :: typat(natom)
  end subroutine symrhoij
 end interface

 interface
  subroutine transgrid(mpi_enreg,nspden,optgrid,optin,optout,pawfgr,rhog,rhogf,rhor,rhorf)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: nspden
   integer,intent(in) :: optgrid
   integer,intent(in) :: optin
   integer,intent(in) :: optout
   type(MPI_type),intent(inout) :: mpi_enreg
   type(pawfgr_type),intent(in) :: pawfgr
   real(dp),intent(inout) :: rhog(2,pawfgr%nfftc)
   real(dp),intent(inout) :: rhogf(2,pawfgr%nfft)
   real(dp),intent(inout) :: rhor(pawfgr%nfftc,nspden)
   real(dp),intent(inout) :: rhorf(pawfgr%nfft,nspden)
  end subroutine transgrid
 end interface

end module interfaces_13paw
!!***
