#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Abinit Post Process Application
author: MA/VS
last edited: january 2014
"""

import sys,os,time,commands
import string, math, re
import threading

#GUI 
import gui.graph as Graph
import gui.conv  as Conv

#Utility
import utility.write as Write
import utility.positions as Atom
import utility.analysis as Analysis

try:
    from PyQt4 import Qt,QtGui,QtCore
except:
    pass;

from numpy import *

#------------------------------------------------------#
#-------------------WINDOWS POSITIONS------------------#
#------------------------------------------------------#

class WinPOS(QtGui.QWidget):

    def __init__(self, file,punits, parent = None,name =''):

        self.file = file
        self.name = name
        self.units = punits #Dictionary with the units ans the conversion
        self.x1 = []
        self.x2 = []
        self.y1 = []
        self.y2 = []
        self.legend_x = "" 
        self.legend_y = ""
        self.typat = self.file.getTypat()
        self.ntypat = max(self.typat)

        self.initUI(parent) #Creation of postion windows
        self.changeMode()   #Generation of graphic of position
        self.raise_()

    def initUI(self, parent):

        #-----------------Creation of the windows----------------------------#
        QtGui.QWidget.__init__(self, parent)
        self.setAttribute(QtCore.Qt.WA_DeleteOnClose)
        self.setWindowTitle('Position options')
        self.setFixedSize(200, 100)

        self.center()
        self.layout = QtGui.QGridLayout()
        self.setLayout(self.layout)

        self.mode1 = QtGui.QLabel("Position :", self)
        self.mode1.setFixedWidth(65)

        self.sbm1 = QtGui.QComboBox()
        self.sbm1.setFixedWidth(95)

        self.sbm1.addItem(str('PBC'))
        self.sbm1.addItem(str('Standard'))
        self.sbm1.addItem(str('Average'))
        self.connect(self.sbm1,QtCore.SIGNAL('currentIndexChanged(const QString&)'),self.changeMode)        

        self.mode2 = QtGui.QLabel("View :", self)
        self.mode2.setFixedWidth(45)

        self.sbm2 = QtGui.QComboBox()
        self.sbm2.setFixedWidth(70)

        self.sbm2.addItem(str('XY'))
        self.sbm2.addItem(str('XZ'))
        self.sbm2.addItem(str('YZ'))
        self.connect(self.sbm2,QtCore.SIGNAL('currentIndexChanged(const QString&)'),self.changeMode)

        self.pbClose = QtGui.QPushButton("close")
        self.pbClose.setFixedSize(70,20)
        self.connect(self.pbClose,QtCore.SIGNAL("clicked()"),QtCore.SLOT('close()')) 

        self.layout.addWidget(self.mode1    , 1, 0, 1, 1, QtCore.Qt.AlignRight)
        self.layout.addWidget(self.sbm1     , 1, 1, 1, 1, QtCore.Qt.AlignCenter)
        self.layout.addWidget(self.mode2    , 2, 0, 1, 1, QtCore.Qt.AlignRight)
        self.layout.addWidget(self.sbm2     , 2, 1, 1, 1, QtCore.Qt.AlignCenter)
        self.layout.addWidget(self.pbClose  , 7, 0, 1, 2, QtCore.Qt.AlignCenter)

        self.show()
        #------------------------------------------------------------------------#

    def changeMode(self):

        mode1 = self.sbm1.currentText()
        mode2 = self.sbm2.currentText()

        self.marker_size = 2 #Set maker_size to 2 (except average)

        if mode1 == 'PBC':

            self.sym = Atom.PBC(self.file)

            if mode2 == 'XY':
                    
                self.x1 = self.sym.getx1()
                self.y1 = self.sym.gety1()

                if self.ntypat == 2:
        
                    self.x2 = self.sym.getx2()
                    self.y2 = self.sym.gety2()

            elif mode2 == 'XZ':
        
                self.x1 = self.sym.getx1()
                self.y1 = self.sym.getz1()

                if self.ntypat == 2:
        
                    self.x2 = self.sym.getx2()
                    self.y2 = self.sym.getz2()

            else :

                self.x1 = self.sym.gety1()
                self.y1 = self.sym.getz1()

                if self.ntypat == 2:
                    
                    self.x2 = self.sym.gety2()
                    self.y2 = self.sym.getz2()

        elif mode1 == 'Standard':

            if mode2 == 'XY':

                if self.ntypat == 1:

                    self.x1 = hstack(self.file.getPos()[:,:,0])
                    self.y1 = hstack(self.file.getPos()[:,:,1])

                elif self.ntypat == 2:

                    indexAtom1 = array([i for i,x in enumerate(self.typat) if x == 1],dtype=int)
                    indexAtom2 = array([i for i,x in enumerate(self.typat) if x == 2],dtype=int)

                    self.x1 = hstack(self.file.getPos()[:,indexAtom1,0])
                    self.y1 = hstack(self.file.getPos()[:,indexAtom1,1])
                    self.x2 = hstack(self.file.getPos()[:,indexAtom2,0])
                    self.y2 = hstack(self.file.getPos()[:,indexAtom2,1])

            elif mode2 == 'XZ':

                if self.ntypat == 1:

                    self.x1 = hstack(self.file.getPos()[:,:,0])
                    self.y1 = hstack(self.file.getPos()[:,:,2])


                elif self.ntypat == 2:

                    indexAtom1 = array([i for i,x in enumerate(self.typat) if x == 1],dtype=int)
                    indexAtom2 = array([i for i,x in enumerate(self.typat) if x == 2],dtype=int)

                    self.x1 = hstack(self.file.getPos()[:,indexAtom1,0])
                    self.y1 = hstack(self.file.getPos()[:,indexAtom1,2])
                    self.x2 = hstack(self.file.getPos()[:,indexAtom2,0])
                    self.y2 = hstack(self.file.getPos()[:,indexAtom2,2])

            else :

                if self.ntypat == 1:

                    self.x1 = hstack(self.file.getPos()[:,:,1])
                    self.y1 = hstack(self.file.getPos()[:,:,2])

                elif self.ntypat == 2:

                    indexAtom1 = array([i for i,x in enumerate(self.typat) if x == 1],dtype=int)
                    indexAtom2 = array([i for i,x in enumerate(self.typat) if x == 2],dtype=int)

                    self.x1 = hstack(self.file.getPos()[:,indexAtom1,1])
                    self.y1 = hstack(self.file.getPos()[:,indexAtom1,2])
                    self.x2 = hstack(self.file.getPos()[:,indexAtom2,1])
                    self.y2 = hstack(self.file.getPos()[:,indexAtom2,2])


        else :

            self.aver = Atom.Average(self.file)
            self.marker_size = 5 #set marker_size to 5

            if mode2 == 'XY':
 
                self.x1 = self.aver.getx1()
                self.y1 = self.aver.gety1()

                if self.ntypat == 2:
        
                    self.x2 = self.aver.getx2()
                    self.y2 = self.aver.gety2()

            elif mode2 == 'XZ':

                self.x1 = self.aver.getx1()
                self.y1 = self.aver.getz1()

                if self.ntypat == 2:
                    
                    self.x2 = self.aver.getx2()
                    self.y2 = self.aver.getz2()

            else :

                self.x1 = self.aver.gety1()
                self.y1 = self.aver.getz1()

                if self.ntypat == 2:
        
                    self.x2 = self.aver.gety2()
                    self.y2 = self.aver.getz2()

        if mode2 == 'XY':
            self.legend_x = "x" 
            self.legend_y = "y"

        elif mode2 == 'XZ':
            self.legend_x = "x" 
            self.legend_y = "z"

        else :
            self.legend_x = "y" 
            self.legend_y = "z"

        self.updateGraph()            
        

    def updateGraph(self):                     
        try: 
            self.graphPosition.updatePos(self.x1*self.units['Distance'][1],self.y1*self.units['Distance'][1],\
                                             self.legend_x+" ("+str(self.units['Distance'][0])+")",\
                                             self.legend_y+" ("+str(self.units['Distance'][0])+")",\
                                             marker_size=self.marker_size, name = self.name)
        except:
            self.graphPosition = Graph.graphic(self.x1*self.units['Distance'][1],self.y1*self.units['Distance'][1],\
                                                   self.legend_x+" ("+str(self.units['Distance'][0])+")",\
                                                   self.legend_y+" ("+str(self.units['Distance'][0])+")",\
                                                   average=False,point = True,marker='.', marker_size=2,name = self.name)

        if self.ntypat == 2:
            self.graphPosition.addGraph(self.x2*self.units['Distance'][1],self.y2*self.units['Distance'][1],True)        

        self.graphPosition.show()


    def center(self):
        screen = QtGui.QDesktopWidget().screenGeometry()
        size =  self.geometry()
        self.move((screen.width()-size.width())/2, (screen.height()-size.height())/2)


    def close(self):
        del self.graphPosition
        del self
    
    def closeEvent(self, event):
        try:
            del self.graphPosition
        except:
            pass
        try:
            del self
        except:
            pass
