/*
 * AirportBaseStationHangup Utility
 *
 * Copyright (C) 2000, Jonathan Sevy <jsevy@mcs.drexel.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */



import java.net.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;




public class AirportBaseStationHangupNoSwing extends Frame
							implements ActionListener, Runnable, WindowListener
{
	
	Button hangupModemButton, connectModemButton, newHostButton;
	TextArea messagesArea;
	ScrollPane messagesScroll;
	TextField hostIDField, modemStatusField, timeField;
	Label authorLabel, hostIDLabel, modemStatusLabel, timeLabel, connectTimeCaveatLabel;
	
	MenuBar theMenubar;
	Menu fileMenu;
	MenuItem quitItem;
	
	InetAddress hostAddress;
	
	DatagramSocket dSocket;
	final int OSU_NMS_PORT = 192;	
	
	boolean minimized;
	
	Thread statusThread;		
	
	
			
	
	public AirportBaseStationHangupNoSwing() 
	{
		setUpDisplay();
		
		try
		{
			hostAddress = InetAddress.getByName(hostIDField.getText());
			
			dSocket = new DatagramSocket();
			dSocket.setSoTimeout(2000);	// 2 seconds
			InetAddress hostAddress = InetAddress.getByName(hostIDField.getText());
			
			statusThread = new Thread(this);
			statusThread.start();
		
		}
		catch(Exception e)
		{
			messagesArea.setText("Exception during modem status polling startup:  " + e + "\n");
		}
		
		
	}
	
	
	
	private void setUpDisplay()
	{
		
		/*
		try
		{
			// set look-and-feel to native platform l&f, if possible
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
		catch(Exception e)
		{
			// or not...
		}
		
		
		this.getRootPane().setBorder(new BevelBorder(BevelBorder.RAISED));
		
		// set fonts to smaller-than-normal size, for compaction!
		UIManager manager = new UIManager();
		FontUIResource appFont = new FontUIResource("SansSerif", Font.PLAIN, 10);
		UIDefaults defaults = manager.getLookAndFeelDefaults();
		Enumeration keys = defaults.keys();
		
		while (keys.hasMoreElements())
		{
			String nextKey = (String)(keys.nextElement());
			if ((nextKey.indexOf("font") > -1) || (nextKey.indexOf("Font") > -1))
			{
				manager.put(nextKey, appFont);
			}
		}
		*/
		
		
		// register self as WindowListener, to catch minimization events
		addWindowListener(this);
		
		/*
		theMenubar = new MenuBar();
		this.setMenuBar(theMenubar);
		fileMenu = new Menu("File");
		
		quitItem = new MenuItem("Quit");
		quitItem.setActionCommand("quit");
		quitItem.addActionListener(this);
		fileMenu.add(quitItem);
		
		theMenubar.add(fileMenu);
		*/
		
		hostIDLabel = new Label("Address:");
		hostIDField = new TextField(10);
		hostIDField.setText("10.0.1.1");
		hostIDField.setEditable(false);
		
		modemStatusLabel = new Label("Modem status:");
		modemStatusField = new TextField(10);
		modemStatusField.setEditable(false);
		
		timeLabel = new Label("Connection time:");
		timeField = new TextField(10);
		timeField.setEditable(false);
		
		authorLabel = new Label(" Version 1.4        J. Sevy, June 2001");
		authorLabel.setFont(new Font("SansSerif", Font.ITALIC, 8));
			
		
		hangupModemButton = new Button("Hangup Modem");
		hangupModemButton.setActionCommand("hangup modem");
		hangupModemButton.addActionListener(this);
		
		connectModemButton = new Button("Connect Modem");
		connectModemButton.setActionCommand("connect modem");
		connectModemButton.addActionListener(this);
		
		newHostButton = new Button("Set address");
		newHostButton.setActionCommand("new host");
		newHostButton.addActionListener(this);
		
		messagesArea = new TextArea(3,30);
		messagesScroll = new ScrollPane();
		messagesScroll.add(messagesArea);
		 
		
        URL url = AirportBaseStationHangupNoSwing.class.getResource("iconImage.gif");
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(url));
		
		
		// now set up display
		// set params for layout manager
		GridBagLayout  theLayout = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		
		c.gridwidth = 1;
		c.gridheight = 1;
		c.fill = GridBagConstraints.NONE;
		c.ipadx = 0;
		c.ipady = 0;
		c.insets = new Insets(2,2,2,2);
		c.anchor = GridBagConstraints.CENTER;
		c.weightx = 0;
		c.weighty = 0;
		
		
		
		this.setTitle("AirPort Modem Utility");
		
		Panel buttonPanel = new Panel();
		buttonPanel.setLayout(theLayout);
		
		c.gridx = 1;
		c.gridy = 1;
		theLayout.setConstraints(hangupModemButton, c);
		buttonPanel.add(hangupModemButton);
		
		c.gridx = 2;
		c.gridy = 1;
		theLayout.setConstraints(connectModemButton, c);
		buttonPanel.add(connectModemButton);
		
		
		
		Panel hostPanel = new Panel();
		hostPanel.setLayout(theLayout);
		
		c.gridx = 1;
		c.gridy = 1;
		theLayout.setConstraints(hostIDLabel, c);
		hostPanel.add(hostIDLabel);
		
		c.gridx = 2;
		c.gridy = 1;
		theLayout.setConstraints(hostIDField, c);
		hostPanel.add(hostIDField);
		
		
		c.gridx = 3;
		c.gridy = 1;
		theLayout.setConstraints(newHostButton, c);
		hostPanel.add(newHostButton);
		
		
		
		Panel modemStatusPanel = new Panel();
		modemStatusPanel.setLayout(theLayout);
		
		c.gridx = 1;
		c.gridy = 1;
		c.anchor = GridBagConstraints.EAST;
		theLayout.setConstraints(modemStatusLabel, c);
		modemStatusPanel.add(modemStatusLabel);
		
		c.gridx = 2;
		c.gridy = 1;
		c.anchor = GridBagConstraints.WEST;
		theLayout.setConstraints(modemStatusField, c);
		modemStatusPanel.add(modemStatusField);
		
		c.gridx = 1;
		c.gridy = 2;
		c.anchor = GridBagConstraints.EAST;
		theLayout.setConstraints(timeLabel, c);
		modemStatusPanel.add(timeLabel);
		
		c.gridx = 2;
		c.gridy = 2;
		c.anchor = GridBagConstraints.WEST;
		theLayout.setConstraints(timeField, c);
		modemStatusPanel.add(timeField);
		
		/*
		Panel modemStatusOuterPanel = new Panel();
		modemStatusOuterPanel.setLayout(theLayout);
		
		c.gridx = 1;
		c.gridy = 1;
		c.anchor = GridBagConstraints.CENTER;
		theLayout.setConstraints(modemStatusPanel, c);
		modemStatusOuterPanel.add(modemStatusPanel);
		
		c.gridx = 1;
		c.gridy = 2;
		theLayout.setConstraints(connectTimeCaveatLabel, c);
		modemStatusOuterPanel.add(connectTimeCaveatLabel);
		*/
		

		
		c.gridwidth = 1;
		c.anchor = GridBagConstraints.CENTER;
		
		
		
		
		this.setLayout(theLayout);
		
		
		c.gridx = 1;
		c.gridy = 1;
		theLayout.setConstraints(hostPanel, c);
		this.add(hostPanel);
		
		
		c.gridx = 1;
		c.gridy = 2;
		theLayout.setConstraints(buttonPanel, c);
		this.add(buttonPanel);
		
		c.gridx = 1;
		c.gridy = 3;
		theLayout.setConstraints(modemStatusPanel, c);
		this.add(modemStatusPanel);
		
		/*
		c.gridx = 1;
		c.gridy = 4;
		Label messagesLabel = new Label("Messages:");
		theLayout.setConstraints(messagesLabel, c);
		this.add(messagesLabel);
		
		c.gridx = 1;
		c.gridy = 5;
		theLayout.setConstraints(messagesScroll, c);
		this.add(messagesScroll);				
		
		c.gridx = 1;
		c.gridy = 6;
		theLayout.setConstraints(authorLabel, c);
		this.add(authorLabel);
		*/
		
		this.validate();
		this.repaint();
		
		
	}
	
	
	
	// WindowListener methods
	
	public void windowActivated(WindowEvent e)
	{
		// do nothing
	}
	
	
	public void windowClosing(WindowEvent e)
	{
	    // exit
	    System.exit(0);
	}
	
	
	public void windowClosed(WindowEvent e)
	{
		// do nothing
	}
	
	
	public void windowDeactivated(WindowEvent e)
	{
		// do nothing
	}
	
	
	public void windowOpened(WindowEvent e)
	{
		// do nothing
	}
	
	
	public void windowIconified(WindowEvent e)
	{
	    // display minimized stuff; will print just connect time (or "Unconnected") as title text
	    minimized = true;
	    
	}
	
	
	public void windowDeiconified(WindowEvent e)
	{
	    // display full title; connect time will be placed in
	    minimized = false;
	    this.setTitle("AirPort Modem Utility");
	}
	
	
	
	
	
	public void actionPerformed(ActionEvent theEvent)
	// respond to button pushes, menu selections
	{
		String command = theEvent.getActionCommand();
		
	
		if (command == "quit")
		{
			System.exit(0);
		}
		
		
		
		if (command == "new host")
		{
			
			String newHost = InputDialog.getInputFromDialog(this, "Input new host:", hostIDField.getText());
			if (newHost != null)
			{
				
				try
				{
					hostAddress = InetAddress.getByName(newHost);
					hostIDField.setText(newHost);
				
				}
				catch(UnknownHostException e)
				{
					MessageDialog.showMessageDialog(this, "Unknown host name supplied.");
				}
				catch(Exception e)
				{
					MessageDialog.showMessageDialog(this, "Unknown host name supplied.");
				}
			}
			
		}
		
		
		
		if (command == "hangup modem")
		{
			hangupModem();
		}	
		
		
		
		if (command == "connect modem")
		{
			connectModem();
		}
		
		
	
		
	}
	
	
	
	private void hangupModem() 
	{
		try
		{
			messagesArea.setText("Hanging up modem....");
			
			DatagramSocket dSocket = new DatagramSocket();
			dSocket.setSoTimeout(15000);	//15 seconds
			int AIRPORT_PORT = 192;
			//InetAddress hostAddress = InetAddress.getByName(hostIDField.getText());
	
			byte[] bytes = new byte[116];	// from sniffs
			bytes[0] = (byte)0x06;			// from S. Sexton - thanks!
			
			
			DatagramPacket outPacket = new DatagramPacket(bytes, bytes.length, hostAddress, AIRPORT_PORT);
					
			dSocket.send(outPacket);
			
			
			/*
			// don't bother waiting for a reply
			DatagramPacket inPacket = new DatagramPacket(bytes, bytes.length);
			dSocket.receive(inPacket);
			bytes = inPacket.getData();
			*/
			
			/*
			System.out.println("Returned Message bytes:");
			for (int i = 0; i < bytes.length; ++i)
				System.out.print(hexByte(bytes[i]) + " ");
			*/
			
			/*
			int rows = 8;	// really, 7.25
			int cols = 16;
			ByteBlock block = new ByteBlock(rows, cols, bytes);
			AirportDiscoveryInfo theInfo = new AirportDiscoveryInfo(block);
			
			theArea.append("Reply received:\n");
			theArea.append("Device address: " + theInfo.get("Base station IP address").toString() + "\n");
			theArea.append("Device name:    " + theInfo.get("Base station name").toString() + "\n");
			theArea.append("Device type:    " + theInfo.get("Device identifying string").toString() + "\n");
			theArea.append("\n");
			*/
			
			messagesArea.append("please wait for modem to disconnect.\n");
			
			/*
			// enable connection button
			connectModemButton.setEnabled(true);
			
			// disable hangup button
			hangupModemButton.setEnabled(false);
			*/
				
					
		}
		catch(Exception e)
		{
			messagesArea.append("Exception during hangup:  " + e + "\n");
		}
		
	}
	
	
	
	private void connectModem() 
	{
		try
		{
			messagesArea.setText("Dialing modem....");
			
			DatagramSocket dSocket = new DatagramSocket();
			dSocket.setSoTimeout(15000);	//15 seconds
			int AIRPORT_PORT = 192;
			InetAddress hostAddress = InetAddress.getByName(hostIDField.getText());
	
			byte[] bytes = new byte[116];	// from sniffs
			bytes[0] = (byte)0x07;			// from P. Werz - thanks!
			
			
			DatagramPacket outPacket = new DatagramPacket(bytes, bytes.length, hostAddress, AIRPORT_PORT);
					
			dSocket.send(outPacket);
			
			
			/*
			// don't bother waiting for a reply
			DatagramPacket inPacket = new DatagramPacket(bytes, bytes.length);
			dSocket.receive(inPacket);
			bytes = inPacket.getData();
			*/
			
			/*
			System.out.println("Returned Message bytes:");
			for (int i = 0; i < bytes.length; ++i)
				System.out.print(hexByte(bytes[i]) + " ");
			*/
			
			/*
			int rows = 8;	// really, 7.25
			int cols = 16;
			ByteBlock block = new ByteBlock(rows, cols, bytes);
			AirportDiscoveryInfo theInfo = new AirportDiscoveryInfo(block);
			
			theArea.append("Reply received:\n");
			theArea.append("Device address: " + theInfo.get("Base station IP address").toString() + "\n");
			theArea.append("Device name:    " + theInfo.get("Base station name").toString() + "\n");
			theArea.append("Device type:    " + theInfo.get("Device identifying string").toString() + "\n");
			theArea.append("\n");
			*/
			
			messagesArea.append("please wait for modem to connect.\n");
			
			/*
			// enable connection button
			connectModemButton.setEnabled(true);
			
			// disable hangup button
			hangupModemButton.setEnabled(false);
			*/
				
					
		}
		catch(Exception e)
		{
			messagesArea.append("Exception during modem connect:  " + e + "\n");
		}
		
	}
	
	
	
	
	
	
	private String hexByte(byte b)
	{
		int pos = b;
		if (pos < 0)
			pos += 256;
		String returnString = new String();
		returnString += Integer.toHexString(pos/16);
		returnString += Integer.toHexString(pos%16);
		return returnString;
	}
	
	
	
	
	public void run()
	{
		
		while(true)
		{
		
			try
			{
			
				// send request for state of modem: use 116-byte payload to keep version 1 base stations
				// happy; 0801 requests status info; 0310 requests all info at or following item number
				// 0310
				byte[] payloadBytes = new byte[116];
				payloadBytes[0] = (byte)0x08;
				payloadBytes[1] = (byte)0x01;
				payloadBytes[2] = (byte)0x03;
				payloadBytes[3] = (byte)0x10;
				
				DatagramPacket outPacket = new DatagramPacket(payloadBytes, payloadBytes.length, hostAddress, OSU_NMS_PORT);
						
				dSocket.send(outPacket);
				
				
				// wait for a reply; 128 bytes should be enough
				byte[] receivedBytes = new byte[128];	
				
				DatagramPacket inPacket = new DatagramPacket(receivedBytes, receivedBytes.length);
				dSocket.receive(inPacket);
				receivedBytes = inPacket.getData();
				int receivedLength = inPacket.getLength();
				
				// now parse the received bytes into a hash of info
				OSUNMSInfoHash infoHash = new OSUNMSInfoHash(receivedBytes, receivedLength);
				
				// test element number 0311: will be 4 if modem connected
				int connectedValue = infoHash.get(new Integer(0x0311)).getIntegerValue();
				
				switch (connectedValue)
				{
				
				
					case 4:
					{
						// connected
						hangupModemButton.setEnabled(true);
						connectModemButton.setEnabled(false);
						
						String statusString = "Connected";
						
						// get connect speed from element number 0315: only valid for version 2
						// base station, where length is 6; for version 1, value is always 115,200
						// and returned as hex string of digits!
						OSUNMSInfoElement speedElement = infoHash.get(new Integer(0x0315));
						if (speedElement.length == 6)
						{
							int speed = speedElement.getIntegerValue();
							if (speed > 0)
							{
								statusString += "  (" + speed + " bps)";
							}
						}
						
						modemStatusField.setText(statusString);
						
						// if connected, see for how long
						int connectionTime = infoHash.get(new Integer(0x0316)).getIntegerValue();
						
						// change to hours:minutes:seconds format
						int hours = connectionTime / 3600;
						int minutes = (connectionTime / 60) % 60;
						int seconds = connectionTime % 60;
						
						// make hours, minutes and seconds have 2 digits
						String hourString = new String();
						hourString += hours;
						if (hourString.length() < 2)
							hourString = "0" + hourString;
						
						String minuteString = new String();
						minuteString += minutes;
						if (minuteString.length() < 2)
							minuteString = "0" + minuteString;
						
						String secondString = new String();
						secondString += seconds;
						if (secondString.length() < 2)
							secondString = "0" + secondString;
						
						String timeString = hourString + ":" + minuteString + ":" + secondString;
						
						timeLabel.setText("Connection time:");
						timeField.setText(timeString);
						
						if (minimized)
							this.setTitle(timeString);
				
						break;
					}
					case 5:
					{
						// modem temporarily disabled
						modemStatusField.setText("Temporarily disabled");
						if (minimized)
							this.setTitle("Disabled");
						
						hangupModemButton.setEnabled(false);
						connectModemButton.setEnabled(true);
						
						// set time field to time remaining while disabled
						timeLabel.setText("Time remaining:");
						int remainingTime = infoHash.get(new Integer(0x0319)).getIntegerValue();
						String remainingTimeString = Integer.toString(remainingTime);
						if (remainingTimeString.length() < 2)
							remainingTimeString = "0" + remainingTimeString;
						timeField.setText("0:" + remainingTimeString);
						
						break;
					}
					
					case 2:
					case 3:
					{
						// modem/PPPoE connecting
						modemStatusField.setText("Connecting...");
						if (minimized)
							this.setTitle("Connecting...");
						
						hangupModemButton.setEnabled(true);
						connectModemButton.setEnabled(false);
						
						// make sure connect time field erased
						timeLabel.setText("Connection time:");
						timeField.setText("");
						
						break;
					}
					
					case 1:
					default:
					{
						// modem PPPoE disconnected (but not disabled)
						modemStatusField.setText("Unconnected");
						if (minimized)
							this.setTitle("Unconnected");
							
						hangupModemButton.setEnabled(false);
						connectModemButton.setEnabled(true);
						
						// make sure time field erased
						timeLabel.setText("Connection time:");
						timeField.setText("");
						
						break;
					}
						
				}
					
				//System.out.println("Polling thread checked modem status.\n");
			
			}
			catch(InterruptedIOException e)
			{
				// don't bother informing of interruption
				//messagesArea.setText("Exception during modem status polling:  " + e + "\n");
			}
			catch(Exception e)
			{
				messagesArea.setText("Exception during modem status polling:  " + e + "\n");
			}
			
			
			try
			{
				// sleep for 1 second
				Thread.sleep(1000);
			}
			catch(InterruptedException e)
			{
				// don't bother informing of interruption
				//messagesArea.setText("Exception during modem status polling:  " + e + "\n");
			}
			
		
		}
		
		
	}
	
	
	
	
	private void redialDelayThreadRoutine()
	{
		
		// disable modem redial capability while modem resets
		modemStatusField.setText("Disabled");
			
		try
		{
			// sleep for 1 second
			Thread.sleep(1000);
		}
		catch(InterruptedException e)
		{
			// don't bother informing of interruption
			//messagesArea.setText("Exception during modem status polling:  " + e + "\n");
		}
			
		modemStatusField.setText("Disabled");
		
		
	}
	

	
	
	
	
	public static void main(String args[]) 
	{
		try
		{
			AirportBaseStationHangupNoSwing theApp = new AirportBaseStationHangupNoSwing();
			theApp.pack();
			theApp.show();
		}
		catch (Exception e)
		{}
	}
	

}