// CHECKSTYLE:OFF
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

// Generated by Snowball (build from 867c4ec70debd4daa7fb4d5a9f7759b47887d0b9)
package opennlp.tools.stemmer.snowball;


/**
 * This class implements the stemming algorithm defined by a snowball script.
 * <p>
 * Generated by Snowball (build from 867c4ec70debd4daa7fb4d5a9f7759b47887d0b9) - <a href="https://github.com/snowballstem/snowball">https://github.com/snowballstem/snowball</a>
 * </p>
 */
@SuppressWarnings("unused")
public class turkishStemmer extends AbstractSnowballStemmer {


  private final static Among a_0[] = {
      new Among("m", -1, -1),
      new Among("n", -1, -1),
      new Among("miz", -1, -1),
      new Among("niz", -1, -1),
      new Among("muz", -1, -1),
      new Among("nuz", -1, -1),
      new Among("m\u00FCz", -1, -1),
      new Among("n\u00FCz", -1, -1),
      new Among("m\u0131z", -1, -1),
      new Among("n\u0131z", -1, -1)
  };

  private final static Among a_1[] = {
      new Among("leri", -1, -1),
      new Among("lar\u0131", -1, -1)
  };

  private final static Among a_2[] = {
      new Among("ni", -1, -1),
      new Among("nu", -1, -1),
      new Among("n\u00FC", -1, -1),
      new Among("n\u0131", -1, -1)
  };

  private final static Among a_3[] = {
      new Among("in", -1, -1),
      new Among("un", -1, -1),
      new Among("\u00FCn", -1, -1),
      new Among("\u0131n", -1, -1)
  };

  private final static Among a_4[] = {
      new Among("a", -1, -1),
      new Among("e", -1, -1)
  };

  private final static Among a_5[] = {
      new Among("na", -1, -1),
      new Among("ne", -1, -1)
  };

  private final static Among a_6[] = {
      new Among("da", -1, -1),
      new Among("ta", -1, -1),
      new Among("de", -1, -1),
      new Among("te", -1, -1)
  };

  private final static Among a_7[] = {
      new Among("nda", -1, -1),
      new Among("nde", -1, -1)
  };

  private final static Among a_8[] = {
      new Among("dan", -1, -1),
      new Among("tan", -1, -1),
      new Among("den", -1, -1),
      new Among("ten", -1, -1)
  };

  private final static Among a_9[] = {
      new Among("ndan", -1, -1),
      new Among("nden", -1, -1)
  };

  private final static Among a_10[] = {
      new Among("la", -1, -1),
      new Among("le", -1, -1)
  };

  private final static Among a_11[] = {
      new Among("ca", -1, -1),
      new Among("ce", -1, -1)
  };

  private final static Among a_12[] = {
      new Among("im", -1, -1),
      new Among("um", -1, -1),
      new Among("\u00FCm", -1, -1),
      new Among("\u0131m", -1, -1)
  };

  private final static Among a_13[] = {
      new Among("sin", -1, -1),
      new Among("sun", -1, -1),
      new Among("s\u00FCn", -1, -1),
      new Among("s\u0131n", -1, -1)
  };

  private final static Among a_14[] = {
      new Among("iz", -1, -1),
      new Among("uz", -1, -1),
      new Among("\u00FCz", -1, -1),
      new Among("\u0131z", -1, -1)
  };

  private final static Among a_15[] = {
      new Among("siniz", -1, -1),
      new Among("sunuz", -1, -1),
      new Among("s\u00FCn\u00FCz", -1, -1),
      new Among("s\u0131n\u0131z", -1, -1)
  };

  private final static Among a_16[] = {
      new Among("lar", -1, -1),
      new Among("ler", -1, -1)
  };

  private final static Among a_17[] = {
      new Among("niz", -1, -1),
      new Among("nuz", -1, -1),
      new Among("n\u00FCz", -1, -1),
      new Among("n\u0131z", -1, -1)
  };

  private final static Among a_18[] = {
      new Among("dir", -1, -1),
      new Among("tir", -1, -1),
      new Among("dur", -1, -1),
      new Among("tur", -1, -1),
      new Among("d\u00FCr", -1, -1),
      new Among("t\u00FCr", -1, -1),
      new Among("d\u0131r", -1, -1),
      new Among("t\u0131r", -1, -1)
  };

  private final static Among a_19[] = {
      new Among("cas\u0131na", -1, -1),
      new Among("cesine", -1, -1)
  };

  private final static Among a_20[] = {
      new Among("di", -1, -1),
      new Among("ti", -1, -1),
      new Among("dik", -1, -1),
      new Among("tik", -1, -1),
      new Among("duk", -1, -1),
      new Among("tuk", -1, -1),
      new Among("d\u00FCk", -1, -1),
      new Among("t\u00FCk", -1, -1),
      new Among("d\u0131k", -1, -1),
      new Among("t\u0131k", -1, -1),
      new Among("dim", -1, -1),
      new Among("tim", -1, -1),
      new Among("dum", -1, -1),
      new Among("tum", -1, -1),
      new Among("d\u00FCm", -1, -1),
      new Among("t\u00FCm", -1, -1),
      new Among("d\u0131m", -1, -1),
      new Among("t\u0131m", -1, -1),
      new Among("din", -1, -1),
      new Among("tin", -1, -1),
      new Among("dun", -1, -1),
      new Among("tun", -1, -1),
      new Among("d\u00FCn", -1, -1),
      new Among("t\u00FCn", -1, -1),
      new Among("d\u0131n", -1, -1),
      new Among("t\u0131n", -1, -1),
      new Among("du", -1, -1),
      new Among("tu", -1, -1),
      new Among("d\u00FC", -1, -1),
      new Among("t\u00FC", -1, -1),
      new Among("d\u0131", -1, -1),
      new Among("t\u0131", -1, -1)
  };

  private final static Among a_21[] = {
      new Among("sa", -1, -1),
      new Among("se", -1, -1),
      new Among("sak", -1, -1),
      new Among("sek", -1, -1),
      new Among("sam", -1, -1),
      new Among("sem", -1, -1),
      new Among("san", -1, -1),
      new Among("sen", -1, -1)
  };

  private final static Among a_22[] = {
      new Among("mi\u015F", -1, -1),
      new Among("mu\u015F", -1, -1),
      new Among("m\u00FC\u015F", -1, -1),
      new Among("m\u0131\u015F", -1, -1)
  };

  private final static Among a_23[] = {
      new Among("b", -1, 1),
      new Among("c", -1, 2),
      new Among("d", -1, 3),
      new Among("\u011F", -1, 4)
  };

  private static final char g_vowel[] = {17, 65, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 8, 0, 0, 0, 0, 0, 0, 1};

  private static final char g_U[] = {1, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 1};

  private static final char g_vowel1[] = {1, 64, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};

  private static final char g_vowel2[] = {17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130};

  private static final char g_vowel3[] = {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};

  private static final char g_vowel4[] = {17};

  private static final char g_vowel5[] = {65};

  private static final char g_vowel6[] = {65};

  private boolean B_continue_stemming_noun_suffixes;


  private boolean r_check_vowel_harmony() {
    int v_1 = limit - cursor;
    golab0:
    while (true) {
      int v_2 = limit - cursor;
      lab1:
      {
        if (!(in_grouping_b(g_vowel, 97, 305))) {
          break lab1;
        }
        cursor = limit - v_2;
        break golab0;
      }
      cursor = limit - v_2;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
    }
    lab2:
    {
      int v_3 = limit - cursor;
      lab3:
      {
        if (!(eq_s_b("a"))) {
          break lab3;
        }
        golab4:
        while (true) {
          int v_4 = limit - cursor;
          lab5:
          {
            if (!(in_grouping_b(g_vowel1, 97, 305))) {
              break lab5;
            }
            cursor = limit - v_4;
            break golab4;
          }
          cursor = limit - v_4;
          if (cursor <= limit_backward) {
            break lab3;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab6:
      {
        if (!(eq_s_b("e"))) {
          break lab6;
        }
        golab7:
        while (true) {
          int v_5 = limit - cursor;
          lab8:
          {
            if (!(in_grouping_b(g_vowel2, 101, 252))) {
              break lab8;
            }
            cursor = limit - v_5;
            break golab7;
          }
          cursor = limit - v_5;
          if (cursor <= limit_backward) {
            break lab6;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab9:
      {
        if (!(eq_s_b("\u0131"))) {
          break lab9;
        }
        golab10:
        while (true) {
          int v_6 = limit - cursor;
          lab11:
          {
            if (!(in_grouping_b(g_vowel3, 97, 305))) {
              break lab11;
            }
            cursor = limit - v_6;
            break golab10;
          }
          cursor = limit - v_6;
          if (cursor <= limit_backward) {
            break lab9;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab12:
      {
        if (!(eq_s_b("i"))) {
          break lab12;
        }
        golab13:
        while (true) {
          int v_7 = limit - cursor;
          lab14:
          {
            if (!(in_grouping_b(g_vowel4, 101, 105))) {
              break lab14;
            }
            cursor = limit - v_7;
            break golab13;
          }
          cursor = limit - v_7;
          if (cursor <= limit_backward) {
            break lab12;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab15:
      {
        if (!(eq_s_b("o"))) {
          break lab15;
        }
        golab16:
        while (true) {
          int v_8 = limit - cursor;
          lab17:
          {
            if (!(in_grouping_b(g_vowel5, 111, 117))) {
              break lab17;
            }
            cursor = limit - v_8;
            break golab16;
          }
          cursor = limit - v_8;
          if (cursor <= limit_backward) {
            break lab15;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab18:
      {
        if (!(eq_s_b("\u00F6"))) {
          break lab18;
        }
        golab19:
        while (true) {
          int v_9 = limit - cursor;
          lab20:
          {
            if (!(in_grouping_b(g_vowel6, 246, 252))) {
              break lab20;
            }
            cursor = limit - v_9;
            break golab19;
          }
          cursor = limit - v_9;
          if (cursor <= limit_backward) {
            break lab18;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      lab21:
      {
        if (!(eq_s_b("u"))) {
          break lab21;
        }
        golab22:
        while (true) {
          int v_10 = limit - cursor;
          lab23:
          {
            if (!(in_grouping_b(g_vowel5, 111, 117))) {
              break lab23;
            }
            cursor = limit - v_10;
            break golab22;
          }
          cursor = limit - v_10;
          if (cursor <= limit_backward) {
            break lab21;
          }
          cursor--;
        }
        break lab2;
      }
      cursor = limit - v_3;
      if (!(eq_s_b("\u00FC"))) {
        return false;
      }
      golab24:
      while (true) {
        int v_11 = limit - cursor;
        lab25:
        {
          if (!(in_grouping_b(g_vowel6, 246, 252))) {
            break lab25;
          }
          cursor = limit - v_11;
          break golab24;
        }
        cursor = limit - v_11;
        if (cursor <= limit_backward) {
          return false;
        }
        cursor--;
      }
    }
    cursor = limit - v_1;
    return true;
  }

  private boolean r_mark_suffix_with_optional_n_consonant() {
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!(eq_s_b("n"))) {
          break lab1;
        }
        int v_2 = limit - cursor;
        if (!(in_grouping_b(g_vowel, 97, 305))) {
          break lab1;
        }
        cursor = limit - v_2;
        break lab0;
      }
      cursor = limit - v_1;
      {
        int v_3 = limit - cursor;
        lab2:
        {
          int v_4 = limit - cursor;
          if (!(eq_s_b("n"))) {
            break lab2;
          }
          cursor = limit - v_4;
          return false;
        }
        cursor = limit - v_3;
      }
      int v_5 = limit - cursor;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
      if (!(in_grouping_b(g_vowel, 97, 305))) {
        return false;
      }
      cursor = limit - v_5;
    }
    return true;
  }

  private boolean r_mark_suffix_with_optional_s_consonant() {
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!(eq_s_b("s"))) {
          break lab1;
        }
        int v_2 = limit - cursor;
        if (!(in_grouping_b(g_vowel, 97, 305))) {
          break lab1;
        }
        cursor = limit - v_2;
        break lab0;
      }
      cursor = limit - v_1;
      {
        int v_3 = limit - cursor;
        lab2:
        {
          int v_4 = limit - cursor;
          if (!(eq_s_b("s"))) {
            break lab2;
          }
          cursor = limit - v_4;
          return false;
        }
        cursor = limit - v_3;
      }
      int v_5 = limit - cursor;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
      if (!(in_grouping_b(g_vowel, 97, 305))) {
        return false;
      }
      cursor = limit - v_5;
    }
    return true;
  }

  private boolean r_mark_suffix_with_optional_y_consonant() {
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!(eq_s_b("y"))) {
          break lab1;
        }
        int v_2 = limit - cursor;
        if (!(in_grouping_b(g_vowel, 97, 305))) {
          break lab1;
        }
        cursor = limit - v_2;
        break lab0;
      }
      cursor = limit - v_1;
      {
        int v_3 = limit - cursor;
        lab2:
        {
          int v_4 = limit - cursor;
          if (!(eq_s_b("y"))) {
            break lab2;
          }
          cursor = limit - v_4;
          return false;
        }
        cursor = limit - v_3;
      }
      int v_5 = limit - cursor;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
      if (!(in_grouping_b(g_vowel, 97, 305))) {
        return false;
      }
      cursor = limit - v_5;
    }
    return true;
  }

  private boolean r_mark_suffix_with_optional_U_vowel() {
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!(in_grouping_b(g_U, 105, 305))) {
          break lab1;
        }
        int v_2 = limit - cursor;
        if (!(out_grouping_b(g_vowel, 97, 305))) {
          break lab1;
        }
        cursor = limit - v_2;
        break lab0;
      }
      cursor = limit - v_1;
      {
        int v_3 = limit - cursor;
        lab2:
        {
          int v_4 = limit - cursor;
          if (!(in_grouping_b(g_U, 105, 305))) {
            break lab2;
          }
          cursor = limit - v_4;
          return false;
        }
        cursor = limit - v_3;
      }
      int v_5 = limit - cursor;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
      if (!(out_grouping_b(g_vowel, 97, 305))) {
        return false;
      }
      cursor = limit - v_5;
    }
    return true;
  }

  private boolean r_mark_possessives() {
    if (find_among_b(a_0) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_U_vowel()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_sU() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (!(in_grouping_b(g_U, 105, 305))) {
      return false;
    }
    if (!r_mark_suffix_with_optional_s_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_lArI() {
    if (find_among_b(a_1) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yU() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (!(in_grouping_b(g_U, 105, 305))) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_nU() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_2) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_nUn() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_3) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_n_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_4) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_nA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_5) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_DA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_6) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ndA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_7) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_DAn() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_8) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ndAn() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_9) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ylA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_10) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ki() {
    if (!(eq_s_b("ki"))) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ncA() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_11) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_n_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yUm() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_12) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_sUn() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_13) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yUz() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_14) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_sUnUz() {
    if (find_among_b(a_15) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_lAr() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_16) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_nUz() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_17) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_DUr() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_18) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_cAsInA() {
    if (find_among_b(a_19) == 0) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yDU() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_20) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ysA() {
    if (find_among_b(a_21) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_ymUs_() {
    if (!r_check_vowel_harmony()) {
      return false;
    }
    if (find_among_b(a_22) == 0) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_mark_yken() {
    if (!(eq_s_b("ken"))) {
      return false;
    }
    if (!r_mark_suffix_with_optional_y_consonant()) {
      return false;
    }
    return true;
  }

  private boolean r_stem_nominal_verb_suffixes() {
    ket = cursor;
    B_continue_stemming_noun_suffixes = true;
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        lab2:
        {
          int v_2 = limit - cursor;
          lab3:
          {
            if (!r_mark_ymUs_()) {
              break lab3;
            }
            break lab2;
          }
          cursor = limit - v_2;
          lab4:
          {
            if (!r_mark_yDU()) {
              break lab4;
            }
            break lab2;
          }
          cursor = limit - v_2;
          lab5:
          {
            if (!r_mark_ysA()) {
              break lab5;
            }
            break lab2;
          }
          cursor = limit - v_2;
          if (!r_mark_yken()) {
            break lab1;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab6:
      {
        if (!r_mark_cAsInA()) {
          break lab6;
        }
        lab7:
        {
          int v_3 = limit - cursor;
          lab8:
          {
            if (!r_mark_sUnUz()) {
              break lab8;
            }
            break lab7;
          }
          cursor = limit - v_3;
          lab9:
          {
            if (!r_mark_lAr()) {
              break lab9;
            }
            break lab7;
          }
          cursor = limit - v_3;
          lab10:
          {
            if (!r_mark_yUm()) {
              break lab10;
            }
            break lab7;
          }
          cursor = limit - v_3;
          lab11:
          {
            if (!r_mark_sUn()) {
              break lab11;
            }
            break lab7;
          }
          cursor = limit - v_3;
          lab12:
          {
            if (!r_mark_yUz()) {
              break lab12;
            }
            break lab7;
          }
          cursor = limit - v_3;
        }
        if (!r_mark_ymUs_()) {
          break lab6;
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab13:
      {
        if (!r_mark_lAr()) {
          break lab13;
        }
        bra = cursor;
        slice_del();
        int v_4 = limit - cursor;
        lab14:
        {
          ket = cursor;
          lab15:
          {
            int v_5 = limit - cursor;
            lab16:
            {
              if (!r_mark_DUr()) {
                break lab16;
              }
              break lab15;
            }
            cursor = limit - v_5;
            lab17:
            {
              if (!r_mark_yDU()) {
                break lab17;
              }
              break lab15;
            }
            cursor = limit - v_5;
            lab18:
            {
              if (!r_mark_ysA()) {
                break lab18;
              }
              break lab15;
            }
            cursor = limit - v_5;
            if (!r_mark_ymUs_()) {
              cursor = limit - v_4;
              break lab14;
            }
          }
        }
        B_continue_stemming_noun_suffixes = false;
        break lab0;
      }
      cursor = limit - v_1;
      lab19:
      {
        if (!r_mark_nUz()) {
          break lab19;
        }
        lab20:
        {
          int v_6 = limit - cursor;
          lab21:
          {
            if (!r_mark_yDU()) {
              break lab21;
            }
            break lab20;
          }
          cursor = limit - v_6;
          if (!r_mark_ysA()) {
            break lab19;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab22:
      {
        lab23:
        {
          int v_7 = limit - cursor;
          lab24:
          {
            if (!r_mark_sUnUz()) {
              break lab24;
            }
            break lab23;
          }
          cursor = limit - v_7;
          lab25:
          {
            if (!r_mark_yUz()) {
              break lab25;
            }
            break lab23;
          }
          cursor = limit - v_7;
          lab26:
          {
            if (!r_mark_sUn()) {
              break lab26;
            }
            break lab23;
          }
          cursor = limit - v_7;
          if (!r_mark_yUm()) {
            break lab22;
          }
        }
        bra = cursor;
        slice_del();
        int v_8 = limit - cursor;
        lab27:
        {
          ket = cursor;
          if (!r_mark_ymUs_()) {
            cursor = limit - v_8;
            break lab27;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      if (!r_mark_DUr()) {
        return false;
      }
      bra = cursor;
      slice_del();
      int v_9 = limit - cursor;
      lab28:
      {
        ket = cursor;
        lab29:
        {
          int v_10 = limit - cursor;
          lab30:
          {
            if (!r_mark_sUnUz()) {
              break lab30;
            }
            break lab29;
          }
          cursor = limit - v_10;
          lab31:
          {
            if (!r_mark_lAr()) {
              break lab31;
            }
            break lab29;
          }
          cursor = limit - v_10;
          lab32:
          {
            if (!r_mark_yUm()) {
              break lab32;
            }
            break lab29;
          }
          cursor = limit - v_10;
          lab33:
          {
            if (!r_mark_sUn()) {
              break lab33;
            }
            break lab29;
          }
          cursor = limit - v_10;
          lab34:
          {
            if (!r_mark_yUz()) {
              break lab34;
            }
            break lab29;
          }
          cursor = limit - v_10;
        }
        if (!r_mark_ymUs_()) {
          cursor = limit - v_9;
          break lab28;
        }
      }
    }
    bra = cursor;
    slice_del();
    return true;
  }

  private boolean r_stem_suffix_chain_before_ki() {
    ket = cursor;
    if (!r_mark_ki()) {
      return false;
    }
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!r_mark_DA()) {
          break lab1;
        }
        bra = cursor;
        slice_del();
        int v_2 = limit - cursor;
        lab2:
        {
          ket = cursor;
          lab3:
          {
            int v_3 = limit - cursor;
            lab4:
            {
              if (!r_mark_lAr()) {
                break lab4;
              }
              bra = cursor;
              slice_del();
              int v_4 = limit - cursor;
              lab5:
              {
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_4;
                  break lab5;
                }
              }
              break lab3;
            }
            cursor = limit - v_3;
            if (!r_mark_possessives()) {
              cursor = limit - v_2;
              break lab2;
            }
            bra = cursor;
            slice_del();
            int v_5 = limit - cursor;
            lab6:
            {
              ket = cursor;
              if (!r_mark_lAr()) {
                cursor = limit - v_5;
                break lab6;
              }
              bra = cursor;
              slice_del();
              if (!r_stem_suffix_chain_before_ki()) {
                cursor = limit - v_5;
                break lab6;
              }
            }
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab7:
      {
        if (!r_mark_nUn()) {
          break lab7;
        }
        bra = cursor;
        slice_del();
        int v_6 = limit - cursor;
        lab8:
        {
          ket = cursor;
          lab9:
          {
            int v_7 = limit - cursor;
            lab10:
            {
              if (!r_mark_lArI()) {
                break lab10;
              }
              bra = cursor;
              slice_del();
              break lab9;
            }
            cursor = limit - v_7;
            lab11:
            {
              ket = cursor;
              lab12:
              {
                int v_8 = limit - cursor;
                lab13:
                {
                  if (!r_mark_possessives()) {
                    break lab13;
                  }
                  break lab12;
                }
                cursor = limit - v_8;
                if (!r_mark_sU()) {
                  break lab11;
                }
              }
              bra = cursor;
              slice_del();
              int v_9 = limit - cursor;
              lab14:
              {
                ket = cursor;
                if (!r_mark_lAr()) {
                  cursor = limit - v_9;
                  break lab14;
                }
                bra = cursor;
                slice_del();
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_9;
                  break lab14;
                }
              }
              break lab9;
            }
            cursor = limit - v_7;
            if (!r_stem_suffix_chain_before_ki()) {
              cursor = limit - v_6;
              break lab8;
            }
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      if (!r_mark_ndA()) {
        return false;
      }
      lab15:
      {
        int v_10 = limit - cursor;
        lab16:
        {
          if (!r_mark_lArI()) {
            break lab16;
          }
          bra = cursor;
          slice_del();
          break lab15;
        }
        cursor = limit - v_10;
        lab17:
        {
          if (!r_mark_sU()) {
            break lab17;
          }
          bra = cursor;
          slice_del();
          int v_11 = limit - cursor;
          lab18:
          {
            ket = cursor;
            if (!r_mark_lAr()) {
              cursor = limit - v_11;
              break lab18;
            }
            bra = cursor;
            slice_del();
            if (!r_stem_suffix_chain_before_ki()) {
              cursor = limit - v_11;
              break lab18;
            }
          }
          break lab15;
        }
        cursor = limit - v_10;
        if (!r_stem_suffix_chain_before_ki()) {
          return false;
        }
      }
    }
    return true;
  }

  private boolean r_stem_noun_suffixes() {
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        ket = cursor;
        if (!r_mark_lAr()) {
          break lab1;
        }
        bra = cursor;
        slice_del();
        int v_2 = limit - cursor;
        lab2:
        {
          if (!r_stem_suffix_chain_before_ki()) {
            cursor = limit - v_2;
            break lab2;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab3:
      {
        ket = cursor;
        if (!r_mark_ncA()) {
          break lab3;
        }
        bra = cursor;
        slice_del();
        int v_3 = limit - cursor;
        lab4:
        {
          lab5:
          {
            int v_4 = limit - cursor;
            lab6:
            {
              ket = cursor;
              if (!r_mark_lArI()) {
                break lab6;
              }
              bra = cursor;
              slice_del();
              break lab5;
            }
            cursor = limit - v_4;
            lab7:
            {
              ket = cursor;
              lab8:
              {
                int v_5 = limit - cursor;
                lab9:
                {
                  if (!r_mark_possessives()) {
                    break lab9;
                  }
                  break lab8;
                }
                cursor = limit - v_5;
                if (!r_mark_sU()) {
                  break lab7;
                }
              }
              bra = cursor;
              slice_del();
              int v_6 = limit - cursor;
              lab10:
              {
                ket = cursor;
                if (!r_mark_lAr()) {
                  cursor = limit - v_6;
                  break lab10;
                }
                bra = cursor;
                slice_del();
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_6;
                  break lab10;
                }
              }
              break lab5;
            }
            cursor = limit - v_4;
            ket = cursor;
            if (!r_mark_lAr()) {
              cursor = limit - v_3;
              break lab4;
            }
            bra = cursor;
            slice_del();
            if (!r_stem_suffix_chain_before_ki()) {
              cursor = limit - v_3;
              break lab4;
            }
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab11:
      {
        ket = cursor;
        lab12:
        {
          int v_7 = limit - cursor;
          lab13:
          {
            if (!r_mark_ndA()) {
              break lab13;
            }
            break lab12;
          }
          cursor = limit - v_7;
          if (!r_mark_nA()) {
            break lab11;
          }
        }
        lab14:
        {
          int v_8 = limit - cursor;
          lab15:
          {
            if (!r_mark_lArI()) {
              break lab15;
            }
            bra = cursor;
            slice_del();
            break lab14;
          }
          cursor = limit - v_8;
          lab16:
          {
            if (!r_mark_sU()) {
              break lab16;
            }
            bra = cursor;
            slice_del();
            int v_9 = limit - cursor;
            lab17:
            {
              ket = cursor;
              if (!r_mark_lAr()) {
                cursor = limit - v_9;
                break lab17;
              }
              bra = cursor;
              slice_del();
              if (!r_stem_suffix_chain_before_ki()) {
                cursor = limit - v_9;
                break lab17;
              }
            }
            break lab14;
          }
          cursor = limit - v_8;
          if (!r_stem_suffix_chain_before_ki()) {
            break lab11;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab18:
      {
        ket = cursor;
        lab19:
        {
          int v_10 = limit - cursor;
          lab20:
          {
            if (!r_mark_ndAn()) {
              break lab20;
            }
            break lab19;
          }
          cursor = limit - v_10;
          if (!r_mark_nU()) {
            break lab18;
          }
        }
        lab21:
        {
          int v_11 = limit - cursor;
          lab22:
          {
            if (!r_mark_sU()) {
              break lab22;
            }
            bra = cursor;
            slice_del();
            int v_12 = limit - cursor;
            lab23:
            {
              ket = cursor;
              if (!r_mark_lAr()) {
                cursor = limit - v_12;
                break lab23;
              }
              bra = cursor;
              slice_del();
              if (!r_stem_suffix_chain_before_ki()) {
                cursor = limit - v_12;
                break lab23;
              }
            }
            break lab21;
          }
          cursor = limit - v_11;
          if (!r_mark_lArI()) {
            break lab18;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab24:
      {
        ket = cursor;
        if (!r_mark_DAn()) {
          break lab24;
        }
        bra = cursor;
        slice_del();
        int v_13 = limit - cursor;
        lab25:
        {
          ket = cursor;
          lab26:
          {
            int v_14 = limit - cursor;
            lab27:
            {
              if (!r_mark_possessives()) {
                break lab27;
              }
              bra = cursor;
              slice_del();
              int v_15 = limit - cursor;
              lab28:
              {
                ket = cursor;
                if (!r_mark_lAr()) {
                  cursor = limit - v_15;
                  break lab28;
                }
                bra = cursor;
                slice_del();
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_15;
                  break lab28;
                }
              }
              break lab26;
            }
            cursor = limit - v_14;
            lab29:
            {
              if (!r_mark_lAr()) {
                break lab29;
              }
              bra = cursor;
              slice_del();
              int v_16 = limit - cursor;
              lab30:
              {
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_16;
                  break lab30;
                }
              }
              break lab26;
            }
            cursor = limit - v_14;
            if (!r_stem_suffix_chain_before_ki()) {
              cursor = limit - v_13;
              break lab25;
            }
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab31:
      {
        ket = cursor;
        lab32:
        {
          int v_17 = limit - cursor;
          lab33:
          {
            if (!r_mark_nUn()) {
              break lab33;
            }
            break lab32;
          }
          cursor = limit - v_17;
          if (!r_mark_ylA()) {
            break lab31;
          }
        }
        bra = cursor;
        slice_del();
        int v_18 = limit - cursor;
        lab34:
        {
          lab35:
          {
            int v_19 = limit - cursor;
            lab36:
            {
              ket = cursor;
              if (!r_mark_lAr()) {
                break lab36;
              }
              bra = cursor;
              slice_del();
              if (!r_stem_suffix_chain_before_ki()) {
                break lab36;
              }
              break lab35;
            }
            cursor = limit - v_19;
            lab37:
            {
              ket = cursor;
              lab38:
              {
                int v_20 = limit - cursor;
                lab39:
                {
                  if (!r_mark_possessives()) {
                    break lab39;
                  }
                  break lab38;
                }
                cursor = limit - v_20;
                if (!r_mark_sU()) {
                  break lab37;
                }
              }
              bra = cursor;
              slice_del();
              int v_21 = limit - cursor;
              lab40:
              {
                ket = cursor;
                if (!r_mark_lAr()) {
                  cursor = limit - v_21;
                  break lab40;
                }
                bra = cursor;
                slice_del();
                if (!r_stem_suffix_chain_before_ki()) {
                  cursor = limit - v_21;
                  break lab40;
                }
              }
              break lab35;
            }
            cursor = limit - v_19;
            if (!r_stem_suffix_chain_before_ki()) {
              cursor = limit - v_18;
              break lab34;
            }
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab41:
      {
        ket = cursor;
        if (!r_mark_lArI()) {
          break lab41;
        }
        bra = cursor;
        slice_del();
        break lab0;
      }
      cursor = limit - v_1;
      lab42:
      {
        if (!r_stem_suffix_chain_before_ki()) {
          break lab42;
        }
        break lab0;
      }
      cursor = limit - v_1;
      lab43:
      {
        ket = cursor;
        lab44:
        {
          int v_22 = limit - cursor;
          lab45:
          {
            if (!r_mark_DA()) {
              break lab45;
            }
            break lab44;
          }
          cursor = limit - v_22;
          lab46:
          {
            if (!r_mark_yU()) {
              break lab46;
            }
            break lab44;
          }
          cursor = limit - v_22;
          if (!r_mark_yA()) {
            break lab43;
          }
        }
        bra = cursor;
        slice_del();
        int v_23 = limit - cursor;
        lab47:
        {
          ket = cursor;
          lab48:
          {
            int v_24 = limit - cursor;
            lab49:
            {
              if (!r_mark_possessives()) {
                break lab49;
              }
              bra = cursor;
              slice_del();
              int v_25 = limit - cursor;
              lab50:
              {
                ket = cursor;
                if (!r_mark_lAr()) {
                  cursor = limit - v_25;
                  break lab50;
                }
              }
              break lab48;
            }
            cursor = limit - v_24;
            if (!r_mark_lAr()) {
              cursor = limit - v_23;
              break lab47;
            }
          }
          bra = cursor;
          slice_del();
          ket = cursor;
          if (!r_stem_suffix_chain_before_ki()) {
            cursor = limit - v_23;
            break lab47;
          }
        }
        break lab0;
      }
      cursor = limit - v_1;
      ket = cursor;
      lab51:
      {
        int v_26 = limit - cursor;
        lab52:
        {
          if (!r_mark_possessives()) {
            break lab52;
          }
          break lab51;
        }
        cursor = limit - v_26;
        if (!r_mark_sU()) {
          return false;
        }
      }
      bra = cursor;
      slice_del();
      int v_27 = limit - cursor;
      lab53:
      {
        ket = cursor;
        if (!r_mark_lAr()) {
          cursor = limit - v_27;
          break lab53;
        }
        bra = cursor;
        slice_del();
        if (!r_stem_suffix_chain_before_ki()) {
          cursor = limit - v_27;
          break lab53;
        }
      }
    }
    return true;
  }

  private boolean r_post_process_last_consonants() {
    int among_var;
    ket = cursor;
    among_var = find_among_b(a_23);
    if (among_var == 0) {
      return false;
    }
    bra = cursor;
    switch (among_var) {
      case 1:
        slice_from("p");
        break;
      case 2:
        slice_from("\u00E7");
        break;
      case 3:
        slice_from("t");
        break;
      case 4:
        slice_from("k");
        break;
    }
    return true;
  }

  private boolean r_append_U_to_stems_ending_with_d_or_g() {
    ket = cursor;
    bra = cursor;
    lab0:
    {
      int v_1 = limit - cursor;
      lab1:
      {
        if (!(eq_s_b("d"))) {
          break lab1;
        }
        break lab0;
      }
      cursor = limit - v_1;
      if (!(eq_s_b("g"))) {
        return false;
      }
    }
    golab2:
    while (true) {
      int v_2 = limit - cursor;
      lab3:
      {
        if (!(in_grouping_b(g_vowel, 97, 305))) {
          break lab3;
        }
        cursor = limit - v_2;
        break golab2;
      }
      cursor = limit - v_2;
      if (cursor <= limit_backward) {
        return false;
      }
      cursor--;
    }
    lab4:
    {
      int v_3 = limit - cursor;
      lab5:
      {
        lab6:
        {
          int v_4 = limit - cursor;
          lab7:
          {
            if (!(eq_s_b("a"))) {
              break lab7;
            }
            break lab6;
          }
          cursor = limit - v_4;
          if (!(eq_s_b("\u0131"))) {
            break lab5;
          }
        }
        slice_from("\u0131");
        break lab4;
      }
      cursor = limit - v_3;
      lab8:
      {
        lab9:
        {
          int v_5 = limit - cursor;
          lab10:
          {
            if (!(eq_s_b("e"))) {
              break lab10;
            }
            break lab9;
          }
          cursor = limit - v_5;
          if (!(eq_s_b("i"))) {
            break lab8;
          }
        }
        slice_from("i");
        break lab4;
      }
      cursor = limit - v_3;
      lab11:
      {
        lab12:
        {
          int v_6 = limit - cursor;
          lab13:
          {
            if (!(eq_s_b("o"))) {
              break lab13;
            }
            break lab12;
          }
          cursor = limit - v_6;
          if (!(eq_s_b("u"))) {
            break lab11;
          }
        }
        slice_from("u");
        break lab4;
      }
      cursor = limit - v_3;
      lab14:
      {
        int v_7 = limit - cursor;
        lab15:
        {
          if (!(eq_s_b("\u00F6"))) {
            break lab15;
          }
          break lab14;
        }
        cursor = limit - v_7;
        if (!(eq_s_b("\u00FC"))) {
          return false;
        }
      }
      slice_from("\u00FC");
    }
    return true;
  }

  private boolean r_is_reserved_word() {
    if (!(eq_s_b("ad"))) {
      return false;
    }
    int v_1 = limit - cursor;
    lab0:
    {
      if (!(eq_s_b("soy"))) {
        cursor = limit - v_1;
        break lab0;
      }
    }
    if (cursor > limit_backward) {
      return false;
    }
    return true;
  }

  private boolean r_more_than_one_syllable_word() {
    int v_1 = cursor;
    for (int v_2 = 2; v_2 > 0; v_2--) {
      golab0:
      while (true) {
        lab1:
        {
          if (!(in_grouping(g_vowel, 97, 305))) {
            break lab1;
          }
          break golab0;
        }
        if (cursor >= limit) {
          return false;
        }
        cursor++;
      }
    }
    cursor = v_1;
    return true;
  }

  private boolean r_postlude() {
    limit_backward = cursor;
    cursor = limit;
    {
      int v_1 = limit - cursor;
      lab0:
      {
        if (!r_is_reserved_word()) {
          break lab0;
        }
        return false;
      }
      cursor = limit - v_1;
    }
    int v_2 = limit - cursor;
    r_append_U_to_stems_ending_with_d_or_g();
    cursor = limit - v_2;
    int v_3 = limit - cursor;
    r_post_process_last_consonants();
    cursor = limit - v_3;
    cursor = limit_backward;
    return true;
  }

  public boolean stem() {
    if (!r_more_than_one_syllable_word()) {
      return false;
    }
    limit_backward = cursor;
    cursor = limit;
    int v_1 = limit - cursor;
    r_stem_nominal_verb_suffixes();
    cursor = limit - v_1;
    if (!(B_continue_stemming_noun_suffixes)) {
      return false;
    }
    int v_2 = limit - cursor;
    r_stem_noun_suffixes();
    cursor = limit - v_2;
    cursor = limit_backward;
    if (!r_postlude()) {
      return false;
    }
    return true;
  }

  @Override
  public boolean equals(Object o) {
    return o instanceof turkishStemmer;
  }

  @Override
  public int hashCode() {
    return turkishStemmer.class.getName().hashCode();
  }


}

