/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.cojen.classfile.Descriptor;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.WeakCanonicalSet;

public class MethodDesc
extends Descriptor
implements Serializable {
    private static final TypeDesc[] EMPTY_PARAMS = new TypeDesc[0];
    private static final WeakCanonicalSet<Descriptor> cInstances = TypeDesc.cInstances;
    private final transient String mDescriptor;
    private final transient TypeDesc mRetType;
    private final transient TypeDesc[] mParams;

    static MethodDesc intern(MethodDesc desc) {
        return cInstances.put(desc);
    }

    public static MethodDesc forArguments(TypeDesc ret, TypeDesc[] params) {
        if (ret == null) {
            ret = TypeDesc.VOID;
        }
        if (params == null || params.length == 0) {
            params = EMPTY_PARAMS;
        }
        return MethodDesc.intern(new MethodDesc(ret, params));
    }

    public static MethodDesc forDescriptor(String desc) throws IllegalArgumentException {
        try {
            int cursor = 0;
            char c = desc.charAt(cursor++);
            if (c != '(') {
                throw MethodDesc.invalidDescriptor(desc);
            }
            StringBuffer buf = new StringBuffer();
            ArrayList<TypeDesc> list = new ArrayList<TypeDesc>();
            block8: while ((c = desc.charAt(cursor++)) != ')') {
                block1 : switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        buf.append(c);
                        break;
                    }
                    case '[': {
                        buf.append(c);
                        continue block8;
                    }
                    case 'L': {
                        while (true) {
                            buf.append(c);
                            if (c == ';') break block1;
                            c = desc.charAt(cursor++);
                        }
                    }
                    default: {
                        throw MethodDesc.invalidDescriptor(desc);
                    }
                }
                list.add(TypeDesc.forDescriptor(buf.toString()));
                buf.setLength(0);
            }
            TypeDesc ret = TypeDesc.forDescriptor(desc.substring(cursor));
            TypeDesc[] tds = list.toArray(new TypeDesc[list.size()]);
            return MethodDesc.intern(new MethodDesc(desc, ret, tds));
        }
        catch (NullPointerException e) {
            throw MethodDesc.invalidDescriptor(desc);
        }
        catch (IndexOutOfBoundsException e) {
            throw MethodDesc.invalidDescriptor(desc);
        }
    }

    public static MethodDesc forMethod(Method method) {
        TypeDesc[] paramTypes;
        Class<?>[] paramClasses = method.getParameterTypes();
        if (paramClasses == null || paramClasses.length == 0) {
            paramTypes = EMPTY_PARAMS;
        } else {
            paramTypes = new TypeDesc[paramClasses.length];
            int i = paramClasses.length;
            while (--i >= 0) {
                paramTypes[i] = TypeDesc.forClass(paramClasses[i]);
            }
        }
        return MethodDesc.forArguments(TypeDesc.forClass(method.getReturnType()), paramTypes);
    }

    private static IllegalArgumentException invalidDescriptor(String desc) {
        return new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    private MethodDesc(TypeDesc ret, TypeDesc[] params) {
        this.mDescriptor = MethodDesc.generateDescriptor(ret, params);
        this.mRetType = ret;
        this.mParams = params;
    }

    private MethodDesc(String desc, TypeDesc ret, TypeDesc[] params) {
        this.mDescriptor = desc;
        this.mRetType = ret;
        this.mParams = params;
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public TypeDesc getReturnType() {
        return this.mRetType;
    }

    public int getParameterCount() {
        return this.mParams.length;
    }

    public TypeDesc[] getParameterTypes() {
        TypeDesc[] params = this.mParams;
        return params != EMPTY_PARAMS ? (TypeDesc[])params.clone() : params;
    }

    public String toMethodSignature(String name) {
        return this.toMethodSignature(name, false);
    }

    public String toMethodSignature(String name, boolean varargs) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mRetType.getFullName());
        buf.append(' ');
        buf.append(name);
        buf.append('(');
        TypeDesc[] params = this.mParams;
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            TypeDesc param = params[i];
            if (varargs && param.isArray() && i == params.length - 1) {
                buf.append(param.getComponentType().getFullName());
                buf.append("...");
                continue;
            }
            buf.append(param.getFullName());
        }
        return buf.append(')').toString();
    }

    public String toString() {
        return this.mDescriptor;
    }

    public int hashCode() {
        return this.mDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MethodDesc) {
            return ((MethodDesc)other).mDescriptor.equals(this.mDescriptor);
        }
        return false;
    }

    Object writeReplace() throws ObjectStreamException {
        return new External(this.mDescriptor);
    }

    private static String generateDescriptor(TypeDesc ret, TypeDesc[] params) {
        String paramDesc;
        int paramsLength;
        int length = ret.getDescriptor().length() + 2;
        int i = paramsLength = params.length;
        while (--i >= 0) {
            length += params[i].getDescriptor().length();
        }
        char[] buf = new char[length];
        buf[0] = 40;
        int index = 1;
        for (int i2 = 0; i2 < paramsLength; ++i2) {
            paramDesc = params[i2].getDescriptor();
            int paramDescLength = paramDesc.length();
            paramDesc.getChars(0, paramDescLength, buf, index);
            index += paramDescLength;
        }
        buf[index++] = 41;
        paramDesc = ret.getDescriptor();
        paramDesc.getChars(0, paramDesc.length(), buf, index);
        return new String(buf);
    }

    private static class External
    implements Externalizable {
        private String mDescriptor;

        public External() {
        }

        public External(String desc) {
            this.mDescriptor = desc;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mDescriptor);
        }

        public void readExternal(ObjectInput in) throws IOException {
            this.mDescriptor = in.readUTF();
        }

        public Object readResolve() throws ObjectStreamException {
            return MethodDesc.forDescriptor(this.mDescriptor);
        }
    }
}

