/*
 * hash.h
 *
 * $Id: hash.h 31 2012-04-20 21:57:34Z diraison $
 *
 * This file is part of the btcheck project (c) 2008-2009 distributed
 * under the GNU GPLv3 license and created by Jean Diraison
 * <jean.diraison@ac-rennes.fr>
 *
 * URL: http://sourceforge.net/projects/btcheck/
 *
 */

#ifndef BTCHECK_HASH_H_
#define BTCHECK_HASH_H_

#ifdef WITH_OPENSSL
#include <openssl/sha.h>
#else
#ifdef WITH_WINDOWS_CRYPTOAPI
#include <windows.h>
#include <wincrypt.h>
#define SHA_DIGEST_LENGTH		(20)
#define SHA_CTX struct { \
	HCRYPTPROV hCryptProv; \
	HCRYPTHASH hCryptHash; \
}
#else
#include <stdint.h>
#define SHA_DIGEST_LENGTH		(20)
#define SHA_CTX struct { \
	uint32_t       hash[5]; \
	long long      length; \
	int            buflen; \
	unsigned char  buffer[64]; \
}
#endif
#endif

#define HASH_LENGTH		(SHA_DIGEST_LENGTH)

typedef SHA_CTX hashcharctx_t;

int init_hash_char(hashcharctx_t *ctx);
int update_hash_char(hashcharctx_t *ctx, int c);
int final_hash_char(unsigned char *md, hashcharctx_t *ctx);
unsigned char *compute_hash_buffer(unsigned char *md, void *data, unsigned long length);

#endif
