#
#  A series of compact levels.
#

import boarddef, mnstrmap, random
from boarddef import LNasty, LMonky, LGhosty, LFlappy
from boarddef import LSpringy, LOrcy, LGramy, LBlitzy
from boarddef import RNasty, RMonky, RGhosty, RFlappy
from boarddef import RSpringy, ROrcy, RGramy, RBlitzy


class level01(boarddef.Level):
    a = LNasty
    b = RNasty
    
    walls = """
#############################
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##         a     b         ##
####   ###############   ####
##                         ##
##                         ##
##                         ##
##         a     b         ##
####   ###############   ####
##                         ##
##                         ##
##                         ##
##         a     b         ##
####   ###############   ####
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""


class level02(boarddef.Level):
    a = LNasty
    b = RNasty
    g = RGhosty
    
    walls = """
#############################
##            #            ##
##            #            ##
##            #            ##
##            #   g        ##
##  g         #            ##
##            #            ##
##            #            ##
####   ###############   ####
##     #             #     ##
##     #             #     ##
##     #             #     ##
##     #   a     b   #     ##
####   ###############   ####
##                         ##
##                         ##
##                         ##
##                         ##
####                     ####
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""


class level03(boarddef.Level):
    a = LNasty
    b = RNasty

    letter = 1
    
    walls = """
#########    ###    #########
##      #           #      ##
##      #           #      ##
##      #           #      ##
##      #           #      ##
##b  #  #           #  # a ##
######  #####   #####  ######
##                         ##
##                         ##
##                         ##
##  #b  #   #   #   # a #  ##
##  #####   #####   #####  ##
##    #               #    ##
##    #               #    ##
##    #               #    ##
##b   #               #  a ##
#######    # b   #    #######
##         #######         ##
##            #            ##
##            #            ##
##            #            ##
##            #            ##
##            #            ##
#########    ###    #########
"""   #|#    #|#    #|#   """


class level04(boarddef.Level):
    a = LNasty
    b = RNasty
    g = LOrcy

    fire = 1
    
    walls = """
#########    ###    #########
##      #           #      ##
##      #           #      ##
##      #           #      ##
##      #           #      ##
##b  #  #           #  # a ##
######  #####   #####  ######
##                         ##
##                         ##
##                         ##
##  #b  #   #gg #   # a #  ##
##  #####   #####   #####  ##
##    #               #    ##
##    #               #    ##
##    #               #    ##
##b   #               #  a ##
#######    # b   #    #######
##         #######         ##
##            #            ##
##            #            ##
##            #            ##
##            #            ##
##            #            ##
#########    ###    #########
"""   #|#    #|#    #|#   """

class level05(boarddef.Level):
    a = LNasty
    b = RNasty
    g = LOrcy
    f = RFlappy

    water = top = letter = 1
    
    walls = """
##      #           #      ##
##      #           #      ##
##      #           #      ##
##      #           #      ##
##      #           #      ##
##b  #  #           #  # a ##
#### #  #####   #####  # ####
##                         ##
##                         ##
##                         ##
##  #b  #   #gg #   # a #  ##
##  # ###   ## ##   ### #  ##
##    #               #    ##
##    #               #    ##
##    #       f       #    ##
##b   #               #  a ##
#######    # b   #    #######
##         # ### #         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
#########           #########
"""   #|#    #|#    #|#   """

    winds = """
>>                         <<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level06(boarddef.Level):
    a = LNasty, RNasty, LMonky

    letter = fire = 1
    
    walls = """
#############################
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##        ###              ##
##          #           ## ##
##      ##  #       ##  #  ##
##       #  #   ##  #   #  ##
##   ##  #  #   #   #   #  ##
##    #  ####   #   #   #a ##
## a  ####      #############
## ####                    ##
####                       ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level07(boarddef.Level):
    g = LGhosty, LGhosty, LGhosty, LGhosty
    h = RGhosty, RGhosty, RGhosty, RGhosty

    letter = lightning = 1
    
    walls = """
##                         ##
##                         ##
##   #                 #   ##
##   #                 #   ##
##   #                 #   ##
##  ###               ###  ##
##h # #       #       # #g ##
## # # #      #      # # # ##
##### ####    #    #### #####
## # # #     ###     # # # ##
##  # #      # #      # #  ##
##  ###     # # #     ###  ##
##   #    #### ####    #   ##
##   #      # # #      #   ##
##   #       # #       #   ##
##           ###           ##
##            #            ##
##      #     #     #      ##
##      #     #     #      ##
##      #           #      ##
##     ###         ###     ##
##     # #         # #     ##
##    # # #       # # #    ##
##  #### ####   #### ####  ##
"""   #|#    #|#    #|#   """

class level08(boarddef.Level):
    s = LSpringy
    r = RSpringy
    f = LFlappy
    g = RFlappy
    
    walls = """
#############################
##                         ##
## g                    f  ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##            #            ##
##                         ##
##           ###           ##
##                         ##
##          #####          ##
##                         ##
##         #######         ##
##                         ##
##        #########        ##
##         sssrrr          ##
##       ###########       ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level09(boarddef.Level):
    m = (LMonky, RMonky,)*5
    g = LGhosty
    
    walls = """
#######  ####   ####  #######
#######  ####   ####  #######
##         ##   ##         ##
##         ##   ##         ##
##   g     ##   ##     g   ##
##         ##   ##         ##
##         ##   ##         ##
####    #####   #####    ####
####    #####   #####    ####
##                         ##
##   ##  ####   ####  ##   ##
##   ##  ####   ####  ##   ##
##       ##       ##       ##
####     ##       ##     ####
####     ##   m   ##     ####
##       ##  ###  ##       ##
##   ##  ##  ###  ##  ##   ##
##   ##  ##  ###  ##  ##   ##
##       ##  ###  ##       ##
####     ##       ##     ####
####     ##       ##     ####
##       ##       ##       ##
##   ##  ####   ####  ##   ##
#######  ####   ####  #######
"""   #|#    #|#    #|#   """

class level10(boarddef.Level):
    n = LNasty

    fire = top = 1
    
    walls = """
##            #####   ##   ##
##               ##nn ##   ##
##               #######   ##
##                         ##
##                         ##
##  ##   #####             ##
##  ##nn ##                ##
##  #######     #####   ## ##
##                 ##nn ## ##
##                 ####### ##
##                         ##
##                         ##
## ##   #####              ##
## ##nn ##                 ##
## #######                 ##
##                         ##
##           #####   ##    ##
##              ##nn ##    ##
##              #######    ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

    winds = """
>>                         <<
>>>           >>v  xxx    <<<
>>^                       ^<<
>>^                   v<<<^<<
>>^                       ^<<
>>^                       ^<<
>>^   xxx  v<<            ^<<
>>^                       ^<<
>>^>>>v         >>v  xxx  ^<<
>>^                       ^<<
>>^               >v      ^<<
>>^                       ^<<
>>^                       ^<<
>>^  xxx  v<<             ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^               xxx     ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level11(boarddef.Level):
    o = LOrcy
    p = ROrcy

    letter = fire = water = lightning = top = 1
    
    walls = """
##                         ##
##                         ##
###                       ###
##  #                   #  ##
##    #               #    ##
##      #           #      ##
##        # #   # #        ##
##            #            ##
## o  p  o #  #  #p  o  p  ##
####### ####  #  #### #######
##            #            ##
##            #            ##
##            #            ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #      #      #     ##
##     #  # #   # #  #     ##
##     #             #     ##
###### ######   ###### ######
"""   #|#    #|#    #|#   """

class level12(boarddef.Level):
    o = LGramy
    
    walls = """
##            ####         ##
##            #  #         ##
##            ####         ##
##            #  #         ##
##          #            o ##
##          #################
##                   #  #  ##
##                   ####  ##
##       o #         #  #  ##
## #########         ####  ##
## #  #              #  #  ##
## ####          #       o ##
## #  #          ############
## ####          #  #      ##
## #  #          ####      ##
##       o #     #  #      ##
############     ####      ##
##    #  #       #  #      ##
##    ####           o #   ##
##    #  #      ########   ##
##    ####                 ##
##    #  #                 ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level13(boarddef.Level):
    n = LNasty
    m = LMonky
    g = LGhosty
    f = LFlappy
    s = LSpringy
    o = LOrcy
    r = LGramy
    b = LBlitzy
    
    walls = """
##         # ####          ##
##  f      ##  ##   ####   ##
##          ####   ##  ##  ##
##                 #### #  ##
##   ####   f      ######  ##
##  ##  ##     f   ######  ##
##  # ####   ####   ####   ##
##  ######  ######         ##
##  ######  ######         ##
##   ####   #### #         ##
##          ##  ##     f   ##
##           ####          ##
##  f                      ##
##                ####     ##
##               ######    ##
##     ####      ######    ##
##    ##  ##     # ####    ##
##    # ####  f  ##  ##    ##
##    ######      ####     ##
##    ######               ##
##     ####                ##
##                         ##
##          ####           ##
######     ######       #####
"""   #|#    #|#    #|#   """

class level14(boarddef.Level):
    o = LOrcy
    r = LGramy
    
    walls = """
#############################
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##    ###           ###    ##
##     ##           ##     ##
##      #           #      ##
##    ###           ###    ##
##     ##           ##     ##
##      #           #      ##
##      ##         ##      ##
##     ##           ##     ##
##    ###           ###    ##
##    ##             ##    ##
##    ##             ##    ##
##    ##or        or ##    ##
#############################
"""   #|#    #|#    #|#   """

class level15(boarddef.Level):
    s = LSpringy
    g = LGhosty
    
    walls = """
#############################
##                         ##
##                         ##
##                         ##
##       s       s         ##
##       s       s         ##
##       s       s         ##
##    ###s  #####s  ###    ##
##   #  ## ####### ##  #   ##
##   #    ###   ###    #   ##
##   ##  ###     ###  ##   ##
##     # ###  g  ### #     ##
##    #  ###     ###  #    ##
##   #    ###   ###    #   ##
##   #  ## ####### ##  #   ##
##    ###   #####   ###    ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level16(boarddef.Level):
    l = LBlitzy, LGramy
    r = RBlitzy, RGramy

    letter = 1
    
    walls = """
#############################
##           l r           ##
##           ####       ## ##
## ####   ## ####       ## ##
## ####   ##       #### ## ##
##    l   ##    ## #### ## ##
##  ####  ##    ##      l  ##
##  ####     ## ##    #### ##
##       ##  ## ##    #### ##
## ####  ##  ##            ##
## ####  ##  ## #### ##    ##
##       ##     #### ##    ##
##  ##      ####     ##    ##
##  ## #### ####  l  ## ## ##
##  ## ####       ##    ## ##
##  ##            ##    ## ##
##        ##      ## r  ## ##
##   #### ##      ## ##    ##
##   #### ## ####    ## ## ##
##        ## ####    ## ## ##
##   ####            ## ## ##
##   ####               ## ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level17(boarddef.Level):
    m = LMonky
    j = RMonky
    g = LGhosty
    h = RGhosty
    b = LBlitzy
    
    walls = """
############               ##
##         #               ##
##   g     #               ##
##  #####  #  ###########  ##
##  #   #  #  #         #  ##
##  #  ##  #  #   g     #  ##
##  #  #j  #  #  #####  #  ##
##  #  #####  #  #   #  #  ##
##  #         #  #  ##  #  ##
##  #b        #  #  #j  #  ##
##  ###########  #  #####  ##
##               #         ##
##               #         ##
##  ###########  #    h    ##
##  #         #  #  #####  ##
##  #    h    #  #  #   #  ##
##  #  #####  #  #  ##  #  ##
##  #  #   #  #  # m #  #  ##
##  #  ##  #  #  #####  #  ##
##  # m #  #  #         #  ##
##  #####  #  #       b #  ##
##         #  ###########  ##
##       b #               ##
############               ##
"""   #|#    #|#    #|#   """

class level18(boarddef.Level):
    o = (ROrcy,)*10
    
    walls = """
#############   #############
##                         ##
##            #            ##
##                         ##
##          #   #          ##
##                         ##
##                         ##
##       #         #       ##
##                         ##
##     #   #######   #     ##
##     #             #     ##
##     ##           ##     ##
##     #  ###   ###  #     ##
##     ##           ##     ##
##     #             #     ##
##     #   #######   #     ##
##     #             #     ##
##     ##           ##     ##
##     ######   ######     ##
##     ###         ###     ##
##     ##     o     ##     ##
##     ##  #######  ##     ##
##     ##           ##     ##
#############   #############
"""   #|#    #|#    #|#   """

class level19(boarddef.Level):
    n = LNasty
    g = RGhosty
    f = LFlappy
    s = LSpringy
    
    walls = """
##    ###    ###    ###    ##
##   #   #  #   #  #   #   ##
##   #   ####   ####   #   ##
##   #n  #  #n  #  #n  #   ##
##    ###    ###    ###    ##
##     #             #     ##
##     #             #     ##
##    ###      f    ###    ##
##   #   #  g      #   #   ##
##   #   #     f   #   #   ##
##   #n  #  g      #n  #   ##
##    ###           ###    ##
##     #             #     ##
##     #             #     ##
##    ###    ###    ###    ##
##   #   #s #   #s #   #   ##
##   #   ####   ####   #   ##
##   #n  #  #n  #  #n  #   ##
##    ###    ###    ###    ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level20(boarddef.Level):
    s = LSpringy, RSpringy

    letter = fire = top = 1
    
    walls = """
###                       ###
###                       ###
##                         ##
##                         ##
##ss  ss   #     #  ss  ss ##
## #   #   #     #   #   # ##
## #   #    #####    #   # ##
## #   #             #   # ##
## #   #             #   # ##
## #                     # ##
## #                     # ##
## #                     # ##
##                         ##
##                         ##
##                         ##
##                         ##
##    #               #    ##
##    #               #    ##
##    #               #    ##
##                         ##
##                         ##
##                         ##
##                         ##
## #########     ######### ##
"""   #|#    #|#    #|#   """

class level21(boarddef.Level):
    n = (RNasty,)*12

    letter = 1
    
    walls = """
#############################
##                         ##
##n                        ##
#########################  ##
##                         ##
##                         ##
##  #########################
##                         ##
##                         ##
#########################  ##
##                         ##
##                         ##
##  #########################
##                         ##
##                         ##
#########################  ##
##                         ##
##                         ##
##  #########################
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level22(boarddef.Level):
    n = LNasty
    m = LMonky
    g = LGhosty
    f = LFlappy
    s = LSpringy
    o = LOrcy
    r = LGramy
    b = LBlitzy
    
    walls = """
##    ###    ###    ###    ##
##   #   #  #   #  #   #   ##
##   #   ####   ####   #   ##
##   #o  #  #b  #  #r  #   ##
##    ###    ###    ###    ##
##     #             #     ##
##     #             #     ##
##    ###           ###    ##
##   #   #         #   #   ##
##   #   #         #   #   ##
##   #g  #         #f  #   ##
##    ###           ###    ##
##     #             #     ##
##     #             #     ##
##    ###    ###    ###    ##
##   #   #  #   #  #   #   ##
##   #   ####   ####   #   ##
##   #m  #  #s  #  #n  #   ##
##    ###    ###    ###    ##
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level23(boarddef.Level):
    m = LMonky

    water = top = 1
    
    walls = """
######    #       #    ######
######    #       #    ######
##        #  m    #        ##
## ######## ##### ######## ##
## ######## ##### ######## ##
## ######## #####   m   ## ##
## ######## ########### ## ##
##      m      ######## ## ##
## ########### ######## ## ##
## ###########      m   ## ##
## ################ ###### ##
## ################ ###### ##
## ########     m          ##
## ######## ############## ##
## ######## ############## ##
## ########m   ########### ##
##  m    ##### #####   m   ##
######## ##### ##### ########
######## m       m   ########
############## ##############
#############################
##                         ##
##                         ##
######    #########    ######
"""   #|#    #|#    #|#   """

class level24(boarddef.Level):
    g = RGhosty
    f = RFlappy
    s = LSpringy
    t = RSpringy
    
    walls = """
#############################
##                         ##
##                         ##
## s                    t  ##
## s                    t  ##
## s                    t  ##
######                 ######
##                         ##
##   #####  #####  #####   ##
##   #      #      #       ##
##   #g     #      #g      ##
##   #      #f     #       ##
##   #      #      #       ##
##                         ##
##                         ##
##   #####  #####  #####   ##
##   #      #      #       ##
##   #      #g     #       ##
##   #f     #      #f      ##
##   #      #      #       ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level25(boarddef.Level):
    s = LSpringy
    t = RSpringy

    letter = lightning = 1
    
    walls = """
#############   #############
##                         ##
##            #            ##
##            #            ##
##  s                  t   ##
##   #    #       #    #   ##
##   #    #       #    #   ##
##                         ##
##            #            ##
##            #            ##
##  t                  s   ##
##   #    #       #    #   ##
##   #    #       #    #   ##
##                         ##
##            #            ##
##            #            ##
##  s                  t   ##
##   #    #       #    #   ##
##   #    #       #    #   ##
##                         ##
##            #            ##
##            #            ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """

class level26(boarddef.Level):
    s = LSpringy

    fire = 1
    
    walls = """
#######               #######
##                         ##
##                         ##
##s                      s ##
##s   #######   #######  s ##
##s                      s ##
####                     ####
##                         ##
##    ##             ##    ##
##                         ##
##        ##     ##        ##
##                         ##
##           ###           ##
##                         ##
##s                      s ##
####   ##           ##   ####
##                         ##
##                         ##
##                         ##
##                         ##
##         s    s          ##
##       ##       ##       ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level27(boarddef.Level):
    s = LSpringy

    fire = 1
    
    walls = """
##                         ##
##                         ##
##        #  s    #        ##
##s  #     # s   #     # s ##
##  #       #s  #       #  ##
## #         # #         # ##
###           #           ###
##           ###           ##
###           #           ###
##   #     #  #  #     #   ##
##    #s  #   #   #s  #    ##
##     # #         # #     ##
##      #           #      ##
##     ###         ###     ##
##      #           #      ##
##      #           #      ##
##   s      #s  #     s    ##
##   #   #   # #   #   #   ##
##    # #     #     # #    ##
##     #     ###     #     ##
##    ###     #     ###    ##
##     #             #     ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level28(boarddef.Level):
    f = LFlappy
    
    walls = """
#############################
#########         ###########
##     ##   f     ####     ##
##f    ##   ff    ####   f ##
##f  f ##   ###   ####f f  ##
##   f ##   ###   #### f   ##
#####  ##   ###    ######  ##
#####  ##   ###    ######  ##
#####  ##   ####   ######  ##
#####  ##   ####   ######  ##
##          ####           ##
##                         ##
##                         ##
##   ##   ########   ###   ##
##   ##   ########   ###   ##
##   ##   ########   ###   ##
##   ##      ###     ###   ##
##   ##      ###     ###   ##
##   ##      ###     ###   ##
##   #####   ###   #####   ##
##   #####   ###   #####   ##
##           ###           ##
##           ###           ##
#############################
"""   #|#    #|#    #|#   """

class level29(boarddef.Level):
    f = LFlappy, RFlappy

    top = water = 1
    
    walls = """
##  #####################  ##
##                         ##
##    f              f     ##
##  #####################  ##
##  #####################  ##
##                         ##
##     f            f      ##
##  #####################  ##
##  #####################  ##
##                         ##
##      f          f       ##
##  #####################  ##
##  #####################  ##
##                         ##
##       f        f        ##
##  #####################  ##
##  #####################  ##
##                         ##
##        f      f         ##
##  #####################  ##
##  #####################  ##
##                         ##
##         f    f          ##
##  #####################  ##
"""   #|#    #|#    #|#   """

class level30(boarddef.Level):
    g = RGhosty
    h = RGhosty
    i = LGhosty
    j = LGhosty
    
    walls = """
#############################
##                         ##
##                         ##
##                         ##
##         ####g #         ##
##          ######         ##
##        j ######         ##
##         #######         ##
##         ######          ##
##         ######h         ##
##         #  ####         ##
##          i              ##
##                         ##
##                         ##
##   ####g #     ####g #   ##
##    ######      ######   ##
##  j ######    j ######   ##
##   #######     #######   ##
##   ######      ######    ##
##   ######h     ######h   ##
##   #  ####     #  ####   ##
##    i           i        ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level31(boarddef.Level):
    o = LGramy, RGramy
    r = LOrcy
    s = ROrcy

    top = letter = lightning = fire = 1
    
    walls = """
##   ########   ########   ##
##                         ##
##                         ##
##    r              s     ##
##   ########   ########   ##
##o                      o ##
######                 ######
##                         ##
##o       s #   #r       o ##
#############   #############
##                         ##
##                         ##
##  #####################  ##
##                         ##
##                         ##
##    #######   #######    ##
##                         ##
##o                      o ##
##########  #   #  ##########
##          #   #          ##
##         ##   ##         ##
##                         ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """

class level32(boarddef.Level):
    n = LNasty, RNasty
    f = (LFlappy, RFlappy) * 2
    
    walls = """
#############   #############
##         ##   ##         ##
##       f ##   ##f        ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##n        ##   ##       n ##
#############################
#############################
##                         ##
##              f          ##
##n                      n ##
#############################
#############################
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
#############   #############
"""   #|#    #|#    #|#   """

    winds = """
>>            ^            <<
>>>>>>>>>>>>> ^ <<<<<<<<<<<<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^           ^           ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^          xxx          ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level33(boarddef.Level):
    monsters = [mnstrmap.Gramy(14, -2, 1),
                mnstrmap.Gramy(13, -2, 0)] * 10
    top = 1
    
    walls = """
##         ##   ##         ##
##         ##   ##         ##
##         ##   ##         ##
##    #######   #######    ##
##    #               #    ##
##    #               #    ##
##    #  ###########  #    ##
##    #               #    ##
##    #               #    ##
##    #######   #######    ##
##    #               #    ##
##    #               #    ##
##    #  ###########  #    ##
##    #               #    ##
##    #               #    ##
##    #######   #######    ##
##    #               #    ##
##    #               #    ##
##    #  ###########  #    ##
##    #               #    ##
##    #               #    ##
##    #######   #######    ##
##         ##   ##         ##
#############   #############
"""   #|#    #|#    #|#   """

    winds = """
>>                         <<
>>>xxxxxxxxxxxxxxxxxxxxxxx<<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level34(boarddef.Level):
    n = LNasty
    N = RNasty
    m = LMonky
    M = RMonky
    g = LGhosty
    G = RGhosty
    o = LOrcy
    O = ROrcy
    r = LGramy
    R = RGramy
    b = LBlitzy, RBlitzy

    top = water = letter = 1
    
    walls = """
##### # ############# # #####
##    #       #       #    ##
##    #       #       #    ##
##    #       #       #    ##
##          r #R           ##
############# # #############
##            #            ##
##G   #       #       #  g ##
##    #       #       #    ##
##    #       #       #    ##
##    #O      b     o #    ##
##### # ############# # #####
##    #               #    ##
##    #       #       #    ##
##    #       #       #    ##
##    #       #       #    ##
##M           #          m ##
############# # #############
##            #            ##
##    #       #       #    ##
##    #       #       #    ##
##    #       #       #    ##
##    #     n #N      #    ##
##### # ############# # #####
"""   #|#    #|#    #|#   """

class level35(boarddef.Level):
    g = (RGhosty,)*3
    h = (LGhosty,)*3
    
    walls = """
#############   #############
##                       h ##
#############################
##g                        ##
#############################
##                       h ##
#############   #############
##g                        ##
#############################
##                       h ##
#############################
##g                        ##
#############   #############
##                       h ##
#############################
##g                        ##
#############################
##                       h ##
#############   #############
##g                        ##
#############################
##                         ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """

class level36(boarddef.Level):
    f = LFlappy
    r = RSpringy

    top = fire = letter = 1
    
    walls = """
##    # # #       # # #    ##
## f   # #   r     # #  f  ##
##    # # #f r    # # #    ##
##     # #   r     # #     ##
##  f # # #    f  # # #  f ##
##     # #         # #     ##
## f  # # #    f  # # # f  ##
##     # #  f      # #     ##
##    # # #       # # #    ##
##  f  # #    f    # # f   ##
##    # # #     f # # #    ##
##     # #  f      # #     ##
##    # # #       # # #    ##
##     # #   f  f  # #     ##
##    # # #       # # #    ##
##     # #         # #     ##
##    # # #   f   # # #    ##
##     # #         # #     ##
##    # # #   f   # # #    ##
##     # #  f      # #     ##
##    # # #     f # # #    ##
##     # #         # #     ##
##    # # # f     # # #    ##
#############################
"""   #|#    #|#    #|#   """

class level37(boarddef.Level):
    n = LNasty
    m = RMonky
    o = (RFlappy,) * 5
    s = LSpringy
    t = RSpringy
    
    walls = """
#######   #########   #######
##                         ##
##                         ##
##                         ##
##   #s    t    s    t #   ##
##  #####################  ##
##   #                 #   ##
##   #                 #   ##
##   #  o              #   ##
##   #                 #   ##
##   #                 #   ##
##   #     #n  m #     #   ##
##   #     #######     #   ##
##   #        #        #   ##
##   #        #        #   ##
##   #        #        #   ##
##   #        #        #   ##
##   #        #        #   ##
##  #####################  ##
##   #        #        #   ##
##            #            ##
##            #            ##
##            #            ##
#######   #########   #######
"""   #|#    #|#    #|#   """

class level38(boarddef.Level):
    f = LFlappy
    b = (LBlitzy, RBlitzy) * 2

    water = 1
    
    walls = """
#############   #############
##                         ##
##                         ##
##                         ##
##    b      b       b     ##
##   ######### #########   ##
##   ######### #########   ##
##   ######### #########   ##
##   ###             ###   ##
##   ### f  f  f  f  ###   ##
##   ###             ###   ##
##   ###   ### ###   ###   ##
##   ###   ### ###   ###   ##
##   ###   ### ###   ###   ##
##   ###   ### ###   ###   ##
##   ###             ###   ##
##   ### f  f  f  f  ###   ##
##   ######### #########   ##
##   ######### #########   ##
##   ######### #########   ##
##                         ##
##                         ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """

class level39(boarddef.Level):
    monsters = []
    mnstrclasses = ([mnstrmap.Nasty] * 10 +
                    [None]           * 30 +
                    [mnstrmap.Monky] * 7 +
                    [None]           * 30 +
                    [mnstrmap.Orcy]  * 5)
    for i in range(len(mnstrclasses)):
        if mnstrclasses[i]:
            left = random.randrange(2)
            x = random.choice([7,14,21])
            monsters.append(mnstrclasses[i](x-left, -2*i, left))
    
    walls = """
######   ####   ####   ######
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
######    #########    ######
##                         ##
##                         ##
##                         ##
##                         ##
#############################
"""   #|#    #|#    #|#   """

class level40(boarddef.Level):
    g = LGhosty

    top = fire = 1
    
    walls = """
##                         ##
##                         ##
##           # ##          ##
##          ##  ### #      ##
##       # ##              ##
##                         ##
##                         ##
##                #        ##
##         #      ####     ##
##     ###                 ##
##     # #   g             ##
##            #            ##
##           ###   #       ##
##      #     #    ###     ##
##    ###      g     #     ##
##      #                  ##
##            g            ##
##     #           ##      ##
##     #      #     ###    ##
##   ###      #            ##
##            # g          ##
##         g  #      #     ##
##    ##      #     ##     ##
## # ###             ## ## ##
"""   #|#    #|#    #|#   """

    winds = """
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>>>>>>>>>>>vvxvv<<<<<<<<<<<<
>>>>>>>>>>>>vvxvv<<<<<<<<<<<<
>>>>>>>>>>>>vxxxv<<<<<<<<<<<<
>>>>>>>>>>>>vxxxv<<<<<<<<<<<<
>>>>>>>>>>>>vxxxv<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>>>>>>>>>>>xxxxx<<<<<<<<<<<<
>>                         <<
"""

class level41(boarddef.Level):
    f = RFlappy
    j = LFlappy
    b = RBlitzy
    d = LBlitzy

    top = 1

    walls = """
#############   #############
##b                      d ##
#####        db         #####
##      #############      ##
##     ##           ##     ##
###   ### jfjfjfjf  ###   ###
##     ## fjfjfjfj  ##     ##
####    #####   #####    ####
##                         ##
###                       ###
####                     ####
#b                       d ##
######                 ######
###                       ###
#######               #######
#####                   #####
##b                      d ##
##########        ###########
#####                   #####
####                     ####
#######               #######
##                         ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """

    winds = """
>>                         <<
>>v<<<<<<<<<<<<>>>>>>>>>>>v<<
>>v>>>>>>>>vvvvvvv<<<<<<<<v<<
>>v>>>>>>>>vvvvvvv<<<<<<<<v<<
>>v>>>>>>>>xxxxxxx<<<<<<<<v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>v                       v<<
>>>          vvv          <<<
>>>          vvv          <<<
"""

class level42(boarddef.Level):
    l = LOrcy, LOrcy
    r = ROrcy, ROrcy
    b = ROrcy, LOrcy, ROrcy, LOrcy

    top = 1
    water = 1
    letter = 1

    walls = """
##                    #    ##
##          l       r      ##
##          ##      ##     ##
##                         ##
##  ####               ### ##
##                #        ##
##    #               #    ##
##      # # r              ##
## #        ##             ##
##   r           #  #      ##
##   ## #      #           ##
##          #            # ##
##           r    #     #  ##
##       # # ##        #   ##
## #   #       b      #    ##
##  #          ##    #     ##
##   #  r           #      ##
##    # ##         #       ##
##                #        ##
##         # #             ##
##            b            ##
##            ## #         ##
##                 #       ##
##  ###  ##           #    ##
"""   #|#    #|#    #|#   """

    winds = """
>>>vvvvvvvvvvvvvvvvvvvvvvv<<<
>>>vvvvvvvvvvvvvvvvvvvvvvv<<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level43(boarddef.Level):
    s = LSpringy, RSpringy, LSpringy, RSpringy
    f = LFlappy
    g = RFlappy

    walls = """
##        #       #        ##
##        #g    f #        ##
##                         ##
##    #               #    ##
##    #               #    ##
##s   #   #       #   #  s ##
## #  #               #  # ##
## #          #          # ##
##            #            ##
##        # s #s  #        ##
##        # # # # #        ##
##   # #  # # # # #  # #   ##
## # # #  # # # # #  # # # ##
## # # #  # # # # #  # # # ##
## # #    # #   # #    # # ##
## # #    #       #    # # ##
## # #    #       #    # # ##
## #                     # ##
## #                     # ##
## #                     # ##
## #         # #         # ##
##         # # # #         ##
##     # # # # # # #       ##
## # # # # # # # # # # # # ##
"""   #|#    #|#    #|#   """

class level44(boarddef.Level):
    o = LGramy
    p = RGramy
    g = RFlappy
    h = LFlappy

    top = 1

    walls = """
##                         ##
##                         ##
##                         ##
########  ##               ##
## h  ##  ##               ##
## g  ##  ##     ######    ##
## h  ##  ##     ##  ##    ##
## g  ##  ##     ##  ##    ##
## h  ##  ##     ##  ##    ##
## g  ##  ##     ##  ##    ##
##    ##  ##     ##  ##    ##
##    ##  ##     ##  ## h  ##
##    ##  ##     ##  ## g  ##
##    ##  ##     ##  ## h  ##
##    ##  ##     ##  ## g  ##
##    ######     ##  ## h  ##
##               ##  ## g  ##
##               ##  ########
##                         ##
##                         ##
##                         ##
##                         ##
##    p  o  p  o  p  o     ##
#############################
"""   #|#    #|#    #|#   """

    winds = """
>>>vvvvvvvvvvvvvvvvvvvvvvv<<<
>>>>>>>>vv<<<<<vv<<<>>>vvv<<<
>>^     vv                ^<<
>>^     vv                ^<<
>>^     vv                ^<<
>>^     vv                ^<<
>>^     vv         ><     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     vv         ^^     ^<<
>>^     ><         ^^     ^<<
>>^  ^<<<>>>^      ^^     ^<<
>>^                ^^     ^<<
>>^                ^^     ^<<
>>^           >>>>>^^<<<<<^<<
>>^                       ^<<
>>^                       ^<<
>>^vvvvvvvvvvvvvvvvvvvvvvv^<<
>>^vvvvvvvvvvvvvvvvvvvvvvv^<<
>>^vvvvvvvvvvvvvvvvvvvvvvv^<<
"""

class level45(boarddef.Level):
    b = LBlitzy, RBlitzy

    top = 1
    water = 1

    walls = """
##                         ##
##          ## ##          ##
##    ## ## #   # ## ##    ##
##    #   # #   # #   #    ##
##    #   # #bb # #   #    ##
##    #bb # ## ## #bb #    ##
##    ## ##       ## ##    ##
##          ## ##          ##
##   ## ## #     # ## ##   ##
##   #   # #     # #   #   ##
##   #   # #     # #   #   ##
##   #bb # #     # #bb #   ##
##   ## ## #bbbb # ## ##   ##
##          ## ##          ##
##    ## ##       ## ##    ##
##    #   # ## ## #   #    ##
##    #   # #   # #   #    ##
##    #bb # #   # #bb #    ##
##    ## ## #bb # ## ##    ##
##          ## ##          ##
##                         ##
##                         ##
##                         ##
### ##################### ###
"""   #|#    #|#    #|#   """

    winds = """
>>>vvvvvvvvvvvvvvvvvvvvvvv<<<
>>>>>>>>>>>>>xxx<<<<<<<<<<<<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
>>xxxxxxxxxxxxxxxxxxxxxxxxx<<
"""

class level46(boarddef.Level):
    m = LMonky, RGramy
    n = LGramy, RMonky
    g = [RGhosty] * 4
    h = [LGhosty] * 4

    letter = 1
    fire = 1

    walls = """
#############   #############
##                         ##
##                         ##
##                         ##
#############   #############
##       ##       ##       ##
## g     ##       ##    h  ##
##       ## mnmnm ##       ##
##       ###########       ##
##                         ##
##                         ##
##                         ##
########     ###     ########
##    ##      #      ##    ##
##    ##      #      ##    ##
##mnm ##      #      ##mnm ##
########    #####    ########
##            #            ##
##            #            ##
##         #######         ##
##                         ##
##                         ##
##          # # #          ##
############     ############
"""   #|#    #|#    #|#   """

    winds = """
>>>           ^           <<<
>>>>>>>>>>>>>>^<<<<<<<<<<<<<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
>>^           x           ^<<
>>^                       ^<<
>>^                       ^<<
>>^                       ^<<
"""

class level47(boarddef.Level):
    l = LOrcy
    r = ROrcy
    n = LNasty
    m = RNasty

    top = 1
    lightning = 1

    walls = """
##   ###################   ##
##   ###################   ##
##            #            ##
##            #            ##
##                         ##
##                         ##
##                         ##
######   ####   ####   ######
##         #     #         ##
##         #     #         ##
##         #     #         ##
##  #####  #######  #####  ##
##                         ##
##                         ##
##                         ##
#####  ######   ######  #####
##      #           #      ##
##      #           #      ##
##rmr   #    lr     #  lnl ##
#########  #######  #########
##   #        #        #   ##
##   #        #        #   ##
##   #rmrmrmr #lnlnlnl #   ##
##   ###################   ##
"""   #|#    #|#    #|#   """

    winds = """
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>vvvvvvvvvvvvvvvvvvvvvvvvv<<
>>>>>>>vvvvvvvvvvvvvvv<<<<<<<
>>>>>>>>^^^^^^^^^^^^^<<<<<<<<
>>>>>>>>^^^^^^^^^^^^^<<<<<<<<
>>>>>>>>^^^^^^^^^^^^^<<<<<<<<
>>^                       ^<<
"""

class levelFinal(boarddef.Level):
    
    walls = """
#############   #############
##                         ##
##                         ##
##                         ##
##                         ##
##                         ##
####  #################  ####
##        ###   ###        ##
##         ##   ##         ##
#######     #####     #######
##                         ##
##                         ##
##                         ##
##                         ##
#########           #########
##                         ##
##                         ##
##                         ##
##########         ##########
##                         ##
##                         ##
##                         ##
##                         ##
#############   #############
"""   #|#    #|#    #|#   """
# nb.: the previous line has no purpose
# other than helping with wall alignment
