#include <cdi.h>
#include <cstring>
#include <cstdlib>
#include <cmath>

#include "cdo_options.h"
#include "cdo_defaultValues.h"
#include "cdo_cdiWrapper.h"

int
datatype2str(int datatype, char *datatypestr)
{
  int status = 0;

  // clang-format off
  if      (datatype == CDI_DATATYPE_PACK)   strcpy(datatypestr, "P0");
  else if (datatype > 0 && datatype <= 32)  snprintf(datatypestr, 4, "P%d", datatype);
  else if (datatype == CDI_DATATYPE_CPX32)  strcpy(datatypestr, "C32");
  else if (datatype == CDI_DATATYPE_CPX64)  strcpy(datatypestr, "C64");
  else if (datatype == CDI_DATATYPE_FLT32)  strcpy(datatypestr, "F32");
  else if (datatype == CDI_DATATYPE_FLT64)  strcpy(datatypestr, "F64");
  else if (datatype == CDI_DATATYPE_INT8)   strcpy(datatypestr, "I8");
  else if (datatype == CDI_DATATYPE_INT16)  strcpy(datatypestr, "I16");
  else if (datatype == CDI_DATATYPE_INT32)  strcpy(datatypestr, "I32");
  else if (datatype == CDI_DATATYPE_UINT8)  strcpy(datatypestr, "U8");
  else if (datatype == CDI_DATATYPE_UINT16) strcpy(datatypestr, "U16");
  else if (datatype == CDI_DATATYPE_UINT32) strcpy(datatypestr, "U32");
  else
    {
      strcpy(datatypestr, "-1");
      status = -1;
    }
  // clang-format on

  return status;
}

int
str2datatype(const char *datatypestr)
{
  int datatype = -1;
  size_t len = strlen(datatypestr);

  if (len > 1)
    {
      int ilen = atoi(datatypestr + 1);
      // clang-format off
      if (strncmp(datatypestr, "P0", len) == 0)          datatype = CDI_DATATYPE_PACK;
      else if (strncmp(datatypestr, "P", 1) == 0 && ilen > 0 && ilen <= 32) datatype = atoi(datatypestr + 1);
      else if (strncmp(datatypestr, "C32", len) == 0)    datatype = CDI_DATATYPE_CPX32;
      else if (strncmp(datatypestr, "C64", len) == 0)    datatype = CDI_DATATYPE_CPX64;
      else if (strncmp(datatypestr, "F32", len) == 0)    datatype = CDI_DATATYPE_FLT32;
      else if (strncmp(datatypestr, "F64", len) == 0)    datatype = CDI_DATATYPE_FLT64;
      else if (strncmp(datatypestr, "I8", len) == 0)     datatype = CDI_DATATYPE_INT8;
      else if (strncmp(datatypestr, "I16", len) == 0)    datatype = CDI_DATATYPE_INT16;
      else if (strncmp(datatypestr, "I32", len) == 0)    datatype = CDI_DATATYPE_INT32;
      else if (strncmp(datatypestr, "U8", len) == 0)     datatype = CDI_DATATYPE_UINT8;
      else if (strncmp(datatypestr, "U16", len) == 0)    datatype = CDI_DATATYPE_UINT16;
      else if (strncmp(datatypestr, "U32", len) == 0)    datatype = CDI_DATATYPE_UINT32;
      else if (strncmp(datatypestr, "real", len) == 0)   datatype = CDI_DATATYPE_FLT32;
      else if (strncmp(datatypestr, "double", len) == 0) datatype = CDI_DATATYPE_FLT64;
      // clang-format on
    }

  return datatype;
}
int
cdoTaxisCreate(int taxisType)
{
  if (CdoDefault::TaxisType != CDI_UNDEFID) taxisType = CdoDefault::TaxisType;
  return taxisCreate(taxisType);
}
