#ifndef H_CDW_SAFE_INPUT_LINE
#define H_CDW_SAFE_INPUT_LINE

#include "main.h"
#include "cdw_ncurses.h"
#include "cdw_dynamic_label.h"



/* User can make N attempts to enter and fix string with unsafe
   character(s). After the N times the widget's driver returns
   CDW_KEY_ESCAPE. */
#define CDW_SAFE_INPUT_LINE_ATTEMPTS_MAX   5



/* Error messsage will be displayed for X seconds in a message area
   associated with the input line. */
#define CDW_SAFE_INPUT_LINE_ERROR_MESSAGE_TIME     3



typedef struct  {

	cdw_widget_t widget;

	WINDOW *parent;

	int n_cols;  /* width - number of columns of input field */
	/* no height field, it is always equal 1 */

	int chars_max;  /* maximum number of chars that user can enter into input line */
	int input_type;
	int cursor_pos;  /* Cursor position in input line. This variable keeps the position between calls to widget's driver. */

	FORM **form;
	FIELD *field;

	CDW_DYNAMIC_LABEL *message_area;

	int attempts_max;
} CDW_SAFE_INPUT_LINE;



CDW_SAFE_INPUT_LINE *cdw_safe_input_line_new(WINDOW *parent, FORM **form, FIELD *field, int n_cols, const char *initial_content, int input_type, int chars_max);
void     cdw_safe_input_line_delete(CDW_SAFE_INPUT_LINE **line);
char    *cdw_safe_input_line_get_content(CDW_SAFE_INPUT_LINE *line);
cdw_rv_t cdw_safe_input_line_set_content(CDW_SAFE_INPUT_LINE *line, const char *content);
void     cdw_safe_input_line_bind_message_area(CDW_SAFE_INPUT_LINE *line, CDW_DYNAMIC_LABEL *label);
int      cdw_safe_input_line_driver(CDW_SAFE_INPUT_LINE *line, void *dummy);

#endif /* #ifndef H_CDW_SAFE_INPUT_LINE */
