// This file has been generated by Py++.

#include "boost/python.hpp"
#include "generators/include/python_CEGUIOpenGLRenderer.h"
#include "OpenGLRendererBase.pypp.hpp"

namespace bp = boost::python;

struct OpenGLRendererBase_wrapper : CEGUI::OpenGLRendererBase, bp::wrapper< CEGUI::OpenGLRendererBase > {

    OpenGLRendererBase_wrapper( )
    : CEGUI::OpenGLRendererBase( )
      , bp::wrapper< CEGUI::OpenGLRendererBase >(){
        // null constructor
    
    }

    OpenGLRendererBase_wrapper(::CEGUI::Sizef const & display_size )
    : CEGUI::OpenGLRendererBase( boost::ref(display_size) )
      , bp::wrapper< CEGUI::OpenGLRendererBase >(){
        // constructor
    
    }

    virtual ::CEGUI::OpenGLGeometryBufferBase * createGeometryBuffer_impl(  ){
        bp::override func_createGeometryBuffer_impl = this->get_override( "createGeometryBuffer_impl" );
        return func_createGeometryBuffer_impl(  );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget(  ) {
        if( bp::override func_createTextureTarget = this->get_override( "createTextureTarget" ) )
            return func_createTextureTarget(  );
        else{
            return this->CEGUI::OpenGLRendererBase::createTextureTarget(  );
        }
    }
    
    ::CEGUI::TextureTarget * default_createTextureTarget(  ) {
        return CEGUI::OpenGLRendererBase::createTextureTarget( );
    }

    virtual ::CEGUI::TextureTarget * createTextureTarget_impl(  ){
        bp::override func_createTextureTarget_impl = this->get_override( "createTextureTarget_impl" );
        return func_createTextureTarget_impl(  );
    }

    virtual void destroyAllGeometryBuffers(  ) {
        if( bp::override func_destroyAllGeometryBuffers = this->get_override( "destroyAllGeometryBuffers" ) )
            func_destroyAllGeometryBuffers(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers(  );
        }
    }
    
    void default_destroyAllGeometryBuffers(  ) {
        CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers( );
    }

    virtual void destroyAllTextureTargets(  ) {
        if( bp::override func_destroyAllTextureTargets = this->get_override( "destroyAllTextureTargets" ) )
            func_destroyAllTextureTargets(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextureTargets(  );
        }
    }
    
    void default_destroyAllTextureTargets(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextureTargets( );
    }

    virtual void destroyAllTextures(  ) {
        if( bp::override func_destroyAllTextures = this->get_override( "destroyAllTextures" ) )
            func_destroyAllTextures(  );
        else{
            this->CEGUI::OpenGLRendererBase::destroyAllTextures(  );
        }
    }
    
    void default_destroyAllTextures(  ) {
        CEGUI::OpenGLRendererBase::destroyAllTextures( );
    }

    virtual void destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        if( bp::override func_destroyGeometryBuffer = this->get_override( "destroyGeometryBuffer" ) )
            func_destroyGeometryBuffer( boost::ref(buffer) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
        }
    }
    
    void default_destroyGeometryBuffer( ::CEGUI::GeometryBuffer const & buffer ) {
        CEGUI::OpenGLRendererBase::destroyGeometryBuffer( boost::ref(buffer) );
    }

    virtual void destroyTexture( ::CEGUI::Texture & texture ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(texture) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::Texture & texture ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(texture) );
    }

    virtual void destroyTexture( ::CEGUI::String const & name ) {
        if( bp::override func_destroyTexture = this->get_override( "destroyTexture" ) )
            func_destroyTexture( boost::ref(name) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
        }
    }
    
    void default_destroyTexture( ::CEGUI::String const & name ) {
        CEGUI::OpenGLRendererBase::destroyTexture( boost::ref(name) );
    }

    virtual void destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        if( bp::override func_destroyTextureTarget = this->get_override( "destroyTextureTarget" ) )
            func_destroyTextureTarget( boost::python::ptr(target) );
        else{
            this->CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
        }
    }
    
    void default_destroyTextureTarget( ::CEGUI::TextureTarget * target ) {
        CEGUI::OpenGLRendererBase::destroyTextureTarget( boost::python::ptr(target) );
    }

    virtual ::CEGUI::Sizef getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        if( bp::override func_getAdjustedTextureSize = this->get_override( "getAdjustedTextureSize" ) )
            return func_getAdjustedTextureSize( boost::ref(sz) );
        else{
            return this->CEGUI::OpenGLRendererBase::getAdjustedTextureSize( boost::ref(sz) );
        }
    }
    
    ::CEGUI::Sizef default_getAdjustedTextureSize( ::CEGUI::Sizef const & sz ) const  {
        return CEGUI::OpenGLRendererBase::getAdjustedTextureSize( boost::ref(sz) );
    }

    virtual ::CEGUI::uint getMaxTextureSize(  ) const  {
        if( bp::override func_getMaxTextureSize = this->get_override( "getMaxTextureSize" ) )
            return func_getMaxTextureSize(  );
        else{
            return this->CEGUI::OpenGLRendererBase::getMaxTextureSize(  );
        }
    }
    
    ::CEGUI::uint default_getMaxTextureSize(  ) const  {
        return CEGUI::OpenGLRendererBase::getMaxTextureSize( );
    }

    void initialiseDisplaySizeWithViewportSize(  ){
        CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize(  );
    }

    void initialiseMaxTextureSize(  ){
        CEGUI::OpenGLRendererBase::initialiseMaxTextureSize(  );
    }

    virtual bool isS3TCSupported(  ) const {
        bp::override func_isS3TCSupported = this->get_override( "isS3TCSupported" );
        return func_isS3TCSupported(  );
    }

    virtual bool isTextureDefined( ::CEGUI::String const & name ) const  {
        if( bp::override func_isTextureDefined = this->get_override( "isTextureDefined" ) )
            return func_isTextureDefined( boost::ref(name) );
        else{
            return this->CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
        }
    }
    
    bool default_isTextureDefined( ::CEGUI::String const & name ) const  {
        return CEGUI::OpenGLRendererBase::isTextureDefined( boost::ref(name) );
    }

    static void logTextureCreation( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureCreation( boost::ref(name) );
    }

    static void logTextureDestruction( ::CEGUI::String const & name ){
        CEGUI::OpenGLRendererBase::logTextureDestruction( boost::ref(name) );
    }

    virtual void setDisplaySize( ::CEGUI::Sizef const & sz ) {
        if( bp::override func_setDisplaySize = this->get_override( "setDisplaySize" ) )
            func_setDisplaySize( boost::ref(sz) );
        else{
            this->CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
        }
    }
    
    void default_setDisplaySize( ::CEGUI::Sizef const & sz ) {
        CEGUI::OpenGLRendererBase::setDisplaySize( boost::ref(sz) );
    }

    virtual void setupRenderingBlendMode( ::CEGUI::BlendMode const mode, bool const force=false ){
        bp::override func_setupRenderingBlendMode = this->get_override( "setupRenderingBlendMode" );
        func_setupRenderingBlendMode( mode, force );
    }

    virtual void beginRendering(  ){
        bp::override func_beginRendering = this->get_override( "beginRendering" );
        func_beginRendering(  );
    }

    virtual void endRendering(  ){
        bp::override func_endRendering = this->get_override( "endRendering" );
        func_endRendering(  );
    }

};

void register_OpenGLRendererBase_class(){

    { //::CEGUI::OpenGLRendererBase
        typedef bp::class_< OpenGLRendererBase_wrapper, bp::bases< ::CEGUI::Renderer >, boost::noncopyable > OpenGLRendererBase_exposer_t;
        OpenGLRendererBase_exposer_t OpenGLRendererBase_exposer = OpenGLRendererBase_exposer_t( "OpenGLRendererBase", "! Common base class used for other OpenGL based renderer modules.\n", bp::no_init );
        bp::scope OpenGLRendererBase_scope( OpenGLRendererBase_exposer );
        OpenGLRendererBase_exposer.def( bp::init< >() );
        OpenGLRendererBase_exposer.def( bp::init< CEGUI::Sizef const & >(( bp::arg("display_size") ), "*!\n\
            \n\
                Constructor.\n\
        \n\
            @param display_size\n\
                Size object describing the initial display resolution.\n\
            *\n") );
        { //::CEGUI::OpenGLRendererBase::createGeometryBuffer
        
            typedef ::CEGUI::GeometryBuffer & ( ::CEGUI::OpenGLRendererBase::*createGeometryBuffer_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createGeometryBuffer"
                , createGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::createGeometryBuffer)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createGeometryBuffer_impl
        
            typedef ::CEGUI::OpenGLGeometryBufferBase * ( OpenGLRendererBase_wrapper::*createGeometryBuffer_impl_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createGeometryBuffer_impl"
                , createGeometryBuffer_impl_function_type( &OpenGLRendererBase_wrapper::createGeometryBuffer_impl )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! return some appropriate OpenGLGeometryBufferBase subclass instance.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::String const &,::CEGUI::String const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("filename"), bp::arg("resourceGroup") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::CEGUI::Sizef const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTexture"
                , createTexture_function_type(&::CEGUI::OpenGLRendererBase::createTexture)
                , ( bp::arg("name"), bp::arg("size") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*createTexture_function_type )( ::CEGUI::String const &,::GLuint,::CEGUI::Sizef const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTexture"
                , createTexture_function_type( &::CEGUI::OpenGLRendererBase::createTexture )
                , ( bp::arg("name"), bp::arg("tex"), bp::arg("sz") )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Create a texture that uses an existing OpenGL texture with the specified\n\
                    size.  Note that it is your responsibility to ensure that the OpenGL\n\
                    texture is valid and that the specified size is accurate.\n\
            \n\
                @param sz\n\
                    Size object that describes the pixel size of the OpenGL texture\n\
                    identified by  tex.\n\
            \n\
                @param name\n\
                    String holding the name for the new texture.  Texture names must be\n\
                    unique within the Renderer.\n\
            \n\
                @return\n\
                    Texture object that wraps the OpenGL texture  tex, and whose size is\n\
                    specified to be  sz.\n\
            \n\
                @exceptions\n\
                    - AlreadyExistsException - thrown if a Texture object named  name\n\
                      already exists within the system.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTextureTarget
        
            typedef ::CEGUI::TextureTarget * ( ::CEGUI::OpenGLRendererBase::*createTextureTarget_function_type )(  ) ;
            typedef ::CEGUI::TextureTarget * ( OpenGLRendererBase_wrapper::*default_createTextureTarget_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTextureTarget"
                , createTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::createTextureTarget)
                , default_createTextureTarget_function_type(&OpenGLRendererBase_wrapper::default_createTextureTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::createTextureTarget_impl
        
            typedef ::CEGUI::TextureTarget * ( OpenGLRendererBase_wrapper::*createTextureTarget_impl_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "createTextureTarget_impl"
                , createTextureTarget_impl_function_type( &OpenGLRendererBase_wrapper::createTextureTarget_impl )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "! return some appropriate TextureTarget subclass instance.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllGeometryBuffers_function_type )(  ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyAllGeometryBuffers_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyAllGeometryBuffers"
                , destroyAllGeometryBuffers_function_type(&::CEGUI::OpenGLRendererBase::destroyAllGeometryBuffers)
                , default_destroyAllGeometryBuffers_function_type(&OpenGLRendererBase_wrapper::default_destroyAllGeometryBuffers) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextureTargets
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextureTargets_function_type )(  ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyAllTextureTargets_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyAllTextureTargets"
                , destroyAllTextureTargets_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextureTargets)
                , default_destroyAllTextureTargets_function_type(&OpenGLRendererBase_wrapper::default_destroyAllTextureTargets) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyAllTextures
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyAllTextures_function_type )(  ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyAllTextures_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyAllTextures"
                , destroyAllTextures_function_type(&::CEGUI::OpenGLRendererBase::destroyAllTextures)
                , default_destroyAllTextures_function_type(&OpenGLRendererBase_wrapper::default_destroyAllTextures) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyGeometryBuffer
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyGeometryBuffer"
                , destroyGeometryBuffer_function_type(&::CEGUI::OpenGLRendererBase::destroyGeometryBuffer)
                , default_destroyGeometryBuffer_function_type(&OpenGLRendererBase_wrapper::default_destroyGeometryBuffer)
                , ( bp::arg("buffer") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyTexture_function_type )( ::CEGUI::Texture & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGLRendererBase_wrapper::default_destroyTexture)
                , ( bp::arg("texture") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTexture
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTexture_function_type )( ::CEGUI::String const & ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyTexture_function_type )( ::CEGUI::String const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyTexture"
                , destroyTexture_function_type(&::CEGUI::OpenGLRendererBase::destroyTexture)
                , default_destroyTexture_function_type(&OpenGLRendererBase_wrapper::default_destroyTexture)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::destroyTextureTarget
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_destroyTextureTarget_function_type )( ::CEGUI::TextureTarget * ) ;
            
            OpenGLRendererBase_exposer.def( 
                "destroyTextureTarget"
                , destroyTextureTarget_function_type(&::CEGUI::OpenGLRendererBase::destroyTextureTarget)
                , default_destroyTextureTarget_function_type(&OpenGLRendererBase_wrapper::default_destroyTextureTarget)
                , ( bp::arg("target") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::enableExtraStateSettings
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*enableExtraStateSettings_function_type )( bool ) ;
            
            OpenGLRendererBase_exposer.def( 
                "enableExtraStateSettings"
                , enableExtraStateSettings_function_type( &::CEGUI::OpenGLRendererBase::enableExtraStateSettings )
                , ( bp::arg("setting") )
                , "*!\n\
                \n\
                    Tells the renderer to initialise some extra states beyond what it\n\
                    directly needs itself for CEGUI.\n\
            \n\
                    This option is useful in cases where you've made changes to the default\n\
                    OpenGL state and do not want to saverestore those between CEGUI\n\
                    rendering calls.  Note that this option will not deal with every\n\
                    possible state or extension - if you want a state added here, make a\n\
                    request and we'll consider it ;)\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::getActiveRenderTarget
        
            typedef ::CEGUI::RenderTarget * ( ::CEGUI::OpenGLRendererBase::*getActiveRenderTarget_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "getActiveRenderTarget"
                , getActiveRenderTarget_function_type( &::CEGUI::OpenGLRendererBase::getActiveRenderTarget )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                \n\
                    Helper to get the active render target.\n\
            \n\
                @return\n\
                    The active RenderTarget.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::getActiveViewPort
        
            typedef ::CEGUI::Rectf const & ( ::CEGUI::OpenGLRendererBase::*getActiveViewPort_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "getActiveViewPort"
                , getActiveViewPort_function_type( &::CEGUI::OpenGLRendererBase::getActiveViewPort )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                \n\
                    Helper to get the viewport.\n\
            \n\
                @return\n\
                    The viewport.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::getAdjustedTextureSize
        
            typedef ::CEGUI::Sizef ( ::CEGUI::OpenGLRendererBase::*getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            typedef ::CEGUI::Sizef ( OpenGLRendererBase_wrapper::*default_getAdjustedTextureSize_function_type )( ::CEGUI::Sizef const & ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getAdjustedTextureSize"
                , getAdjustedTextureSize_function_type(&::CEGUI::OpenGLRendererBase::getAdjustedTextureSize)
                , default_getAdjustedTextureSize_function_type(&OpenGLRendererBase_wrapper::default_getAdjustedTextureSize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDefaultRenderTarget
        
            typedef ::CEGUI::RenderTarget & ( ::CEGUI::OpenGLRendererBase::*getDefaultRenderTarget_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "getDefaultRenderTarget"
                , getDefaultRenderTarget_function_type(&::CEGUI::OpenGLRendererBase::getDefaultRenderTarget)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplayDPI
        
            typedef ::CEGUI::Vector2f const & ( ::CEGUI::OpenGLRendererBase::*getDisplayDPI_function_type )(  ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getDisplayDPI"
                , getDisplayDPI_function_type(&::CEGUI::OpenGLRendererBase::getDisplayDPI)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getDisplaySize
        
            typedef ::CEGUI::Sizef const & ( ::CEGUI::OpenGLRendererBase::*getDisplaySize_function_type )(  ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getDisplaySize"
                , getDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::getDisplaySize)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getIdentifierString
        
            typedef ::CEGUI::String const & ( ::CEGUI::OpenGLRendererBase::*getIdentifierString_function_type )(  ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getIdentifierString"
                , getIdentifierString_function_type(&::CEGUI::OpenGLRendererBase::getIdentifierString)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::getMaxTextureSize
        
            typedef ::CEGUI::uint ( ::CEGUI::OpenGLRendererBase::*getMaxTextureSize_function_type )(  ) const;
            typedef ::CEGUI::uint ( OpenGLRendererBase_wrapper::*default_getMaxTextureSize_function_type )(  ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getMaxTextureSize"
                , getMaxTextureSize_function_type(&::CEGUI::OpenGLRendererBase::getMaxTextureSize)
                , default_getMaxTextureSize_function_type(&OpenGLRendererBase_wrapper::default_getMaxTextureSize) );
        
        }
        { //::CEGUI::OpenGLRendererBase::getNextPOTSize
        
            typedef float ( *getNextPOTSize_function_type )( float const );
            
            OpenGLRendererBase_exposer.def( 
                "getNextPOTSize"
                , getNextPOTSize_function_type( &::CEGUI::OpenGLRendererBase::getNextPOTSize )
                , ( bp::arg("f") )
                , "*!\n\
            \n\
                Utility function that will return  f if it's a power of two, or the\n\
                next power of two up from  f if it's not.\n\
            *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::getTexture
        
            typedef ::CEGUI::Texture & ( ::CEGUI::OpenGLRendererBase::*getTexture_function_type )( ::CEGUI::String const & ) const;
            
            OpenGLRendererBase_exposer.def( 
                "getTexture"
                , getTexture_function_type(&::CEGUI::OpenGLRendererBase::getTexture)
                , ( bp::arg("name") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::CEGUI::OpenGLRendererBase::grabTextures
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*grabTextures_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "grabTextures"
                , grabTextures_function_type( &::CEGUI::OpenGLRendererBase::grabTextures )
                , "*!\n\
            \n\
                Grabs all the loaded textures from Texture RAM and stores them in a\n\
                local data buffer.  This function invalidates all textures, and\n\
                restoreTextures must be called before any CEGUI rendering is done for\n\
                predictable results.\n\
            *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseDisplaySizeWithViewportSize
        
            typedef void ( OpenGLRendererBase_wrapper::*initialiseDisplaySizeWithViewportSize_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "initialiseDisplaySizeWithViewportSize"
                , initialiseDisplaySizeWithViewportSize_function_type( &OpenGLRendererBase_wrapper::initialiseDisplaySizeWithViewportSize )
                , "! helper to set display size with current viewport size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::initialiseMaxTextureSize
        
            typedef void ( OpenGLRendererBase_wrapper::*initialiseMaxTextureSize_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "initialiseMaxTextureSize"
                , initialiseMaxTextureSize_function_type( &OpenGLRendererBase_wrapper::initialiseMaxTextureSize )
                , "! helper to set (rough) max texture size.\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::isS3TCSupported
        
            typedef bool ( ::CEGUI::OpenGLRendererBase::*isS3TCSupported_function_type )(  ) const;
            
            OpenGLRendererBase_exposer.def( 
                "isS3TCSupported"
                , bp::pure_virtual( isS3TCSupported_function_type(&::CEGUI::OpenGLRendererBase::isS3TCSupported) )
                , "! Return whether EXT_texture_compression_s3tc is supported\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::isTextureDefined
        
            typedef bool ( ::CEGUI::OpenGLRendererBase::*isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            typedef bool ( OpenGLRendererBase_wrapper::*default_isTextureDefined_function_type )( ::CEGUI::String const & ) const;
            
            OpenGLRendererBase_exposer.def( 
                "isTextureDefined"
                , isTextureDefined_function_type(&::CEGUI::OpenGLRendererBase::isTextureDefined)
                , default_isTextureDefined_function_type(&OpenGLRendererBase_wrapper::default_isTextureDefined)
                , ( bp::arg("name") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureCreation
        
            typedef void ( *logTextureCreation_function_type )( ::CEGUI::String const & );
            
            OpenGLRendererBase_exposer.def( 
                "logTextureCreation"
                , logTextureCreation_function_type( &OpenGLRendererBase_wrapper::logTextureCreation )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::logTextureDestruction
        
            typedef void ( *logTextureDestruction_function_type )( ::CEGUI::String const & );
            
            OpenGLRendererBase_exposer.def( 
                "logTextureDestruction"
                , logTextureDestruction_function_type( &OpenGLRendererBase_wrapper::logTextureDestruction )
                , ( bp::arg("name") )
                , "! helper to safely log the creation of a named texture\n\
            ! helper to safely log the destruction of a named texture\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::restoreTextures
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*restoreTextures_function_type )(  ) ;
            
            OpenGLRendererBase_exposer.def( 
                "restoreTextures"
                , restoreTextures_function_type( &::CEGUI::OpenGLRendererBase::restoreTextures )
                , "*!\n\
            \n\
                Restores all the loaded textures from the local data buffers previously\n\
                created by 'grabTextures'\n\
            *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::setActiveRenderTarget
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*setActiveRenderTarget_function_type )( ::CEGUI::RenderTarget * ) ;
            
            OpenGLRendererBase_exposer.def( 
                "setActiveRenderTarget"
                , setActiveRenderTarget_function_type( &::CEGUI::OpenGLRendererBase::setActiveRenderTarget )
                , ( bp::arg("renderTarget") )
                , "*!\n\
                \n\
                    Helper to set the active render target.\n\
            \n\
                @param renderTarget\n\
                    The active RenderTarget.\n\
                *\n" );
        
        }
        { //::CEGUI::OpenGLRendererBase::setDisplaySize
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            typedef void ( OpenGLRendererBase_wrapper::*default_setDisplaySize_function_type )( ::CEGUI::Sizef const & ) ;
            
            OpenGLRendererBase_exposer.def( 
                "setDisplaySize"
                , setDisplaySize_function_type(&::CEGUI::OpenGLRendererBase::setDisplaySize)
                , default_setDisplaySize_function_type(&OpenGLRendererBase_wrapper::default_setDisplaySize)
                , ( bp::arg("sz") ) );
        
        }
        { //::CEGUI::OpenGLRendererBase::setupRenderingBlendMode
        
            typedef void ( ::CEGUI::OpenGLRendererBase::*setupRenderingBlendMode_function_type )( ::CEGUI::BlendMode const,bool const ) ;
            
            OpenGLRendererBase_exposer.def( 
                "setupRenderingBlendMode"
                , bp::pure_virtual( setupRenderingBlendMode_function_type(&::CEGUI::OpenGLRendererBase::setupRenderingBlendMode) )
                , ( bp::arg("mode"), bp::arg("force")=(bool const)(false) )
                , "! set the render states for the specified BlendMode.\n" );
        
        }
        OpenGLRendererBase_exposer.staticmethod( "getNextPOTSize" );
        OpenGLRendererBase_exposer.staticmethod( "logTextureCreation" );
        OpenGLRendererBase_exposer.staticmethod( "logTextureDestruction" );
    }

}
