use strict;
use warnings;
use Module::Build;
use version; our $VERSION = qv('3.4.0.3');

my $builder = Module::Build->new(
    module_name   => 'CipUX::Passwd',
    license       => 'gpl2',
    dist_author   => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version  => "$VERSION",
    dist_abstract => 'RPC client to set once own password',

    #    create_makefile_pl => 'traditional',
    #    create_readme      => 1,
    verbose     => 1,
    installdirs => 'vendor',

    meta_merge => { resources => { homepage => q(http://www.cipux.org), }, },

    recommends => {
        'File::Spec'          => 0,
        'Test::More'          => 0,
        'Test::Perl::Critic'  => 0,
        'Test::Pod'           => '1.14',
        'Test::Pod::Coverage' => '1.04',
    },

    build_requires => {},

    requires => {
        'CipUX'              => '3.4.0.0',
        'CipUX::RPC::Client' => '3.4.0.0',
        'Class::Std'         => '0.0.9',
        'English'            => 0,
        'Readonly'           => 0,
        'version'            => 0,
    },
    mkd_files => { 'doc/usage.mkd' => 'mydoc/usage.mkd', },
    install_path => { 'mydoc' => '/usr/share/doc/cipux-passwd' },
    add_to_cleanup => ['CipUX-Passwd-*'],
);

# BUILD target
#$builder->do_create_readme();
#$builder->do_create_makefile_pl();
$builder->add_build_element('mkd');
$builder->create_build_script();

