#include "memory"

void *Memory::malloc(size_t sz, string const &desc) {
    void *ptr = ::malloc(sz);
    MemoryEntry ent = { ptr, sz, desc };
    Mutex::lock(&s_memlog);
    s_memlog.push_back(ent);
    Mutex::unlock(&s_memlog);
    if (s_follow) {
	Mutex::lock(&cout);
	cout << "Memory::malloc(" << sz << ") -> " << ptr << ' '
	     << desc << '\n';
	Mutex::unlock(&cout);
    }
    return ptr;
}
