
/* color.c */

#include "color.h"
#include "argp.h"
#include "gen.h"

#define SIZE WIDTH_DATA+2+2*N_ESC+2*N_ESC0

/* Color in two colors a copy of a given string.  Return a pointer to
 * the copy.  */
char *color2(
  char       *      s,
  const char *const p,
  const char *      cs,
  const char *      cp
) {
  static char buf[SIZE];
  char *d = buf;
  char *cx;
  if ( !opt.color ) return s;
  while ( *cs && d < &buf[SIZE]          ) *d++ = *cs++;
  while ( *s  && d < &buf[SIZE] && s < p ) *d++ = * s++;
  cx = C_NONE;
  while ( *cx && d < &buf[SIZE]          ) *d++ = *cx++;
  while ( *cp && d < &buf[SIZE]          ) *d++ = *cp++;
  while ( *s  && d < &buf[SIZE]          ) *d++ = * s++;
  cx = C_NONE;
  while ( *cx && d < &buf[SIZE]          ) *d++ = *cx++;
  *d = '\0';
  return buf;
}

