-- $Id$ 

-- testing function calls

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


ENTITY dummy is
	FUNCTION foo(bofu : integer; tofu : integer) return integer is
	begin
		return bofu + tofu;
	end foo;
end ENTITY dummy;

ARCHITECTURE impl of dummy is
	constant failure : integer := 8;
begin
	p1 : PROCESS
		variable result : integer;	
	begin
		result := foo(3, 5);
		assert result = 8 report "3+5 != 8?" severity failure;
		wait;
	end PROCESS;

	p2 : PROCESS
		variable a, b : integer;
		variable result : integer;	
	begin
		a := 3;
		b := 5;
		result := foo(a, b);
		assert result = 8 report "3+5 != 8?" severity failure;
		wait;
	end PROCESS;

	p3 : PROCESS
		variable a, b: integer;
		variable result : integer;	
	begin
		a := 3;
		b := 5;
		result := foo(bofu => a, tofu => b);
		assert result = 8 report "3+5 != 8?" severity failure;
		wait;
	end PROCESS;

	p4 : PROCESS
		variable a, b: integer;
		variable result : integer;	
	begin
		a := 3;
		b := 5;
		result := foo(tofu => b, bofu => a); 
		-- this one should fail.
		--result := foo(kamefu => a, tofu => b);
		assert result = 8 report "3+5 != 8?" severity failure;
		wait;
	end PROCESS;

end ARCHITECTURE impl;
