# Security Policy

The FreeCAD project is a FOSS (Free and Open-Source Software) project that has a community of thousands of users and 
hundreds of developers worldwide. We encourage responsible reporting of security vulnerabilities that may affect users
of this software, and will endeavor to address these vulnerabilities when they are discovered.

## Bounties

FreeCAD does not have a program to pay bounties for security bugs. If you discover a vulnerability that affects a part 
of the FreeCAD project (either directly in FreeCAD, in a library it depends on, or in any of the various other 
subprojects such as our website, forums, etc.) we ask you to join the large community of volunteer contributors and
file a report about the issue.

Note that funds may be available from the [FreeCAD Project Association (FPA)](https://fpa.freecad.org) to pursue 
security research and/or the development of fixes to any vulnerabilities discovered. However, vulnerabilities held as 
hostage in demands for "bounties" will not be entertained. Contact the FPA at fpa@freecad.org for more information.

## Supported Versions

FreeCAD implements security fixes to the current release series, and to the current development on the master branch.

| Version | Supported          |
|---------| ------------------ |
| 0.21    | :white_check_mark: |
| 0.20.2  | :white_check_mark: |
| < 0.20  | :x:                |

## Reporting a Vulnerability

To report a vulnerability use GitHub's security reporting tool:
https://github.com/FreeCAD/FreeCAD/security/advisories/new

