// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an app block builder. If the app block builder is in the STARTING or
// STOPPING state, you can't update it. If the app block builder is in the RUNNING
// state, you can only update the DisplayName and Description. If the app block
// builder is in the STOPPED state, you can update any attribute except the Name.
func (c *Client) UpdateAppBlockBuilder(ctx context.Context, params *UpdateAppBlockBuilderInput, optFns ...func(*Options)) (*UpdateAppBlockBuilderOutput, error) {
	if params == nil {
		params = &UpdateAppBlockBuilderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAppBlockBuilder", params, optFns, c.addOperationUpdateAppBlockBuilderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAppBlockBuilderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAppBlockBuilderInput struct {

	// The unique name for the app block builder.
	//
	// This member is required.
	Name *string

	// The list of interface VPC endpoint (interface endpoint) objects. Administrators
	// can connect to the app block builder only through the specified endpoints.
	AccessEndpoints []types.AccessEndpoint

	// The attributes to delete from the app block builder.
	AttributesToDelete []types.AppBlockBuilderAttribute

	// The description of the app block builder.
	Description *string

	// The display name of the app block builder.
	DisplayName *string

	// Enables or disables default internet access for the app block builder.
	EnableDefaultInternetAccess *bool

	// The Amazon Resource Name (ARN) of the IAM role to apply to the app block
	// builder. To assume a role, the app block builder calls the AWS Security Token
	// Service (STS) AssumeRole API operation and passes the ARN of the role to use.
	// The operation creates a new session with temporary credentials. AppStream 2.0
	// retrieves the temporary credentials and creates the appstream_machine_role
	// credential profile on the instance. For more information, see Using an IAM Role
	// to Grant Permissions to Applications and Scripts Running on AppStream 2.0
	// Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string

	// The instance type to use when launching the app block builder. The following
	// instance types are available:
	//   - stream.standard.small
	//   - stream.standard.medium
	//   - stream.standard.large
	//   - stream.standard.xlarge
	//   - stream.standard.2xlarge
	InstanceType *string

	// The platform of the app block builder. WINDOWS_SERVER_2019 is the only valid
	// value.
	Platform types.PlatformType

	// The VPC configuration for the app block builder. App block builders require
	// that you specify at least two subnets in different availability zones.
	VpcConfig *types.VpcConfig

	noSmithyDocumentSerde
}

type UpdateAppBlockBuilderOutput struct {

	// Describes an app block builder.
	AppBlockBuilder *types.AppBlockBuilder

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAppBlockBuilderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateAppBlockBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateAppBlockBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAppBlockBuilder"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAppBlockBuilderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAppBlockBuilder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAppBlockBuilder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAppBlockBuilder",
	}
}
