// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Saves a copy of a database migration assessment report to your Amazon S3
// bucket. DMS can save your assessment report as a comma-separated value (CSV) or
// a PDF file.
func (c *Client) ExportMetadataModelAssessment(ctx context.Context, params *ExportMetadataModelAssessmentInput, optFns ...func(*Options)) (*ExportMetadataModelAssessmentOutput, error) {
	if params == nil {
		params = &ExportMetadataModelAssessmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ExportMetadataModelAssessment", params, optFns, c.addOperationExportMetadataModelAssessmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ExportMetadataModelAssessmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ExportMetadataModelAssessmentInput struct {

	// The migration project name or Amazon Resource Name (ARN).
	//
	// This member is required.
	MigrationProjectIdentifier *string

	// A value that specifies the database objects to assess.
	//
	// This member is required.
	SelectionRules *string

	// The file format of the assessment file.
	AssessmentReportTypes []types.AssessmentReportType

	// The name of the assessment file to create in your Amazon S3 bucket.
	FileName *string

	noSmithyDocumentSerde
}

type ExportMetadataModelAssessmentOutput struct {

	// The Amazon S3 details for an assessment exported in CSV format.
	CsvReport *types.ExportMetadataModelAssessmentResultEntry

	// The Amazon S3 details for an assessment exported in PDF format.
	PdfReport *types.ExportMetadataModelAssessmentResultEntry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationExportMetadataModelAssessmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpExportMetadataModelAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpExportMetadataModelAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ExportMetadataModelAssessment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpExportMetadataModelAssessmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opExportMetadataModelAssessment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opExportMetadataModelAssessment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ExportMetadataModelAssessment",
	}
}
