// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides details about how an DataSync transfer location for an Amazon FSx for
// NetApp ONTAP file system is configured. If your location uses SMB, the
// DescribeLocationFsxOntap operation doesn't actually return a Password .
func (c *Client) DescribeLocationFsxOntap(ctx context.Context, params *DescribeLocationFsxOntapInput, optFns ...func(*Options)) (*DescribeLocationFsxOntapOutput, error) {
	if params == nil {
		params = &DescribeLocationFsxOntapInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeLocationFsxOntap", params, optFns, c.addOperationDescribeLocationFsxOntapMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeLocationFsxOntapOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeLocationFsxOntapInput struct {

	// Specifies the Amazon Resource Name (ARN) of the FSx for ONTAP file system
	// location that you want information about.
	//
	// This member is required.
	LocationArn *string

	noSmithyDocumentSerde
}

type DescribeLocationFsxOntapOutput struct {

	// The time that the location was created.
	CreationTime *time.Time

	// The ARN of the FSx for ONTAP file system.
	FsxFilesystemArn *string

	// The ARN of the FSx for ONTAP file system location.
	LocationArn *string

	// The uniform resource identifier (URI) of the FSx for ONTAP file system location.
	LocationUri *string

	// Specifies the data transfer protocol that DataSync uses to access your Amazon
	// FSx file system.
	Protocol *types.FsxProtocol

	// The security groups that DataSync uses to access your FSx for ONTAP file system.
	SecurityGroupArns []string

	// The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system
	// where you're copying data to or from.
	StorageVirtualMachineArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeLocationFsxOntapMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeLocationFsxOntap{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeLocationFsxOntap"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeLocationFsxOntapValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeLocationFsxOntap(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeLocationFsxOntap(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeLocationFsxOntap",
	}
}
