// Code generated by smithy-go-codegen DO NOT EDIT.

package healthlake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/healthlake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Begins a FHIR export job.
func (c *Client) StartFHIRExportJob(ctx context.Context, params *StartFHIRExportJobInput, optFns ...func(*Options)) (*StartFHIRExportJobOutput, error) {
	if params == nil {
		params = &StartFHIRExportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartFHIRExportJob", params, optFns, c.addOperationStartFHIRExportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartFHIRExportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartFHIRExportJobInput struct {

	// An optional user provided token used for ensuring idempotency.
	//
	// This member is required.
	ClientToken *string

	// The Amazon Resource Name used during the initiation of the job.
	//
	// This member is required.
	DataAccessRoleArn *string

	// The AWS generated ID for the data store from which files are being exported for
	// an export job.
	//
	// This member is required.
	DatastoreId *string

	// The output data configuration that was supplied when the export job was created.
	//
	// This member is required.
	OutputDataConfig types.OutputDataConfig

	// The user generated name for an export job.
	JobName *string

	noSmithyDocumentSerde
}

type StartFHIRExportJobOutput struct {

	// The AWS generated ID for an export job.
	//
	// This member is required.
	JobId *string

	// The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS,
	// COMPLETED, or FAILED.
	//
	// This member is required.
	JobStatus types.JobStatus

	// The AWS generated ID for the data store from which files are being exported for
	// an export job.
	DatastoreId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartFHIRExportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartFHIRExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartFHIRExportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartFHIRExportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartFHIRExportJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartFHIRExportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartFHIRExportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartFHIRExportJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartFHIRExportJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartFHIRExportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartFHIRExportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartFHIRExportJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartFHIRExportJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartFHIRExportJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartFHIRExportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartFHIRExportJob",
	}
}
