// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a vehicle.
func (c *Client) UpdateVehicle(ctx context.Context, params *UpdateVehicleInput, optFns ...func(*Options)) (*UpdateVehicleOutput, error) {
	if params == nil {
		params = &UpdateVehicleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateVehicle", params, optFns, c.addOperationUpdateVehicleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateVehicleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateVehicleInput struct {

	// The unique ID of the vehicle to update.
	//
	// This member is required.
	VehicleName *string

	// The method the specified attributes will update the existing attributes on the
	// vehicle. Use Overwite to replace the vehicle attributes with the specified
	// attributes. Or use Merge to combine all attributes. This is required if
	// attributes are present in the input.
	AttributeUpdateMode types.UpdateMode

	// Static information about a vehicle in a key-value pair. For example:
	// "engineType" : "1.3 L R2"
	Attributes map[string]string

	// The ARN of the decoder manifest associated with this vehicle.
	DecoderManifestArn *string

	// The ARN of a vehicle model (model manifest) associated with the vehicle.
	ModelManifestArn *string

	noSmithyDocumentSerde
}

type UpdateVehicleOutput struct {

	// The ARN of the updated vehicle.
	Arn *string

	// The ID of the updated vehicle.
	VehicleName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateVehicleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateVehicle{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateVehicle{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateVehicle"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateVehicleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateVehicle(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateVehicle(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateVehicle",
	}
}
