// Code generated by fieldpath-gen.
// source: github.com/gogo/protobuf/fieldpath/fieldpath-gen/template.go
// DO NOT EDIT!

package fieldpath_test

import (
	"bytes"
	"fmt"
	"github.com/gogo/protobuf/fieldpath"
	"github.com/gogo/protobuf/proto"
	"github.com/gogo/protobuf/test"
	math_rand "math/rand"
	"reflect"
	"sort"
	"testing"
	"time"
)

var _ = bytes.MinRead
var pseudo int64 = time.Now().UnixNano()

type FuncHandler struct {
	Float64Func
	Float32Func
	Int64Func
	Int32Func
	Uint64Func
	Uint32Func
	BoolFunc
	BytesFunc
	StringFunc
}

type Float64Func func(float64)
type Float32Func func(float32)
type Int64Func func(int64)
type Int32Func func(int32)
type Uint64Func func(uint64)
type Uint32Func func(uint32)
type BoolFunc func(bool)
type BytesFunc func([]byte)
type StringFunc func(string)

func (this Float64Func) Float64(v float64) { this(v) }
func (this Float32Func) Float32(v float32) { this(v) }
func (this Int64Func) Int64(v int64)       { this(v) }
func (this Int32Func) Int32(v int32)       { this(v) }
func (this Uint64Func) Uint64(v uint64)    { this(v) }
func (this Uint32Func) Uint32(v uint32)    { this(v) }
func (this BoolFunc) Bool(v bool)          { this(v) }
func (this BytesFunc) Bytes(v []byte)      { this(v) }
func (this StringFunc) String(v string)    { this(v) }

type sortable struct {
	list [][]byte
}

func (this *sortable) Len() int {
	return len(this.list)
}

func (this *sortable) Swap(i, j int) {
	this.list[i], this.list[j] = this.list[j], this.list[i]
}

func (this *sortable) Get(index int) []byte {
	return this.list[index]
}

func TestUnmarshalFirstNinOptNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestUnmarshalNinOptNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestCompiledNinOptNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64Path("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1 %v", unmarshalled[0], *p.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeFloat64 []*test.NinOptNative

func (s sorterNinOptNativeFloat64) Less(i, j int) bool {

	var vi *float64
	var vj *float64
	if s[i].Field1 != nil {

		vi = s[i].Field1

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field1").GetDefaultFloat64()
	}
	if s[j].Field1 != nil {

		vj = s[j].Field1

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field1").GetDefaultFloat64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeFloat64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeFloat64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeFloat64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeFloat64(b *testing.B) {
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeFloat64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeFloat64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFloat64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field1)
	}

}

func TestUnmarshalNinOptStructFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field1)
	}

}

func TestCompiledNinOptStructFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field1 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field1) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field1 %v", unmarshalled[0], *p.Field4.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1").GetDefaultFloat64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructFloat64 []*test.NinOptStruct

func (s sorterNinOptStructFloat64) Less(i, j int) bool {

	var vi *float64
	var vj *float64
	if s[i].Field4 != nil && s[i].Field4.Field1 != nil {

		vi = s[i].Field4.Field1

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1").GetDefaultFloat64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field1 != nil {

		vj = s[j].Field4.Field1

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1").GetDefaultFloat64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructFloat64) Len() int {
	return len(this)
}

func (this sorterNinOptStructFloat64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructFloat64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructFloat64(b *testing.B) {
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructFloat64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructFloat64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFloat64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field1")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedFloat64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field1) {
		if len(unmarshalled) == 0 && len(p.Field1) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field1 %#v", unmarshalled, p.Field1))
	}

}

func TestCompiledNinRepNativeFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64Path("test", "NinRepNative", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field1) {
		if len(unmarshalled) == 0 && len(p.Field1) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field1 %#v", unmarshalled, p.Field1))
	}

}

func TestCompiledNinNestedStructFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field1 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field1) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field1 %v", unmarshalled[0], *p.Field1.Field4.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field1").GetDefaultFloat64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestUnmarshalNinOptNativeDefaultFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field1 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestCompiledNinOptNativeDefaultFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []float64
	f := FuncHandler{
		Float64Func: func(v float64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1 %v", unmarshalled[0], *p.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1").GetDefaultFloat64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultFloat64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultFloat64) Less(i, j int) bool {

	var vi *float64
	var vj *float64
	if s[i].Field1 != nil {

		vi = s[i].Field1

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1").GetDefaultFloat64()
	}
	if s[j].Field1 != nil {

		vj = s[j].Field1

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1").GetDefaultFloat64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultFloat64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultFloat64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultFloat64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultFloat64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultFloat64(b *testing.B) {
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultFloat64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFloat64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultFloat64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFloat64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultFloat64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field2)
	}

}

func TestUnmarshalNinOptNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field2)
	}

}

func TestCompiledNinOptNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32Path("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field2 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field2) {

			panic(fmt.Errorf("unmarshalled %v != p.Field2 %v", unmarshalled[0], *p.Field2))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeFloat32 []*test.NinOptNative

func (s sorterNinOptNativeFloat32) Less(i, j int) bool {

	var vi *float32
	var vj *float32
	if s[i].Field2 != nil {

		vi = s[i].Field2

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field2").GetDefaultFloat32()
	}
	if s[j].Field2 != nil {

		vj = s[j].Field2

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field2").GetDefaultFloat32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeFloat32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeFloat32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeFloat32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeFloat32(b *testing.B) {
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeFloat32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeFloat32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFloat32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field2)
	}

}

func TestUnmarshalNinOptStructFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field2)
	}

}

func TestCompiledNinOptStructFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field2 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field2) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field2 %v", unmarshalled[0], *p.Field4.Field2))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2").GetDefaultFloat32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructFloat32 []*test.NinOptStruct

func (s sorterNinOptStructFloat32) Less(i, j int) bool {

	var vi *float32
	var vj *float32
	if s[i].Field4 != nil && s[i].Field4.Field2 != nil {

		vi = s[i].Field4.Field2

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2").GetDefaultFloat32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field2 != nil {

		vj = s[j].Field4.Field2

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2").GetDefaultFloat32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructFloat32) Len() int {
	return len(this)
}

func (this sorterNinOptStructFloat32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructFloat32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructFloat32(b *testing.B) {
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructFloat32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructFloat32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFloat32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field2")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedFloat32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field2) {
		if len(unmarshalled) == 0 && len(p.Field2) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field2 %#v", unmarshalled, p.Field2))
	}

}

func TestCompiledNinRepNativeFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32Path("test", "NinRepNative", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field2) {
		if len(unmarshalled) == 0 && len(p.Field2) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field2 %#v", unmarshalled, p.Field2))
	}

}

func TestCompiledNinNestedStructFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field2 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field2) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field2 %v", unmarshalled[0], *p.Field1.Field4.Field2))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field2").GetDefaultFloat32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field2)
	}

}

func TestUnmarshalNinOptNativeDefaultFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field2 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field2 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field2)
	}

}

func TestCompiledNinOptNativeDefaultFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFloat32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []float32
	f := FuncHandler{
		Float32Func: func(v float32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFloat32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field2 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field2) {

			panic(fmt.Errorf("unmarshalled %v != p.Field2 %v", unmarshalled[0], *p.Field2))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2").GetDefaultFloat32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultFloat32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultFloat32) Less(i, j int) bool {

	var vi *float32
	var vj *float32
	if s[i].Field2 != nil {

		vi = s[i].Field2

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2").GetDefaultFloat32()
	}
	if s[j].Field2 != nil {

		vj = s[j].Field2

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2").GetDefaultFloat32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultFloat32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultFloat32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultFloat32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultFloat32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFloat32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultFloat32(b *testing.B) {
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFloat32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultFloat32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFloat32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultFloat32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFloat32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultFloat32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFloat32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field2")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field3)
	}

}

func TestUnmarshalNinOptNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field3)
	}

}

func TestCompiledNinOptNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field3 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field3) {

			panic(fmt.Errorf("unmarshalled %v != p.Field3 %v", unmarshalled[0], *p.Field3))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field3").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeInt32 []*test.NinOptNative

func (s sorterNinOptNativeInt32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field3 != nil {

		vi = s[i].Field3

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field3").GetDefaultInt32()
	}
	if s[j].Field3 != nil {

		vj = s[j].Field3

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field3").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeInt32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeInt32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeInt32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeInt32(b *testing.B) {
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeInt32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeInt32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeInt32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field3)
	}

}

func TestUnmarshalNinOptStructInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field3)
	}

}

func TestCompiledNinOptStructInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field3 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field3) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field3 %v", unmarshalled[0], *p.Field4.Field3))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructInt32 []*test.NinOptStruct

func (s sorterNinOptStructInt32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field4 != nil && s[i].Field4.Field3 != nil {

		vi = s[i].Field4.Field3

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3").GetDefaultInt32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field3 != nil {

		vj = s[j].Field4.Field3

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructInt32) Len() int {
	return len(this)
}

func (this sorterNinOptStructInt32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructInt32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructInt32(b *testing.B) {
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructInt32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructInt32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructInt32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field3")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedInt32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field3) {
		if len(unmarshalled) == 0 && len(p.Field3) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field3 %#v", unmarshalled, p.Field3))
	}

}

func TestCompiledNinRepNativeInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinRepNative", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field3) {
		if len(unmarshalled) == 0 && len(p.Field3) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field3 %#v", unmarshalled, p.Field3))
	}

}

func TestCompiledNinNestedStructInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field3 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field3) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field3 %v", unmarshalled[0], *p.Field1.Field4.Field3))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field3").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field3)
	}

}

func TestUnmarshalNinOptNativeDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field3 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field3 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field3)
	}

}

func TestCompiledNinOptNativeDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field3 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field3) {

			panic(fmt.Errorf("unmarshalled %v != p.Field3 %v", unmarshalled[0], *p.Field3))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultInt32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultInt32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field3 != nil {

		vi = s[i].Field3

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3").GetDefaultInt32()
	}
	if s[j].Field3 != nil {

		vj = s[j].Field3

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultInt32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultInt32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultInt32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultInt32(b *testing.B) {
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultInt32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultInt32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultInt32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field3")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptEnumDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptEnumDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if int32(*unmarshalled) != int32(*p.Field1) {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestUnmarshalNinOptEnumDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptEnumDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if int32(*unmarshalled) != int32(*p.Field1) {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestCompiledNinOptEnumDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptEnumDefault(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil {

		if !reflect.DeepEqual(int32(unmarshalled[0]), int32(*p.Field1)) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1 %v", unmarshalled[0], *p.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptEnumDefaultInt32 []*test.NinOptEnumDefault

func (s sorterNinOptEnumDefaultInt32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field1 != nil {

		v1 := int32(*s[i].Field1)
		vi = &v1

	} else {
		vi = fieldpath.TestDefault("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1").GetDefaultInt32()
	}
	if s[j].Field1 != nil {

		v2 := int32(*s[j].Field1)
		vj = &v2

	} else {
		vj = fieldpath.TestDefault("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptEnumDefaultInt32) Len() int {
	return len(this)
}

func (this sorterNinOptEnumDefaultInt32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptEnumDefaultInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptEnumDefaultInt32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptEnumDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptEnumDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptEnumDefaultInt32(b *testing.B) {
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptEnumDefaultInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptEnumDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptEnumDefaultInt32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptEnumDefaultInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptEnumDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptEnumDefaultInt32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptEnumDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptEnumDefaultInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptEnumDefaultInt32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptEnumDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptEnumDefaultInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt32SinglePath("test", "NinOptEnumDefault", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptEnumDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstAnotherNinOptEnumInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedAnotherNinOptEnum(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if int32(*unmarshalled) != int32(*p.Field1) {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestUnmarshalAnotherNinOptEnumInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32SinglePath("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedAnotherNinOptEnum(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field1 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if int32(*unmarshalled) != int32(*p.Field1) {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field1)
	}

}

func TestCompiledAnotherNinOptEnumInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt32Path("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedAnotherNinOptEnum(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil {

		if !reflect.DeepEqual(int32(unmarshalled[0]), int32(*p.Field1)) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1 %v", unmarshalled[0], *p.Field1))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterAnotherNinOptEnumInt32 []*test.AnotherNinOptEnum

func (s sorterAnotherNinOptEnumInt32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field1 != nil {

		v1 := int32(*s[i].Field1)
		vi = &v1

	} else {
		vi = fieldpath.TestDefault("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1").GetDefaultInt32()
	}
	if s[j].Field1 != nil {

		v2 := int32(*s[j].Field1)
		vj = &v2

	} else {
		vj = fieldpath.TestDefault("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterAnotherNinOptEnumInt32) Len() int {
	return len(this)
}

func (this sorterAnotherNinOptEnumInt32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortAnotherNinOptEnumInt32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterAnotherNinOptEnumInt32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedAnotherNinOptEnum(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt32SinglePath("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.AnotherNinOptEnum{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathAnotherNinOptEnumInt32(b *testing.B) {
	fp, err := fieldpath.NewInt32SinglePath("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterAnotherNinOptEnumInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedAnotherNinOptEnum(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortAnotherNinOptEnumInt32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortAnotherNinOptEnumInt32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedAnotherNinOptEnum(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortAnotherNinOptEnumInt32, l)
		for i := 0; i < l; i++ {
			s := &test.AnotherNinOptEnum{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortAnotherNinOptEnumInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortAnotherNinOptEnumInt32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedAnotherNinOptEnum(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathAnotherNinOptEnumInt32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt32SinglePath("test", "AnotherNinOptEnum", test.ThetestDescription(), "Field1")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedAnotherNinOptEnum(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4)
	}

}

func TestUnmarshalNinOptNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4)
	}

}

func TestCompiledNinOptNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64Path("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4 %v", unmarshalled[0], *p.Field4))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field4").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeInt64 []*test.NinOptNative

func (s sorterNinOptNativeInt64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field4 != nil {

		vi = s[i].Field4

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field4").GetDefaultInt64()
	}
	if s[j].Field4 != nil {

		vj = s[j].Field4

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field4").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeInt64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeInt64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeInt64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeInt64(b *testing.B) {
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeInt64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeInt64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeInt64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field4)
	}

}

func TestUnmarshalNinOptStructInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field4)
	}

}

func TestCompiledNinOptStructInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field4 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field4) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field4 %v", unmarshalled[0], *p.Field4.Field4))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructInt64 []*test.NinOptStruct

func (s sorterNinOptStructInt64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field4 != nil && s[i].Field4.Field4 != nil {

		vi = s[i].Field4.Field4

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4").GetDefaultInt64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field4 != nil {

		vj = s[j].Field4.Field4

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructInt64) Len() int {
	return len(this)
}

func (this sorterNinOptStructInt64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructInt64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructInt64(b *testing.B) {
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructInt64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructInt64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructInt64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field4")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedInt64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field4) {
		if len(unmarshalled) == 0 && len(p.Field4) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field4 %#v", unmarshalled, p.Field4))
	}

}

func TestCompiledNinRepNativeInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64Path("test", "NinRepNative", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field4) {
		if len(unmarshalled) == 0 && len(p.Field4) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field4 %#v", unmarshalled, p.Field4))
	}

}

func TestCompiledNinNestedStructInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field4 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field4) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field4 %v", unmarshalled[0], *p.Field1.Field4.Field4))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field4").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4)
	}

}

func TestUnmarshalNinOptNativeDefaultInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4)
	}

}

func TestCompiledNinOptNativeDefaultInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewInt64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewInt64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4 %v", unmarshalled[0], *p.Field4))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultInt64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultInt64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field4 != nil {

		vi = s[i].Field4

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4").GetDefaultInt64()
	}
	if s[j].Field4 != nil {

		vj = s[j].Field4

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultInt64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultInt64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultInt64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultInt64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewInt64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultInt64(b *testing.B) {
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewInt64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultInt64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultInt64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultInt64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultInt64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultInt64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewInt64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field4")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field6)
	}

}

func TestUnmarshalNinOptNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field6)
	}

}

func TestCompiledNinOptNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64Path("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field6 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field6) {

			panic(fmt.Errorf("unmarshalled %v != p.Field6 %v", unmarshalled[0], *p.Field6))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field6").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeUint64 []*test.NinOptNative

func (s sorterNinOptNativeUint64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field6 != nil {

		vi = s[i].Field6

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field6").GetDefaultUint64()
	}
	if s[j].Field6 != nil {

		vj = s[j].Field6

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field6").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeUint64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeUint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeUint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeUint64(b *testing.B) {
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeUint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeUint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeUint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field6)
	}

}

func TestUnmarshalNinOptStructUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field6)
	}

}

func TestCompiledNinOptStructUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field6 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field6) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field6 %v", unmarshalled[0], *p.Field4.Field6))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructUint64 []*test.NinOptStruct

func (s sorterNinOptStructUint64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field4 != nil && s[i].Field4.Field6 != nil {

		vi = s[i].Field4.Field6

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6").GetDefaultUint64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field6 != nil {

		vj = s[j].Field4.Field6

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructUint64) Len() int {
	return len(this)
}

func (this sorterNinOptStructUint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructUint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructUint64(b *testing.B) {
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructUint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructUint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructUint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field6")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedUint64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field6) {
		if len(unmarshalled) == 0 && len(p.Field6) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field6 %#v", unmarshalled, p.Field6))
	}

}

func TestCompiledNinRepNativeUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64Path("test", "NinRepNative", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field6) {
		if len(unmarshalled) == 0 && len(p.Field6) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field6 %#v", unmarshalled, p.Field6))
	}

}

func TestCompiledNinNestedStructUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field6 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field6) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field6 %v", unmarshalled[0], *p.Field1.Field4.Field6))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field6").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field6)
	}

}

func TestUnmarshalNinOptNativeDefaultUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field6 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field6 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field6)
	}

}

func TestCompiledNinOptNativeDefaultUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field6 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field6) {

			panic(fmt.Errorf("unmarshalled %v != p.Field6 %v", unmarshalled[0], *p.Field6))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultUint64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultUint64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field6 != nil {

		vi = s[i].Field6

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6").GetDefaultUint64()
	}
	if s[j].Field6 != nil {

		vj = s[j].Field6

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultUint64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultUint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultUint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultUint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultUint64(b *testing.B) {
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultUint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultUint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultUint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultUint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultUint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field6")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field5)
	}

}

func TestUnmarshalNinOptNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field5)
	}

}

func TestCompiledNinOptNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32Path("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field5 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field5) {

			panic(fmt.Errorf("unmarshalled %v != p.Field5 %v", unmarshalled[0], *p.Field5))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field5").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeUint32 []*test.NinOptNative

func (s sorterNinOptNativeUint32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field5 != nil {

		vi = s[i].Field5

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field5").GetDefaultUint32()
	}
	if s[j].Field5 != nil {

		vj = s[j].Field5

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field5").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeUint32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeUint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeUint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeUint32(b *testing.B) {
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeUint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeUint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeUint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field5)
	}

}

func TestUnmarshalNinOptStructUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field5)
	}

}

func TestCompiledNinOptStructUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field5 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field5) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field5 %v", unmarshalled[0], *p.Field4.Field5))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructUint32 []*test.NinOptStruct

func (s sorterNinOptStructUint32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field4 != nil && s[i].Field4.Field5 != nil {

		vi = s[i].Field4.Field5

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5").GetDefaultUint32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field5 != nil {

		vj = s[j].Field4.Field5

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructUint32) Len() int {
	return len(this)
}

func (this sorterNinOptStructUint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructUint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructUint32(b *testing.B) {
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructUint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructUint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructUint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field5")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedUint32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field5) {
		if len(unmarshalled) == 0 && len(p.Field5) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field5 %#v", unmarshalled, p.Field5))
	}

}

func TestCompiledNinRepNativeUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32Path("test", "NinRepNative", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field5) {
		if len(unmarshalled) == 0 && len(p.Field5) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field5 %#v", unmarshalled, p.Field5))
	}

}

func TestCompiledNinNestedStructUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field5 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field5) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field5 %v", unmarshalled[0], *p.Field1.Field4.Field5))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field5").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field5)
	}

}

func TestUnmarshalNinOptNativeDefaultUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field5 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field5 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field5)
	}

}

func TestCompiledNinOptNativeDefaultUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewUint32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewUint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field5 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field5) {

			panic(fmt.Errorf("unmarshalled %v != p.Field5 %v", unmarshalled[0], *p.Field5))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultUint32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultUint32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field5 != nil {

		vi = s[i].Field5

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5").GetDefaultUint32()
	}
	if s[j].Field5 != nil {

		vj = s[j].Field5

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultUint32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultUint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultUint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultUint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewUint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultUint32(b *testing.B) {
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewUint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultUint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultUint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultUint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultUint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultUint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewUint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field5")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field7)
	}

}

func TestUnmarshalNinOptNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field7)
	}

}

func TestCompiledNinOptNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32Path("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field7 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field7) {

			panic(fmt.Errorf("unmarshalled %v != p.Field7 %v", unmarshalled[0], *p.Field7))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field7").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeSint32 []*test.NinOptNative

func (s sorterNinOptNativeSint32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field7 != nil {

		vi = s[i].Field7

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field7").GetDefaultInt32()
	}
	if s[j].Field7 != nil {

		vj = s[j].Field7

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field7").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeSint32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeSint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeSint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeSint32(b *testing.B) {
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeSint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeSint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field7)
	}

}

func TestUnmarshalNinOptStructSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field7)
	}

}

func TestCompiledNinOptStructSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field7 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field7) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field7 %v", unmarshalled[0], *p.Field4.Field7))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructSint32 []*test.NinOptStruct

func (s sorterNinOptStructSint32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field4 != nil && s[i].Field4.Field7 != nil {

		vi = s[i].Field4.Field7

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7").GetDefaultInt32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field7 != nil {

		vj = s[j].Field4.Field7

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructSint32) Len() int {
	return len(this)
}

func (this sorterNinOptStructSint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructSint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructSint32(b *testing.B) {
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructSint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructSint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field7")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedSint32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field7) {
		if len(unmarshalled) == 0 && len(p.Field7) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field7 %#v", unmarshalled, p.Field7))
	}

}

func TestCompiledNinRepNativeSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32Path("test", "NinRepNative", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field7) {
		if len(unmarshalled) == 0 && len(p.Field7) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field7 %#v", unmarshalled, p.Field7))
	}

}

func TestCompiledNinNestedStructSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field7 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field7) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field7 %v", unmarshalled[0], *p.Field1.Field4.Field7))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field7").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field7)
	}

}

func TestUnmarshalNinOptNativeDefaultSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field7 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field7 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field7)
	}

}

func TestCompiledNinOptNativeDefaultSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field7 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field7) {

			panic(fmt.Errorf("unmarshalled %v != p.Field7 %v", unmarshalled[0], *p.Field7))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultSint32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultSint32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field7 != nil {

		vi = s[i].Field7

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7").GetDefaultInt32()
	}
	if s[j].Field7 != nil {

		vj = s[j].Field7

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultSint32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultSint32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultSint32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultSint32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultSint32(b *testing.B) {
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultSint32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSint32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultSint32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSint32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultSint32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field7")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field8)
	}

}

func TestUnmarshalNinOptNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field8)
	}

}

func TestCompiledNinOptNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64Path("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field8 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field8) {

			panic(fmt.Errorf("unmarshalled %v != p.Field8 %v", unmarshalled[0], *p.Field8))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field8").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeSint64 []*test.NinOptNative

func (s sorterNinOptNativeSint64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field8 != nil {

		vi = s[i].Field8

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field8").GetDefaultInt64()
	}
	if s[j].Field8 != nil {

		vj = s[j].Field8

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field8").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeSint64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeSint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeSint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeSint64(b *testing.B) {
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeSint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeSint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field8)
	}

}

func TestUnmarshalNinOptStructSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field8)
	}

}

func TestCompiledNinOptStructSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field8 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field8) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field8 %v", unmarshalled[0], *p.Field4.Field8))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructSint64 []*test.NinOptStruct

func (s sorterNinOptStructSint64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field4 != nil && s[i].Field4.Field8 != nil {

		vi = s[i].Field4.Field8

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8").GetDefaultInt64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field8 != nil {

		vj = s[j].Field4.Field8

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructSint64) Len() int {
	return len(this)
}

func (this sorterNinOptStructSint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructSint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructSint64(b *testing.B) {
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructSint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructSint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field8")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedSint64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field8) {
		if len(unmarshalled) == 0 && len(p.Field8) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field8 %#v", unmarshalled, p.Field8))
	}

}

func TestCompiledNinRepNativeSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64Path("test", "NinRepNative", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field8) {
		if len(unmarshalled) == 0 && len(p.Field8) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field8 %#v", unmarshalled, p.Field8))
	}

}

func TestCompiledNinNestedStructSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field8 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field8) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field8 %v", unmarshalled[0], *p.Field1.Field4.Field8))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field8").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field8)
	}

}

func TestUnmarshalNinOptNativeDefaultSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field8 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field8 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field8)
	}

}

func TestCompiledNinOptNativeDefaultSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSint64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSint64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field8 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field8) {

			panic(fmt.Errorf("unmarshalled %v != p.Field8 %v", unmarshalled[0], *p.Field8))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultSint64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultSint64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field8 != nil {

		vi = s[i].Field8

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8").GetDefaultInt64()
	}
	if s[j].Field8 != nil {

		vj = s[j].Field8

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultSint64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultSint64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultSint64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultSint64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSint64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultSint64(b *testing.B) {
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSint64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultSint64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSint64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultSint64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSint64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultSint64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSint64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field8")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field9)
	}

}

func TestUnmarshalNinOptNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field9)
	}

}

func TestCompiledNinOptNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32Path("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field9 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field9) {

			panic(fmt.Errorf("unmarshalled %v != p.Field9 %v", unmarshalled[0], *p.Field9))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field9").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeFixed32 []*test.NinOptNative

func (s sorterNinOptNativeFixed32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field9 != nil {

		vi = s[i].Field9

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field9").GetDefaultUint32()
	}
	if s[j].Field9 != nil {

		vj = s[j].Field9

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field9").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeFixed32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeFixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeFixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeFixed32(b *testing.B) {
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeFixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeFixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field9)
	}

}

func TestUnmarshalNinOptStructFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field9)
	}

}

func TestCompiledNinOptStructFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field9 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field9) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field9 %v", unmarshalled[0], *p.Field4.Field9))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructFixed32 []*test.NinOptStruct

func (s sorterNinOptStructFixed32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field4 != nil && s[i].Field4.Field9 != nil {

		vi = s[i].Field4.Field9

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9").GetDefaultUint32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field9 != nil {

		vj = s[j].Field4.Field9

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructFixed32) Len() int {
	return len(this)
}

func (this sorterNinOptStructFixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructFixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructFixed32(b *testing.B) {
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructFixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructFixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field9")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedFixed32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field9) {
		if len(unmarshalled) == 0 && len(p.Field9) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field9 %#v", unmarshalled, p.Field9))
	}

}

func TestCompiledNinRepNativeFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32Path("test", "NinRepNative", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field9) {
		if len(unmarshalled) == 0 && len(p.Field9) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field9 %#v", unmarshalled, p.Field9))
	}

}

func TestCompiledNinNestedStructFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field9 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field9) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field9 %v", unmarshalled[0], *p.Field1.Field4.Field9))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field9").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field9)
	}

}

func TestUnmarshalNinOptNativeDefaultFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field9 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9").GetDefaultUint32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field9 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field9)
	}

}

func TestCompiledNinOptNativeDefaultFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []uint32
	f := FuncHandler{
		Uint32Func: func(v uint32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field9 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field9) {

			panic(fmt.Errorf("unmarshalled %v != p.Field9 %v", unmarshalled[0], *p.Field9))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9").GetDefaultUint32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultFixed32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultFixed32) Less(i, j int) bool {

	var vi *uint32
	var vj *uint32
	if s[i].Field9 != nil {

		vi = s[i].Field9

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9").GetDefaultUint32()
	}
	if s[j].Field9 != nil {

		vj = s[j].Field9

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9").GetDefaultUint32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultFixed32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultFixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultFixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultFixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultFixed32(b *testing.B) {
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultFixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultFixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultFixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field9")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field11)
	}

}

func TestUnmarshalNinOptNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field11)
	}

}

func TestCompiledNinOptNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64Path("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field11 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field11) {

			panic(fmt.Errorf("unmarshalled %v != p.Field11 %v", unmarshalled[0], *p.Field11))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field11").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeFixed64 []*test.NinOptNative

func (s sorterNinOptNativeFixed64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field11 != nil {

		vi = s[i].Field11

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field11").GetDefaultUint64()
	}
	if s[j].Field11 != nil {

		vj = s[j].Field11

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field11").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeFixed64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeFixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeFixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeFixed64(b *testing.B) {
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeFixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeFixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeFixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field11)
	}

}

func TestUnmarshalNinOptStructFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field11)
	}

}

func TestCompiledNinOptStructFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field11 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field11) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field11 %v", unmarshalled[0], *p.Field4.Field11))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructFixed64 []*test.NinOptStruct

func (s sorterNinOptStructFixed64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field4 != nil && s[i].Field4.Field11 != nil {

		vi = s[i].Field4.Field11

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11").GetDefaultUint64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field11 != nil {

		vj = s[j].Field4.Field11

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructFixed64) Len() int {
	return len(this)
}

func (this sorterNinOptStructFixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructFixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructFixed64(b *testing.B) {
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructFixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructFixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructFixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field11")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedFixed64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field11) {
		if len(unmarshalled) == 0 && len(p.Field11) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field11 %#v", unmarshalled, p.Field11))
	}

}

func TestCompiledNinRepNativeFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64Path("test", "NinRepNative", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field11) {
		if len(unmarshalled) == 0 && len(p.Field11) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field11 %#v", unmarshalled, p.Field11))
	}

}

func TestCompiledNinNestedStructFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field11 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field11) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field11 %v", unmarshalled[0], *p.Field1.Field4.Field11))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field11").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field11)
	}

}

func TestUnmarshalNinOptNativeDefaultFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field11 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11").GetDefaultUint64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field11 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field11)
	}

}

func TestCompiledNinOptNativeDefaultFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewFixed64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []uint64
	f := FuncHandler{
		Uint64Func: func(v uint64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewFixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field11 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field11) {

			panic(fmt.Errorf("unmarshalled %v != p.Field11 %v", unmarshalled[0], *p.Field11))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11").GetDefaultUint64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultFixed64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultFixed64) Less(i, j int) bool {

	var vi *uint64
	var vj *uint64
	if s[i].Field11 != nil {

		vi = s[i].Field11

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11").GetDefaultUint64()
	}
	if s[j].Field11 != nil {

		vj = s[j].Field11

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11").GetDefaultUint64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultFixed64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultFixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultFixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultFixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewFixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultFixed64(b *testing.B) {
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewFixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultFixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultFixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultFixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultFixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewFixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field11")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field10)
	}

}

func TestUnmarshalNinOptNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field10)
	}

}

func TestCompiledNinOptNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32Path("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field10 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field10) {

			panic(fmt.Errorf("unmarshalled %v != p.Field10 %v", unmarshalled[0], *p.Field10))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field10").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeSfixed32 []*test.NinOptNative

func (s sorterNinOptNativeSfixed32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field10 != nil {

		vi = s[i].Field10

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field10").GetDefaultInt32()
	}
	if s[j].Field10 != nil {

		vj = s[j].Field10

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field10").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeSfixed32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeSfixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeSfixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeSfixed32(b *testing.B) {
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeSfixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeSfixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSfixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field10)
	}

}

func TestUnmarshalNinOptStructSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field10)
	}

}

func TestCompiledNinOptStructSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field10 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field10) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field10 %v", unmarshalled[0], *p.Field4.Field10))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructSfixed32 []*test.NinOptStruct

func (s sorterNinOptStructSfixed32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field4 != nil && s[i].Field4.Field10 != nil {

		vi = s[i].Field4.Field10

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10").GetDefaultInt32()
	}
	if s[j].Field4 != nil && s[j].Field4.Field10 != nil {

		vj = s[j].Field4.Field10

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructSfixed32) Len() int {
	return len(this)
}

func (this sorterNinOptStructSfixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructSfixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructSfixed32(b *testing.B) {
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructSfixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructSfixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSfixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field10")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedSfixed32Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field10) {
		if len(unmarshalled) == 0 && len(p.Field10) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field10 %#v", unmarshalled, p.Field10))
	}

}

func TestCompiledNinRepNativeSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32Path("test", "NinRepNative", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field10) {
		if len(unmarshalled) == 0 && len(p.Field10) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field10 %#v", unmarshalled, p.Field10))
	}

}

func TestCompiledNinNestedStructSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field10 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field10) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field10 %v", unmarshalled[0], *p.Field1.Field4.Field10))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field10").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field10)
	}

}

func TestUnmarshalNinOptNativeDefaultSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field10 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10").GetDefaultInt32() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field10 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field10)
	}

}

func TestCompiledNinOptNativeDefaultSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed32Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int32
	f := FuncHandler{
		Int32Func: func(v int32) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed32Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field10 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field10) {

			panic(fmt.Errorf("unmarshalled %v != p.Field10 %v", unmarshalled[0], *p.Field10))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10").GetDefaultInt32() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultSfixed32 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultSfixed32) Less(i, j int) bool {

	var vi *int32
	var vj *int32
	if s[i].Field10 != nil {

		vi = s[i].Field10

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10").GetDefaultInt32()
	}
	if s[j].Field10 != nil {

		vj = s[j].Field10

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10").GetDefaultInt32()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultSfixed32) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultSfixed32) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultSfixed32(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultSfixed32, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed32Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultSfixed32(b *testing.B) {
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed32Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultSfixed32(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSfixed32, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultSfixed32, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSfixed32, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultSfixed32(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed32SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field10")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field12)
	}

}

func TestUnmarshalNinOptNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field12)
	}

}

func TestCompiledNinOptNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64Path("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field12 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field12) {

			panic(fmt.Errorf("unmarshalled %v != p.Field12 %v", unmarshalled[0], *p.Field12))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field12").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeSfixed64 []*test.NinOptNative

func (s sorterNinOptNativeSfixed64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field12 != nil {

		vi = s[i].Field12

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field12").GetDefaultInt64()
	}
	if s[j].Field12 != nil {

		vj = s[j].Field12

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field12").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeSfixed64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeSfixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeSfixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeSfixed64(b *testing.B) {
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeSfixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeSfixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeSfixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field12)
	}

}

func TestUnmarshalNinOptStructSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field12)
	}

}

func TestCompiledNinOptStructSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64Path("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field12 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field12) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field12 %v", unmarshalled[0], *p.Field4.Field12))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructSfixed64 []*test.NinOptStruct

func (s sorterNinOptStructSfixed64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field4 != nil && s[i].Field4.Field12 != nil {

		vi = s[i].Field4.Field12

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12").GetDefaultInt64()
	}
	if s[j].Field4 != nil && s[j].Field4.Field12 != nil {

		vj = s[j].Field4.Field12

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructSfixed64) Len() int {
	return len(this)
}

func (this sorterNinOptStructSfixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructSfixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructSfixed64(b *testing.B) {
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructSfixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructSfixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructSfixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field12")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepPackedNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedSfixed64Path("test", "NinRepPackedNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field12) {
		if len(unmarshalled) == 0 && len(p.Field12) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field12 %#v", unmarshalled, p.Field12))
	}

}

func TestCompiledNinRepNativeSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64Path("test", "NinRepNative", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field12) {
		if len(unmarshalled) == 0 && len(p.Field12) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field12 %#v", unmarshalled, p.Field12))
	}

}

func TestCompiledNinNestedStructSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64Path("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field12 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field12) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field12 %v", unmarshalled[0], *p.Field1.Field4.Field12))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field12").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field12)
	}

}

func TestUnmarshalNinOptNativeDefaultSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field12 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12").GetDefaultInt64() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field12 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field12)
	}

}

func TestCompiledNinOptNativeDefaultSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewSfixed64Path("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []int64
	f := FuncHandler{
		Int64Func: func(v int64) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewSfixed64Unmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field12 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field12) {

			panic(fmt.Errorf("unmarshalled %v != p.Field12 %v", unmarshalled[0], *p.Field12))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12").GetDefaultInt64() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultSfixed64 []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultSfixed64) Less(i, j int) bool {

	var vi *int64
	var vj *int64
	if s[i].Field12 != nil {

		vi = s[i].Field12

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12").GetDefaultInt64()
	}
	if s[j].Field12 != nil {

		vj = s[j].Field12

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12").GetDefaultInt64()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultSfixed64) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultSfixed64) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultSfixed64(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultSfixed64, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewSfixed64Sorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultSfixed64(b *testing.B) {
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewSfixed64Sorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultSfixed64(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSfixed64, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultSfixed64, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultSfixed64, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultSfixed64(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewSfixed64SinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field12")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinOptNativeBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBoolPath("test", "NinOptNative", test.ThetestDescription(), "Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field13 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field13) {

			panic(fmt.Errorf("unmarshalled %v != p.Field13 %v", unmarshalled[0], *p.Field13))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field13").GetDefaultBool() {
			t.Fatalf("wrong default")
		}

	}

}

func TestCompiledNinOptStructBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBoolPath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field13 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field13) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field13 %v", unmarshalled[0], *p.Field4.Field13))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field13").GetDefaultBool() {
			t.Fatalf("wrong default")
		}

	}

}

func TestCompiledNinRepPackedNativeBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewPackedBoolPath("test", "NinRepPackedNative", test.ThetestDescription(), "Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepPackedNative(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewPackedBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field13) {
		if len(unmarshalled) == 0 && len(p.Field13) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field13 %#v", unmarshalled, p.Field13))
	}

}

func TestCompiledNinRepNativeBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBoolPath("test", "NinRepNative", test.ThetestDescription(), "Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field13) {
		if len(unmarshalled) == 0 && len(p.Field13) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field13 %#v", unmarshalled, p.Field13))
	}

}

func TestCompiledNinNestedStructBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBoolPath("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field13 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field13) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field13 %v", unmarshalled[0], *p.Field1.Field4.Field13))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field13").GetDefaultBool() {
			t.Fatalf("wrong default")
		}

	}

}

func TestCompiledNinOptNativeDefaultBool(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBoolPath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field13")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []bool
	f := FuncHandler{
		BoolFunc: func(v bool) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBoolUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field13 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field13) {

			panic(fmt.Errorf("unmarshalled %v != p.Field13 %v", unmarshalled[0], *p.Field13))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field13").GetDefaultBool() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field14)
	}

}

func TestUnmarshalNinOptNativeString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field14)
	}

}

func TestCompiledNinOptNativeString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringPath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled []string
	f := FuncHandler{
		StringFunc: func(v string) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewStringUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field14 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field14) {

			panic(fmt.Errorf("unmarshalled %v != p.Field14 %v", unmarshalled[0], *p.Field14))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field14").GetDefaultString() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeString []*test.NinOptNative

func (s sorterNinOptNativeString) Less(i, j int) bool {

	var vi *string
	var vj *string
	if s[i].Field14 != nil {

		vi = s[i].Field14

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field14").GetDefaultString()
	}
	if s[j].Field14 != nil {

		vj = s[j].Field14

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNative", test.ThetestDescription(), "Field14").GetDefaultString()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeString) Len() int {
	return len(this)
}

func (this sorterNinOptNativeString) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeString, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewStringSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeString(b *testing.B) {
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewStringSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeString(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeString, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeString, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field14)
	}

}

func TestUnmarshalNinOptStructString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field4.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field4.Field14)
	}

}

func TestCompiledNinOptStructString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringPath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled []string
	f := FuncHandler{
		StringFunc: func(v string) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewStringUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field14 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field4.Field14) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field14 %v", unmarshalled[0], *p.Field4.Field14))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14").GetDefaultString() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptStructString []*test.NinOptStruct

func (s sorterNinOptStructString) Less(i, j int) bool {

	var vi *string
	var vj *string
	if s[i].Field4 != nil && s[i].Field4.Field14 != nil {

		vi = s[i].Field4.Field14

	} else {
		vi = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14").GetDefaultString()
	}
	if s[j].Field4 != nil && s[j].Field4.Field14 != nil {

		vj = s[j].Field4.Field14

	} else {
		vj = fieldpath.TestDefault("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14").GetDefaultString()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptStructString) Len() int {
	return len(this)
}

func (this sorterNinOptStructString) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructString, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewStringSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructString(b *testing.B) {
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewStringSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructString(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructString, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructString, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field14")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinRepNativeString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringPath("test", "NinRepNative", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinRepNative(r, false)
	var unmarshalled []string
	f := FuncHandler{
		StringFunc: func(v string) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewStringUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if !reflect.DeepEqual(unmarshalled, p.Field14) {
		if len(unmarshalled) == 0 && len(p.Field14) == 0 {
			return
		}
		panic(fmt.Errorf("unmarshalled %#v != p.Field14 %#v", unmarshalled, p.Field14))
	}

}

func TestCompiledNinNestedStructString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringPath("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled []string
	f := FuncHandler{
		StringFunc: func(v string) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewStringUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field14 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field1.Field4.Field14) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field14 %v", unmarshalled[0], *p.Field1.Field4.Field14))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field14").GetDefaultString() {
			t.Fatalf("wrong default")
		}

	}

}

func TestUnmarshalFirstNinOptNativeDefaultString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field14)
	}

}

func TestUnmarshalNinOptNativeDefaultString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field14 != nil) {
		if unmarshalled != nil {

			if *unmarshalled == *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14").GetDefaultString() {
				return
			}

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}

	if *unmarshalled != *p.Field14 {
		t.Fatalf("%v != %v", *unmarshalled, *p.Field14)
	}

}

func TestCompiledNinOptNativeDefaultString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewStringPath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled []string
	f := FuncHandler{
		StringFunc: func(v string) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewStringUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field14 != nil {

		if !reflect.DeepEqual(unmarshalled[0], *p.Field14) {

			panic(fmt.Errorf("unmarshalled %v != p.Field14 %v", unmarshalled[0], *p.Field14))
		}
		return
	}
	if len(unmarshalled) > 0 {

		if unmarshalled[0] != *fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14").GetDefaultString() {
			t.Fatalf("wrong default")
		}

	}

}

type sorterNinOptNativeDefaultString []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultString) Less(i, j int) bool {

	var vi *string
	var vj *string
	if s[i].Field14 != nil {

		vi = s[i].Field14

	} else {
		vi = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14").GetDefaultString()
	}
	if s[j].Field14 != nil {

		vj = s[j].Field14

	} else {
		vj = fieldpath.TestDefault("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14").GetDefaultString()
	}
	if vj == nil {
		return false
	}
	if vi == nil {
		return true
	}
	return *vi < *vj

}

func (this sorterNinOptNativeDefaultString) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultString) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultString(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultString, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewStringSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultString(b *testing.B) {
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewStringSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultString(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultString, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultString, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultString, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultString(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewStringSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field14")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptNativeBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field15)
	}

}

func TestUnmarshalNinOptNativeBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field15)
	}

}

func TestCompiledNinOptNativeBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesPath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNative(r, false)
	var unmarshalled [][]byte
	f := FuncHandler{
		BytesFunc: func(v []byte) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBytesUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field15 != nil {

		if !reflect.DeepEqual(unmarshalled[0], p.Field15) {

			panic(fmt.Errorf("unmarshalled %v != p.Field15 %v", unmarshalled[0], p.Field15))
		}
		return
	}
	if len(unmarshalled) > 0 {

		t.Fatalf("Expected nil")

	}

}

type sorterNinOptNativeBytes []*test.NinOptNative

func (s sorterNinOptNativeBytes) Less(i, j int) bool {

	if !(s[j].Field15 != nil) {
		return false
	}
	if !(s[i].Field15 != nil) {
		return true
	}
	return bytes.Compare(s[i].Field15, s[j].Field15) == -1

}

func (this sorterNinOptNativeBytes) Len() int {
	return len(this)
}

func (this sorterNinOptNativeBytes) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeBytes, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNative(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewBytesSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNative{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeBytes(b *testing.B) {
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewBytesSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeBytes(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeBytes, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNative{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeBytes, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNative(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNative", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNative(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestUnmarshalFirstNinOptStructBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field4.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field4.Field15)
	}

}

func TestUnmarshalNinOptStructBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field4 != nil && p.Field4.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field4.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field4.Field15)
	}

}

func TestCompiledNinOptStructBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesPath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptStruct(r, false)
	var unmarshalled [][]byte
	f := FuncHandler{
		BytesFunc: func(v []byte) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBytesUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field4 != nil && p.Field4.Field15 != nil {

		if !reflect.DeepEqual(unmarshalled[0], p.Field4.Field15) {

			panic(fmt.Errorf("unmarshalled %v != p.Field4.Field15 %v", unmarshalled[0], p.Field4.Field15))
		}
		return
	}
	if len(unmarshalled) > 0 {

		t.Fatalf("Expected nil")

	}

}

type sorterNinOptStructBytes []*test.NinOptStruct

func (s sorterNinOptStructBytes) Less(i, j int) bool {

	if !(s[j].Field4 != nil && s[j].Field4.Field15 != nil) {
		return false
	}
	if !(s[i].Field4 != nil && s[i].Field4.Field15 != nil) {
		return true
	}
	return bytes.Compare(s[i].Field4.Field15, s[j].Field4.Field15) == -1

}

func (this sorterNinOptStructBytes) Len() int {
	return len(this)
}

func (this sorterNinOptStructBytes) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptStructBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptStructBytes, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptStruct(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewBytesSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptStruct{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptStructBytes(b *testing.B) {
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptStructBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewBytesSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptStructBytes(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptStructBytes, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptStruct{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptStructBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptStructBytes, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptStruct(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptStructBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptStruct", test.ThetestDescription(), "Field4.Field15")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptStruct(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */

func TestCompiledNinNestedStructBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesPath("test", "NinNestedStruct", test.ThetestDescription(), "Field1.Field4.Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinNestedStruct(r, false)
	var unmarshalled [][]byte
	f := FuncHandler{
		BytesFunc: func(v []byte) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBytesUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field1 != nil && p.Field1.Field4 != nil && p.Field1.Field4.Field15 != nil {

		if !reflect.DeepEqual(unmarshalled[0], p.Field1.Field4.Field15) {

			panic(fmt.Errorf("unmarshalled %v != p.Field1.Field4.Field15 %v", unmarshalled[0], p.Field1.Field4.Field15))
		}
		return
	}
	if len(unmarshalled) > 0 {

		t.Fatalf("Expected nil")

	}

}

func TestUnmarshalFirstNinOptNativeDefaultBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.UnmarshalFirst(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field15)
	}

}

func TestUnmarshalNinOptNativeDefaultBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	unmarshalled, err := fp.Unmarshal(buf)
	if err != nil {
		panic(err)
	}
	if !(p.Field15 != nil) {
		if unmarshalled != nil {

			t.Fatalf("unmarshalled != nil")
		}
		return
	}
	if unmarshalled == nil {
		t.Fatalf("ummarshalled == nil")
	}
	if !bytes.Equal(unmarshalled, p.Field15) {
		t.Fatalf("%v != %v", unmarshalled, p.Field15)
	}

}

func TestCompiledNinOptNativeDefaultBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	fp, err := fieldpath.NewBytesPath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	p := test.NewPopulatedNinOptNativeDefault(r, false)
	var unmarshalled [][]byte
	f := FuncHandler{
		BytesFunc: func(v []byte) {
			unmarshalled = append(unmarshalled, v)
		},
	}
	unmarshaler := fieldpath.NewBytesUnmarshaler(fp, f)
	buf, err := proto.Marshal(p)
	if err != nil {
		panic(err)
	}
	compiled := fieldpath.Compile(unmarshaler)
	err = compiled.Unmarshal(buf)
	if err != nil {
		panic(err)
	}

	if p.Field15 != nil {

		if !reflect.DeepEqual(unmarshalled[0], p.Field15) {

			panic(fmt.Errorf("unmarshalled %v != p.Field15 %v", unmarshalled[0], p.Field15))
		}
		return
	}
	if len(unmarshalled) > 0 {

		t.Fatalf("Expected nil")

	}

}

type sorterNinOptNativeDefaultBytes []*test.NinOptNativeDefault

func (s sorterNinOptNativeDefaultBytes) Less(i, j int) bool {

	if !(s[j].Field15 != nil) {
		return false
	}
	if !(s[i].Field15 != nil) {
		return true
	}
	return bytes.Compare(s[i].Field15, s[j].Field15) == -1

}

func (this sorterNinOptNativeDefaultBytes) Len() int {
	return len(this)
}

func (this sorterNinOptNativeDefaultBytes) Swap(i, j int) {
	this[i], this[j] = this[j], this[i]
}

func TestSortNinOptNativeDefaultBytes(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping test in short mode.")
	}
	r := math_rand.New(math_rand.NewSource(time.Now().UnixNano()))
	l := r.Intn(1000)
	unmarshalled := make(sorterNinOptNativeDefaultBytes, l)
	marshalled := make([][]byte, l)
	var err error
	for i := 0; i < l; i++ {
		unmarshalled[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		marshalled[i], err = proto.Marshal(unmarshalled[i])
		if err != nil {
			panic(err)
		}
	}
	sort.Sort(unmarshalled)
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	fpsorter := fieldpath.NewBytesSorter(&sortable{marshalled}, fp)
	sort.Sort(fpsorter)
	struct2 := &test.NinOptNativeDefault{}
	for i := 0; i < l; i++ {
		err = proto.Unmarshal(marshalled[i], struct2)
		if err != nil {
			panic(err)
		}
		if err := unmarshalled[i].VerboseEqual(struct2); err != nil {
			panic(err)
		}
	}
}

/* BENCHMARKS DISABLED

func BenchmarkSortPathNinOptNativeDefaultBytes(b *testing.B) {
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sorterNinOptNativeDefaultBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		fpsorter := fieldpath.NewBytesSorter(&sortable{bytes}, fp)
		sort.Sort(fpsorter)
	}
}

func BenchmarkUnmarshalAndSortNinOptNativeDefaultBytes(b *testing.B) {
	var err error
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultBytes, l)
		bytes := make([][]byte, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
			bytes[i], err = proto.Marshal(structs[i])
			if err != nil {
				panic(err)
			}
		}
		b.StartTimer()
		structs2 := make(sortNinOptNativeDefaultBytes, l)
		for i := 0; i < l; i++ {
			s := &test.NinOptNativeDefault{}
			proto.Unmarshal(bytes[i], s)
			structs2[i] = s
		}
		sort.Sort(structs2)
	}
}

func BenchmarkJustSortNinOptNativeDefaultBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		l := r.Intn(1000)
		structs := make(sortNinOptNativeDefaultBytes, l)
		for i := 0; i < l; i++ {
			structs[i] = test.NewPopulatedNinOptNativeDefault(r, false)
		}
		b.StartTimer()
		sort.Sort(structs)
	}
}

func BenchmarkUnmarshalPathNinOptNativeDefaultBytes(b *testing.B) {
	r := math_rand.New(math_rand.NewSource(pseudo))
	fp, err := fieldpath.NewBytesSinglePath("test", "NinOptNativeDefault", test.ThetestDescription(), "Field15")
	if err != nil {
		panic(err)
	}
	for i := 0; i < b.N; i++ {
		b.StopTimer()
		p := test.NewPopulatedNinOptNativeDefault(r, false)
		data, err := proto.Marshal(p)
		if err != nil {
			panic(err)
		}
		b.StartTimer()
		fp.Unmarshal(data)
	}
}

BENCHMARKS DISABLED */
